/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.LogisticsTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.PayTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.ReturnCodeEnum;
import com.ebaiyihui.medicalcloud.config.NodeConfig;
import com.ebaiyihui.medicalcloud.mapper.HospitalConfigMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugLogisticsOrderMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugLogisticsOrderRegMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugMainMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugOrderMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugPrescriptionMapper;
import com.ebaiyihui.medicalcloud.mapper.MosOutpatientMainRelMapper;
import com.ebaiyihui.medicalcloud.pojo.dto.LogisticsDetailResDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.LogisticsResDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.RelatedOrderResDTO;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugPrescriptionEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.HospitalConfigEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugLogisticsOrderEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugLogisticsOrderRegEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosOutpatientMainRelEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.FromOutlineVO;
import com.ebaiyihui.medicalcloud.pojo.vo.LogisticsDetailResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.LogisticsResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.CheckDeliveryRangeReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.CheckDeliveryRangeResVo;
import com.ebaiyihui.medicalcloud.service.MosDrugLogisticsOrderService;
import com.ebaiyihui.medicalcloud.service.MosDrugMainService;
import com.ebaiyihui.medicalcloud.utils.DistanceUtil;
import com.ebaiyihui.medicalcloud.utils.HttpUtils;
import com.ebaiyihui.onlineoutpatient.common.dto.PatAdvisoryDetailDTO;
import com.github.pagehelper.PageHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MosDrugLogisticsOrderServiceImpl
implements MosDrugLogisticsOrderService {
    private static final Logger log = LoggerFactory.getLogger(MosDrugLogisticsOrderServiceImpl.class);
    public static final int FIFTEEN_KM = 15000;
    public static final int OUT_RANGE = 1;
    public static final int NOT_OUT_RANGE = 2;
    @Autowired
    private MosDrugLogisticsOrderMapper mosDrugLogisticsOrderMapper;
    @Autowired
    private MosDrugLogisticsOrderRegMapper mosDrugLogisticsOrderRegMapper;
    @Autowired
    private MosDrugPrescriptionMapper mosDrugPrescriptionMapper;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private NodeConfig nodeConfig;
    @Autowired
    private MosOutpatientMainRelMapper mosOutpatientMainRelMapper;
    @Autowired
    private MosDrugMainService mosDrugMainService;
    @Autowired
    private MosDrugOrderMapper mosDrugOrderMapper;
    @Autowired
    private HospitalConfigMapper hospitalConfigMapper;

    public BaseResponse<List<LogisticsResDTO>> getLogisticsList(LogisticsResVO logisticsResVO) {
        log.info("\u7269\u6d41\u5217\u8868\u5165\u53c2:{}" + JSONObject.toJSONString((Object)logisticsResVO));
        ArrayList listStatus = new ArrayList();
        this.getDrugStatus(listStatus);
        int total = 0;
        if (!logisticsResVO.getBeginTime().equals("") && !logisticsResVO.getFinishTime().equals("")) {
            logisticsResVO.setBeginTime(logisticsResVO.getBeginTime() + " 00:00:00");
            logisticsResVO.setFinishTime(logisticsResVO.getFinishTime() + " 23:59:59");
        }
        PageHelper.startPage((int)logisticsResVO.getPageIndex(), (int)logisticsResVO.getPageSize());
        List logisticsResDTOS = this.mosDrugLogisticsOrderMapper.getLogisticsList(logisticsResVO.getOrderStatus(), logisticsResVO.getBeginTime(), logisticsResVO.getFinishTime(), logisticsResVO.getSearch(), logisticsResVO.getAppCode(), logisticsResVO.getType(), listStatus);
        total = this.mosDrugLogisticsOrderMapper.getLogisticsList(logisticsResVO.getOrderStatus(), logisticsResVO.getBeginTime(), logisticsResVO.getFinishTime(), logisticsResVO.getSearch(), logisticsResVO.getAppCode(), logisticsResVO.getType(), listStatus).size();
        log.info("\u5217\u8868\u4fe1\u606f:{}" + JSONObject.toJSONString((Object)logisticsResDTOS));
        for (LogisticsResDTO logisticsResDTO : logisticsResDTOS) {
            logisticsResDTO.setTotalPrice(logisticsResDTO.getLogisticsBasisAmount().add(logisticsResDTO.getOverweightAmount()).add(logisticsResDTO.getPackageAmout()));
            logisticsResDTO.setTotal(Integer.valueOf(total));
        }
        return BaseResponse.success((Object)logisticsResDTOS);
    }

    public BaseResponse<LogisticsDetailResDTO> logisticsDetail(LogisticsDetailResVO detailResVO) {
        log.info("\u7269\u6d41\u8be6\u60c5\u5165\u53c2:{}" + JSONObject.toJSONString((Object)detailResVO));
        MosDrugLogisticsOrderEntity mosDrugLogisticsOrderEntity = this.mosDrugLogisticsOrderMapper.selectByPrimaryKey(detailResVO.getLogisticsId());
        if (mosDrugLogisticsOrderEntity == null) {
            return BaseResponse.error((String)"\u7269\u6d41\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        mosDrugLogisticsOrderEntity.setTotalPrice(mosDrugLogisticsOrderEntity.getLogisticsBasisAmount().add(mosDrugLogisticsOrderEntity.getPackageAmout()).add(mosDrugLogisticsOrderEntity.getOverweightAmount()));
        LogisticsDetailResDTO logisticsDetailResDTO = new LogisticsDetailResDTO();
        if (LogisticsTypeEnum.SF_KD.getValue().equals(mosDrugLogisticsOrderEntity.getLogisticsName())) {
            mosDrugLogisticsOrderEntity.setLogisticsName("\u987a\u4e30\u5feb\u9012");
        } else if (LogisticsTypeEnum.GYHH_KD.getValue().equals(mosDrugLogisticsOrderEntity.getLogisticsName())) {
            mosDrugLogisticsOrderEntity.setLogisticsName("\u56fd\u836f\u534e\u9e3f\u7269\u6d41");
        }
        if (PayTypeEnum.WECHAT_PAY.getValue().equals(mosDrugLogisticsOrderEntity.getPayMethod())) {
            mosDrugLogisticsOrderEntity.setPayMethod("\u5fae\u4fe1");
        } else {
            mosDrugLogisticsOrderEntity.setPayMethod("\u652f\u4ed8\u5b9d");
        }
        logisticsDetailResDTO.setMosDrugLogisticsOrderEntity(mosDrugLogisticsOrderEntity);
        BaseResponse listBaseResponse = this.mosDrugMainService.queryLogisticsRoute(detailResVO.getLogisticsId());
        logisticsDetailResDTO.setLogisticsRouteEntities((List)listBaseResponse.getData());
        ArrayList<RelatedOrderResDTO> resDTOList = new ArrayList<RelatedOrderResDTO>();
        List mosDrugLogisticsOrderRegEntities = this.mosDrugLogisticsOrderRegMapper.getByLogisticsOrderId(detailResVO.getLogisticsId());
        for (MosDrugLogisticsOrderRegEntity mosDrugLogisticsOrderRegEntity : mosDrugLogisticsOrderRegEntities) {
            MosOutpatientMainRelEntity mosOutpatientMainRelEntity;
            RelatedOrderResDTO relatedOrderResDTO = new RelatedOrderResDTO();
            DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(mosDrugLogisticsOrderRegEntity.getMainId());
            DrugPrescriptionEntity drugPrescriptionEntities = this.mosDrugPrescriptionMapper.queryByMainId(mosDrugLogisticsOrderRegEntity.getMainId());
            DrugOrderEntity drugOrderEntity = this.mosDrugOrderMapper.queryByMainId(drugMainEntity.getxId());
            if (drugPrescriptionEntities != null) {
                relatedOrderResDTO.setBusinessName("\u5904\u65b9\u8ba2\u5355");
                relatedOrderResDTO.setMainId(drugMainEntity.getxId());
                if (Objects.nonNull(drugOrderEntity)) {
                    relatedOrderResDTO.setOrderNo(drugOrderEntity.getOrderSeq());
                }
                relatedOrderResDTO.setDoctorName(drugMainEntity.getPresDoctorName());
                relatedOrderResDTO.setPatientName(drugMainEntity.getPatientName());
                relatedOrderResDTO.setDeptName(drugMainEntity.getPresDeptName());
                relatedOrderResDTO.setPrice(drugPrescriptionEntities.getPrice());
                resDTOList.add(relatedOrderResDTO);
            }
            if ((mosOutpatientMainRelEntity = this.mosOutpatientMainRelMapper.getByMainId(mosDrugLogisticsOrderRegEntity.getMainId())) != null) {
                String url = new StringBuffer(this.nodeConfig.getAddress()).append(drugMainEntity.getPresOrgan()).append("/netinquiry/admission/querymedicalrecordslist").toString();
                PatAdvisoryDetailDTO patAdvisoryDetailDTO = new PatAdvisoryDetailDTO();
                patAdvisoryDetailDTO.setAdmissionId(mosOutpatientMainRelEntity.getAdmissionId());
                patAdvisoryDetailDTO.setOrderId(mosOutpatientMainRelEntity.getOrderId());
                log.info("\u8bf7\u6c42\u5728\u7ebf\u95e8\u8bca\u7684url\u662f:{}====\u8bf7\u6c42\u5728\u7ebf\u95e8\u8bca\u7684\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)patAdvisoryDetailDTO));
                FromOutlineVO fromOutlineVO = null;
                try {
                    String dataStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)patAdvisoryDetailDTO), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
                    log.info("\u8c03\u7528\u5728\u7ebf\u95e8\u8bca\u8fd4\u56de\u662f:{}", (Object)dataStr);
                    if (ReturnCodeEnum.SUCCEED.getValue().equals(JSONObject.parseObject((String)dataStr).getString("code")) && null != JSONObject.parseObject((String)dataStr).getJSONObject("data")) {
                        fromOutlineVO = (FromOutlineVO)JSONObject.parseObject((String)JSONObject.parseObject((String)dataStr).getString("data"), FromOutlineVO.class);
                        log.info("fromOutlineVO\u662f:{}", (Object)fromOutlineVO.toString());
                        RelatedOrderResDTO relatedOrderResDTO1 = new RelatedOrderResDTO();
                        relatedOrderResDTO1.setBusinessName("\u5728\u7ebf\u590d\u8bca");
                        relatedOrderResDTO1.setOrderNo(mosOutpatientMainRelEntity.getOrderId());
                        relatedOrderResDTO1.setDoctorName(fromOutlineVO.getPresDoctorName());
                        relatedOrderResDTO1.setPatientName(fromOutlineVO.getPatientName());
                        relatedOrderResDTO1.setDeptName(fromOutlineVO.getPresDeptName());
                        relatedOrderResDTO1.setPrice(fromOutlineVO.getPrice());
                        relatedOrderResDTO1.setAdmissionId(mosOutpatientMainRelEntity.getAdmissionId());
                        resDTOList.add(relatedOrderResDTO1);
                    }
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            logisticsDetailResDTO.setRelatedOrderResDTOS(resDTOList);
        }
        return BaseResponse.success((Object)logisticsDetailResDTO);
    }

    public MosDrugLogisticsOrderEntity selectByMainId(String mainId) {
        return this.mosDrugLogisticsOrderMapper.selectByMainId(mainId);
    }

    public BaseResponse checkDeliveryRange(CheckDeliveryRangeReqVo checkDeliveryRangeReqVo) {
        HospitalConfigEntity configEntity = this.hospitalConfigMapper.selectByAppcode(checkDeliveryRangeReqVo.getAppCode());
        if (Objects.isNull(configEntity)) {
            return BaseResponse.error((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u533b\u9662\u4fe1\u606f");
        }
        CheckDeliveryRangeResVo checkDeliveryRangeResVo = new CheckDeliveryRangeResVo();
        Double deliveryDistance = DistanceUtil.distance((double)Double.parseDouble(configEntity.getLatitude()), (double)Double.parseDouble(configEntity.getLongitude()), (double)Double.parseDouble(checkDeliveryRangeReqVo.getLatitude()), (double)Double.parseDouble(checkDeliveryRangeReqVo.getLongitude()));
        if (deliveryDistance >= 15000.0) {
            checkDeliveryRangeResVo.setDeliveryRangeFlag(Integer.valueOf(1));
            checkDeliveryRangeResVo.setDeliveryDistance(deliveryDistance);
            return BaseResponse.success((Object)checkDeliveryRangeResVo);
        }
        checkDeliveryRangeResVo.setDeliveryRangeFlag(Integer.valueOf(2));
        checkDeliveryRangeResVo.setDeliveryDistance(deliveryDistance);
        return BaseResponse.success((Object)checkDeliveryRangeResVo);
    }

    private void getDrugStatus(List<Integer> listStatus) {
        listStatus.add(DrugMainStatusEnum.TO_SEND.getValue());
        listStatus.add(DrugMainStatusEnum.SENT.getValue());
        listStatus.add(DrugMainStatusEnum.TO_TRANSPORT.getValue());
        listStatus.add(DrugMainStatusEnum.TO_DELIVERY.getValue());
        listStatus.add(DrugMainStatusEnum.SIGN_IN.getValue());
        listStatus.add(DrugMainStatusEnum.SIGN_IN.getValue());
        listStatus.add(DrugMainStatusEnum.FINISH.getValue());
    }
}

