/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.doctoruser.api.pojo.vo.UcConfigurationVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.medicalcloud.common.enums.DistributionTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.DrugTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.MerchantTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.OrderStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.OrderTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.PayBillOrderStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.PayChannelEnum;
import com.ebaiyihui.medicalcloud.common.enums.PayStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.PayTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.ReturnCodeEnum;
import com.ebaiyihui.medicalcloud.config.SpecialNodeConfig;
import com.ebaiyihui.medicalcloud.exception.AsynException;
import com.ebaiyihui.medicalcloud.factory.PresRoamProcessStrategyFactory;
import com.ebaiyihui.medicalcloud.manage.HisManage;
import com.ebaiyihui.medicalcloud.manage.LogisticsManage;
import com.ebaiyihui.medicalcloud.manage.OrderPayManage;
import com.ebaiyihui.medicalcloud.manage.PushManage;
import com.ebaiyihui.medicalcloud.mapper.DrugDetailMapper;
import com.ebaiyihui.medicalcloud.mapper.HospitalConfigMapper;
import com.ebaiyihui.medicalcloud.mapper.MerchantConfigMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugLogisticsOrderMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugLogisticsOrderRegMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugMainMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugOrderMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugPrescriptionMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugstoreMapper;
import com.ebaiyihui.medicalcloud.mapper.MosInspectionOtherFeeMapper;
import com.ebaiyihui.medicalcloud.mapper.MosOutpatientMainRelMapper;
import com.ebaiyihui.medicalcloud.pojo.dto.BaseOperationDto;
import com.ebaiyihui.medicalcloud.pojo.dto.DrugOrderDTO;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugDetailEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugPrescriptionEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugstoreEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.HisLogEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.HospitalConfigEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MerchantConfigEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugLogisticsOrderEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugLogisticsOrderRegEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.ServicePayBillEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.his.hyt.FeeItemVO;
import com.ebaiyihui.medicalcloud.pojo.vo.his.hyt.PrescriptionPreSettlementReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.his.hyt.PrescriptionPreSettlementResVo;
import com.ebaiyihui.medicalcloud.pojo.vo.his.hyt.PriceInfoFeeItem;
import com.ebaiyihui.medicalcloud.pojo.vo.his.hyt.QueryPrescriptionReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.his.hyt.QueryPrescriptionResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.his.hyt.TransModelVo;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.LocalPreCreateOrderReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.DrugPayReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.HytDrugPayReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.LogisticsPayReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.LogisticsRefundReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.PayNotifyReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.PayReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.RefundCallBackReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.RefundReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.RefundResVo;
import com.ebaiyihui.medicalcloud.service.HisLogService;
import com.ebaiyihui.medicalcloud.service.OrderPayService;
import com.ebaiyihui.medicalcloud.service.PresRoamProcessRegService;
import com.ebaiyihui.medicalcloud.service.PresRoamProcessService;
import com.ebaiyihui.medicalcloud.service.ServicePayBillService;
import com.ebaiyihui.medicalcloud.utils.DateUtils;
import com.ebaiyihui.medicalcloud.utils.DistanceUtil;
import com.ebaiyihui.medicalcloud.utils.GenSeqUtils;
import com.ebaiyihui.medicalcloud.utils.HanyuPinyinUtil;
import com.ebaiyihui.medicalcloud.utils.RedisUtil;
import com.ebaiyihui.medicalcloud.utils.SignUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderPayServiceImpl
implements OrderPayService {
    private static final Logger log = LoggerFactory.getLogger(OrderPayServiceImpl.class);
    @Autowired
    private OrderPayManage orderPayManage;
    @Autowired
    private PushManage pushManage;
    @Autowired
    private MosDrugOrderMapper drugOrderMapper;
    @Autowired
    private MerchantConfigMapper merchantConfigMapper;
    @Autowired
    private MosDrugLogisticsOrderMapper drugLogisticsOrderMapper;
    @Autowired
    private MosDrugLogisticsOrderRegMapper drugLogisticsOrderRegMapper;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosDrugstoreMapper mosDrugstoreMapper;
    @Autowired
    private SpecialNodeConfig specialNodeConfig;
    @Autowired
    private HospitalConfigMapper hospitalConfigMapper;
    @Autowired
    private MosDrugOrderMapper mosDrugOrderMapper;
    @Autowired
    private HisManage hisManage;
    @Autowired
    private MosOutpatientMainRelMapper mosOutpatientMainRelMapper;
    @Autowired
    private DrugDetailMapper drugDetailMapper;
    @Autowired
    private MosDrugPrescriptionMapper drugPrescriptionMapper;
    @Autowired
    private LogisticsManage logisticsManage;
    @Autowired
    private PresRoamProcessRegService presRoamProcessRegService;
    @Autowired
    private HisLogService hisLogService;
    @Autowired
    private ServicePayBillService servicePayBillService;
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private MosInspectionOtherFeeMapper mosInspectionOtherFeeMapper;
    private static final String RETURNCODE = "SUCCESS";

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<?> createTradeDrug(DrugPayReqVO vo) {
        MosDrugLogisticsOrderEntity mosDrugLogisticsOrderEntity;
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(vo.getMainId());
        String processCode = this.presRoamProcessRegService.getProcessCodeByAppCodeOrHospitalNameFirstLetter(drugMainEntity.getPresOrgan(), drugMainEntity.getHospitalNameFirstLetter());
        PresRoamProcessService presRoamProcessService = PresRoamProcessStrategyFactory.getPresRoamProcessStrategy((String)processCode);
        BaseResponse baseResponse = presRoamProcessService.createTradeOrder(vo);
        if (!baseResponse.isSuccess()) {
            return baseResponse;
        }
        DrugOrderEntity drugOrderEntity = this.mosDrugOrderMapper.queryByMainId(vo.getMainId());
        PayReqVO payReqVO = new PayReqVO();
        payReqVO.setMerchantId(drugOrderEntity.getMerchantId());
        payReqVO.setBizSysSeq(drugOrderEntity.getBizSysSeq());
        BigDecimal payAmount = null;
        payAmount = Objects.nonNull(vo.getLogisticsPayReqVO()) ? (Objects.nonNull((mosDrugLogisticsOrderEntity = this.drugLogisticsOrderMapper.selectByMainId(drugMainEntity.getxId())).getPayAmount()) ? drugOrderEntity.getPayAmount().add(mosDrugLogisticsOrderEntity.getPayAmount()) : drugOrderEntity.getPayAmount()) : drugOrderEntity.getPayAmount();
        if (vo.getPayMethod().equals(PayTypeEnum.NCEFY_OFFLINE_MEDICAL_INS_PAY.getValue())) {
            log.info("=====\u7ebf\u4e0b\u652f\u4ed8=====");
            return baseResponse;
        }
        payReqVO.setPayAmount(payAmount);
        payReqVO.setPayChannel(vo.getPayChannel());
        payReqVO.setPayMethod(vo.getPayMethod());
        payReqVO.setOpenId(StringUtils.isEmpty((String)vo.getOpenId()) ? "" : vo.getOpenId());
        payReqVO.setOrderSeq(drugOrderEntity.getOrderSeq());
        payReqVO.setMerchantType(MerchantTypeEnum.DRUG.getValue());
        payReqVO.setMainId(vo.getMainId());
        payReqVO.setProductInfo("\u4e92\u8054\u7f51\u533b\u7597-\u95e8\u8bca\u7f34\u8d39");
        return this.orderPayManage.createTradeServer(payReqVO);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<?> createTradeLogistics(LogisticsPayReqVO vo) {
        if (PayChannelEnum.WX_XCX.getValue().equalsIgnoreCase(vo.getPayChannel()) && StringUtils.isEmpty((String)vo.getOpenId())) {
            return BaseResponse.error((String)"\u5fae\u4fe1\u5c0f\u7a0b\u5e8fopenId\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        HospitalConfigEntity configEntity = this.hospitalConfigMapper.selectByAppcode(vo.getAppCode());
        if (configEntity == null) {
            return BaseResponse.error((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u533b\u9662\u4fe1\u606f");
        }
        if (vo.getDistributionType() == null) {
            vo.setDistributionType(DistributionTypeEnum.CITY_EXPRESS.getValue());
        }
        MosDrugLogisticsOrderEntity orderEntity = null;
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById((String)vo.getMainIds().get(0));
        if (StringUtils.isNotEmpty((String)vo.getOrderId())) {
            orderEntity = this.drugLogisticsOrderMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(vo.getOrderId())));
            log.info(JSON.toJSONString((Object)orderEntity));
        }
        PayReqVO payReqVO = new PayReqVO();
        String orderSeq = "";
        if (orderEntity != null) {
            if (OrderStatusEnum.PAID.getValue().equals(orderEntity.getOrderStatus())) {
                return BaseResponse.error((String)"\u8ba2\u5355\u5df2\u652f\u4ed8,\u8bf7\u52ff\u91cd\u590d\u652f\u4ed8");
            }
            if (orderEntity.getOrderStatus().equals(OrderStatusEnum.EXPIRED.getValue())) {
                return BaseResponse.error((String)"\u8ba2\u5355\u5df2\u8fc7\u671f");
            }
            if (orderEntity.getOrderStatus().equals(OrderStatusEnum.TOPAY.getValue())) {
                log.info("======>\u7269\u6d41\u652f\u4ed8\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)orderEntity));
                orderSeq = orderEntity.getOrderSeq();
                if (!vo.getExtra().equals(orderEntity.getPayAmount())) {
                    orderSeq = GenSeqUtils.genOrderSeq((String)"");
                    orderEntity.setOrderSeq(orderSeq);
                }
                orderEntity.setPayAmount(vo.getExtra());
                orderEntity.setChannelCode(vo.getPayChannel());
                orderEntity.setUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                orderEntity.setLogisticsBasisAmount(vo.getExtra().subtract(configEntity.getOverweightAmount()).subtract(configEntity.getPackStandardMoney()));
                orderEntity.setOverweightAmount(configEntity.getOverweightAmount());
                orderEntity.setPackageAmout(configEntity.getPackStandardMoney());
                orderEntity.setInvoiceNum(vo.getInvoiceNum());
                orderEntity.setInvoiceTitle(vo.getInvoiceTitle());
                orderEntity.setDestProvince(vo.getDestProvince());
                orderEntity.setDestCity(vo.getDestCity());
                orderEntity.setDestDistrict(vo.getDestDistrict());
                orderEntity.setDestDetailAddress(vo.getDestAddress());
                orderEntity.setDestAddress(vo.getDestProvince() + vo.getDestCity() + vo.getDestDistrict() + vo.getDestAddress());
                orderEntity.setDestAddressId(vo.getDestAddressId());
                orderEntity.setDestLatitude(vo.getLatitude());
                orderEntity.setDestLongitude(vo.getLongitude());
                orderEntity.setDestName(vo.getDestName());
                orderEntity.setDestPhone(vo.getDestPhone());
                orderEntity.setAppCode(vo.getAppCode());
                orderEntity.setLogisticsPayMethod(Integer.valueOf(vo.getLogisticsPayeMthod()));
                orderEntity.setDepositumInfo("\u836f\u54c1");
                orderEntity.setPackStandardMoney("3");
                orderEntity.setMonthlyCard(configEntity.getMonthlyCard());
                orderEntity.setSrcProvince(configEntity.getProvince());
                orderEntity.setSrcCity(configEntity.getCity());
                orderEntity.setSrcDistrict(configEntity.getDistrict());
                orderEntity.setSrcDetailAddress(configEntity.getDetailAddress());
                orderEntity.setSrcAddress(configEntity.getProvince() + configEntity.getCity() + configEntity.getDistrict() + configEntity.getDetailAddress());
                orderEntity.setSrcName(configEntity.getName());
                orderEntity.setSrcPhone(configEntity.getPhone());
                Double deliveryDistance = DistanceUtil.distance((double)Double.parseDouble(configEntity.getLatitude()), (double)Double.parseDouble(configEntity.getLongitude()), (double)Double.parseDouble(vo.getLatitude()), (double)Double.parseDouble(vo.getLongitude()));
                orderEntity.setDestDeliveryDistance(deliveryDistance.toString());
                if (DrugTypeEnum.CM.getValue().equals(vo.getPresType())) {
                    orderEntity.setProductCode("CHINESE_HERBAL");
                } else {
                    orderEntity.setProductCode("OTHER");
                }
                orderEntity.setExpressType(Integer.valueOf(vo.getExpressType() == null ? 1 : vo.getExpressType()));
                orderEntity.setLogisticsName(vo.getLogisticsType());
                if (drugMainEntity.getPresOrgan().equalsIgnoreCase(this.specialNodeConfig.getHyt())) {
                    String freeType = drugMainEntity.getPatientNoType() == 3 ? "\u533b\u4fdd" : "\u81ea\u8d39";
                    orderEntity.setRemark(drugMainEntity.getPatientName() + "+" + freeType);
                    if (drugMainEntity.getPatientNoType() == 3) {
                        orderEntity.setDistributionType(vo.getDistributionType());
                        if (vo.getDestAddress().contains("\u822a\u5929\u4e8c\u9662\u4e1c\u5de5\u4e1a\u533a") || vo.getDestAddress().contains("\u822a\u5929\u4e8c\u9662\u897f\u5de5\u4e1a\u533a")) {
                            orderEntity.setLogisticsBasisAmount(BigDecimal.valueOf(0.0));
                            orderEntity.setPayAmount(BigDecimal.valueOf(0.0));
                        } else {
                            DrugstoreEntity drugstoreEntity = this.mosDrugstoreMapper.queryById(drugMainEntity.getStoreId());
                            LocalPreCreateOrderReqVO reqVO = new LocalPreCreateOrderReqVO();
                            reqVO.setUserLat(vo.getLatitude());
                            reqVO.setUserLng(vo.getLongitude());
                            reqVO.setUserAddress(vo.getDestProvince() + vo.getDestCity() + vo.getDestDistrict() + vo.getDestAddress());
                            BaseResponse baseResponse = this.logisticsManage.localPrCreateOrder(reqVO, drugstoreEntity, configEntity, vo.getDistributionType());
                            if (baseResponse == null) {
                                return BaseResponse.error((String)"\u8c03\u7528\u7269\u6d41\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                            }
                            if (!ReturnCodeEnum.SUCCEED.getValue().equals(baseResponse.getCode())) {
                                return BaseResponse.error((String)baseResponse.getMsg());
                            }
                            String price = (String)baseResponse.getData();
                            if (StringUtils.isEmpty((String)price)) {
                                return BaseResponse.error((String)"\u672a\u83b7\u53d6\u5230\u7269\u6d41\u914d\u9001\u8d39\uff0c\u8bf7\u91cd\u65b0\u652f\u4ed8");
                            }
                            orderEntity.setLogisticsBasisAmount(new BigDecimal(price).subtract(configEntity.getOverweightAmount()).subtract(configEntity.getPackStandardMoney()));
                            orderEntity.setPayAmount(new BigDecimal(price));
                        }
                        orderEntity.setRemark(drugMainEntity.getPatientName() + "+" + freeType + "+" + DistributionTypeEnum.getDesc((Integer)vo.getDistributionType()));
                    }
                } else {
                    orderEntity.setRemark("\u60a3\u8005\u59d3\u540d\uff1a" + drugMainEntity.getPatientName());
                }
                this.drugLogisticsOrderMapper.updateByPrimaryKeySelective(orderEntity);
                log.info("======>\u7269\u6d41\u652f\u4ed8\u66f4\u65b0\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)orderEntity));
            }
        } else {
            MerchantConfigEntity merchantConfigEntity = this.merchantConfigMapper.queryByOrganCodeAndMerchantType(vo.getAppCode(), Integer.valueOf(2));
            orderEntity = new MosDrugLogisticsOrderEntity();
            orderSeq = GenSeqUtils.genOrderSeq((String)"");
            orderEntity.setPayMethod(vo.getPayMethod());
            orderEntity.setPayAmount(vo.getExtra());
            orderEntity.setChannelCode(vo.getPayChannel());
            orderEntity.setUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
            orderEntity.setCreateTime(DateUtils.getThisDateTime((Date)new Date()));
            orderEntity.setOrderSeq(orderSeq);
            orderEntity.setMchId(merchantConfigEntity.getMerchantSeq());
            orderEntity.setLogisticsBasisAmount(vo.getExtra().subtract(configEntity.getOverweightAmount()).subtract(configEntity.getPackStandardMoney()));
            orderEntity.setOverweightAmount(configEntity.getOverweightAmount());
            orderEntity.setPackageAmout(configEntity.getPackStandardMoney());
            orderEntity.setInvoiceNum(vo.getInvoiceNum());
            orderEntity.setInvoiceTitle(vo.getInvoiceTitle());
            orderEntity.setDestProvince(vo.getDestProvince());
            orderEntity.setDestCity(vo.getDestCity());
            orderEntity.setDestDistrict(vo.getDestDistrict());
            orderEntity.setDestDetailAddress(vo.getDestAddress());
            orderEntity.setDestAddress(vo.getDestProvince() + vo.getDestCity() + vo.getDestDistrict() + vo.getDestAddress());
            orderEntity.setDestAddressId(vo.getDestAddressId());
            orderEntity.setDestLatitude(vo.getLatitude());
            orderEntity.setDestLongitude(vo.getLongitude());
            orderEntity.setDestName(vo.getDestName());
            orderEntity.setDestPhone(vo.getDestPhone());
            orderEntity.setAppCode(vo.getAppCode());
            orderEntity.setLogisticsPayMethod(Integer.valueOf(vo.getLogisticsPayeMthod()));
            orderEntity.setDepositumInfo("\u836f\u54c1");
            orderEntity.setPackStandardMoney("3");
            orderEntity.setMonthlyCard(configEntity.getMonthlyCard());
            orderEntity.setSrcProvince(configEntity.getProvince());
            orderEntity.setSrcCity(configEntity.getCity());
            orderEntity.setSrcDistrict(configEntity.getDistrict());
            orderEntity.setSrcDetailAddress(configEntity.getDetailAddress());
            orderEntity.setSrcAddress(configEntity.getProvince() + configEntity.getCity() + configEntity.getDistrict() + configEntity.getDetailAddress());
            orderEntity.setSrcName(configEntity.getName());
            orderEntity.setSrcPhone(configEntity.getPhone());
            Double deliveryDistance = DistanceUtil.distance((double)Double.parseDouble(configEntity.getLatitude()), (double)Double.parseDouble(configEntity.getLongitude()), (double)Double.parseDouble(vo.getLatitude()), (double)Double.parseDouble(vo.getLongitude()));
            orderEntity.setDestDeliveryDistance(deliveryDistance.toString());
            if (DrugTypeEnum.CM.getValue().equals(vo.getPresType())) {
                orderEntity.setProductCode("CHINESE_HERBAL");
            } else {
                orderEntity.setProductCode("OTHER");
            }
            orderEntity.setExpressType(Integer.valueOf(vo.getExpressType() == null ? 1 : vo.getExpressType()));
            orderEntity.setLogisticsName(vo.getLogisticsType());
            orderEntity.setHospitalId(drugMainEntity.getOrganId());
            orderEntity.setHospitalName(drugMainEntity.getPresOrganName());
            orderEntity.setBizSysSeq(merchantConfigEntity.getBizSysSeq());
            orderEntity.setOrderStatus(OrderStatusEnum.TOPAY.getValue());
            if (drugMainEntity.getPresOrgan().equalsIgnoreCase(this.specialNodeConfig.getHyt())) {
                String freeType = drugMainEntity.getPatientNoType() == 3 ? "\u533b\u4fdd" : "\u81ea\u8d39";
                orderEntity.setRemark(drugMainEntity.getPatientName() + "+" + freeType);
                if (drugMainEntity.getPatientNoType() == 3) {
                    orderEntity.setDistributionType(vo.getDistributionType());
                    if (vo.getDestAddress().contains("\u822a\u5929\u4e8c\u9662\u4e1c\u5de5\u4e1a\u533a") || vo.getDestAddress().contains("\u822a\u5929\u4e8c\u9662\u897f\u5de5\u4e1a\u533a")) {
                        orderEntity.setLogisticsBasisAmount(BigDecimal.valueOf(0.0));
                        orderEntity.setPayAmount(BigDecimal.valueOf(0.0));
                    } else {
                        DrugstoreEntity drugstoreEntity = this.mosDrugstoreMapper.queryById(drugMainEntity.getStoreId());
                        LocalPreCreateOrderReqVO reqVO = new LocalPreCreateOrderReqVO();
                        reqVO.setUserLat(vo.getLatitude());
                        reqVO.setUserLng(vo.getLongitude());
                        reqVO.setUserAddress(vo.getDestProvince() + vo.getDestCity() + vo.getDestDistrict() + vo.getDestAddress());
                        BaseResponse baseResponse = this.logisticsManage.localPrCreateOrder(reqVO, drugstoreEntity, configEntity, vo.getDistributionType());
                        if (baseResponse == null) {
                            return BaseResponse.error((String)"\u8c03\u7528\u7269\u6d41\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                        }
                        if (!ReturnCodeEnum.SUCCEED.getValue().equals(baseResponse.getCode())) {
                            return BaseResponse.error((String)baseResponse.getMsg());
                        }
                        String price = (String)baseResponse.getData();
                        if (StringUtils.isEmpty((String)price)) {
                            return BaseResponse.error((String)"\u672a\u83b7\u53d6\u5230\u7269\u6d41\u914d\u9001\u8d39\uff0c\u8bf7\u91cd\u65b0\u652f\u4ed8");
                        }
                        orderEntity.setLogisticsBasisAmount(new BigDecimal(price).subtract(configEntity.getOverweightAmount()).subtract(configEntity.getPackStandardMoney()));
                        orderEntity.setPayAmount(new BigDecimal(price));
                    }
                    orderEntity.setRemark(drugMainEntity.getPatientName() + "+" + freeType + "+" + DistributionTypeEnum.getDesc((Integer)vo.getDistributionType()));
                }
            } else {
                orderEntity.setRemark("\u60a3\u8005\u59d3\u540d\uff1a" + drugMainEntity.getPatientName());
            }
            this.drugLogisticsOrderMapper.insert(orderEntity);
            Long id = orderEntity.getId();
            log.info("============\u7269\u6d41\u7684\u8ba2\u5355id{}:", (Object)id);
            vo.getMainIds().stream().forEach(item -> {
                this.drugLogisticsOrderRegMapper.deleteByMainId(item);
                MosDrugLogisticsOrderRegEntity logisticsOrderRegEntity = new MosDrugLogisticsOrderRegEntity();
                logisticsOrderRegEntity.setMainId(item);
                logisticsOrderRegEntity.setLogisticsOrderId(id);
                logisticsOrderRegEntity.setCreateTime(DateUtils.getThisDateTime((Date)new Date()));
                logisticsOrderRegEntity.setUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                this.drugLogisticsOrderRegMapper.insert(logisticsOrderRegEntity);
            });
        }
        if (vo.getAppCode().equals(this.specialNodeConfig.getHyt()) && (vo.getDestAddress().contains("\u822a\u5929\u4e8c\u9662\u4e1c\u5de5\u4e1a\u533a") || vo.getDestAddress().contains("\u822a\u5929\u4e8c\u9662\u897f\u5de5\u4e1a\u533a"))) {
            drugMainEntity.setItemStatus(DrugMainStatusEnum.TO_SEND.getValue());
            drugMainEntity.setOrderType(OrderTypeEnum.COURIER_ORDER.getValue());
            this.mosDrugMainMapper.update(drugMainEntity);
            orderEntity.setOrderStatus(OrderStatusEnum.PAID.getValue());
            orderEntity.setPayTime(new Date());
            this.drugLogisticsOrderMapper.updateByPrimaryKeySelective(orderEntity);
            return BaseResponse.success((Object)"0");
        }
        payReqVO.setMerchantId(orderEntity.getMchId());
        payReqVO.setBizSysSeq(orderEntity.getBizSysSeq());
        payReqVO.setPayAmount(orderEntity.getPayAmount());
        payReqVO.setPayChannel(vo.getPayChannel());
        payReqVO.setPayMethod(vo.getPayMethod());
        payReqVO.setOpenId(StringUtils.isEmpty((String)vo.getOpenId()) ? "" : vo.getOpenId());
        payReqVO.setOrderSeq(orderSeq);
        payReqVO.setMainId(drugMainEntity.getxId());
        payReqVO.setProductInfo("\u7269\u6d41\u914d\u9001\u8d39");
        payReqVO.setMerchantType(MerchantTypeEnum.LOGISTICS.getValue());
        return this.orderPayManage.createTradeServer(payReqVO);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<?> refundLogistics(RefundCallBackReqVo refundCallBackReqVo) {
        if (!this.checkApplyKey(refundCallBackReqVo)) {
            return BaseResponse.error((String)"\u9a8c\u7b7e\u672a\u901a\u8fc7");
        }
        log.info("======>\u7269\u6d41\u9000\u6b3e\u56de\u8c03---\u53c2\u6570{}", (Object)refundCallBackReqVo.toString());
        MosDrugLogisticsOrderEntity orderEntity = this.drugLogisticsOrderMapper.selectByOrderSeq(refundCallBackReqVo.getOutTradeNo());
        log.info("======>\u7269\u6d41\u9000\u6b3e\u56de\u8c03---\u8ba2\u5355\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)orderEntity));
        ServicePayBillEntity servicePayBillEntity = this.servicePayBillService.selectByOutTradeNoAndStatus(orderEntity.getOrderSeq(), PayBillOrderStatusEnum.REFUNDING.getValue());
        if (PayStatusEnum.SUCCESS.getValue().equalsIgnoreCase(refundCallBackReqVo.getReturnCode())) {
            servicePayBillEntity.setStatus(PayBillOrderStatusEnum.REFUNDED.getValue());
            servicePayBillEntity.setTradeStatus(PayStatusEnum.SUCCESS.getValue());
        } else {
            servicePayBillEntity.setStatus(PayBillOrderStatusEnum.REFUNDED_FAIL.getValue());
            servicePayBillEntity.setTradeStatus(PayStatusEnum.FAIL.getValue());
        }
        servicePayBillEntity.setRefundNo(refundCallBackReqVo.getRefundNo());
        servicePayBillEntity.setRefundTime(refundCallBackReqVo.getRefundTime());
        servicePayBillEntity.setRefundAmount(refundCallBackReqVo.getRefundMoney());
        servicePayBillEntity.setOutRefundNo(refundCallBackReqVo.getOutTradeNo());
        log.info("\u7269\u6d41\u9000\u6b3e\u56de\u8c03\u63a5\u53e3\u66f4\u65b0\u8d26\u5355\u4fe1\u606f\u8ba2\u5355\u72b6\u6001:{}", (Object)JSON.toJSONString((Object)servicePayBillEntity));
        this.servicePayBillService.update(servicePayBillEntity);
        if (orderEntity != null) {
            orderEntity.setOrderStatus(OrderStatusEnum.REFUNDED.getValue());
            orderEntity.setRefundTime(refundCallBackReqVo.getRefundTime());
            this.drugLogisticsOrderMapper.updateByPrimaryKeySelective(orderEntity);
            if (!orderEntity.getAppCode().equals(this.specialNodeConfig.getHyt())) {
                List list = this.drugLogisticsOrderRegMapper.getByLogisticsOrderId(orderEntity.getId());
                list.forEach(entity -> {
                    DrugMainEntity drugMainEntity = new DrugMainEntity();
                    drugMainEntity.setxId(entity.getMainId());
                    drugMainEntity.setItemStatus(DrugMainStatusEnum.DEPLOY_BACK.getValue());
                    this.mosDrugMainMapper.update(drugMainEntity);
                });
            } else {
                List list = this.drugLogisticsOrderRegMapper.getByLogisticsOrderId(orderEntity.getId());
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(((MosDrugLogisticsOrderRegEntity)list.get(0)).getMainId());
                    new Thread(() -> {
                        try {
                            UcConfigurationVO configurationVO = this.pushManage.getClientCode(drugMainEntity.getPresOrgan(), "sms");
                            String signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("patientCode");
                            this.pushManage.iSMSPush("ali", drugMainEntity.getPresOrgan(), signCode, "yyy_ddtk", drugMainEntity.getPatientPhone(), new HashMap());
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                            throw new AsynException(e.getMessage());
                        }
                    }).start();
                }
            }
        }
        return BaseResponse.success((Object)PayStatusEnum.SUCCESS.getValue());
    }

    private boolean checkApplyKey(RefundCallBackReqVo refundNotifyReqVO) {
        String applyKey = this.merchantConfigMapper.queryApplyKeyByApplyId(refundNotifyReqVO.getApplyId());
        Map keyAndValue = SignUtil.getKeyAndValue((Object)refundNotifyReqVO);
        return SignUtil.checkSign((Map)keyAndValue, (String)applyKey);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<?> logisticsPayCall(PayNotifyReqVO payNotifyReqVO) {
        log.info("\u7269\u6d41\u652f\u4ed8\u56de\u8c03\u4fe1\u606f->{}", (Object)JSONObject.toJSONString((Object)payNotifyReqVO));
        if (RETURNCODE.equals(payNotifyReqVO.getResultCode())) {
            MosDrugLogisticsOrderEntity mosDrugLogisticsOrderEntity = this.drugLogisticsOrderMapper.selectByOrderSeq(payNotifyReqVO.getOutTradeNo());
            log.info("\u7269\u6d41\u8ba2\u5355\u4fe1\u606f->{}", (Object)Objects.toString(mosDrugLogisticsOrderEntity, null));
            if (mosDrugLogisticsOrderEntity == null) {
                return BaseResponse.success((Object)RETURNCODE);
            }
            if (OrderStatusEnum.PAID.getValue().equals(mosDrugLogisticsOrderEntity.getOrderStatus())) {
                return BaseResponse.success((Object)RETURNCODE);
            }
            this.saveLogisticsPayBill(payNotifyReqVO, mosDrugLogisticsOrderEntity);
            List list = this.drugLogisticsOrderRegMapper.getByLogisticsOrderId(mosDrugLogisticsOrderEntity.getId());
            list.forEach(entity -> {
                DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(entity.getMainId());
                drugMainEntity.setItemStatus(DrugMainStatusEnum.DEPLOYING.getValue());
                if (this.specialNodeConfig.getHyt().equals(drugMainEntity.getPresOrgan())) {
                    drugMainEntity.setItemStatus(DrugMainStatusEnum.TO_SEND.getValue());
                }
                drugMainEntity.setOrderType(OrderTypeEnum.COURIER_ORDER.getValue());
                this.mosDrugMainMapper.update(drugMainEntity);
                new Thread(() -> {
                    LinkedHashMap data = new LinkedHashMap();
                    HashMap<String, String> map1 = new HashMap<String, String>();
                    map1.put("value", drugMainEntity.getPresDoctorName());
                    data.put("doctorName", map1);
                    HashMap<String, String> map2 = new HashMap<String, String>();
                    map2.put("value", " \u5904\u65b9\u652f\u4ed8\u6210\u529f");
                    data.put("issue", map2);
                    HashMap<String, String> map3 = new HashMap<String, String>();
                    map3.put("value", "\u836f\u54c1\u5df2\u5b8c\u6210\u652f\u4ed8\uff0c\u60a8\u9009\u62e9\u4e86\u836f\u54c1\u914d\u9001\u7684\u65b9\u5f0f");
                    data.put("info", map3);
                    if (drugMainEntity.getPresOrgan().equals(this.specialNodeConfig.getZryh())) {
                        this.pushManage.iWeChatPush(drugMainEntity.getPresOrgan(), "inquiry_common_notify", this.pushManage.getOpenId(drugMainEntity.getPresOrgan(), drugMainEntity.getPatientUserId()), data, "/prescription/pages/detial/detial?mainId=" + drugMainEntity.getxId());
                    } else {
                        this.pushManage.iWeChatPush(drugMainEntity.getPresOrgan(), "inquiry_common_notify", this.pushManage.getOpenId(drugMainEntity.getPresOrgan(), drugMainEntity.getPatientUserId()), data, "/prescription/pages/checkDrugPay/checkDrugPay?mainId=" + drugMainEntity.getxId());
                    }
                }).start();
            });
            mosDrugLogisticsOrderEntity.setBankTradeNo(payNotifyReqVO.getTradeNo());
            mosDrugLogisticsOrderEntity.setOrderStatus(OrderStatusEnum.PAID.getValue());
            mosDrugLogisticsOrderEntity.setDealSeq(payNotifyReqVO.getDealTradeNo());
            mosDrugLogisticsOrderEntity.setBizSysSeq(payNotifyReqVO.getServiceCode());
            mosDrugLogisticsOrderEntity.setPayTime(payNotifyReqVO.getPayTime());
            mosDrugLogisticsOrderEntity.setPayMethod(payNotifyReqVO.getPayChannel());
            this.drugLogisticsOrderMapper.updateByPrimaryKeySelective(mosDrugLogisticsOrderEntity);
        }
        return BaseResponse.success((Object)RETURNCODE);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> applyRefundSecond(BaseOperationDto dto) {
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(dto.getMainId());
        if (drugMainEntity == null) {
            return BaseResponse.error((String)"\u7535\u5b50\u5904\u65b9\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (DrugMainStatusEnum.FINISH.getValue().equals(drugMainEntity.getItemStatus()) && drugMainEntity.getFailureTime().before(new Date())) {
            return BaseResponse.error((String)"\u8be5\u72b6\u6001\u4e0d\u652f\u6301\u9000\u6b3e");
        }
        String processCode = this.presRoamProcessRegService.getProcessCodeByAppCodeOrHospitalNameFirstLetter(drugMainEntity.getPresOrgan(), drugMainEntity.getHospitalNameFirstLetter());
        PresRoamProcessService presRoamProcessService = PresRoamProcessStrategyFactory.getPresRoamProcessStrategy((String)processCode);
        DrugOrderEntity drugOrderEntity = this.drugOrderMapper.queryByMainId(drugMainEntity.getxId());
        ServicePayBillEntity servicePayBillEntity = this.servicePayBillService.selectByOutTradeNoAndStatus(drugOrderEntity.getOrderSeq(), PayBillOrderStatusEnum.PAID.getValue());
        servicePayBillEntity.setStatus(PayBillOrderStatusEnum.REFUNDING.getValue());
        servicePayBillEntity.setId(null);
        servicePayBillEntity.setWorkServiceCode("yyy");
        log.info("\u7533\u8bf7\u9000\u6b3e\u4fdd\u5b58\u8d26\u5355\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)servicePayBillEntity));
        this.servicePayBillService.save(servicePayBillEntity);
        return presRoamProcessService.applyRefundSecond(dto, drugMainEntity);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<?> createTradeDrugItem(DrugPayReqVO vo) {
        String mainId = (String)vo.getMainIds().get(0);
        DrugOrderDTO dto = this.drugOrderMapper.queryOrderByMainId(mainId);
        if (PayChannelEnum.WX_XCX.getValue().equalsIgnoreCase(vo.getPayChannel()) && StringUtils.isEmpty((String)vo.getOpenId())) {
            return BaseResponse.error((String)"\u5fae\u4fe1\u5c0f\u7a0b\u5e8fopenId\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (dto == null) {
            return BaseResponse.error((String)"\u7535\u5b50\u5904\u65b9\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (BigDecimal.ZERO.equals(dto.getPrice())) {
            return BaseResponse.error((String)"\u836f\u54c1\u8d39\u7528\u4e0d\u80fd\u4e3a0\u5143");
        }
        if (dto.getOrderStatus() != null) {
            if (dto.getOrderStatus().equals(OrderStatusEnum.PAID.getValue())) {
                return BaseResponse.error((String)"\u8ba2\u5355\u5df2\u652f\u4ed8,\u8bf7\u52ff\u91cd\u590d\u652f\u4ed8");
            }
            if (dto.getOrderStatus().equals(OrderStatusEnum.PAYING.getValue())) {
                return BaseResponse.error((String)"\u8ba2\u5355\u652f\u4ed8\u5904\u7406\u4e2d,\u8bf7\u52ff\u91cd\u590d\u652f\u4ed8");
            }
            if (dto.getOrderStatus().equals(OrderStatusEnum.EXPIRED.getValue())) {
                return BaseResponse.error((String)"\u8ba2\u5355\u5df2\u8fc7\u671f");
            }
        }
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(mainId);
        DrugOrderEntity orderEntity = new DrugOrderEntity();
        orderEntity.setPayMethod(vo.getPayMethod());
        orderEntity.setPayAmount(dto.getPrice());
        orderEntity.setChannelCode(vo.getPayChannel());
        orderEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        if (Objects.nonNull(dto.getOrderStatus()) && dto.getOrderStatus().equals(OrderStatusEnum.TOPAY.getValue())) {
            log.info("======>\u836f\u54c1\u652f\u4ed8\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)dto));
            orderEntity.setxId(dto.getOrderId());
            this.drugOrderMapper.update(orderEntity);
            log.info("======>\u836f\u54c1\u652f\u4ed8\u66f4\u65b0\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)orderEntity));
        } else {
            MerchantConfigEntity merchantConfigEntity = this.merchantConfigMapper.queryByOrganCodeAndMerchantType(dto.getPresOrgan(), Integer.valueOf(1));
            String orderSeq = GenSeqUtils.genOrderSeq((String)"");
            orderEntity.setxId(GenSeqUtils.getUniqueNo());
            orderEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
            orderEntity.setMainId(dto.getMainId());
            orderEntity.setMerchantId(merchantConfigEntity.getMerchantSeq());
            orderEntity.setOrderSeq(orderSeq);
            orderEntity.setBizSysSeq(merchantConfigEntity.getBizSysSeq());
            orderEntity.setOrganCode(dto.getPresOrgan());
            orderEntity.setStatus(OrderStatusEnum.TOPAY.getValue());
            this.drugOrderMapper.insert(orderEntity);
        }
        DrugOrderEntity drugOrderEntity = this.mosDrugOrderMapper.queryByMainId(mainId);
        drugMainEntity.setItemStatus(DrugMainStatusEnum.ZRYH_UNPAID.getValue());
        this.mosDrugMainMapper.update(drugMainEntity);
        PayReqVO payReqVO = new PayReqVO();
        payReqVO.setMerchantId(dto.getOrderStatus() == null ? orderEntity.getMerchantId() : dto.getMerchantId());
        payReqVO.setBizSysSeq(dto.getOrderStatus() == null ? orderEntity.getBizSysSeq() : dto.getBizSysSeq());
        payReqVO.setPayAmount(payReqVO.getPayAmount() == null ? new BigDecimal(0).add(orderEntity.getPayAmount()) : payReqVO.getPayAmount().add(orderEntity.getPayAmount()));
        payReqVO.setPayChannel(vo.getPayChannel());
        payReqVO.setPayMethod(vo.getPayMethod());
        payReqVO.setOpenId(StringUtils.isEmpty((String)vo.getOpenId()) ? "" : vo.getOpenId());
        payReqVO.setOrderSeq(drugOrderEntity.getOrderSeq());
        payReqVO.setMainId(drugOrderEntity.getMainId());
        payReqVO.setProductInfo("\u4e92\u8054\u7f51\u533b\u7597-\u95e8\u8bca\u7f34\u8d39");
        payReqVO.setMerchantType(MerchantTypeEnum.DRUG.getValue());
        return this.orderPayManage.createTradeServer(payReqVO);
    }

    private PriceInfoFeeItem getPriceInfoFeeItem(FeeItemVO feeItemVO) {
        PriceInfoFeeItem priceInfoFeeItem = new PriceInfoFeeItem();
        priceInfoFeeItem.setCenteritemGrade(feeItemVO.getCenteritemgrade());
        priceInfoFeeItem.setComBo(feeItemVO.getComBo());
        priceInfoFeeItem.setCost(feeItemVO.getCost());
        priceInfoFeeItem.setDoctName(feeItemVO.getDoctName());
        priceInfoFeeItem.setDoseOnce(feeItemVO.getDoseNoce());
        priceInfoFeeItem.setDoseUnit(feeItemVO.getDoseUnit());
        priceInfoFeeItem.setDrugFlag(feeItemVO.getDrugFlag());
        priceInfoFeeItem.setExecDept(feeItemVO.getExecDept());
        priceInfoFeeItem.setFeeDate(feeItemVO.getFeeDate());
        priceInfoFeeItem.setFeeName(feeItemVO.getFeeName());
        priceInfoFeeItem.setItemCode(feeItemVO.getItemCode());
        priceInfoFeeItem.setItemName(feeItemVO.getItemName());
        priceInfoFeeItem.setMoOrder(feeItemVO.getMoOrder());
        priceInfoFeeItem.setPrice(feeItemVO.getPrice());
        priceInfoFeeItem.setPriceUnit(feeItemVO.getPriceUnit());
        priceInfoFeeItem.setQty(feeItemVO.getQty());
        priceInfoFeeItem.setRecipeNO(feeItemVO.getRecipeNO());
        priceInfoFeeItem.setSeqNO(feeItemVO.getSeqNO());
        priceInfoFeeItem.setSpecs(feeItemVO.getSpecs());
        priceInfoFeeItem.setStockDept(feeItemVO.getStockDept());
        return priceInfoFeeItem;
    }

    private boolean presWhetherSame(List<QueryPrescriptionResVO> queryPrescriptionResVOList) {
        for (QueryPrescriptionResVO prescriptionResVO : queryPrescriptionResVOList) {
            log.info("=====his\u67e5\u8be2\u7684\u5904\u65b9\u4fe1\u606f" + JSON.toJSONString((Object)prescriptionResVO));
            List feeItemList = prescriptionResVO.getFeeItem().getFeeItemList();
            DrugPrescriptionEntity drugPrescriptionEntity = this.drugPrescriptionMapper.getByHisRecipeNo(prescriptionResVO.getRecipeNO());
            List detailEntityList = this.drugDetailMapper.getByPresId(drugPrescriptionEntity.getxId());
            log.info("========\u67e5\u8be2\u51fa\u7684\u836f\u54c1\u4fe1\u606f" + JSONObject.toJSONString((Object)detailEntityList));
            if (feeItemList.size() != detailEntityList.size()) {
                log.info("=========his\u836f\u54c1\u7684\u6570\u91cf\u4e0d\u76f8\u540c");
                return true;
            }
            Map<String, DrugDetailEntity> drugMainEntityMap = detailEntityList.stream().collect(Collectors.toMap(DrugDetailEntity::getDrugCommonCode, drugDetailEntity -> drugDetailEntity));
            for (FeeItemVO feeItemVO : feeItemList) {
                DrugDetailEntity drugDetailEntity2 = drugMainEntityMap.get(feeItemVO.getItemCode());
                if (feeItemVO.getDays().equals(drugDetailEntity2.getDuration().toString()) && new BigDecimal(feeItemVO.getDoseNoce()).setScale(4, RoundingMode.HALF_UP).equals(drugDetailEntity2.getSingleDose().setScale(4, RoundingMode.HALF_UP)) && feeItemVO.getDoseUnit().equals(drugDetailEntity2.getMeasureUnit()) && new BigDecimal(feeItemVO.getPrice()).setScale(4, RoundingMode.HALF_UP).equals(drugDetailEntity2.getUnitPrice().setScale(4, RoundingMode.HALF_UP)) && new BigDecimal(feeItemVO.getQty()).setScale(4, RoundingMode.HALF_UP).equals(drugDetailEntity2.getAmount().setScale(4, RoundingMode.HALF_UP)) && new BigDecimal(feeItemVO.getCost()).setScale(4, RoundingMode.HALF_UP).equals(drugDetailEntity2.getTotalPrice().setScale(4, RoundingMode.HALF_UP)) && feeItemVO.getSpecs().equals(drugDetailEntity2.getDrugSpec()) && feeItemVO.getUseName().equals(drugDetailEntity2.getUsageDesc()) && feeItemVO.getFreqName().equals(drugDetailEntity2.getFrequencyDesc())) continue;
                log.info("=========his\u836f\u54c1\u7684\u4fe1\u606f\u4e0d\u76f8\u540c->{}", (Object)drugDetailEntity2.toString());
                return true;
            }
        }
        return false;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<?> createDrugTrade(HytDrugPayReqVO vo) {
        if (PayChannelEnum.WX_XCX.getValue().equalsIgnoreCase(vo.getPayChannel()) && StringUtils.isEmpty((String)vo.getOpenId())) {
            return BaseResponse.error((String)"\u5fae\u4fe1\u5c0f\u7a0b\u5e8fopenId\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (CollectionUtils.isEmpty((Collection)vo.getMainIds())) {
            return BaseResponse.error((String)"\u5f53\u524d\u6ca1\u6709\u9700\u8981\u652f\u4ed8\u7684\u5904\u65b9");
        }
        if (this.isRepeatPay(StringUtils.join((Object[])vo.getMainIds().toArray(), (String)","))) {
            return BaseResponse.error((String)"\u8bf7\u52ff\u91cd\u590d\u70b9\u51fb");
        }
        List dtoList = this.drugOrderMapper.queryListOrderByMainId(vo.getMainIds());
        if (CollectionUtils.isEmpty((Collection)dtoList)) {
            return BaseResponse.error((String)"\u533b\u5631\u4fe1\u606f\u7f3a\u5931");
        }
        for (DrugOrderDTO dto : dtoList) {
            if (dto.getOrderStatus() == null || !OrderStatusEnum.PAID.getValue().equals(dto.getOrderStatus())) continue;
            return BaseResponse.error((String)"\u5b58\u5728\u5df2\u652f\u4ed8\u7684\u533b\u5631\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
        }
        List<Object> resVoList = new ArrayList();
        QueryPrescriptionReqVO reqVO = new QueryPrescriptionReqVO();
        reqVO.setClinicCode(vo.getHisRegNo());
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)reqVO);
        BaseResponse response = this.hisManage.sendHis("/hyt-his/api/v1/card/queryPrescription", frontRequest, Object.class);
        DrugMainEntity mainEntity = this.mosDrugMainMapper.queryById((String)vo.getMainIds().get(0));
        HisLogEntity logEntity = this.hisLogService.savaEntity(frontRequest, "/hyt-his/api/v1/card/queryPrescription", mainEntity.getOrganId());
        logEntity.setResponse(JSONObject.toJSONString((Object)response));
        this.hisLogService.update(logEntity);
        if (response.getData() == null || !((Map)response.getData()).containsKey("queryPrescriptionList")) {
            return BaseResponse.error((String)"\u67e5\u8be2\u5904\u65b9\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        List queryPrescriptionList = (List)((Map)response.getData()).get("queryPrescriptionList");
        ObjectMapper mapper = new ObjectMapper();
        queryPrescriptionList = (List)mapper.convertValue((Object)queryPrescriptionList, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        List prescriptionList = this.drugPrescriptionMapper.queryByMainIds(vo.getMainIds());
        ArrayList<PriceInfoFeeItem> priceInfoFeeItemList = new ArrayList<PriceInfoFeeItem>();
        for (DrugPrescriptionEntity drugPrescriptionEntity : prescriptionList) {
            resVoList = queryPrescriptionList.stream().filter(queryPrescription -> queryPrescription.getRecipeNO().equals(drugPrescriptionEntity.getHisRecipeNo())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(resVoList)) {
                return BaseResponse.error((String)"\u5904\u65b9\u5185\u5bb9\u6709\u66f4\u65b0\uff0c\u8bf7\u524d\u5f80\u804a\u5929\u9875\u9762\u4e0e\u533b\u751f\u8054\u7cfb\uff0c\u786e\u8ba4\u5904\u65b9\u540e\u518d\u8fdb\u884c\u652f\u4ed8");
            }
            boolean isPresWhetherSame = this.presWhetherSame(resVoList);
            if (isPresWhetherSame) {
                return BaseResponse.error((String)"\u60a8\u597d\uff0c\u60a8\u7684\u5904\u65b9\u5185\u5bb9\u5df2\u66f4\u65b0\uff0c\u8bf7\u524d\u5f80\u804a\u5929\u9875\u9762\u4e0e\u533b\u751f\u8054\u7cfb\uff0c\u786e\u8ba4\u5904\u65b9\u540e\u518d\u8fdb\u884c\u652f\u4ed8");
            }
            for (QueryPrescriptionResVO resVO : resVoList) {
                for (FeeItemVO feeItemVO : resVO.getFeeItem().getFeeItemList()) {
                    PriceInfoFeeItem priceInfoFeeItem = this.getPriceInfoFeeItem(feeItemVO);
                    priceInfoFeeItemList.add(priceInfoFeeItem);
                }
            }
        }
        PrescriptionPreSettlementReqVo prescriptionPreSettlementReqVo = new PrescriptionPreSettlementReqVo();
        TransModelVo transModelVo = new TransModelVo();
        transModelVo.setBankTransNO("");
        transModelVo.setTransNO("");
        prescriptionPreSettlementReqVo.setTransModelVo(transModelVo);
        prescriptionPreSettlementReqVo.setClinicNO(vo.getHisRegNo());
        prescriptionPreSettlementReqVo.setFeeItems(priceInfoFeeItemList);
        FrontRequest preSettlementFrontRequest = new FrontRequest();
        preSettlementFrontRequest.setBody((Object)prescriptionPreSettlementReqVo);
        BaseResponse baseResponse = this.hisManage.sendHis("/hyt-his/api/v1/prescription/preSettlement", preSettlementFrontRequest, PrescriptionPreSettlementResVo.class);
        log.info("\u9884\u7ed3\u7b97\u63a5\u53e3his\u8fd4\u56de\u4fe1\u606f->{}", (Object)baseResponse.toString());
        HisLogEntity hisLogEntity = this.hisLogService.savaEntity(frontRequest, "/hyt-his/api/v1/prescription/preSettlement", mainEntity.getOrganId());
        hisLogEntity.setResponse(JSONObject.toJSONString((Object)response));
        this.hisLogService.update(hisLogEntity);
        if (!baseResponse.isSuccess()) {
            return BaseResponse.error((String)"\u9884\u7ed3\u7b97\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
        }
        MerchantConfigEntity merchantConfigEntity = this.merchantConfigMapper.queryByOrganCodeAndMerchantType(((DrugOrderDTO)dtoList.get(0)).getPresOrgan(), Integer.valueOf(1));
        String orderSeq = GenSeqUtils.genOrderSeq((String)"");
        for (String mainId : vo.getMainIds()) {
            BigDecimal payAmount = prescriptionList.stream().filter(item -> mainId.equals(item.getMainId())).map(v -> v.getPrice()).reduce(BigDecimal.ZERO, BigDecimal::add);
            DrugOrderEntity orderEntity = this.mosDrugOrderMapper.queryByMainId(mainId);
            if (orderEntity == null) {
                orderEntity = new DrugOrderEntity();
                orderEntity.setxId(GenSeqUtils.getUniqueNo());
                orderEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
                orderEntity.setMainId(mainId);
                orderEntity.setMerchantId(merchantConfigEntity.getMerchantSeq());
                orderEntity.setOrderSeq(orderSeq);
                orderEntity.setBizSysSeq(merchantConfigEntity.getBizSysSeq());
                orderEntity.setOrganCode(((DrugOrderDTO)dtoList.get(0)).getPresOrgan());
                orderEntity.setStatus(OrderStatusEnum.TOPAY.getValue());
                orderEntity.setPayMethod(vo.getPayMethod());
                orderEntity.setPayAmount(payAmount);
                orderEntity.setChannelCode(vo.getPayChannel());
                orderEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                orderEntity.setInvoiceNo(((PrescriptionPreSettlementResVo)baseResponse.getData()).getInvoiceNo());
                this.drugOrderMapper.insert(orderEntity);
                continue;
            }
            orderEntity.setxId(orderEntity.getxId());
            orderEntity.setBizSysSeq(merchantConfigEntity.getBizSysSeq());
            orderEntity.setOrderSeq(orderSeq);
            orderEntity.setPayMethod(vo.getPayMethod());
            orderEntity.setPayAmount(payAmount);
            orderEntity.setChannelCode(vo.getPayChannel());
            orderEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
            orderEntity.setInvoiceNo(((PrescriptionPreSettlementResVo)baseResponse.getData()).getInvoiceNo());
            this.drugOrderMapper.update(orderEntity);
        }
        BigDecimal payAmount = prescriptionList.stream().map(v -> v.getPrice()).reduce(BigDecimal.ZERO, BigDecimal::add);
        PayReqVO payReqVO = new PayReqVO();
        payReqVO.setMerchantId(merchantConfigEntity.getMerchantSeq());
        payReqVO.setBizSysSeq(merchantConfigEntity.getBizSysSeq());
        payReqVO.setPayAmount(payAmount);
        payReqVO.setPayChannel(vo.getPayChannel());
        payReqVO.setPayMethod(vo.getPayMethod());
        payReqVO.setOpenId(StringUtils.isEmpty((String)vo.getOpenId()) ? "" : vo.getOpenId());
        payReqVO.setOrderSeq(orderSeq);
        payReqVO.setProductInfo("\u4e92\u8054\u7f51\u533b\u7597-\u95e8\u8bca\u7f34\u8d39");
        payReqVO.setMerchantType(MerchantTypeEnum.DRUG.getValue());
        payReqVO.setMainId(mainEntity.getxId());
        return this.orderPayManage.createTradeServer(payReqVO);
    }

    public BaseResponse<?> applyRefundLogistics(LogisticsRefundReqVO vo) {
        log.info("======>\u7533\u8bf7\u7269\u6d41\u9000\u6b3e - \u53c2\u6570:{}", (Object)JSON.toJSONString((Object)vo));
        MosDrugLogisticsOrderEntity logisticsOrderEntity = this.drugLogisticsOrderMapper.selectByPrimaryKey(Long.valueOf(vo.getLogisticsId()));
        if (logisticsOrderEntity == null) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u7269\u6d41\u8ba2\u5355");
        }
        if (OrderStatusEnum.REFUNDING.getValue().equals(logisticsOrderEntity.getOrderStatus()) || OrderStatusEnum.REFUNDED.getValue().equals(logisticsOrderEntity.getOrderStatus())) {
            return BaseResponse.error((String)"\u7269\u6d41\u8d39\u7528\u6b63\u5728\u9000\u6b3e\u4e2d\u6216\u5df2\u9000\u6b3e\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
        }
        if (logisticsOrderEntity.getAppCode().equals(this.specialNodeConfig.getHyt()) && (logisticsOrderEntity.getDestAddress().contains("\u822a\u5929\u4e8c\u9662\u4e1c\u5de5\u4e1a\u533a") || logisticsOrderEntity.getDestAddress().contains("\u822a\u5929\u4e8c\u9662\u897f\u5de5\u4e1a\u533a"))) {
            log.info("======\u822a\u5929\u4e8c\u9662\u514d\u7269\u6d41======");
            return BaseResponse.error((String)"\u6b64\u8ba2\u5355\u4e3a\u514d\u8d39\u7269\u6d41\u5355\uff0c\u4e0d\u80fd\u9000\u6b3e\u3002");
        }
        ServicePayBillEntity servicePayBillEntity = this.servicePayBillService.selectByOutTradeNoAndStatus(logisticsOrderEntity.getOrderSeq(), PayBillOrderStatusEnum.PAID.getValue());
        servicePayBillEntity.setStatus(PayBillOrderStatusEnum.REFUNDING.getValue());
        servicePayBillEntity.setId(null);
        servicePayBillEntity.setWorkServiceCode("yyy");
        log.info("\u7533\u8bf7\u7269\u6d41\u9000\u6b3e\u63a5\u53e3\u4fdd\u5b58\u9000\u6b3e\u4e2d\u8d26\u5355:{}", (Object)JSON.toJSONString((Object)servicePayBillEntity));
        this.servicePayBillService.save(servicePayBillEntity);
        RefundReqVO logisticsRefundReqVO = new RefundReqVO();
        logisticsRefundReqVO.setOrderSeq(logisticsOrderEntity.getOrderSeq());
        logisticsRefundReqVO.setDealSeq(logisticsOrderEntity.getDealSeq());
        logisticsRefundReqVO.setMerchantId(logisticsOrderEntity.getMchId());
        logisticsRefundReqVO.setPayMethod(logisticsOrderEntity.getPayMethod());
        logisticsRefundReqVO.setPayAmount(logisticsOrderEntity.getPayAmount());
        logisticsRefundReqVO.setMerchantType(MerchantTypeEnum.LOGISTICS.getValue());
        RefundResVo logisticsRefundResVo = this.orderPayManage.applyRefundServer(logisticsRefundReqVO);
        if (!logisticsRefundResVo.isFlag()) {
            return BaseResponse.error((String)("\u7269\u6d41\u9000\u6b3e\uff1a" + logisticsRefundResVo.getMsg()));
        }
        logisticsOrderEntity.setOrderStatus(OrderStatusEnum.REFUNDING.getValue());
        this.drugLogisticsOrderMapper.updateByPrimaryKeySelective(logisticsOrderEntity);
        List regList = this.drugLogisticsOrderRegMapper.getByLogisticsOrderId(logisticsOrderEntity.getId());
        if (CollectionUtils.isNotEmpty((Collection)regList)) {
            DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(((MosDrugLogisticsOrderRegEntity)regList.get(0)).getMainId());
            new Thread(() -> {
                if (this.specialNodeConfig.getHyt().equals(logisticsOrderEntity.getAppCode())) {
                    LinkedHashMap data = new LinkedHashMap();
                    HashMap<String, String> map1 = new HashMap<String, String>();
                    map1.put("value", drugMainEntity.getPresDoctorName());
                    data.put("doctorName", map1);
                    HashMap<String, String> map2 = new HashMap<String, String>();
                    map2.put("value", " \u7269\u6d41\u8d39\u9000\u6b3e");
                    data.put("issue", map2);
                    HashMap<String, String> map3 = new HashMap<String, String>();
                    map3.put("value", "\u5df2\u8fdb\u884c\u9000\u6b3e\uff0c\u6b3e\u9879\u5c06\u572824\u5c0f\u65f6\u5185\u9000\u56de\u539f\u8d26\u6237");
                    data.put("info", map3);
                    this.pushManage.iWeChatPush(logisticsOrderEntity.getAppCode(), "inquiry_common_notify", this.pushManage.getOpenId(logisticsOrderEntity.getAppCode(), drugMainEntity.getPatientUserId()), data, null);
                }
            }).start();
        }
        return BaseResponse.success();
    }

    private void saveLogisticsPayBill(PayNotifyReqVO payNotifyReqVO, MosDrugLogisticsOrderEntity logisticsOrderEntity) {
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setAppCode(logisticsOrderEntity.getAppCode());
        MerchantConfigEntity merchantConfigEntity = this.merchantConfigMapper.queryByOrganCodeAndMerchantType(logisticsOrderEntity.getAppCode(), MerchantTypeEnum.LOGISTICS.getValue());
        if (Objects.nonNull(merchantConfigEntity)) {
            servicePayBillEntity.setApplyCode(merchantConfigEntity.getMerchantSeq());
        }
        servicePayBillEntity.setDealAmount(payNotifyReqVO.getTotalAmount());
        servicePayBillEntity.setDealTradeNo(payNotifyReqVO.getDealTradeNo());
        servicePayBillEntity.setGoodsInfo("\u4e92\u8054\u7f51\u8bca\u7597-\u7269\u6d41\u8d39");
        servicePayBillEntity.setOrderAmount(payNotifyReqVO.getTotalAmount());
        servicePayBillEntity.setOrganId(logisticsOrderEntity.getHospitalId());
        servicePayBillEntity.setOutTradeNo(logisticsOrderEntity.getOrderSeq());
        servicePayBillEntity.setPayChannel(payNotifyReqVO.getPayChannel());
        servicePayBillEntity.setOrganName(HanyuPinyinUtil.getFirstLettersUp((String)logisticsOrderEntity.getHospitalName()));
        servicePayBillEntity.setServiceCode(logisticsOrderEntity.getAppCode() + "_" + HanyuPinyinUtil.getFirstLettersUp((String)logisticsOrderEntity.getHospitalName()) + "_" + "yyy");
        if (payNotifyReqVO.getReturnCode().equalsIgnoreCase(PayStatusEnum.SUCCESS.getValue())) {
            servicePayBillEntity.setTradeStatus(PayStatusEnum.SUCCESS.getValue());
            servicePayBillEntity.setStatus(PayBillOrderStatusEnum.PAID.getValue());
        } else {
            servicePayBillEntity.setStatus(PayBillOrderStatusEnum.PAID_FAIL.getValue());
            servicePayBillEntity.setTradeStatus(PayStatusEnum.FAIL.getValue());
        }
        servicePayBillEntity.setTradeNo(payNotifyReqVO.getTradeNo());
        servicePayBillEntity.setTradeTime(payNotifyReqVO.getPayTime());
        servicePayBillEntity.setWorkServiceCode("yyy");
        log.info("\u7269\u6d41\u652f\u4ed8\u56de\u8c03\u63a5\u53e3\u4fdd\u5b58\u8d26\u5355\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)servicePayBillEntity));
        this.servicePayBillService.save(servicePayBillEntity);
    }

    private synchronized boolean isRepeatPay(String mainIds) {
        Object val = this.redisUtil.get("yyy_drug_pay_" + mainIds);
        if (Objects.nonNull(val) && Objects.equals(val, "1")) {
            return true;
        }
        this.redisUtil.set("yyy_drug_pay_" + mainIds, (Object)"1", 3L);
        return false;
    }
}

