/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.common.constants.URLConstant;
import com.ebaiyihui.medicalcloud.common.enums.ReturnCodeEnum;
import com.ebaiyihui.medicalcloud.mapper.PharmaceuticalCompanyMapper;
import com.ebaiyihui.medicalcloud.pojo.entity.PharmaceuticalCompanyEntity;
import com.ebaiyihui.medicalcloud.service.PharmaceuticalCompanyService;
import com.ebaiyihui.medicalcloud.utils.HttpUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PharmaceuticalCompanyServiceImpl
implements PharmaceuticalCompanyService {
    private static final Logger log = LoggerFactory.getLogger(PharmaceuticalCompanyServiceImpl.class);
    @Autowired
    private PharmaceuticalCompanyMapper pharmaceuticalCompanyMapper;

    public BaseResponse<List<PharmaceuticalCompanyEntity>> list() {
        return BaseResponse.success((Object)this.pharmaceuticalCompanyMapper.queryAll());
    }

    public BaseResponse<List<Object>> paginglist(JSONObject jsonObject) {
        String pharmaceuticalListUrl = URLConstant.PHARMACEUTICAL_LIST_URL;
        String url = "https://ihos.chinachdu.com/" + pharmaceuticalListUrl;
        List data = new ArrayList();
        try {
            String result = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)jsonObject), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u8bf7\u6c42\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\u67e5\u8be2\u836f\u5546\u7684\u7684\u7ed3\u679c\u662f:{}", (Object)result);
            JSONObject res = (JSONObject)JSONObject.parseObject((String)result, JSONObject.class);
            if (ReturnCodeEnum.SUCCEED.getValue().equals(res.get((Object)"code")) && res.get((Object)"data") != null) {
                data = JSONObject.parseArray((String)res.get((Object)"data").toString()).toJavaList(Object.class);
            }
        }
        catch (IOException e) {
            log.error("\u8c03\u7528\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\u5f02\u5e38");
        }
        return BaseResponse.success(data);
    }

    public BaseResponse<Object> selectPharmacistById(JSONObject jsonObject) {
        String selectPharmacistByIdUrl = URLConstant.SELECT_PHARMACIST_BY_ID_URL;
        String url = "https://ihos.chinachdu.com/" + selectPharmacistByIdUrl;
        Object data = new Object();
        try {
            String result = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)jsonObject), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>selectPharmacistByIdUrl\u7684\u7ed3\u679c\u662f:{}", (Object)result);
            JSONObject res = (JSONObject)JSONObject.parseObject((String)result, JSONObject.class);
            if (ReturnCodeEnum.SUCCEED.getValue().equals(res.get((Object)"code")) && res.get((Object)"data") != null) {
                data = JSONObject.parseObject((String)res.get((Object)"data").toString());
            }
        }
        catch (IOException e) {
            log.error("\u8c03\u7528\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\u5f02\u5e38");
        }
        return BaseResponse.success((Object)data);
    }
}

