/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.utils;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class BYSignUtil {
    private static final Logger log = LoggerFactory.getLogger(BYSignUtil.class);
    private static final String AND = "&";
    private static final String EQUAL = "=";

    public static String getSignature(Map<String, String> reqMap, String key) throws Exception {
        String data = BYSignUtil.getSortedParamStr(reqMap);
        String signature = BYSignUtil.getHMAC((byte[])data.getBytes(), (byte[])key.getBytes(), (String)"HmacSHA256");
        return signature;
    }

    public static void checkSign(Map<String, String> reqMap, String key) throws Exception {
        String cSign;
        String sign;
        long reqTime;
        long currentTimeMillis;
        String jsonString = JSON.toJSONString(reqMap);
        log.info("jsonString = " + jsonString);
        String timestamp = reqMap.get("timestamp");
        if (timestamp == null || "".equals(timestamp)) {
            // empty if block
        }
        if ((currentTimeMillis = System.currentTimeMillis() / 1000L) + 1000L < (reqTime = Long.parseLong(timestamp))) {
            log.info("currentTimeMillis = " + currentTimeMillis);
            log.info("reqTime = " + reqTime);
        }
        if (Math.abs(currentTimeMillis - reqTime) > 300000L) {
            log.info("currentTimeMillis\uff1a" + currentTimeMillis);
            log.info("reqTime\uff1a" + reqTime);
        }
        if ((sign = reqMap.get("sign")) == null || "".equals(sign)) {
            // empty if block
        }
        if (!(cSign = BYSignUtil.getSignature(reqMap, (String)key)).equals(sign)) {
            System.out.println("=====");
        }
    }

    private static String getSortedParamStr(Map<String, String> props) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(props.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = props.get(key);
            if (value == null || "sign".equals(key)) continue;
            if (i == props.size() - 1) {
                sb.append(key).append("=").append((Object)value);
                continue;
            }
            sb.append(key).append("=").append((Object)value).append("&");
        }
        return sb.toString();
    }

    private static String getHMAC(byte[] data, byte[] key, String HmacAlgo) throws Exception {
        SecretKeySpec signingKey = new SecretKeySpec(key, HmacAlgo);
        Mac mac = Mac.getInstance(HmacAlgo);
        mac.init(signingKey);
        return new String(Base64.getEncoder().encode(mac.doFinal(data)));
    }
}

