/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.controller;

import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.exception.BusinessException;
import com.ebaiyihui.medicalcloud.pojo.bm.dto.BMDrugItemResDto;
import com.ebaiyihui.medicalcloud.pojo.bm.dto.CheckPatientDrugsReqDto;
import com.ebaiyihui.medicalcloud.pojo.bm.dto.QueryDrugByBarCodeVO;
import com.ebaiyihui.medicalcloud.pojo.bm.vo.BMAddDrugItemVO;
import com.ebaiyihui.medicalcloud.pojo.bm.vo.BMPageDrugListVO;
import com.ebaiyihui.medicalcloud.pojo.dto.DrugItemQueryResultDTO;
import com.ebaiyihui.medicalcloud.pojo.vo.PageDrugListVO;
import com.ebaiyihui.medicalcloud.service.BMDrugItemService;
import com.ebaiyihui.medicalcloud.utils.ExcelUtils;
import com.ebaiyihui.medicalcloud.utils.excel.ImportDrugTemplateExcel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u4fbf\u6c11\u836f\u54c1 API"})
@RequestMapping(value={"/api/manage/drugItem"})
public class BMDrugItemController {
    private static final Logger log = LoggerFactory.getLogger(BMDrugItemController.class);
    @Resource
    private BMDrugItemService bmDrugItemService;

    @PostMapping(value={"/bm/findDrugItemList"})
    @ApiOperation(value="\u836f\u54c1\u5217\u8868-\u4fbf\u6c11", notes="\u836f\u54c1\u5217\u8868-\u4fbf\u6c11")
    public BaseResponse<PageResult<BMDrugItemResDto>> bmFindDrugItemList(@RequestBody BMPageDrugListVO vo) {
        return this.bmDrugItemService.bmFindDrugItemList(vo);
    }

    @PostMapping(value={"/bm/addDrugItem"})
    @ApiOperation(value="\u65b0\u589e\u836f\u54c1-\u4fbf\u6c11", notes="\u65b0\u589e\u836f\u54c1-\u4fbf\u6c11")
    public BaseResponse<String> bmAddDrugItem(@Validated @RequestBody BMAddDrugItemVO vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)Objects.requireNonNull(bindingResult.getFieldError()).getDefaultMessage());
        }
        return this.bmDrugItemService.bmAddDrugItem(vo);
    }

    @PostMapping(value={"/bm/deleteDrugItemById"})
    @ApiOperation(value="\u5220\u9664\u836f\u54c1-\u4fbf\u6c11", notes="\u5220\u9664\u836f\u54c1-\u4fbf\u6c11")
    public BaseResponse<String> bmDeleteDrugItemById(@RequestParam(value="drugId") String drugId) {
        return this.bmDrugItemService.bmDeleteDrugItemById(drugId);
    }

    @PostMapping(value={"/bm/updateDrugIteam"})
    @ApiOperation(value="\u7f16\u8f91\u836f\u54c1-\u4fbf\u6c11", notes="\u7f16\u8f91\u836f\u54c1-\u4fbf\u6c11")
    public BaseResponse<String> bmUpdateDrugItem(@Validated @RequestBody BMAddDrugItemVO vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)Objects.requireNonNull(bindingResult.getFieldError()).getDefaultMessage());
        }
        return this.bmDrugItemService.bmUpdateDrugItem(vo);
    }

    @PostMapping(value={"/bm/findDrugItemById"})
    @ApiOperation(value="\u6839\u636e\u836f\u54c1id\u67e5\u8be2\u836f\u54c1\u4fe1\u606f-\u4fbf\u6c11", notes="\u6839\u636e\u836f\u54c1id\u67e5\u8be2\u836f\u54c1\u4fe1\u606f-\u4fbf\u6c11")
    public BaseResponse<BMAddDrugItemVO> bmFindDrugItemById(@RequestParam(value="drugId") String drugId) {
        return this.bmDrugItemService.bmFindDrugItemById(drugId);
    }

    @GetMapping(value={"/bm/downloadImportDrugTemplate"})
    @ApiOperation(value="\u836f\u54c1\u5bfc\u5165\u6a21\u677f-\u4fbf\u6c11", notes="\u836f\u54c1\u5bfc\u5165\u6a21\u677f-\u4fbf\u6c11")
    public void bmDownloadImportDrugTemplate(HttpServletResponse response) throws IOException {
        ArrayList list = new ArrayList();
        ExcelUtils.exportExcel(list, null, (String)"\u836f\u54c1\u5bfc\u5165", ImportDrugTemplateExcel.class, (String)"\u836f\u54c1\u5bfc\u5165\u6a21\u677f", (HttpServletResponse)response);
    }

    @PostMapping(value={"/bm/import"})
    @ApiOperation(value="\u836f\u54c1\u5bfc\u5165-\u4fbf\u6c11", notes="\u836f\u54c1\u5bfc\u5165-\u4fbf\u6c11")
    public BaseResponse<String> bmImportItem(@RequestParam(value="appCode") String appCode, @RequestParam(value="hospitalId") String hospitalId, @RequestParam(value="hospitalName") String hospitalName, @RequestParam(value="update") Boolean update, @RequestParam(value="drugType") Integer drugType, @RequestParam(value="pharmaceuticalCompanyId", required=false) String pharmaceuticalCompanyId, MultipartFile file, HttpServletResponse response) {
        if (drugType != 1 && drugType != 2) {
            throw new BusinessException("drugType\u9519\u8bef");
        }
        return this.bmDrugItemService.bmImportItem(appCode, hospitalId, hospitalName, update, drugType, pharmaceuticalCompanyId, file, response);
    }

    @PostMapping(value={"/bm/queryByBarCodes"})
    @ApiOperation(value="\u6839\u636e\u6761\u7801\u67e5\u8be2\u533b\u9662\u836f\u54c1-\u4fbf\u6c11", notes="\u6839\u636e\u6761\u7801\u67e5\u8be2\u533b\u9662\u836f\u54c1-\u4fbf\u6c11")
    public BaseResponse<List<BMDrugItemResDto>> queryByBarCodes(@RequestParam(value="appCode") String appCode, @RequestParam(value="hospitalId") String hospitalId, @RequestParam(value="barCodeSet", required=false) Set<String> barCodeSet) {
        log.info("appCode:{}, hospitalId:{}, barCodeSet:{}", new Object[]{appCode, hospitalId, barCodeSet});
        return this.bmDrugItemService.queryByBarCodes(appCode, hospitalId, barCodeSet);
    }

    @PostMapping(value={"/export"})
    @ApiOperation(value="\u836f\u54c1\u5bfc\u51fa", notes="\u836f\u54c1\u5bfc\u51fa")
    public BaseResponse<String> export(@Validated @RequestBody PageDrugListVO vo, BindingResult bindingResult, HttpServletResponse response) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)Objects.requireNonNull(bindingResult.getFieldError()).getDefaultMessage());
        }
        vo.setPageIndex(Integer.valueOf(1));
        vo.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        return this.bmDrugItemService.export(vo, response);
    }

    @PostMapping(value={"/v1/checkPatientDrugs"})
    @ApiOperation(value="\u60a3\u8005\u9009\u836f\u6821\u9a8c\u7528\u836f\u5929\u6570-\u4fbf\u6c11", notes="\u60a3\u8005\u9009\u836f\u6821\u9a8c\u7528\u836f\u5929\u6570-\u4fbf\u6c11")
    public BaseResponse<String> checkPatientDrugs(@RequestBody @Validated CheckPatientDrugsReqDto reqDto) {
        return this.bmDrugItemService.checkPatientDrugs(reqDto);
    }

    @PostMapping(value={"/queryDrugByBarCode"})
    @ApiOperation(value="\u6839\u636e\u836f\u54c1\u6761\u5f62\u7801\u7f16\u7801\u548c\u836f\u5546id\u67e5\u8be2\u836f\u54c1\u4fe1\u606f", notes="\u6839\u636e\u836f\u54c1\u6761\u5f62\u7801\u7f16\u7801\u548c\u836f\u5546id\u67e5\u8be2\u836f\u54c1\u4fe1\u606f")
    public BaseResponse<DrugItemQueryResultDTO> queryDrugByBarCode(@RequestBody @Validated QueryDrugByBarCodeVO req, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)Objects.requireNonNull(bindingResult.getFieldError()).getDefaultMessage());
        }
        DrugItemQueryResultDTO resVO = this.bmDrugItemService.queryDrugByBarCode(req);
        if (resVO == null) {
            return BaseResponse.success(null);
        }
        return BaseResponse.success((Object)resVO);
    }
}

