/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.manage.CountDrugNumsManage;
import com.ebaiyihui.medicalcloud.pojo.dto.CountDrugDto;
import com.ebaiyihui.medicalcloud.pojo.dto.DrugItemDetailQueryResultDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.DrugItemDto;
import com.ebaiyihui.medicalcloud.pojo.dto.DrugItemResDto;
import com.ebaiyihui.medicalcloud.pojo.dto.DrugNumCountDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.DrugOrderCartDto;
import com.ebaiyihui.medicalcloud.pojo.dto.DrugOrderShoppingDto;
import com.ebaiyihui.medicalcloud.pojo.dto.DrugRecordDto;
import com.ebaiyihui.medicalcloud.pojo.dto.DrugShoppingCartDto;
import com.ebaiyihui.medicalcloud.pojo.dto.drug.DrugSearchResultDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.drug.group.DrugGroupCartDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.drug.group.DrugGroupDetailDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.drug.group.DrugGroupListDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.drug.group.DrugGroupSaveReqDTO;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugFrequencyEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugUnitEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugUsageEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugReasonEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.AddDrugItemVO;
import com.ebaiyihui.medicalcloud.pojo.vo.FindDrugListVo;
import com.ebaiyihui.medicalcloud.pojo.vo.PageDrugItemListVo;
import com.ebaiyihui.medicalcloud.pojo.vo.drugItem.DrugCountReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.drugItem.PatientChooseDrugReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.drugItem.PatientChooseDrugResVo;
import com.ebaiyihui.medicalcloud.service.DrugFrequencyService;
import com.ebaiyihui.medicalcloud.service.DrugItemService;
import com.ebaiyihui.medicalcloud.service.ManageDrugItemService;
import com.ebaiyihui.medicalcloud.service.MosDrugGroupService;
import com.ebaiyihui.medicalcloud.service.MosDrugReasonService;
import com.ebaiyihui.medicalcloud.service.MosDrugUsageService;
import com.ebaiyihui.medicalcloud.utils.AppCodeUtil;
import com.ebaiyihui.medicalcloud.utils.ExcelUtils;
import com.ebaiyihui.medicalcloud.utils.HanyuPinyinUtil;
import com.ebaiyihui.medicalcloud.utils.RedisUtil;
import com.ebaiyihui.medicalcloud.utils.StringUtil;
import com.ebaiyihui.medicalcloud.utils.excel.DrugItemChineseExcel;
import com.ebaiyihui.medicalcloud.utils.excel.DrugItemExcel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u836f\u54c1 API"})
@RequestMapping(value={"/api/manage/drugItem"})
public class DrugItemController {
    private static final Logger log = LoggerFactory.getLogger(DrugItemController.class);
    @Autowired
    private ManageDrugItemService manageDrugItemService;
    @Autowired
    private CountDrugNumsManage countDrugNumsManage;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private MosDrugUsageService mosDrugUsageService;
    @Autowired
    private MosDrugReasonService mosDrugReasonService;
    @Autowired
    private DrugFrequencyService drugFrequencyService;
    @Autowired
    private MosDrugGroupService mosDrugGroupService;
    @Autowired
    private DrugItemService drugItemService;

    @RequestMapping(value={"/findDrugItemList"}, method={RequestMethod.POST})
    @ApiOperation(value="\u836f\u54c1\u5217\u8868", notes="\u836f\u54c1\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="specialDrugType", value="\u533a\u5206\u7ebf\u4e0a \u7ebf\u4e0b\u5b57\u6bb5 0 \u7ebf\u4e0a 1 \u7ebf\u4e0b \u4e0d\u4f20 \u5168\u90e8", paramType="query")})
    public BaseResponse<List<DrugItemResDto>> findDrugItemList(@RequestParam(value="pageIndex", required=false, defaultValue="1") Integer pageIndex, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize, @RequestParam(value="specialDrugType", required=false) Integer specialDrugType, @RequestParam(value="status", required=false, defaultValue="0") Integer status, @RequestParam(value="appCode", required=false, defaultValue="") String appCode, @RequestParam(value="organCode", required=false, defaultValue="") String organCode, @RequestParam(value="search", required=false, defaultValue="") String search, @RequestParam(value="pharmaceuticalCompanyId", required=false, defaultValue="") String pharmaceuticalCompanyId) {
        if (appCode == null || "".equals(appCode)) {
            appCode = organCode;
        }
        if (pageIndex == null) {
            log.error("pageIndex\u4e0d\u80fd\u4e3a\u7a7a...");
            return BaseResponse.error((String)"pageIndex\u4e0d\u80fd\u4e3a\u7a7a...");
        }
        if (pageSize == null) {
            log.error("pageSize\u4e0d\u80fd\u4e3a\u7a7a...");
            return BaseResponse.error((String)"pageSize\u4e0d\u80fd\u4e3a\u7a7a...");
        }
        return this.manageDrugItemService.findDrugItemList(pageIndex, pageSize, status, appCode, search, pharmaceuticalCompanyId, specialDrugType);
    }

    @PostMapping(value={"/v1/findDrugItemList"})
    @ApiOperation(value="\u836f\u54c1\u5217\u8868", notes="\u836f\u54c1\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="specialDrugType", value="\u533a\u5206\u7ebf\u4e0a \u7ebf\u4e0b\u5b57\u6bb5 0 \u7ebf\u4e0a 1 \u7ebf\u4e0b \u4e0d\u4f20 \u5168\u90e8", paramType="query")})
    public BaseResponse<List<DrugItemResDto>> findDrugItemList(@RequestBody PageDrugItemListVo vo) {
        if (vo.getAppCode() == null || "".equals(vo.getAppCode())) {
            vo.setAppCode(vo.getOrganCode());
        }
        if (vo.getPageIndex() == null) {
            log.error("pageIndex\u4e0d\u80fd\u4e3a\u7a7a...");
            return BaseResponse.error((String)"pageIndex\u4e0d\u80fd\u4e3a\u7a7a...");
        }
        if (vo.getPageSize() == null) {
            log.error("pageSize\u4e0d\u80fd\u4e3a\u7a7a...");
            return BaseResponse.error((String)"pageSize\u4e0d\u80fd\u4e3a\u7a7a...");
        }
        return this.manageDrugItemService.findDrugItemList(vo.getPageIndex(), vo.getPageSize(), vo.getStatus(), vo.getAppCode(), vo.getSearch(), vo.getPharmaceuticalCompanyId(), vo.getSpecialDrugType());
    }

    @RequestMapping(value={"/selectDrugByParams"}, method={RequestMethod.POST})
    @ApiOperation(value="\u901a\u8fc7\u836f\u54c1\u901a\u7528\u540d\u79f0\u3001\u89c4\u683c\u3001appCode\u3001\u836f\u5546ID\u67e5\u8be2\u836f\u54c1")
    public BaseResponse<List<PatientChooseDrugResVo>> selectDrugByParams(@RequestBody @Validated PatientChooseDrugReqVo patientChooseDrugReqVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.manageDrugItemService.selectDrugByParams(patientChooseDrugReqVo);
    }

    @RequestMapping(value={"/findDrugCount"}, method={RequestMethod.POST})
    @ApiOperation(value="\u67e5\u8be2\u836f\u54c1\u6570\u91cf", notes="\u67e5\u8be2\u836f\u54c1\u6570\u91cf")
    public BaseResponse<CountDrugDto> findDrugCount(@RequestParam(value="appCode", required=false, defaultValue="") String appCode, @RequestParam(value="organCode", required=false, defaultValue="") String organCode) {
        if (appCode == null || appCode.equals("")) {
            appCode = organCode;
        }
        return this.manageDrugItemService.findDrugCount(appCode);
    }

    @PostMapping(value={"/v1/findDrugCount"})
    @ApiOperation(value="\u67e5\u8be2\u836f\u54c1\u6570\u91cf", notes="\u67e5\u8be2\u836f\u54c1\u6570\u91cf")
    public BaseResponse<CountDrugDto> findDrugCount(@RequestBody FindDrugListVo vo) {
        if (vo.getAppCode() == null || vo.getAppCode().equals("")) {
            vo.setAppCode(vo.getOrganCode());
        }
        return this.manageDrugItemService.findDrugCount(vo.getAppCode());
    }

    @RequestMapping(value={"/updateDrugItemStatus"}, method={RequestMethod.POST})
    @ApiOperation(value="\u4fee\u6539\u836f\u54c1\u72b6\u6001", notes="\u4fee\u6539\u836f\u54c1\u72b6\u6001")
    public BaseResponse<String> updateDrugItemStatus(@RequestParam(value="ids") List<String> ids, @RequestParam(value="status") Integer status) {
        if (status == null) {
            log.error("\u672a\u9009\u62e9\u836f\u54c1\u72b6\u6001");
            return BaseResponse.error((String)"\u672a\u9009\u62e9\u836f\u54c1\u72b6\u6001");
        }
        if (CollectionUtils.isEmpty(ids)) {
            log.error("\u672a\u9009\u62e9\u836f\u54c1ID");
            return BaseResponse.error((String)"\u672a\u9009\u62e9\u836f\u54c1ID");
        }
        return this.manageDrugItemService.updateDrugItemStatus(ids, status);
    }

    @RequestMapping(value={"/deleteDrugItemById"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5220\u9664\u836f\u54c1", notes="\u5220\u9664\u836f\u54c1")
    public BaseResponse<String> deleteDrugItemById(@RequestParam(value="drugId") String drugId) {
        return this.manageDrugItemService.deleteDrugItemById(drugId);
    }

    @RequestMapping(value={"/addDrugIteam"}, method={RequestMethod.POST})
    @ApiOperation(value="\u65b0\u589e\u836f\u54c1", notes="\u65b0\u589e\u836f\u54c1")
    public BaseResponse<String> addDrugItem(@RequestBody AddDrugItemVO vo) {
        if (vo.getAppCode() == "" || vo.getAppCode() == null) {
            vo.setAppCode(vo.getOrganCode());
        }
        return this.manageDrugItemService.addDrugItem(vo);
    }

    @RequestMapping(value={"/findDrugItemById"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6839\u636e\u836f\u54c1id\u67e5\u8be2\u836f\u54c1\u4fe1\u606f", notes="\u6839\u636e\u836f\u54c1id\u67e5\u8be2\u836f\u54c1\u4fe1\u606f")
    public BaseResponse<DrugItemDto> findDrugItemById(@RequestParam(value="drugId") String drugId, @RequestParam(value="appCode", required=false, defaultValue="") String appCode, @RequestParam(value="organCode", required=false, defaultValue="") String organCode) {
        if (StringUtils.isEmpty((CharSequence)drugId)) {
            return BaseResponse.error((String)"\u53c2\u6570\u9519\u8bef:id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)appCode)) {
            appCode = organCode;
        }
        return this.manageDrugItemService.findDrugItemById(drugId, appCode);
    }

    @PostMapping(value={"/v1/findDrugItemById"})
    @ApiOperation(value="\u6839\u636e\u836f\u54c1id\u67e5\u8be2\u836f\u54c1\u4fe1\u606f", notes="\u6839\u636e\u836f\u54c1id\u67e5\u8be2\u836f\u54c1\u4fe1\u606f")
    public BaseResponse<DrugItemDto> findDrugItemById(@RequestBody FindDrugListVo vo) {
        if (StringUtils.isEmpty((CharSequence)vo.getDrugId())) {
            return BaseResponse.error((String)"\u53c2\u6570\u9519\u8bef:id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)vo.getAppCode())) {
            vo.setAppCode(vo.getOrganCode());
        }
        return this.manageDrugItemService.findDrugItemById(vo.getDrugId(), vo.getAppCode());
    }

    @RequestMapping(value={"/updateDrugItem"}, method={RequestMethod.POST})
    @ApiOperation(value="\u4fee\u6539\u836f\u54c1", notes="\u4fee\u6539\u836f\u54c1")
    public BaseResponse<String> updateDrugItem(@RequestBody AddDrugItemVO vo) {
        return this.manageDrugItemService.updateDrugItem(vo);
    }

    @RequestMapping(value={"/findDrugUnitByType"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6839\u636etype\u67e5\u8be2\u836f\u54c1\u5355\u4f4d", notes="\u6839\u636etype\u67e5\u8be2\u836f\u54c1\u5355\u4f4d")
    public BaseResponse<List<DrugUnitEntity>> findDrugUnitByType(@RequestParam(value="type") Integer type) {
        return this.manageDrugItemService.findDrugUnitByType(type);
    }

    @RequestMapping(value={"/findDrugUsage"}, method={RequestMethod.POST})
    @ApiOperation(value="\u67e5\u8be2\u836f\u54c1\u7684\u670d\u7528\u65b9\u5f0f", notes="\u67e5\u8be2\u836f\u54c1\u7684\u670d\u7528\u65b9\u5f0f")
    public BaseResponse<List<DrugUsageEntity>> findDrugUsage(@RequestParam(value="hospitalName", required=false) String hospitalName) {
        return this.manageDrugItemService.findDrugUsage(hospitalName);
    }

    @RequestMapping(value={"/findDrugItemByDrugAlias"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6839\u636e\u836f\u54c1\u522b\u540d\u901a\u7528\u540d\u5546\u54c1\u540d\u67e5\u8be2\u836f\u54c1\u4fe1\u606f", notes="\u6839\u636e\u836f\u54c1\u522b\u540d\u67e5\u8be2\u836f\u54c1\u4fe1\u606f")
    public BaseResponse<DrugSearchResultDTO> findDrugItemByDrugAlias(@RequestParam(value="drugAlias", required=false, defaultValue="") String drugAlias, @RequestParam(value="doctorId") String doctorId, @RequestParam(value="organCode", required=false, defaultValue="") String organCode, @RequestParam(value="appCode", required=false, defaultValue="") String appCode, @RequestParam(value="type", required=false, defaultValue="1") Integer type) {
        log.info("======>\u6839\u636e\u836f\u54c1\u522b\u540d\u67e5\u8be2\u836f\u54c1\u4fe1\u606f\u53c2\u6570drugAlias={},doctorId={},organCode={},appCode={},type={}", new Object[]{drugAlias, doctorId, organCode, appCode, type});
        if (StringUtils.isEmpty((CharSequence)doctorId)) {
            log.error("doctorId...");
            return BaseResponse.error((String)"\u533b\u751fID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (appCode == null || appCode.equals("")) {
            appCode = organCode;
        }
        appCode = AppCodeUtil.tranCode((String)appCode);
        return this.manageDrugItemService.findDrugItemByDrugAlias(drugAlias, doctorId, appCode, type, null, null);
    }

    @PostMapping(value={"/v1/hospitalFindDrugItemByDrugAlias"})
    @ApiOperation(value="\u6839\u636e\u836f\u54c1\u522b\u540d\u901a\u7528\u540d\u5546\u54c1\u540d\u67e5\u8be2\u836f\u54c1\u4fe1\u606f", notes="\u6839\u636e\u836f\u54c1\u522b\u540d\u67e5\u8be2\u836f\u54c1\u4fe1\u606f-\u9662\u5185")
    public BaseResponse<DrugSearchResultDTO> hospitalFindDrugItemByDrugAlias(@RequestBody FindDrugListVo vo) {
        log.info("\u6839\u636e\u522b\u540d\u67e5\u8be2\u9662\u5185\u836f\u54c1====\u300b\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)vo));
        if (StringUtils.isEmpty((CharSequence)vo.getDoctorId())) {
            log.error("doctorId...");
            return BaseResponse.error((String)"\u533b\u751fID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (vo.getAppCode() == null || vo.getAppCode().equals("")) {
            vo.setAppCode(vo.getOrganCode());
        }
        vo.setAppCode(AppCodeUtil.tranCode((String)vo.getAppCode()));
        return this.manageDrugItemService.hospitalFindDrugItemByDrugAlias(vo.getDrugAlias(), vo.getDoctorId(), vo.getAppCode(), vo.getType(), vo.getOrderNumber(), vo.getStoreCode());
    }

    @PostMapping(value={"/v1/findDrugItemByDrugAlias"})
    @ApiOperation(value="\u6839\u636e\u836f\u54c1\u522b\u540d\u901a\u7528\u540d\u5546\u54c1\u540d\u67e5\u8be2\u836f\u54c1\u4fe1\u606f", notes="\u6839\u636e\u836f\u54c1\u522b\u540d\u67e5\u8be2\u836f\u54c1\u4fe1\u606f-\u9662\u5916")
    public BaseResponse<DrugSearchResultDTO> findDrugItemByDrugAlias(@RequestBody FindDrugListVo vo) {
        log.info("\u6839\u636e\u522b\u540d\u67e5\u8be2\u9662\u5916\u836f\u54c1====\u300b\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)vo));
        if (StringUtils.isEmpty((CharSequence)vo.getDoctorId())) {
            return BaseResponse.error((String)"\u533b\u751fID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (vo.getAppCode() == null || vo.getAppCode().isEmpty()) {
            vo.setAppCode(vo.getOrganCode());
        }
        vo.setAppCode(AppCodeUtil.tranCode((String)vo.getAppCode()));
        return this.manageDrugItemService.findDrugItemByDrugAlias(vo.getDrugAlias(), vo.getDoctorId(), vo.getAppCode(), vo.getType(), vo.getOrderNumber(), vo.getPharmacistId());
    }

    @RequestMapping(value={"/detail"}, method={RequestMethod.POST})
    @ApiOperation(value="\u67e5\u8be2\u836f\u54c1\u9879\u8be6\u60c5", notes="\u533b\u751f\u7aef\u67e5\u8be2\u836f\u54c1\u9879\u8be6\u60c5")
    public BaseResponse<DrugItemDetailQueryResultDTO> queryDetail(@RequestParam(value="drugCode", required=false) String drugCode, @RequestParam(value="hospitalName", required=false) String hospitalName) {
        return this.manageDrugItemService.queryDetail(drugCode, hospitalName);
    }

    @PostMapping(value={"/v1/detail"})
    @ApiOperation(value="\u67e5\u8be2\u836f\u54c1\u9879\u8be6\u60c5", notes="\u533b\u751f\u7aef\u67e5\u8be2\u836f\u54c1\u9879\u8be6\u60c5")
    public BaseResponse<DrugItemDetailQueryResultDTO> queryDetail(@RequestBody FindDrugListVo vo) {
        return this.manageDrugItemService.queryDetail(vo.getDrugCode(), vo.getHospitalName());
    }

    @RequestMapping(value={"/countDrugNums"}, method={RequestMethod.POST})
    @ApiOperation(value="\u8ba1\u7b97\u53d6\u836f\u91cf", notes="\u8ba1\u7b97\u53d6\u836f\u91cf")
    public BaseResponse<Object> countDrugNums(@RequestBody DrugNumCountDTO drugNumCountDTO) {
        return this.countDrugNumsManage.countDrugNums(drugNumCountDTO);
    }

    @RequestMapping(value={"/saveDrugRecord"}, method={RequestMethod.POST})
    @ApiOperation(value="\u4fdd\u5b58\u836f\u54c1\u8bb0\u5f55", notes="\u4fdd\u5b58\u836f\u54c1\u8bb0\u5f55")
    public BaseResponse<String> saveDrugRecord(@RequestBody DrugOrderCartDto drugOrderCartDto) {
        Object o;
        BaseResponse verifyQyt;
        log.info("==========>\u4fdd\u5b58\u836f\u54c1\u8bb0\u5f55\u53c2\u6570" + JSONObject.toJSONString((Object)drugOrderCartDto));
        if (Objects.equals(drugOrderCartDto.getAppCode(), "GNYFY") && !(verifyQyt = this.drugItemService.verifyQyt(drugOrderCartDto.getDrugRecordDto().getxId())).isSuccess()) {
            return verifyQyt;
        }
        if (drugOrderCartDto.getOrderNumber() == null || drugOrderCartDto.getOrderNumber().equals("")) {
            return BaseResponse.error((String)"\u8ba2\u5355\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        if (drugOrderCartDto.getAppCode() == null || drugOrderCartDto.getAppCode().equals("")) {
            drugOrderCartDto.setAppCode(drugOrderCartDto.getOrganCode());
        }
        log.info("==========\u836f\u54c1\u7c7b\u578b" + drugOrderCartDto.getDrugRecordDto().getType());
        if (drugOrderCartDto.getDrugRecordDto().getType() == null) {
            drugOrderCartDto.getDrugRecordDto().setType(Integer.valueOf(1));
        }
        drugOrderCartDto.setOrganCode(AppCodeUtil.tranCode((String)drugOrderCartDto.getAppCode()));
        String key = drugOrderCartDto.getOrderNumber() + "_" + drugOrderCartDto.getAppCode() + "_" + drugOrderCartDto.getDrugRecordDto().getType();
        if (drugOrderCartDto.getOrderSource() != null) {
            key = drugOrderCartDto.getOrderNumber() + "_" + drugOrderCartDto.getAppCode() + "_" + drugOrderCartDto.getDrugRecordDto().getType() + "_" + drugOrderCartDto.getOrderSource();
        }
        if ((o = this.redisUtil.get(key)) == null) {
            ArrayList<DrugRecordDto> drugRecordDtoList = new ArrayList<DrugRecordDto>();
            drugRecordDtoList.add(drugOrderCartDto.getDrugRecordDto());
            Boolean b = this.redisUtil.set(key, (Object)JSONObject.toJSONString(drugRecordDtoList));
            if (b.booleanValue()) {
                return BaseResponse.success((Object)"\u4fdd\u5b58\u6210\u529f");
            }
            return BaseResponse.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        List drugRecordDtoList = JSONObject.parseArray((String)o.toString(), DrugRecordDto.class);
        for (DrugRecordDto drugRecordDto : drugRecordDtoList) {
            if (!drugRecordDto.getDrugCode().equals(drugOrderCartDto.getDrugRecordDto().getDrugCode())) continue;
            drugRecordDto.setSingleDoes(drugOrderCartDto.getDrugRecordDto().getSingleDoes());
            drugRecordDto.setDrugCode(drugOrderCartDto.getDrugRecordDto().getDrugCode());
            drugRecordDto.setMinBillPackingUnit(drugOrderCartDto.getDrugRecordDto().getMinBillPackingUnit());
            drugRecordDto.setCommonName(drugOrderCartDto.getDrugRecordDto().getCommonName());
            drugRecordDto.setDrugSpec(drugOrderCartDto.getDrugRecordDto().getDrugSpec());
            drugRecordDto.setPrice(drugOrderCartDto.getDrugRecordDto().getPrice());
            drugRecordDto.setWholePackingUnit(drugOrderCartDto.getDrugRecordDto().getWholePackingUnit());
            drugRecordDto.setFrequencyDesc(drugOrderCartDto.getDrugRecordDto().getFrequencyDesc());
            drugRecordDto.setDrugUsageDesc(drugOrderCartDto.getDrugRecordDto().getDrugUsageDesc());
            drugRecordDto.setRemark(drugOrderCartDto.getDrugRecordDto().getRemark());
            drugRecordDto.setDrugDosage(drugOrderCartDto.getDrugRecordDto().getDrugDosage());
            drugRecordDto.setPriceDrugDosage(drugOrderCartDto.getDrugRecordDto().getPriceDrugDosage());
            drugRecordDto.setUsageDesc(drugOrderCartDto.getDrugRecordDto().getFrequencyDesc());
            drugRecordDto.setMeasureNum(drugOrderCartDto.getDrugRecordDto().getMeasureNum());
            drugRecordDto.setMinBillPackingNum(drugOrderCartDto.getDrugRecordDto().getMinBillPackingNum());
            drugRecordDto.setProductName(drugOrderCartDto.getDrugRecordDto().getProductName());
            drugRecordDto.setReason(drugOrderCartDto.getDrugRecordDto().getReason());
            drugRecordDto.setCycle(drugOrderCartDto.getDrugRecordDto().getCycle());
            Boolean b = this.redisUtil.set(key, (Object)JSONObject.toJSONString((Object)drugRecordDtoList));
            if (b.booleanValue()) {
                return BaseResponse.success((Object)"\u4fdd\u5b58\u6210\u529f");
            }
            return BaseResponse.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        drugRecordDtoList.add(drugOrderCartDto.getDrugRecordDto());
        Boolean b = this.redisUtil.set(key, (Object)JSONObject.toJSONString((Object)drugRecordDtoList));
        if (b.booleanValue()) {
            return BaseResponse.success((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        return BaseResponse.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @RequestMapping(value={"/saveDrugGroupRecord"}, method={RequestMethod.POST})
    @ApiOperation(value="\u4fdd\u5b58\u836f\u54c1\u8bb0\u5f55", notes="\u4fdd\u5b58\u7ec4\u5957\u836f\u54c1\u8bb0\u5f55")
    public BaseResponse<String> saveDrugGroupRecord(@RequestBody DrugGroupCartDTO dto) {
        List drugRecordDtoList;
        if (StringUtils.isNotEmpty((CharSequence)dto.getAppCode())) {
            dto.setOrganCode(dto.getAppCode());
        }
        for (Object drugRecordDto : dto.getDrugRecordDto()) {
            if (drugRecordDto.getType() != null) continue;
            drugRecordDto.setType(Integer.valueOf(1));
        }
        log.info("==========>\u4fdd\u5b58\u7ec4\u5957\u836f\u54c1\u8bb0\u5f55\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        if (CollectionUtils.isEmpty((Collection)dto.getDrugRecordDto())) {
            return BaseResponse.error((String)"\u8bf7\u9009\u62e9\u836f\u54c1");
        }
        dto.setOrganCode(AppCodeUtil.tranCode((String)dto.getOrganCode()));
        String key = "";
        for (DrugRecordDto drugRecordDto : dto.getDrugRecordDto()) {
            key = dto.getOrderNumber() + "_" + dto.getOrganCode() + "_" + drugRecordDto.getType();
        }
        Object o = this.redisUtil.get(key);
        if (o == null) {
            drugRecordDtoList = dto.getDrugRecordDto();
            Boolean b = this.redisUtil.set(key, (Object)JSONObject.toJSONString((Object)drugRecordDtoList));
            if (b.booleanValue()) {
                return BaseResponse.success((Object)"\u4fdd\u5b58\u6210\u529f");
            }
            return BaseResponse.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        drugRecordDtoList = JSONObject.parseArray((String)o.toString(), DrugRecordDto.class);
        for (DrugRecordDto drugRecordDto : drugRecordDtoList) {
            Iterator iterator = dto.getDrugRecordDto().iterator();
            while (iterator.hasNext()) {
                if (!((DrugRecordDto)iterator.next()).getDrugCode().equals(drugRecordDto.getDrugCode())) continue;
                iterator.remove();
            }
        }
        drugRecordDtoList.addAll(dto.getDrugRecordDto());
        Boolean b = this.redisUtil.set(key, (Object)JSONObject.toJSONString((Object)drugRecordDtoList));
        if (b.booleanValue()) {
            return BaseResponse.success((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        return BaseResponse.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @RequestMapping(value={"/findDrugRecord"}, method={RequestMethod.POST})
    @ApiOperation(value="\u67e5\u770b\u836f\u54c1\u8d2d\u7269\u8f66", notes="\u67e5\u770b\u836f\u54c1\u8d2d\u7269\u8f66")
    public BaseResponse<DrugOrderShoppingDto> findDrugRecord(@RequestParam(value="orderNumber") String orderNumber, @RequestParam(value="organCode", required=false, defaultValue="") String organCode, @RequestParam(value="appCode", required=false, defaultValue="") String appCode, @RequestParam(value="type", required=false, defaultValue="1") Integer type) {
        if (orderNumber == null || orderNumber.equals("")) {
            return BaseResponse.error((String)"\u8ba2\u5355\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        if (appCode == null || appCode.equals("")) {
            appCode = organCode;
        }
        if (type == 0 || type == null) {
            type = 1;
        }
        appCode = AppCodeUtil.tranCode((String)appCode);
        String key = orderNumber + "_" + appCode + "_" + type;
        BigDecimal totalprice = BigDecimal.valueOf(0.0);
        DrugOrderShoppingDto drugOrderShoppingDto = new DrugOrderShoppingDto();
        Object o = this.redisUtil.get(key);
        if (o == null) {
            DrugOrderShoppingDto dto = new DrugOrderShoppingDto();
            return BaseResponse.success((Object)dto);
        }
        List drugRecordDtoList = JSONObject.parseArray((String)this.redisUtil.get(key).toString(), DrugRecordDto.class);
        if (drugRecordDtoList == null) {
            DrugOrderShoppingDto dto = new DrugOrderShoppingDto();
            return BaseResponse.success((Object)dto);
        }
        ArrayList<DrugShoppingCartDto> list = new ArrayList<DrugShoppingCartDto>();
        for (DrugRecordDto drugRecordDto : drugRecordDtoList) {
            DrugShoppingCartDto drugShoppingCartDto = new DrugShoppingCartDto();
            drugShoppingCartDto.setCommonName(drugRecordDto.getCommonName());
            drugShoppingCartDto.setxId(drugRecordDto.getxId());
            drugShoppingCartDto.setDrugDosage(drugRecordDto.getDrugDosage());
            drugShoppingCartDto.setWholePackingUnit(drugRecordDto.getWholePackingUnit());
            log.info("========\u4f20\u5165\u7684\u53d6\u836f\u91cf" + drugRecordDto.getDrugDosage());
            BigDecimal a = drugRecordDto.getPrice();
            BigDecimal itemPrice = drugRecordDto.getPrice().multiply(drugRecordDto.getDrugDosage().setScale(4, 4)).setScale(2, 4);
            log.info("========\u8ba1\u7b97\u7684\u4ef7\u683c" + itemPrice);
            drugShoppingCartDto.setItemPrice(itemPrice);
            if (type != 3) {
                drugShoppingCartDto.setNumberUtil(StringUtil.getNoZeros((String)drugRecordDto.getDrugDosage().setScale(0, 4).toString()) + drugRecordDto.getWholePackingUnit());
            } else {
                drugShoppingCartDto.setNumberUtil(StringUtil.getNoZeros((String)drugRecordDto.getDrugDosage().setScale(4, 4).toString()) + drugRecordDto.getMeasureUnit());
            }
            list.add(drugShoppingCartDto);
        }
        for (int i = 0; i < list.size(); ++i) {
            totalprice = totalprice.add(((DrugShoppingCartDto)list.get(i)).getItemPrice()).setScale(2);
        }
        drugOrderShoppingDto.setDrugShoppingCartDtoList(list);
        drugOrderShoppingDto.setTotalPrice(totalprice);
        return BaseResponse.success((Object)drugOrderShoppingDto);
    }

    @PostMapping(value={"/v1/findDrugRecord"})
    @ApiOperation(value="\u67e5\u770b\u836f\u54c1\u8d2d\u7269\u8f66", notes="\u67e5\u770b\u836f\u54c1\u8d2d\u7269\u8f66")
    public BaseResponse<DrugOrderShoppingDto> findDrugRecord(@RequestBody FindDrugListVo vo) {
        if (vo.getOrderNumber() == null || vo.getOrderNumber().equals("")) {
            return BaseResponse.error((String)"\u8ba2\u5355\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        if (vo.getAppCode() == null || vo.getAppCode().equals("")) {
            vo.setAppCode(vo.getOrganCode());
        }
        if (vo.getType() == 0 || vo.getType() == null) {
            vo.setType(Integer.valueOf(1));
        }
        vo.setAppCode(AppCodeUtil.tranCode((String)vo.getAppCode()));
        String key = vo.getOrderNumber() + "_" + vo.getAppCode() + "_" + vo.getType();
        if (vo.getOrderSource() != null) {
            key = key + "_" + vo.getOrderSource();
        }
        BigDecimal totalprice = BigDecimal.valueOf(0.0);
        DrugOrderShoppingDto drugOrderShoppingDto = new DrugOrderShoppingDto();
        Object o = this.redisUtil.get(key);
        if (o == null) {
            DrugOrderShoppingDto dto = new DrugOrderShoppingDto();
            return BaseResponse.success((Object)dto);
        }
        List drugRecordDtoList = JSONObject.parseArray((String)this.redisUtil.get(key).toString(), DrugRecordDto.class);
        if (drugRecordDtoList == null) {
            DrugOrderShoppingDto dto = new DrugOrderShoppingDto();
            return BaseResponse.success((Object)dto);
        }
        ArrayList<DrugShoppingCartDto> list = new ArrayList<DrugShoppingCartDto>();
        for (DrugRecordDto drugRecordDto : drugRecordDtoList) {
            DrugShoppingCartDto drugShoppingCartDto = new DrugShoppingCartDto();
            drugShoppingCartDto.setCommonName(drugRecordDto.getCommonName());
            drugShoppingCartDto.setxId(drugRecordDto.getxId());
            drugShoppingCartDto.setDrugCode(drugRecordDto.getDrugCode());
            drugShoppingCartDto.setDrugDosage(drugRecordDto.getDrugDosage());
            drugShoppingCartDto.setWholePackingUnit(drugRecordDto.getWholePackingUnit());
            log.info("========\u4f20\u5165\u7684\u53d6\u836f\u91cf" + drugRecordDto.getDrugDosage());
            BigDecimal a = drugRecordDto.getPrice();
            BigDecimal itemPrice = drugRecordDto.getPrice().multiply(drugRecordDto.getDrugDosage().setScale(4, 4)).setScale(2, 4);
            log.info("========\u8ba1\u7b97\u7684\u4ef7\u683c" + itemPrice);
            drugShoppingCartDto.setItemPrice(itemPrice);
            if (vo.getType() != 3) {
                drugShoppingCartDto.setNumberUtil(StringUtil.getNoZeros((String)drugRecordDto.getDrugDosage().setScale(0, 4).toString()) + drugRecordDto.getWholePackingUnit());
            } else {
                drugShoppingCartDto.setNumberUtil(StringUtil.getNoZeros((String)drugRecordDto.getDrugDosage().setScale(4, 4).toString()) + drugRecordDto.getMeasureUnit());
            }
            list.add(drugShoppingCartDto);
        }
        for (int i = 0; i < list.size(); ++i) {
            totalprice = vo.getType() == 3 ? totalprice.add(((DrugShoppingCartDto)list.get(i)).getItemPrice()).setScale(4) : totalprice.add(((DrugShoppingCartDto)list.get(i)).getItemPrice()).setScale(2);
        }
        drugOrderShoppingDto.setDrugShoppingCartDtoList(list);
        drugOrderShoppingDto.setTotalPrice(totalprice);
        return BaseResponse.success((Object)drugOrderShoppingDto);
    }

    @RequestMapping(value={"/findDrugRecordDetail"}, method={RequestMethod.POST})
    @ApiOperation(value="\u67e5\u770b\u836f\u54c1\u8d2d\u7269\u8f66\u8be6\u60c5", notes="\u67e5\u770b\u836f\u54c1\u8d2d\u7269\u8f66\u8be6\u60c5")
    public BaseResponse<List<DrugRecordDto>> findDrugRecordDetail(@RequestParam(value="orderNumber") String orderNumber, @RequestParam(value="organCode", required=false, defaultValue="") String organCode, @RequestParam(value="appCode", required=false, defaultValue="") String appCode, @RequestParam(value="type", required=false, defaultValue="1") Integer type, @RequestParam(value="hospitalName", required=false) String hospitalName) {
        if (orderNumber == null || orderNumber.equals("")) {
            return BaseResponse.error((String)"\u8ba2\u5355\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        if (appCode == null || appCode.equals("")) {
            appCode = organCode;
        }
        if (type == 0 || type == null) {
            type = 1;
        }
        log.info("========>\u67e5\u770b\u836f\u54c1\u8d2d\u7269\u8f66\u8be6\u60c5\u53c2\u6570------>orderNumber={},organCode={},type={},appCode={},hospitalName={}", new Object[]{orderNumber, organCode, type, appCode, hospitalName});
        String hospitalNameFirstLetter = null;
        if (StringUtils.isNotEmpty((CharSequence)hospitalName)) {
            hospitalNameFirstLetter = HanyuPinyinUtil.getFirstLetters((String)hospitalName, (HanyuPinyinCaseType)HanyuPinyinCaseType.UPPERCASE);
        }
        BigDecimal totalprice = BigDecimal.valueOf(0.0);
        appCode = AppCodeUtil.tranCode((String)appCode);
        ArrayList<DrugRecordDto> list = new ArrayList<DrugRecordDto>();
        String key = orderNumber + "_" + appCode + "_" + type;
        Object o = this.redisUtil.get(key);
        if (o == null) {
            ArrayList newlist = new ArrayList();
            return BaseResponse.success(newlist);
        }
        List drugRecordDtoList = JSONObject.parseArray((String)this.redisUtil.get(key).toString(), DrugRecordDto.class);
        log.info("========>\u67e5\u770b\u836f\u54c1\u8d2d\u7269\u8f66\u8be6\u60c5drugRecordDtoList------>drugRecordDtoList={}", (Object)JSON.toJSONString((Object)drugRecordDtoList));
        for (DrugRecordDto drugRecordDto : drugRecordDtoList) {
            DrugRecordDto drugRecordDto1 = new DrugRecordDto();
            if (type != 3) {
                drugRecordDto1.setSingleDoes(new BigDecimal(StringUtil.getNoZeros((String)drugRecordDto.getSingleDoes().setScale(4, 4).toString())));
            }
            drugRecordDto1.setDrugCode(drugRecordDto.getDrugCode());
            drugRecordDto1.setMinBillPackingUnit(drugRecordDto.getMinBillPackingUnit());
            drugRecordDto1.setCommonName(drugRecordDto.getCommonName());
            drugRecordDto1.setDrugSpec(drugRecordDto.getDrugSpec());
            drugRecordDto1.setPrice(drugRecordDto.getPrice().setScale(2, 4));
            drugRecordDto1.setWholePackingUnit(drugRecordDto.getWholePackingUnit());
            drugRecordDto1.setFrequencyDesc(drugRecordDto.getFrequencyDesc());
            drugRecordDto1.setDrugUsageDesc(drugRecordDto.getDrugUsageDesc());
            drugRecordDto1.setRemark(drugRecordDto.getRemark());
            drugRecordDto1.setCycle(drugRecordDto.getCycle());
            drugRecordDto1.setProductName(drugRecordDto.getProductName());
            drugRecordDto1.setReason(drugRecordDto.getReason());
            drugRecordDto1.setxId(drugRecordDto.getxId());
            drugRecordDto1.setMeasureNum(drugRecordDto.getMeasureNum());
            drugRecordDto1.setMinBillPackingNum(drugRecordDto.getMinBillPackingNum());
            drugRecordDto1.setDrugDosage(new BigDecimal(StringUtil.getNoZeros((String)drugRecordDto.getDrugDosage().setScale(4, 4).toString())));
            drugRecordDto1.setMeasureUnit(drugRecordDto.getMeasureUnit());
            BigDecimal itemPrice = drugRecordDto.getPrice().multiply(drugRecordDto.getDrugDosage().setScale(4, 4)).setScale(2, 4);
            log.info("========\u8ba1\u7b97\u7684\u4ef7\u683c" + itemPrice);
            drugRecordDto1.setItemPrice(itemPrice);
            log.info("=============\u4f20\u5165\u7684\u5355\u6b21\u5242\u91cf" + drugRecordDto.getSingleDoes());
            if (type == 3) {
                drugRecordDto1.setUsageDesc(new BigDecimal(StringUtil.getNoZeros((String)drugRecordDto.getDrugDosage().setScale(4, 4).toString())) + drugRecordDto.getMeasureUnit().toString());
            } else {
                drugRecordDto1.setPriceDrugDosage("\u00a5" + drugRecordDto.getPrice() + "*" + drugRecordDto.getDrugDosage());
                drugRecordDto1.setUsageDesc(drugRecordDto.getFrequencyDesc() + ",\u6bcf\u6b21" + new BigDecimal(StringUtil.getNoZeros((String)drugRecordDto.getSingleDoes().setScale(4, 4).toString())) + drugRecordDto.getMeasureUnit() + "," + drugRecordDto.getDrugUsageDesc());
            }
            log.info("========>\u904d\u5386\u67e5\u8be2drugRecordDtoList------>drugUsageDesc={}", (Object)drugRecordDto.getDrugUsageDesc());
            DrugUsageEntity drugUsageEntity = new DrugUsageEntity();
            drugUsageEntity = this.mosDrugUsageService.getByDescAndHospitalNameFirstLetter(drugRecordDto.getDrugUsageDesc(), hospitalNameFirstLetter);
            if (drugUsageEntity == null) {
                drugUsageEntity = this.mosDrugUsageService.getByDescAndHospitalNameFirstLetter(drugRecordDto.getDrugUsageDesc(), null);
            }
            if (drugUsageEntity != null) {
                drugRecordDto1.setUsageId(drugUsageEntity.getxId());
            }
            log.info("========>\u904d\u5386\u67e5\u8be2drugRecordDtoList------>frequencyDesc={}", (Object)drugRecordDto.getFrequencyDesc());
            DrugFrequencyEntity drugFrequencyEntity = new DrugFrequencyEntity();
            drugFrequencyEntity = this.drugFrequencyService.getByDescAndHospitalNameFirstLetter(drugRecordDto.getFrequencyDesc(), hospitalNameFirstLetter);
            if (drugFrequencyEntity == null) {
                drugFrequencyEntity = this.drugFrequencyService.getByDescAndHospitalNameFirstLetter(drugRecordDto.getFrequencyDesc(), null);
            }
            if (drugFrequencyEntity != null) {
                drugRecordDto1.setFrequencyId(drugFrequencyEntity.getxId());
            }
            log.info("========>\u904d\u5386\u67e5\u8be2drugRecordDtoList------>reason={}", (Object)drugRecordDto.getReason());
            MosDrugReasonEntity mosDrugReasonEntity = this.mosDrugReasonService.getByDesc(drugRecordDto.getReason());
            if (mosDrugReasonEntity != null) {
                drugRecordDto1.setReasonId(mosDrugReasonEntity.getXId());
            }
            list.add(drugRecordDto1);
        }
        for (int i = 0; i < list.size(); ++i) {
            log.info("=====\u836f\u54c1\u9879\u4ef7\u683c" + ((DrugRecordDto)list.get(i)).getItemPrice());
            totalprice = totalprice.add(((DrugRecordDto)list.get(i)).getItemPrice()).setScale(2);
            log.info("=====\u603b\u4ef7\u683c" + totalprice);
        }
        for (DrugRecordDto drugRecordDto : list) {
            drugRecordDto.setTotalPrice(totalprice);
        }
        log.info("====\u8fd4\u56de\u6570\u636e" + JSONObject.toJSONString(list));
        return BaseResponse.success(list);
    }

    @PostMapping(value={"/v1/findDrugRecordDetail"})
    @ApiOperation(value="\u67e5\u770b\u836f\u54c1\u8d2d\u7269\u8f66\u8be6\u60c5", notes="\u67e5\u770b\u836f\u54c1\u8d2d\u7269\u8f66\u8be6\u60c5")
    public BaseResponse<List<DrugRecordDto>> findDrugRecordDetail(@RequestBody FindDrugListVo vo) {
        Object o;
        if (vo.getOrderNumber() == null || vo.getOrderNumber().isEmpty()) {
            return BaseResponse.error((String)"\u8ba2\u5355\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        if (vo.getAppCode() == null || vo.getAppCode().isEmpty()) {
            vo.setAppCode(vo.getOrganCode());
        }
        if (vo.getType() == 0) {
            vo.setType(Integer.valueOf(1));
        }
        log.info("========>\u67e5\u770b\u836f\u54c1\u8d2d\u7269\u8f66\u8be6\u60c5\u53c2\u6570{}", (Object)JSON.toJSONString((Object)vo));
        String hospitalNameFirstLetter = null;
        if (StringUtils.isNotEmpty((CharSequence)vo.getHospitalName())) {
            hospitalNameFirstLetter = HanyuPinyinUtil.getFirstLetters((String)vo.getHospitalName(), (HanyuPinyinCaseType)HanyuPinyinCaseType.UPPERCASE);
        }
        BigDecimal totalprice = BigDecimal.valueOf(0.0);
        vo.setAppCode(AppCodeUtil.tranCode((String)vo.getAppCode()));
        ArrayList<DrugRecordDto> list = new ArrayList<DrugRecordDto>();
        String key = vo.getOrderNumber() + "_" + vo.getAppCode() + "_" + vo.getType();
        if (vo.getOrderSource() != null) {
            key = key + "_" + vo.getOrderSource();
        }
        if ((o = this.redisUtil.get(key)) == null) {
            ArrayList newlist = new ArrayList();
            return BaseResponse.success(newlist);
        }
        List drugRecordDtoList = JSONObject.parseArray((String)this.redisUtil.get(key).toString(), DrugRecordDto.class);
        log.info("======>\u67e5\u770b\u836f\u54c1\u8d2d\u7269\u8f66\u8be6\u60c5drugRecordDtoList------>drugRecordDtoList==={}", (Object)JSON.toJSONString((Object)drugRecordDtoList));
        for (DrugRecordDto drugRecordDto : drugRecordDtoList) {
            DrugRecordDto drugRecordDto1 = new DrugRecordDto();
            if (vo.getType() != 3) {
                if (drugRecordDto.getSingleDoes() != null) {
                    drugRecordDto1.setSingleDoes(new BigDecimal(StringUtil.getNoZeros((String)drugRecordDto.getSingleDoes().setScale(4, 4).toString())));
                } else {
                    drugRecordDto1.setSingleDoes(new BigDecimal(0));
                }
            }
            drugRecordDto1.setDrugCode(drugRecordDto.getDrugCode());
            drugRecordDto1.setMinBillPackingUnit(drugRecordDto.getMinBillPackingUnit());
            drugRecordDto1.setCommonName(drugRecordDto.getCommonName());
            drugRecordDto1.setDrugSpec(drugRecordDto.getDrugSpec());
            if (vo.getType() == 3) {
                drugRecordDto1.setPrice(drugRecordDto.getPrice().setScale(4, RoundingMode.HALF_UP));
            } else {
                drugRecordDto1.setPrice(drugRecordDto.getPrice().setScale(2, RoundingMode.HALF_UP));
            }
            drugRecordDto1.setWholePackingUnit(drugRecordDto.getWholePackingUnit());
            if (drugRecordDto.getFrequencyDesc() != null) {
                drugRecordDto1.setFrequencyDesc(drugRecordDto.getFrequencyDesc());
            } else {
                drugRecordDto1.setFrequencyDesc("");
            }
            if (drugRecordDto.getDrugUsageDesc() != null) {
                drugRecordDto1.setDrugUsageDesc(drugRecordDto.getDrugUsageDesc());
            } else {
                drugRecordDto1.setDrugUsageDesc("");
            }
            drugRecordDto1.setRemark(drugRecordDto.getRemark());
            if (drugRecordDto.getCycle() != null) {
                drugRecordDto1.setCycle(drugRecordDto.getCycle());
            } else {
                drugRecordDto1.setCycle(Integer.valueOf(0));
            }
            drugRecordDto1.setProductName(drugRecordDto.getProductName());
            drugRecordDto1.setReason(drugRecordDto.getReason());
            drugRecordDto1.setxId(drugRecordDto.getxId());
            drugRecordDto1.setMeasureNum(drugRecordDto.getMeasureNum());
            drugRecordDto1.setMinBillPackingNum(drugRecordDto.getMinBillPackingNum());
            if (drugRecordDto.getDrugDosage() != null) {
                drugRecordDto1.setDrugDosage(new BigDecimal(StringUtil.getNoZeros((String)drugRecordDto.getDrugDosage().setScale(4, RoundingMode.HALF_UP).toString())));
            } else {
                drugRecordDto1.setDrugDosage(new BigDecimal(0));
            }
            drugRecordDto1.setMeasureUnit(drugRecordDto.getMeasureUnit());
            BigDecimal itemPrice = drugRecordDto.getDrugDosage() != null ? (vo.getType() == 3 ? drugRecordDto.getPrice().multiply(drugRecordDto.getDrugDosage().setScale(4, RoundingMode.HALF_UP)).setScale(4, RoundingMode.HALF_UP) : drugRecordDto.getPrice().multiply(drugRecordDto.getDrugDosage().setScale(4, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP)) : new BigDecimal(0);
            log.info("========\u8ba1\u7b97\u7684\u4ef7\u683c{}", (Object)itemPrice);
            drugRecordDto1.setItemPrice(itemPrice);
            log.info("=============\u4f20\u5165\u7684\u5355\u6b21\u5242\u91cf{}", (Object)drugRecordDto.getSingleDoes());
            if (vo.getType() == 3) {
                if (drugRecordDto.getDrugDosage() != null) {
                    drugRecordDto1.setUsageDesc(new BigDecimal(StringUtil.getNoZeros((String)drugRecordDto.getDrugDosage().setScale(4, 4).toString())) + drugRecordDto.getMeasureUnit().toString());
                } else {
                    drugRecordDto1.setUsageDesc("");
                }
            } else {
                drugRecordDto1.setPriceDrugDosage("\u00a5" + drugRecordDto.getPrice() + "*" + drugRecordDto.getDrugDosage());
                if (drugRecordDto.getSingleDoes() != null) {
                    drugRecordDto1.setUsageDesc(drugRecordDto.getFrequencyDesc() + ",\u6bcf\u6b21" + new BigDecimal(StringUtil.getNoZeros((String)drugRecordDto.getSingleDoes().setScale(4, 4).toString())) + drugRecordDto.getMeasureUnit() + "," + drugRecordDto.getDrugUsageDesc());
                } else {
                    drugRecordDto1.setUsageDesc("");
                }
            }
            log.info("========>\u904d\u5386\u67e5\u8be2drugRecordDtoList---->usageId={},drugUsageDesc={}", (Object)drugRecordDto.getUsageId(), (Object)drugRecordDto.getDrugUsageDesc());
            DrugUsageEntity drugUsageEntity = new DrugUsageEntity();
            drugUsageEntity = this.mosDrugUsageService.getByDescAndHospitalNameFirstLetter(drugRecordDto.getDrugUsageDesc(), hospitalNameFirstLetter);
            if (drugUsageEntity == null) {
                drugUsageEntity = this.mosDrugUsageService.getByDescAndHospitalNameFirstLetter(drugRecordDto.getDrugUsageDesc(), null);
            }
            if (drugUsageEntity != null) {
                drugRecordDto1.setUsageId(drugUsageEntity.getxId());
            } else {
                drugRecordDto1.setUsageId("");
            }
            log.info("========>\u904d\u5386\u67e5\u8be2drugRecordDtoList--->frequencyDesc==={}", (Object)drugRecordDto.getFrequencyDesc());
            DrugFrequencyEntity drugFrequencyEntity = new DrugFrequencyEntity();
            drugFrequencyEntity = this.drugFrequencyService.getByDescAndHospitalNameFirstLetter(drugRecordDto.getFrequencyDesc(), hospitalNameFirstLetter);
            if (drugFrequencyEntity == null) {
                drugFrequencyEntity = this.drugFrequencyService.getByDescAndHospitalNameFirstLetter(drugRecordDto.getFrequencyDesc(), null);
            }
            if (drugFrequencyEntity != null) {
                drugRecordDto1.setFrequencyId(drugFrequencyEntity.getxId());
            } else {
                drugRecordDto1.setFrequencyId("");
            }
            log.info("========>\u904d\u5386\u67e5\u8be2drugRecordDtoList--->reason={}", (Object)drugRecordDto.getReason());
            MosDrugReasonEntity mosDrugReasonEntity = this.mosDrugReasonService.getByDesc(drugRecordDto.getReason());
            if (mosDrugReasonEntity != null) {
                drugRecordDto1.setReasonId(mosDrugReasonEntity.getXId());
            }
            list.add(drugRecordDto1);
        }
        for (DrugRecordDto recordDto : list) {
            log.info("=====\u836f\u54c1\u9879\u4ef7\u683c{}", (Object)recordDto.getItemPrice());
            totalprice = vo.getType() == 3 ? totalprice.add(recordDto.getItemPrice()).setScale(4, RoundingMode.HALF_UP) : totalprice.add(recordDto.getItemPrice()).setScale(2, RoundingMode.HALF_UP);
            log.info("=====\u603b\u4ef7\u683c{}", (Object)totalprice);
        }
        for (DrugRecordDto drugRecordDto : list) {
            drugRecordDto.setTotalPrice(totalprice);
        }
        log.info("====\u8fd4\u56de\u6570\u636e{}", (Object)JSONObject.toJSONString(list));
        return BaseResponse.success(list);
    }

    @RequestMapping(value={"/updateDrugRecordDetail"}, method={RequestMethod.POST})
    @ApiOperation(value="\u4fee\u6539\u836f\u54c1\u8d2d\u7269\u8f66\u8be6\u60c5", notes="\u4fee\u6539\u836f\u54c1\u8d2d\u7269\u8f66\u8be6\u60c5")
    public BaseResponse<String> updateDrugRecordDetail(@RequestBody DrugOrderCartDto drugOrderCartDto) {
        if (drugOrderCartDto.getOrderNumber() == null || drugOrderCartDto.getOrderNumber().equals("")) {
            return BaseResponse.error((String)"\u8ba2\u5355\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        if (drugOrderCartDto.getAppCode() == null || drugOrderCartDto.getAppCode().equals("")) {
            drugOrderCartDto.setAppCode(drugOrderCartDto.getOrganCode());
        }
        if (drugOrderCartDto.getDrugRecordDto().getType() == null) {
            drugOrderCartDto.getDrugRecordDto().setType(Integer.valueOf(1));
        }
        drugOrderCartDto.setOrganCode(AppCodeUtil.tranCode((String)drugOrderCartDto.getAppCode()));
        String key = drugOrderCartDto.getOrderNumber() + "_" + drugOrderCartDto.getAppCode() + "_" + drugOrderCartDto.getDrugRecordDto().getType();
        Object o = this.redisUtil.get(key);
        if (o == null) {
            return BaseResponse.success((Object)"");
        }
        List drugRecordDtoList = JSONObject.parseArray((String)o.toString(), DrugRecordDto.class);
        for (DrugRecordDto drugRecordDto : drugRecordDtoList) {
            if (!drugRecordDto.getDrugCode().equals(drugOrderCartDto.getDrugRecordDto().getDrugCode())) continue;
            drugRecordDto.setSingleDoes(drugOrderCartDto.getDrugRecordDto().getSingleDoes());
            drugRecordDto.setDrugCode(drugOrderCartDto.getDrugRecordDto().getDrugCode());
            drugRecordDto.setMinBillPackingUnit(drugOrderCartDto.getDrugRecordDto().getMinBillPackingUnit());
            drugRecordDto.setCommonName(drugOrderCartDto.getDrugRecordDto().getCommonName());
            drugRecordDto.setDrugSpec(drugOrderCartDto.getDrugRecordDto().getDrugSpec());
            drugRecordDto.setPrice(drugOrderCartDto.getDrugRecordDto().getPrice());
            drugRecordDto.setWholePackingUnit(drugOrderCartDto.getDrugRecordDto().getWholePackingUnit());
            drugRecordDto.setFrequencyDesc(drugOrderCartDto.getDrugRecordDto().getFrequencyDesc());
            drugRecordDto.setDrugUsageDesc(drugOrderCartDto.getDrugRecordDto().getDrugUsageDesc());
            drugRecordDto.setRemark(drugOrderCartDto.getDrugRecordDto().getRemark());
            drugRecordDto.setDrugDosage(drugOrderCartDto.getDrugRecordDto().getDrugDosage());
            drugRecordDto.setPriceDrugDosage(drugOrderCartDto.getDrugRecordDto().getPriceDrugDosage());
            drugRecordDto.setUsageDesc(drugOrderCartDto.getDrugRecordDto().getFrequencyDesc());
            drugRecordDto.setMeasureNum(drugOrderCartDto.getDrugRecordDto().getMeasureNum());
            drugRecordDto.setMinBillPackingNum(drugOrderCartDto.getDrugRecordDto().getMinBillPackingNum());
            drugRecordDto.setProductName(drugOrderCartDto.getDrugRecordDto().getProductName());
            drugRecordDto.setReason(drugOrderCartDto.getDrugRecordDto().getReason());
            drugRecordDto.setCycle(drugOrderCartDto.getDrugRecordDto().getCycle());
        }
        Boolean b = this.redisUtil.set(key, (Object)JSONObject.toJSONString((Object)drugRecordDtoList));
        if (b.booleanValue()) {
            return BaseResponse.success((Object)"\u4fee\u6539\u6210\u529f");
        }
        return BaseResponse.error((String)"\u4fee\u6539\u5931\u8d25");
    }

    @RequestMapping(value={"/deleteDrugRecordDetail"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5220\u9664\u836f\u54c1\u8d2d\u7269\u8f66\u4fe1\u606f", notes="\u5220\u9664\u836f\u54c1\u8d2d\u7269\u8f66\u4fe1\u606f")
    public BaseResponse<String> deleteDrugRecordDetail(@RequestParam(value="orderNumber", required=true, defaultValue="") String orderNumber, @RequestParam(value="organCode", required=false, defaultValue="") String organCode, @RequestParam(value="appCode", required=false, defaultValue="") String appCode, @RequestParam(value="drugCode", required=true, defaultValue="") String drugCode, @RequestParam(value="type", required=false, defaultValue="1") Integer type) {
        if (orderNumber == null || orderNumber.equals("")) {
            return BaseResponse.error((String)"\u8ba2\u5355\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        if (appCode == null || appCode.equals("")) {
            appCode = organCode;
        }
        if (type == 0 || type == null) {
            type = 1;
        }
        appCode = AppCodeUtil.tranCode((String)appCode);
        String key = orderNumber + "_" + appCode + "_" + type;
        Object o = this.redisUtil.get(key);
        if (o == null) {
            return BaseResponse.success();
        }
        List drugRecordDtoList = JSONObject.parseArray((String)o.toString(), DrugRecordDto.class);
        Iterator it = drugRecordDtoList.iterator();
        while (it.hasNext()) {
            DrugRecordDto drugRecordDto = (DrugRecordDto)it.next();
            if (!drugRecordDto.getDrugCode().equals(drugCode)) continue;
            it.remove();
        }
        Boolean b = this.redisUtil.set(key, (Object)JSONObject.toJSONString((Object)drugRecordDtoList));
        if (b.booleanValue()) {
            return BaseResponse.success((Object)"\u5220\u9664\u6210\u529f");
        }
        return BaseResponse.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @PostMapping(value={"/v1/deleteDrugRecordDetail"})
    @ApiOperation(value="\u5220\u9664\u836f\u54c1\u8d2d\u7269\u8f66\u4fe1\u606f", notes="\u5220\u9664\u836f\u54c1\u8d2d\u7269\u8f66\u4fe1\u606f")
    public BaseResponse<String> deleteDrugRecordDetail(@RequestBody FindDrugListVo vo) {
        Object o;
        if (vo.getOrderNumber() == null || vo.getOrderNumber().isEmpty()) {
            return BaseResponse.error((String)"\u8ba2\u5355\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        if (vo.getAppCode() == null || vo.getAppCode().isEmpty()) {
            vo.setAppCode(vo.getOrganCode());
        }
        if (vo.getType() == 0 || vo.getType() == null) {
            vo.setType(Integer.valueOf(1));
        }
        vo.setAppCode(AppCodeUtil.tranCode((String)vo.getAppCode()));
        String key = vo.getOrderNumber() + "_" + vo.getAppCode() + "_" + vo.getType();
        if (vo.getOrderSource() != null) {
            key = vo.getOrderNumber() + "_" + vo.getAppCode() + "_" + vo.getType() + "_" + vo.getOrderSource();
        }
        if ((o = this.redisUtil.get(key)) == null) {
            return BaseResponse.success();
        }
        List drugRecordDtoList = JSONObject.parseArray((String)o.toString(), DrugRecordDto.class);
        Iterator it = drugRecordDtoList.iterator();
        while (it.hasNext()) {
            DrugRecordDto drugRecordDto = (DrugRecordDto)it.next();
            if (!drugRecordDto.getDrugCode().equals(vo.getDrugCode())) continue;
            it.remove();
        }
        Boolean b = this.redisUtil.set(key, (Object)JSONObject.toJSONString((Object)drugRecordDtoList));
        if (b.booleanValue()) {
            return BaseResponse.success((Object)"\u5220\u9664\u6210\u529f");
        }
        return BaseResponse.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @RequestMapping(value={"/deleteDrugRecord"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6e05\u9664\u8d2d\u7269\u8f66", notes="\u6e05\u9664\u8d2d\u7269\u8f66")
    public BaseResponse<String> updateDrugRecord(@RequestParam(value="orderNumber") String orderNumber, @RequestParam(value="organCode", required=false, defaultValue="") String organCode, @RequestParam(value="appCode", required=false, defaultValue="") String appCode, @RequestParam(value="type") String type) {
        if (orderNumber == null) {
            return BaseResponse.error((String)"\u8ba2\u5355\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        if (appCode == null || appCode.equals("")) {
            appCode = organCode;
        }
        organCode = AppCodeUtil.tranCode((String)appCode);
        String key = orderNumber + "_" + appCode + "_" + type;
        this.redisUtil.del(new String[]{key});
        return BaseResponse.success((Object)"\u6210\u529f\u6e05\u9664");
    }

    @PostMapping(value={"/v1/deleteDrugRecord"})
    @ApiOperation(value="\u6e05\u9664\u8d2d\u7269\u8f66", notes="\u6e05\u9664\u8d2d\u7269\u8f66")
    public BaseResponse<String> updateDrugRecord(@RequestBody FindDrugListVo vo) {
        if (vo.getOrderNumber() == null) {
            return BaseResponse.error((String)"\u8ba2\u5355\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        if (vo.getAppCode() == null || vo.getAppCode().equals("")) {
            vo.setAppCode(vo.getOrganCode());
        }
        vo.setOrganCode(AppCodeUtil.tranCode((String)vo.getAppCode()));
        String key = vo.getOrderNumber() + "_" + vo.getAppCode() + "_" + vo.getType();
        this.redisUtil.del(new String[]{key});
        return BaseResponse.success((Object)"\u6210\u529f\u6e05\u9664");
    }

    @GetMapping(value={"/group/delete"})
    @ApiOperation(value="\u5220\u9664\u836f\u54c1\u7ec4\u5957", notes="\u5220\u9664\u836f\u54c1\u7ec4\u5957")
    public BaseResponse<Object> delete(@RequestParam(value="groupId", defaultValue="") String groupId) {
        if (StringUtil.isBlank((String)groupId)) {
            log.error("\u53c2\u6570\u9519\u8befgroupId:{}", (Object)groupId);
            return BaseResponse.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        return this.mosDrugGroupService.delete(groupId);
    }

    @GetMapping(value={"/group/list"})
    @ApiOperation(value="\u836f\u54c1\u7ec4\u5957\u5217\u8868", notes="\u836f\u54c1\u7ec4\u5957\u5217\u8868")
    public BaseResponse<List<DrugGroupListDTO>> listByDoctorId(@RequestParam(value="doctorId", defaultValue="") String doctorId, @RequestParam(value="drugType", defaultValue="1") Integer drugType, @RequestParam(value="pageIndex", defaultValue="1") Integer pageIndex, @RequestParam(value="pageSize", defaultValue="15") Integer pageSize) {
        if (StringUtil.isBlank((String)doctorId)) {
            log.error("\u53c2\u6570\u9519\u8befdoctorId:{}", (Object)doctorId);
            return BaseResponse.error((String)"\u53c2\u6570\u7f3a\u5931");
        }
        if (drugType == null) {
            drugType = 1;
        }
        return this.mosDrugGroupService.listByDoctorId(doctorId, drugType, pageIndex, pageSize);
    }

    @GetMapping(value={"/group/detail"})
    @ApiOperation(value="\u836f\u54c1\u7ec4\u5957\u8be6\u60c5", notes="\u836f\u54c1\u7ec4\u5957\u8be6\u60c5")
    public BaseResponse<DrugGroupDetailDTO> detailByDoctorId(@RequestParam(value="groupId", defaultValue="") String groupId) {
        if (StringUtil.isBlank((String)groupId)) {
            log.error("\u53c2\u6570\u9519\u8befgroupId:{}", (Object)groupId);
            return BaseResponse.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        return this.mosDrugGroupService.detailByGroupId(groupId);
    }

    @PostMapping(value={"/group/save"})
    @ApiOperation(value="\u4fdd\u5b58\u836f\u54c1\u7ec4\u5957", notes="\u6dfb\u52a0\u836f\u54c1\u7ec4\u5957")
    public BaseResponse<Object> save(@RequestBody @Validated DrugGroupSaveReqDTO dto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.mosDrugGroupService.save(dto);
    }

    @PostMapping(value={"/import"})
    @ApiOperation(value="\u897f\u836f\u4e2d\u6210\u836f\u836f\u54c1\u5bfc\u5165", notes="\u5bfc\u5165\u836f\u54c1")
    public BaseResponse<Object> importItem(@RequestParam(value="appCode", required=true, defaultValue="") String appCode, @RequestParam(value="hospitalName", required=false) String hospitalName, MultipartFile file) {
        return this.manageDrugItemService.importItem(appCode, hospitalName, file);
    }

    @PostMapping(value={"/import/chineseItem"})
    @ApiOperation(value="\u4e2d\u836f\u5bfc\u5165", notes="\u4e2d\u836f\u5bfc\u5165")
    public BaseResponse<Object> importChineseItem(@RequestParam(value="appCode", required=true, defaultValue="") String appCode, @RequestParam(value="hospitalName", required=false) String hospitalName, MultipartFile file) {
        return this.manageDrugItemService.importChineseItem(appCode, hospitalName, file);
    }

    @PostMapping(value={"/synchronization/deugItem"})
    @ApiOperation(value="\u540c\u6b65\u836f\u54c1", notes="\u540c\u6b65\u836f\u54c1")
    public BaseResponse<Object> synchronizationDeugItem() {
        return this.manageDrugItemService.synchronizationDeugItem();
    }

    @PostMapping(value={"/importWestern"})
    @ApiOperation(value="\u897f\u836f\u5bfc\u5165", notes="\u5bfc\u5165\u836f\u54c1")
    public BaseResponse<Object> importWestern(@RequestParam(value="appCode", required=true, defaultValue="") String appCode, @RequestParam(value="type", required=true, defaultValue="") Integer type, @RequestParam(value="hospitalName", required=false) String hospitalName, @RequestParam(value="pharmaceuticalCompanyId", required=false) String pharmaceuticalCompanyId, @RequestParam(value="file") MultipartFile file) throws IOException {
        long start = System.currentTimeMillis();
        List drugItemExcelList = ExcelUtils.importExcel((MultipartFile)file, DrugItemExcel.class);
        log.info(JSONObject.toJSONString((Object)drugItemExcelList));
        BaseResponse baseResponse = this.manageDrugItemService.importWestern(appCode, type, hospitalName, pharmaceuticalCompanyId, drugItemExcelList);
        log.info("\u5bfc\u5165excel\u6240\u82b1\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - start));
        return baseResponse;
    }

    @PostMapping(value={"/importPatentMedicine"})
    @ApiOperation(value="\u4e2d\u6210\u836f\u5bfc\u5165", notes="\u5bfc\u5165\u836f\u54c1")
    public BaseResponse<Object> importPatentMedicine(@RequestParam(value="appCode", required=true, defaultValue="") String appCode, @RequestParam(value="type", required=true, defaultValue="") Integer type, @RequestParam(value="hospitalName", required=false) String hospitalName, MultipartFile file) throws IOException {
        long start = System.currentTimeMillis();
        List drugItemExcelList = ExcelUtils.importExcel((MultipartFile)file, DrugItemExcel.class);
        log.info(JSONObject.toJSONString((Object)drugItemExcelList));
        log.info("\u5bfc\u5165excel\u6240\u82b1\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - start));
        return this.manageDrugItemService.importWestern(appCode, type, hospitalName, null, drugItemExcelList);
    }

    @PostMapping(value={"/importChineseMedicine"})
    @ApiOperation(value="\u4e2d\u836f\u5bfc\u5165", notes="\u5bfc\u5165\u836f\u54c1")
    public BaseResponse<Object> importChineseMedicine(@RequestParam(value="appCode", required=true, defaultValue="") String appCode, @RequestParam(value="type", required=true, defaultValue="") Integer type, @RequestParam(value="hospitalName", required=false) String hospitalName, MultipartFile file) throws IOException {
        long start = System.currentTimeMillis();
        List drugItemExcelList = ExcelUtils.importExcel((MultipartFile)file, DrugItemChineseExcel.class);
        log.info(JSONObject.toJSONString((Object)drugItemExcelList));
        log.info("\u5bfc\u5165excel\u6240\u82b1\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - start));
        return this.manageDrugItemService.importChineseMedicine(appCode, type, hospitalName, drugItemExcelList);
    }

    @PostMapping(value={"/synchronization/getDrugCount"})
    @ApiOperation(value="\u822a\u5929his\u67e5\u8be2\u836f\u54c1\u5e93\u5b58", notes="\u822a\u5929his\u67e5\u8be2\u836f\u54c1\u5e93\u5b58")
    public BaseResponse<Object> getDrugCount(@RequestBody @Validated DrugCountReqVo drugCountReqVo) {
        return this.manageDrugItemService.getDrugCount(drugCountReqVo);
    }

    @GetMapping(value={"/v1/getFrequencyList"})
    @ApiOperation(value="\u83b7\u53d6\u9891\u6b21\u5217\u8868", notes="\u83b7\u53d6\u9891\u6b21\u5217\u8868")
    public BaseResponse<List<DrugFrequencyEntity>> getFrequencyList(@RequestParam(value="appCode") String appCode, @RequestParam(value="drugType") String drugType) {
        return this.manageDrugItemService.findNewDrugFrequency(appCode, drugType);
    }

    @GetMapping(value={"/v1/getDrugUsageList"})
    @ApiOperation(value="\u83b7\u53d6\u8349\u836f\u4f7f\u7528\u65b9\u6cd5", notes="\u83b7\u53d6\u8349\u836f\u4f7f\u7528\u65b9\u6cd5")
    public BaseResponse<List<DrugUsageEntity>> getDrugUsage(@RequestParam(value="useType") String useType) {
        return this.manageDrugItemService.findNewDrugUsage("", useType);
    }

    @ApiOperation(value="\u8d63\u5357\u533b-\u624b\u52a8\u540c\u6b65\u836f\u54c1\u76ee\u5f55")
    @RequestMapping(value={"/v1/synQueryDrugs"}, method={RequestMethod.GET})
    public BaseResponse<String> synQueryDrugs() throws IOException {
        return this.drugItemService.synQueryDrugs();
    }
}

