/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.controller;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.config.NodeConfig;
import com.ebaiyihui.medicalcloud.pojo.entity.PharmaceuticalCompanyEntity;
import com.ebaiyihui.medicalcloud.service.PharmaceuticalCompanyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u836f\u5546 API"})
@RequestMapping(value={"/api/pharmaceuticalcompany"})
@RestController
public class PharmaceuticalCompanyController {
    private static final Logger log = LoggerFactory.getLogger(PharmaceuticalCompanyController.class);
    @Resource
    PharmaceuticalCompanyService pharmaceuticalCompanyService;
    @Resource
    private NodeConfig nodeConfig;

    @PostMapping(value={"/v1/list"})
    @ApiOperation(value="\u836f\u5546\u5217\u8868", notes="\u836f\u5546\u5217\u8868")
    public BaseResponse<List<PharmaceuticalCompanyEntity>> list() {
        return this.pharmaceuticalCompanyService.list();
    }

    @PostMapping(value={"/bm/list"})
    @ApiOperation(value="\u836f\u5546\u5217\u8868-\u4fbf\u6c11", notes="\u836f\u5546\u5217\u8868-\u4fbf\u6c11")
    public BaseResponse<List<Object>> list(@RequestParam String appCode) {
        JSONObject jsonObject = new JSONObject();
        List bmAppCodeList = this.nodeConfig.getBmAppCodeList();
        log.info("bmAppCodeList:{}", (Object)bmAppCodeList);
        if (!bmAppCodeList.isEmpty() && bmAppCodeList.contains(appCode)) {
            appCode = "sr";
        }
        jsonObject.put("appCode", (Object)appCode);
        return this.pharmaceuticalCompanyService.paginglist(jsonObject);
    }

    @PostMapping(value={"/detail"})
    @ApiOperation(value="\u836f\u5546\u8be6\u60c5", notes="\u836f\u5546\u5217\u8868")
    public BaseResponse<Object> detail(@RequestParam String pharmaceuticalCompanyId) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("pharmaceuticalCompanyId", (Object)pharmaceuticalCompanyId);
        return this.pharmaceuticalCompanyService.selectPharmacistById(jsonObject);
    }
}

