/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.manage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.medicalcloud.common.constants.URLConstant;
import com.ebaiyihui.medicalcloud.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.RemarkTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.ReturnCodeEnum;
import com.ebaiyihui.medicalcloud.config.NodeConfig;
import com.ebaiyihui.medicalcloud.feign.IExpressApiClient;
import com.ebaiyihui.medicalcloud.pojo.bm.dto.DrugItemListV2DTO;
import com.ebaiyihui.medicalcloud.pojo.bm.dto.QueryCaseRecordDTO;
import com.ebaiyihui.medicalcloud.pojo.bm.dto.SendPresImgReqVo;
import com.ebaiyihui.medicalcloud.pojo.bm.vo.DrugIteamListReqVO;
import com.ebaiyihui.medicalcloud.pojo.bm.vo.GetDoctorWebImPatientMedicalDetailVoRes;
import com.ebaiyihui.medicalcloud.pojo.bm.vo.PatientMedicalRecordResVO;
import com.ebaiyihui.medicalcloud.pojo.dto.netinquiry.OutLineListResDTO;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.FromOutlineVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pres.PatAdvisoryDetailDTO;
import com.ebaiyihui.medicalcloud.service.DrugDetailService;
import com.ebaiyihui.medicalcloud.service.MosDrugOrderService;
import com.ebaiyihui.medicalcloud.service.UserAddressService;
import com.ebaiyihui.medicalcloud.utils.HttpUtils;
import com.ebaiyihui.onlineoutpatient.common.dto.MedicalOpinionDto;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DrugMainManage {
    private static final Logger log = LoggerFactory.getLogger(DrugMainManage.class);
    @Autowired
    private IExpressApiClient iExpressApiClient;
    @Autowired
    private MosDrugOrderService mosDrugOrderService;
    @Autowired
    private UserAddressService userAddressService;
    @Autowired
    private DrugDetailService drugDetailService;
    @Autowired
    private NodeConfig nodeConfig;

    public Integer getRemarkTypeByOrderStatus(DrugMainEntity drugMainEntity) {
        Integer value = 0;
        value = drugMainEntity.getItemStatus().equals(DrugMainStatusEnum.UNPAID.getValue()) ? RemarkTypeEnum.ADD_PRES.getValue() : (drugMainEntity.getItemStatus().equals(DrugMainStatusEnum.APPROVING.getValue()) || drugMainEntity.getItemStatus().equals(DrugMainStatusEnum.PHARMACIST_BACK.getValue()) ? RemarkTypeEnum.VERIFIER.getValue() : (drugMainEntity.getItemStatus().equals(DrugMainStatusEnum.DEPLOYING.getValue()) || drugMainEntity.getItemStatus().equals(DrugMainStatusEnum.DEPLOY_BACK.getValue()) ? RemarkTypeEnum.DEPLOYMENT.getValue() : (drugMainEntity.getItemStatus().equals(DrugMainStatusEnum.SENT.getValue()) ? RemarkTypeEnum.CONFIRMSHIPMENT.getValue() : (drugMainEntity.getItemStatus().equals(DrugMainStatusEnum.TO_TAKE.getValue()) || drugMainEntity.getItemStatus().equals(DrugMainStatusEnum.GET_MEDICINE.getValue()) ? RemarkTypeEnum.TAKE_MEDICAL.getValue() : RemarkTypeEnum.REFUND.getValue()))));
        return value;
    }

    public FromOutlineVO getOutLineInfo(String orderId, String admissionId, String appCode) {
        String url = new StringBuffer(this.nodeConfig.getAddress()).append(appCode).append("/netinquiry/admission/querymedicalrecordslist").toString();
        PatAdvisoryDetailDTO patAdvisoryDetailDTO = new PatAdvisoryDetailDTO();
        patAdvisoryDetailDTO.setAdmissionId(admissionId);
        patAdvisoryDetailDTO.setOrderId(orderId);
        log.info("=======>\u8bf7\u6c42\u5728\u7ebf\u590d\u8bca\u7684url:{},\u53c2\u6570:{}", (Object)url, (Object)JSON.toJSONString((Object)patAdvisoryDetailDTO));
        FromOutlineVO fromOutlineVO = null;
        try {
            String result = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)patAdvisoryDetailDTO), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u8bf7\u6c42\u5728\u7ebf\u590d\u8bca\u7684\u7ed3\u679c\u662f:{}", (Object)result);
            if (ReturnCodeEnum.SUCCEED.getValue().equals(JSONObject.parseObject((String)result).getString("code")) && null != JSONObject.parseObject((String)result).getJSONObject("data")) {
                fromOutlineVO = (FromOutlineVO)JSONObject.parseObject((String)JSONObject.parseObject((String)result).getString("data"), FromOutlineVO.class);
            }
        }
        catch (IOException e) {
            log.error("\u8c03\u7528\u5728\u7ebf\u590d\u8bca\u5f02\u5e38");
        }
        return fromOutlineVO;
    }

    public List<OutLineListResDTO> getOutLineList(String patientId, String appCode) {
        String url = new StringBuffer(this.nodeConfig.getAddress()).append(appCode).append("/netinquiry/manager/order/getOrderListBypatientId?patientId=").toString();
        List list = null;
        try {
            log.info("======>\u5728\u7ebf\u95e8\u8bca\u83b7\u53d6\u590d\u8bca\u5217\u8868url:{}", (Object)(url + patientId));
            String result = HttpUtils.get((String)(url + patientId));
            log.info("======>\u5728\u7ebf\u95e8\u8bca\u83b7\u53d6\u590d\u8bca\u5217\u8868\u7ed3\u679c:{}", (Object)result);
            if (ReturnCodeEnum.SUCCEED.getValue().equals(JSONObject.parseObject((String)result).getString("code")) && null != JSONObject.parseObject((String)result).getJSONArray("data")) {
                list = JSONObject.parseArray((String)JSONObject.parseObject((String)result).getJSONArray("data").toJSONString(), OutLineListResDTO.class);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public String getMedicalOpinion(String admId, String appCode) {
        String url = new StringBuffer(this.nodeConfig.getAddress()).append(appCode).append("/netinquiry/doctor_admission/getDoctorMedicalOpinion").toString();
        MedicalOpinionDto medicalOpinionDto = new MedicalOpinionDto();
        medicalOpinionDto.setAdmId(admId);
        System.out.println();
        try {
            log.info("======>\u5728\u7ebf\u95e8\u8bca\u83b7\u53d6\u8bca\u7597\u610f\u89c1----->url:{},\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)medicalOpinionDto));
            String result = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)medicalOpinionDto), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("======>\u5728\u7ebf\u95e8\u8bca\u83b7\u53d6\u8bca\u7597\u610f\u89c1\u7ed3\u679c:{}", (Object)result);
            if (StringUtils.isNotEmpty((String)result) && ReturnCodeEnum.SUCCEED.getValue().equals(JSONObject.parseObject((String)result).getString("code")) && null != JSONObject.parseObject((String)result).getJSONObject("data") && StringUtils.isNotEmpty((String)(medicalOpinionDto = (MedicalOpinionDto)JSONObject.parseObject((String)JSONObject.parseObject((String)result).getString("data"), MedicalOpinionDto.class)).getMedicalOpinion())) {
                return medicalOpinionDto.getMedicalOpinion();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public FromOutlineVO getOutLineInfoSecond(String orderId, String admissionId, String appCode, String clinicCode) {
        String url = new StringBuffer(this.nodeConfig.getAddress()).append(appCode).append("/netinquiry/admission/querymedicalrecordslist").toString();
        PatAdvisoryDetailDTO patAdvisoryDetailDTO = new PatAdvisoryDetailDTO();
        patAdvisoryDetailDTO.setAdmissionId(StringUtils.isEmpty((String)admissionId) ? "" : admissionId);
        patAdvisoryDetailDTO.setOrderId(StringUtils.isEmpty((String)orderId) ? "" : orderId);
        patAdvisoryDetailDTO.setClinicCode(StringUtils.isEmpty((String)clinicCode) ? "" : clinicCode);
        log.info("=======>\u8bf7\u6c42\u5728\u7ebf\u590d\u8bca\u7684url:{},\u53c2\u6570:{}", (Object)url, (Object)JSON.toJSONString((Object)patAdvisoryDetailDTO));
        FromOutlineVO fromOutlineVO = null;
        try {
            String result = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)patAdvisoryDetailDTO), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u8bf7\u6c42\u5728\u7ebf\u590d\u8bca\u7684\u7ed3\u679c\u662f:{}", (Object)result);
            if (ReturnCodeEnum.SUCCEED.getValue().equals(JSONObject.parseObject((String)result).getString("code")) && null != JSONObject.parseObject((String)result).getJSONObject("data")) {
                fromOutlineVO = (FromOutlineVO)JSONObject.parseObject((String)JSONObject.parseObject((String)result).getString("data"), FromOutlineVO.class);
            }
        }
        catch (IOException e) {
            log.error("\u8c03\u7528\u5728\u7ebf\u590d\u8bca\u5f02\u5e38");
        }
        return fromOutlineVO;
    }

    public List<DrugItemListV2DTO> getPreDrugs(DrugIteamListReqVO reqVO) {
        String preDrugUrl = URLConstant.PRE_DRUG_URL;
        String url = "https://ihos.chinachdu.com/" + preDrugUrl;
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("appCode", reqVO.getAppCode());
        query.put("drugStoreId", reqVO.getDrugStoreId());
        query.put("drugType", reqVO.getDrugType());
        query.put("pageNum", 1);
        query.put("pageSize", 200);
        query.put("pharmaceuticalCompanyId", reqVO.getPharmaceuticalCompanyId());
        query.put("searchParams", reqVO.getSearchParams());
        query.put("status", 1);
        HashMap<String, Serializable> request = new HashMap<String, Serializable>();
        request.put("query", query);
        request.put("pageSize", Integer.valueOf(500));
        request.put("isAsc", Boolean.valueOf(false));
        request.put("pageNum", Integer.valueOf(1));
        log.info("=======>\u8bf7\u6c42\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\u7684url:{},\u53c2\u6570:{}", (Object)url, (Object)JSON.toJSONString(request));
        List<Object> drugItemListV2DTOList = new ArrayList<DrugItemListV2DTO>();
        try {
            String result = HttpUtils.doPost((String)url, (String)JSON.toJSONString(request), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u8bf7\u6c42\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\u7684\u7ed3\u679c\u662f:{}", (Object)result);
            if (ReturnCodeEnum.SUCCEED.getValue().equals(JSONObject.parseObject((String)result).getString("code")) && null != JSONObject.parseObject((String)result).getJSONObject("data")) {
                JSONObject resData = JSONObject.parseObject((String)result).getJSONObject("data");
                drugItemListV2DTOList = JSONObject.parseArray((String)resData.getString("content"), DrugItemListV2DTO.class);
            }
        }
        catch (IOException e) {
            log.error("\u8c03\u7528\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\u5f02\u5e38");
        }
        return drugItemListV2DTOList;
    }

    public PatientMedicalRecordResVO getInquiryCaseRecord(String orderNumber, String appCode) {
        log.info("===========\u4f20\u5165\u53c2\u6570orderNumber:{},appCode:{}", (Object)orderNumber, (Object)appCode);
        String OutOnLineDiagnosticUrl = URLConstant.OUT_ON_LINE_QUERY_CASE_RECORD_URL;
        String url = this.nodeConfig.getAddress() + appCode + OutOnLineDiagnosticUrl;
        QueryCaseRecordDTO req = new QueryCaseRecordDTO();
        req.setOrderNumber(orderNumber);
        PatientMedicalRecordResVO res = new PatientMedicalRecordResVO();
        try {
            String result = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)req), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("\u83b7\u53d6\u5728\u7ebf\u590d\u8bca\u7684\u590d\u8bca\u75c5\u5386result:{}", (Object)result);
            if (ReturnCodeEnum.SUCCEED.getValue().equals(JSONObject.parseObject((String)result).getString("code")) && null != JSONObject.parseObject((String)result).getJSONObject("data")) {
                res = (PatientMedicalRecordResVO)JSONObject.parseObject((String)JSONObject.parseObject((String)result).getString("data"), PatientMedicalRecordResVO.class);
            }
        }
        catch (IOException e) {
            log.error("ERROR", (Throwable)e);
        }
        return res;
    }

    public GetDoctorWebImPatientMedicalDetailVoRes getHistoryDrugs(String admId, String appCode) {
        log.info("===========admId:{},appCode:{}", (Object)admId, (Object)appCode);
        String OutOnLineHistoryDrugUrl = URLConstant.OUT_ON_LINE_GET_HISTORY_DRUG_URL;
        String url = this.nodeConfig.getAddress() + appCode + OutOnLineHistoryDrugUrl;
        QueryCaseRecordDTO req = new QueryCaseRecordDTO();
        req.setAdmId(admId);
        GetDoctorWebImPatientMedicalDetailVoRes res = new GetDoctorWebImPatientMedicalDetailVoRes();
        try {
            String result = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)req), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            if (ReturnCodeEnum.SUCCEED.getValue().equals(JSONObject.parseObject((String)result).getString("code")) && null != JSONObject.parseObject((String)result).getJSONObject("data")) {
                res = (GetDoctorWebImPatientMedicalDetailVoRes)JSONObject.parseObject((String)JSONObject.parseObject((String)result).getString("data"), GetDoctorWebImPatientMedicalDetailVoRes.class);
            }
        }
        catch (IOException e) {
            log.error("ERROR", (Throwable)e);
        }
        return res;
    }

    public void sendPresImg(String admId, String message, String msgType, String appCode) {
        log.info("===========\u4f20\u5165\u53c2\u6570admId:{},message:{},msgType:{},msgType:{}", new Object[]{admId, message, msgType, appCode});
        String OutOnLineUrl = URLConstant.OUT_ON_LINE_QUERY_SEND_PRES_IMG;
        String url = this.nodeConfig.getAddress() + appCode + OutOnLineUrl;
        SendPresImgReqVo req = new SendPresImgReqVo();
        req.setAdmId(admId);
        req.setMessage(message);
        req.setMsgType(msgType);
        try {
            String result = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)req), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("\u8bf7\u6c42\u5728\u7ebf\u590d\u8bca\u53d1\u9001\u5904\u65b9\u56fe\u7247\u548c\u63d0\u793a\u4fe1\u606f\u7684\u7ed3\u679cresult:{}", (Object)result);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

