/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.manage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.doctoruser.api.pojo.dto.BaseDTO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.ManagerDoctorListVO;
import com.ebaiyihui.card.common.CardServiceApi;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.HttpKit;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.medicalcloud.common.enums.DrugTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.ReturnCodeEnum;
import com.ebaiyihui.medicalcloud.config.NodeConfig;
import com.ebaiyihui.medicalcloud.exception.BusinessException;
import com.ebaiyihui.medicalcloud.feign.IDoctorApiClient;
import com.ebaiyihui.medicalcloud.manage.GnHisManage;
import com.ebaiyihui.medicalcloud.mapper.DrugItemMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugMainMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugOrderMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugUsageHisMapper;
import com.ebaiyihui.medicalcloud.mapper.MosInspectionBbMapper;
import com.ebaiyihui.medicalcloud.mapper.MosInspectionClassifyMapper;
import com.ebaiyihui.medicalcloud.mapper.MosInspectionDetailMapper;
import com.ebaiyihui.medicalcloud.mapper.MosInspectionItemMapper;
import com.ebaiyihui.medicalcloud.mapper.MosInspectionOtherFeeMapper;
import com.ebaiyihui.medicalcloud.pojo.dto.InspectionExtendDto;
import com.ebaiyihui.medicalcloud.pojo.dto.OprationDrugMainDto;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.PatientListResDTO;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugDetailEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugItemEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugPrescriptionEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugUsageHisEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosInspectionBbEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosInspectionClassifyEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosInspectionDetailEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosInspectionItemEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosOutpatientMainRelEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.AdvicePayOrCancelReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.CancelAdviceReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.ComfirmPayNewReq;
import com.ebaiyihui.medicalcloud.pojo.vo.ComfirmPayNewReqMsg;
import com.ebaiyihui.medicalcloud.pojo.vo.FromOutlineVO;
import com.ebaiyihui.medicalcloud.pojo.vo.GetDiagnosticVo;
import com.ebaiyihui.medicalcloud.pojo.vo.GetHisClinicNoReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.GetImplementDeptReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.GetImplementDeptResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.IssuedUpdateAdviceReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.IssuedUpdateAdviceResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.LisApplyRequest;
import com.ebaiyihui.medicalcloud.pojo.vo.MedicalInfoDTO;
import com.ebaiyihui.medicalcloud.pojo.vo.PacsApplyRequest;
import com.ebaiyihui.medicalcloud.pojo.vo.QueryAdviceReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.QueryAdviceResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.QueryCheckLabProjectReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.QueryCheckLabProjectResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.QueryOtherCostsReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.QueryOtherCostsResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.inquiryOrderVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.HisPayReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.PayNotifyReqVO;
import com.ebaiyihui.medicalcloud.service.DrugDetailService;
import com.ebaiyihui.medicalcloud.service.MosDrugPrescriptionService;
import com.ebaiyihui.medicalcloud.service.MosInspectionDetailService;
import com.ebaiyihui.medicalcloud.service.MosOutpatientMainRelService;
import com.ebaiyihui.medicalcloud.service.impl.MosDrugMainServiceImpl;
import com.ebaiyihui.medicalcloud.utils.DateUtils;
import com.ebaiyihui.medicalcloud.utils.GenSeqUtils;
import com.ebaiyihui.medicalcloud.utils.HttpUtils;
import com.ebaiyihui.onlineoutpatient.common.dto.manager.QueryAppealOrderTypeDTO;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class GnHisManage {
    private static final Logger log = LoggerFactory.getLogger(GnHisManage.class);
    @Resource
    private NodeConfig nodeConfig;
    @Resource
    private CardServiceApi cardServiceApi;
    @Resource
    private IDoctorApiClient doctorApiClient;
    @Resource
    private DrugDetailService detailService;
    @Resource
    private DrugItemMapper drugItemMapper;
    @Resource
    private MosDrugPrescriptionService mosDrugPrescriptionService;
    @Resource
    private MosDrugOrderMapper mosDrugOrderMapper;
    @Resource
    private DrugDetailService drugDetailService;
    @Resource
    private MosOutpatientMainRelService mosOutpatientMainRelService;
    @Resource
    private MosInspectionDetailService inspectionDetailService;
    @Resource
    private MosInspectionItemMapper mosInspectionItemMapper;
    @Resource
    private MosDrugUsageHisMapper mosDrugUsageHisMapper;
    @Resource
    private MosDrugMainMapper mosDrugMainMapper;
    @Resource
    private IDoctorApiClient iDoctorApiClient;
    @Resource
    private MosInspectionDetailMapper mosInspectionDetailMapper;
    @Resource
    private MosInspectionClassifyMapper mosInspectionClassifyMapper;
    @Resource
    private MosInspectionOtherFeeMapper mosInspectionOtherFeeMapper;
    private static final String SUCCESS = "1";
    @Autowired
    private MosInspectionBbMapper mosInspectionBbMapper;
    @Autowired
    private MosDrugMainServiceImpl mosDrugMainServiceImpl;

    public static void setFieldValues(Object obj, String titleCode, String dictValue) {
        Class<?> clazz = obj.getClass();
        try {
            Field field = clazz.getDeclaredField(titleCode);
            if (field != null) {
                field.setAccessible(true);
                if (String.class.equals(field.getType())) {
                    field.set(obj, dictValue);
                } else {
                    log.info("Unsupported field type:{}, for field: {}", field.getType(), (Object)titleCode);
                }
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            log.info("Failed to set value for field:{}, , with value: {}", (Object)titleCode, (Object)dictValue);
        }
    }

    public void gnPushMainToHis(DrugMainEntity mainEntity, DrugPrescriptionEntity prescriptionEntity, OprationDrugMainDto oprationDrugMainDto, List<InspectionExtendDto> extendDtos) {
        try {
            List list;
            BaseResponse hisClinicNo;
            BaseResponse medicalInfo;
            BaseResponse personnelInfoBaseResponse;
            BaseResponse queryOrganPmi = this.queryOrganPmi(mainEntity);
            BaseResponse doctorInfo = this.getDoctorInfo(mainEntity);
            if (!doctorInfo.isSuccess()) {
                log.info("\u67e5\u8be2\u5f00\u65b9\u533b\u751f\u4fe1\u606f\u51fa\u9519");
            }
            if (!(personnelInfoBaseResponse = this.queryPersonnelInfo(oprationDrugMainDto.getOperationId())).isSuccess()) {
                log.info("\u67e5\u8be2\u5ba1\u6838\u533b\u751f\u4fe1\u606f\u51fa\u9519");
            }
            if ((medicalInfo = this.getMedicalInfo(mainEntity)).getData() == null) {
                log.info("\u83b7\u53d6\u75c5\u5386\u8be6\u60c5\u5931\u8d25\uff01");
            }
            if (!(hisClinicNo = this.getHisClinicNo(mainEntity)).isSuccess()) {
                log.info("\u83b7\u53d6hisClinicNo\u5931\u8d25\uff01");
            }
            IssuedUpdateAdviceReqVO issuedUpdateAdviceReqVO = new IssuedUpdateAdviceReqVO();
            issuedUpdateAdviceReqVO.setCardType("0");
            issuedUpdateAdviceReqVO.setCardNo(mainEntity.getPatientNo());
            issuedUpdateAdviceReqVO.setPatientId((String)queryOrganPmi.getData());
            issuedUpdateAdviceReqVO.setClinicNo((String)hisClinicNo.getData());
            issuedUpdateAdviceReqVO.setTotalMoney(String.valueOf(prescriptionEntity.getPrice()));
            issuedUpdateAdviceReqVO.setDescription(mainEntity.getRemark());
            HashMap<Integer, Integer> typeMapping = new HashMap<Integer, Integer>();
            typeMapping.put(DrugTypeEnum.WCTM.getValue(), 1);
            typeMapping.put(DrugTypeEnum.CM.getValue(), 3);
            typeMapping.put(DrugTypeEnum.INSPECT.getValue(), 4);
            typeMapping.put(DrugTypeEnum.CHECKOUT.getValue(), 5);
            typeMapping.put(DrugTypeEnum.TREATMENT.getValue(), 6);
            issuedUpdateAdviceReqVO.setType(String.valueOf(typeMapping.get(mainEntity.getPresType())));
            issuedUpdateAdviceReqVO.setPresNo(prescriptionEntity.getxId());
            issuedUpdateAdviceReqVO.setDeptCode("00100101");
            issuedUpdateAdviceReqVO.setDeptName("\u4e92\u8054\u7f51\u533b\u9662");
            issuedUpdateAdviceReqVO.setDoctorIdcardNo(((DoctorEntityInfoVO)doctorInfo.getData()).getCredNo());
            issuedUpdateAdviceReqVO.setDoctorName(mainEntity.getPresDoctorName());
            issuedUpdateAdviceReqVO.setDoctorCode(mainEntity.getPresDoctorCode());
            issuedUpdateAdviceReqVO.setDoctorCaSign(mainEntity.getDoctorSign());
            issuedUpdateAdviceReqVO.setAuditDoctorCode(((PersonnelInfo)personnelInfoBaseResponse.getData()).getEmplCode());
            issuedUpdateAdviceReqVO.setAuditDoctorName(((PersonnelInfo)personnelInfoBaseResponse.getData()).getDoctorName());
            issuedUpdateAdviceReqVO.setOpenTime(DateUtils.formatDateTime((Date)mainEntity.getxCreateTime()));
            GetDiagnosticVo gnyfy = this.getInquiryDiagnostic(mainEntity.getAdmId(), "GNYFY");
            issuedUpdateAdviceReqVO.setMainSuit(((MedicalInfoDTO)medicalInfo.getData()).getMainSuit());
            issuedUpdateAdviceReqVO.setCurrentHistory(((MedicalInfoDTO)medicalInfo.getData()).getPrimaryDiagno());
            issuedUpdateAdviceReqVO.setPastHistory(((MedicalInfoDTO)medicalInfo.getData()).getPresentHistory());
            issuedUpdateAdviceReqVO.setInspectionPurpose("");
            issuedUpdateAdviceReqVO.setPhysicalExam(((MedicalInfoDTO)medicalInfo.getData()).getPhysicalExamination());
            issuedUpdateAdviceReqVO.setDiagnoseName(gnyfy.getIcdName());
            issuedUpdateAdviceReqVO.setDiagnoseCode(gnyfy.getIcdCode());
            if (extendDtos != null && !extendDtos.isEmpty()) {
                extendDtos.forEach(extendDto -> GnHisManage.setFieldValues((Object)issuedUpdateAdviceReqVO, (String)extendDto.getTitleCode(), (String)extendDto.getDictValue()));
            }
            List detailInfoList = this.buildItems(mainEntity, issuedUpdateAdviceReqVO);
            issuedUpdateAdviceReqVO.setDetailInfoList(detailInfoList);
            FrontRequest request = new FrontRequest();
            request.setBody((Object)issuedUpdateAdviceReqVO);
            log.info("\u5904\u65b9\u63a8\u9001\u81f3his-req:{}", (Object)JSONObject.toJSONString((Object)request));
            String result = HttpKit.jsonPost((String)(this.nodeConfig.getHis() + "/onlineOutpatient/issuedUpdateAdvice"), (String)JSON.toJSONString((Object)request));
            1 timeTypeReference = new /* Unavailable Anonymous Inner Class!! */;
            FrontResponse response = (FrontResponse)JSONObject.parseObject((String)result, (Type)timeTypeReference.getType(), (Feature[])new Feature[0]);
            log.info("\u5904\u65b9\u63a8\u9001\u81f3his-response:{}", (Object)JSONObject.toJSONString((Object)response));
            if (!Objects.equals("1", response.getCode())) {
                log.info(response.getMessage());
            }
            if ((list = ((IssuedUpdateAdviceResVO)response.getBody()).getBody().getList()).isEmpty()) {
                throw new RuntimeException("HIS\u51fa\u53c2\u5904\u65b9\u53f7\u4e3a\u7a7a");
            }
            String hisPresNo = "";
            if (list.size() < detailInfoList.size()) {
                throw new RuntimeException("HIS\u51fa\u53c2\u5904\u65b9\u53f7\u5f02\u5e38");
            }
            Integer ageNum = 1;
            if (mainEntity.getPresType() == 3) {
                ageNum = prescriptionEntity.getAgeNum();
            }
            List hisPresNoDTOArrayList = list.subList(list.size() - detailInfoList.size(), list.size());
            for (int i = detailInfoList.size(); i > 0; --i) {
                IssuedUpdateAdviceReqVO.DetailInfo detailInfo = (IssuedUpdateAdviceReqVO.DetailInfo)detailInfoList.get(detailInfoList.size() - i);
                Optional<IssuedUpdateAdviceResVO.BodyDTO.HisPresNoDTO> optionalHisPresNoDTO = hisPresNoDTOArrayList.stream().filter(hisPresNoDTO1 -> hisPresNoDTO1.getHisYpdm().equals(detailInfo.getYpdm())).findFirst();
                if (!optionalHisPresNoDTO.isPresent()) {
                    throw new RuntimeException("HIS\u51fa\u53c2\u5904\u65b9\u53f7\u91d1\u989d\u5f02\u5e381");
                }
                IssuedUpdateAdviceResVO.BodyDTO.HisPresNoDTO hisPresNoDTO = optionalHisPresNoDTO.get();
                BigDecimal multiply = new BigDecimal(detailInfo.getPrice()).multiply(new BigDecimal(ageNum)).setScale(2, RoundingMode.HALF_UP);
                BigDecimal hisJe = new BigDecimal(hisPresNoDTO.getJe()).setScale(2, RoundingMode.HALF_UP);
                log.info("\u9879\u76ee:{}\uff0c\u91d1\u989d\uff1a{}\uff0c\u5242\u6570\uff1a{}\uff0c\u8ba1\u7b97\u540e\u4ef7\u683c\uff1a{}", new Object[]{detailInfo.getItemName(), detailInfo.getPrice(), ageNum, multiply});
                log.info("HIS\u9879\u76ee:{}\uff0cHIS\u91d1\u989d\uff1a{}", (Object)hisPresNoDTO.getHisYpmc(), (Object)hisPresNoDTO.getJe());
                if (hisJe.compareTo(multiply) != 0) {
                    throw new RuntimeException("HIS\u51fa\u53c2\u5904\u65b9\u53f7\u91d1\u989d\u5f02\u5e38");
                }
                if (mainEntity.getPresType() == 5 || mainEntity.getPresType() == 6 || mainEntity.getPresType() == 7) {
                    MosInspectionDetailEntity inspectionDetailEntity = new MosInspectionDetailEntity();
                    inspectionDetailEntity.setxId(detailInfo.getDetailId());
                    inspectionDetailEntity.setHisDetailNo(hisPresNoDTO.getHisHjmxxh());
                    inspectionDetailEntity.setHisDetailJe(hisPresNoDTO.getJe());
                    inspectionDetailEntity.setHisPresNo(hisPresNoDTO.getHisPresNo());
                    this.mosInspectionDetailMapper.update(inspectionDetailEntity);
                    hisPresNo = hisPresNoDTO.getHisPresNo();
                    continue;
                }
                DrugDetailEntity detailEntity = this.drugDetailService.getById(detailInfo.getDetailId());
                detailEntity.setHisDetailNo(hisPresNoDTO.getHisHjmxxh());
                detailEntity.setHisDetailJe(hisPresNoDTO.getJe());
                detailEntity.setIsRefund(Integer.valueOf(2));
                this.drugDetailService.updateById(detailEntity);
                hisPresNo = hisPresNoDTO.getHisPresNo();
            }
            DrugPrescriptionEntity oldDrugPrescriptionEntity = this.mosDrugPrescriptionService.queryByMainId(oprationDrugMainDto.getMainId());
            oldDrugPrescriptionEntity.setHisRecipeNo(hisPresNo);
            this.mosDrugPrescriptionService.update(oldDrugPrescriptionEntity);
            log.info("\u5904\u65b9\u66f4\u65b0his\u5904\u65b9\u53f7:{}", (Object)JSONObject.toJSONString((Object)oldDrugPrescriptionEntity));
        }
        catch (Exception e) {
            log.info("\u5904\u65b9\u63a8\u9001\u81f3his\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException();
        }
    }

    private List<IssuedUpdateAdviceReqVO.DetailInfo> buildItems(DrugMainEntity mainEntity, IssuedUpdateAdviceReqVO issuedUpdateAdviceReqVO) {
        ArrayList<IssuedUpdateAdviceReqVO.DetailInfo> dtoArrayList = new ArrayList<IssuedUpdateAdviceReqVO.DetailInfo>();
        HashMap<Integer, Integer> typeMapping = new HashMap<Integer, Integer>();
        typeMapping.put(DrugTypeEnum.WCTM.getValue(), 1);
        typeMapping.put(DrugTypeEnum.CM.getValue(), 3);
        typeMapping.put(DrugTypeEnum.INSPECT.getValue(), 6);
        typeMapping.put(DrugTypeEnum.CHECKOUT.getValue(), 5);
        typeMapping.put(DrugTypeEnum.TREATMENT.getValue(), 7);
        Integer integer = (Integer)typeMapping.get(mainEntity.getPresType());
        if (1 == integer || 3 == integer) {
            List byMainIds = this.detailService.getByMainIds("'" + mainEntity.getxId() + "'");
            for (DrugDetailEntity drugDetailData : byMainIds) {
                IssuedUpdateAdviceReqVO.DetailInfo detailInfo = new IssuedUpdateAdviceReqVO.DetailInfo();
                DrugItemEntity byId = this.drugItemMapper.getById(drugDetailData.getDrugId());
                if (Objects.isNull(byId)) {
                    log.info("\u67e5\u8be2\u836f\u54c1\u836f\u623f\u4fe1\u606f\u5931\u8d25");
                }
                detailInfo.setItemCode(byId.getProductCode());
                detailInfo.setItemName(byId.getCommonName());
                detailInfo.setCommonCode(byId.getCommonCode());
                detailInfo.setStoreCode(byId.getStoreCode());
                detailInfo.setStoreName(byId.getStoreName());
                detailInfo.setPresTypeCode(String.valueOf(integer));
                if (mainEntity.getPresType() == 3) {
                    detailInfo.setItemNum(String.valueOf(drugDetailData.getAmount()));
                } else {
                    detailInfo.setItemNum(String.valueOf(drugDetailData.getAmount().multiply(drugDetailData.getMinBillPackingNum())));
                }
                detailInfo.setItemNumUnit(String.valueOf(drugDetailData.getMinBillPackingUnit()));
                detailInfo.setDrugDay(String.valueOf(drugDetailData.getDuration()));
                List entities = this.mosDrugUsageHisMapper.queryByUsage(drugDetailData.getUsageDesc(), null);
                if (Objects.isNull(entities) || entities.isEmpty() || mainEntity.getPresType() == 3) {
                    detailInfo.setDrugUseCode("A2");
                    detailInfo.setDrugUseName("\u53e3\u670d");
                } else {
                    DrugUsageHisEntity drugUsageHisEntity = (DrugUsageHisEntity)entities.get(0);
                    detailInfo.setDrugUseCode(drugUsageHisEntity.getUsageCode());
                    detailInfo.setDrugUseName(drugUsageHisEntity.getUsageDesc());
                }
                detailInfo.setDrugFrequency(String.valueOf(drugDetailData.getFrequencyRate()));
                detailInfo.setItemSpec(drugDetailData.getDrugSpec());
                detailInfo.setDoseNoce(String.valueOf(drugDetailData.getSingleDose()));
                detailInfo.setDoseUnit(drugDetailData.getMeasureUnit());
                detailInfo.setPrice(String.valueOf(drugDetailData.getUnitPrice()));
                detailInfo.setPriceUnit("\u5143");
                detailInfo.setOwnFlag("0");
                detailInfo.setTcmDecoctCode("");
                detailInfo.setTcmDecoctName("");
                if (mainEntity.getPresType() == 3) {
                    DrugPrescriptionEntity prescriptionEntity = this.mosDrugPrescriptionService.queryByMainId(mainEntity.getxId());
                    detailInfo.setTcmPasteCnt(prescriptionEntity.getAgeNum() + ".0000");
                } else {
                    detailInfo.setTcmPasteCnt("1.0000");
                }
                detailInfo.setPosition("");
                detailInfo.setDetailId(drugDetailData.getxId());
                detailInfo.setYpdm(byId.getCommonCode());
                dtoArrayList.add(detailInfo);
            }
        } else {
            Integer inspectionType = null;
            if (DrugTypeEnum.INSPECT.getValue().equals(mainEntity.getPresType())) {
                inspectionType = 2;
            } else if (DrugTypeEnum.CHECKOUT.getValue().equals(mainEntity.getPresType())) {
                inspectionType = 3;
            } else if (DrugTypeEnum.TREATMENT.getValue().equals(mainEntity.getPresType())) {
                inspectionType = 4;
            }
            List listByTypeAndMainId = this.inspectionDetailService.selectListByTypeAndMainId(inspectionType, mainEntity.getxId());
            for (MosInspectionDetailEntity inspectionDetailData : listByTypeAndMainId) {
                MosInspectionItemEntity itemMapperById = this.mosInspectionItemMapper.getById(inspectionDetailData.getItemId());
                IssuedUpdateAdviceReqVO.DetailInfo detailInfo = new IssuedUpdateAdviceReqVO.DetailInfo();
                String code = Objects.equals(itemMapperById.getItemType(), "1") ? itemMapperById.getClinicalCode() : itemMapperById.getItemCode();
                detailInfo.setClinicalCode(itemMapperById.getClinicalCode());
                detailInfo.setCommonCode(code);
                detailInfo.setItemCode("0");
                detailInfo.setItemName(inspectionDetailData.getItemName());
                detailInfo.setItemNum("1");
                detailInfo.setDoseNoce("0");
                detailInfo.setDoseUnit(itemMapperById.getItemUnit());
                detailInfo.setPrice(String.valueOf(itemMapperById.getMoney()));
                detailInfo.setPriceUnit("\u5143");
                detailInfo.setTcmPasteCnt("1.0000");
                detailInfo.setImplementDeptId(inspectionDetailData.getImplementDeptId());
                detailInfo.setImplementDeptName(inspectionDetailData.getImplementDeptName());
                detailInfo.setApplyNo(inspectionDetailData.getApplyNo());
                detailInfo.setStoreCode(inspectionDetailData.getImplementDeptId());
                detailInfo.setStoreName(inspectionDetailData.getImplementDeptName());
                detailInfo.setDetailId(inspectionDetailData.getxId());
                detailInfo.setYpdm(inspectionDetailData.getItemCode());
                dtoArrayList.add(detailInfo);
            }
        }
        return dtoArrayList;
    }

    public static String findAmountByHisPresNo(String hisRecipeNoOtherFee, String targetHisPresNo) throws Exception {
        String[] items;
        ObjectMapper objectMapper = new ObjectMapper();
        for (String item : items = hisRecipeNoOtherFee.split("\\}\\s*,\\s*\\{")) {
            JsonNode jsonNode;
            String hisPresNo;
            if (!item.startsWith("{")) {
                item = "{" + item;
            }
            if (!item.endsWith("}")) {
                item = item + "}";
            }
            if (!targetHisPresNo.equals(hisPresNo = (jsonNode = objectMapper.readTree(item)).get("hisPresNo").asText())) continue;
            return jsonNode.get("je").asText();
        }
        return null;
    }

    public BaseResponse<String> hisPayPressNew(String mainId, PayNotifyReqVO payNotifyReqVO, Integer transType) {
        log.info("=========================\u5f00\u59cb\u652f\u4ed8his\u5904\u65b9mainId==========================={},", (Object)mainId);
        DrugMainEntity mainEntity = this.mosDrugMainMapper.queryById(mainId);
        DrugPrescriptionEntity drugPrescriptionEntity = this.mosDrugPrescriptionService.queryByMainId(mainId);
        if (drugPrescriptionEntity == null) {
            log.info("hisPayPressNew==>\u672a\u627e\u5230\u5904\u65b9\u4fe1\u606f\uff01mainId={}", (Object)mainId);
            return BaseResponse.error((String)"\u672a\u627e\u5230\u5904\u65b9\u4fe1\u606f\uff01");
        }
        ArrayList<HisPayReqVO> hisPresNoList = new ArrayList<HisPayReqVO>();
        if (mainEntity.getPresType() == 5 || mainEntity.getPresType() == 6) {
            List detailEntities = this.mosInspectionDetailMapper.selectList(mainId);
            if (detailEntities != null && !detailEntities.isEmpty()) {
                detailEntities.forEach(detailEntity -> {
                    HisPayReqVO hisPayReqVO = new HisPayReqVO();
                    hisPayReqVO.setHisPresNo(detailEntity.getHisPresNo());
                    hisPayReqVO.setMoney(detailEntity.getHisDetailJe());
                    hisPresNoList.add(hisPayReqVO);
                });
            }
        } else if (drugPrescriptionEntity.getHisRecipeNo() != null) {
            HisPayReqVO hisPayReqVO = new HisPayReqVO();
            hisPayReqVO.setHisPresNo(drugPrescriptionEntity.getHisRecipeNo());
            hisPayReqVO.setMoney(null);
            hisPresNoList.add(hisPayReqVO);
        }
        log.info("hisPayPressNew==>hisPresNoList={}", hisPresNoList);
        List hisPresNoListDistinct = hisPresNoList.stream().distinct().collect(Collectors.toList());
        String hisPresNoString = hisPresNoListDistinct.stream().map(HisPayReqVO::getHisPresNo).reduce((a, b) -> a + "," + b).orElse("");
        log.info("hisPayPressNew==>hisPresNoString={}", (Object)hisPresNoString);
        DrugOrderEntity drugOrderEntity = this.mosDrugOrderMapper.queryByMainId(mainId);
        MosOutpatientMainRelEntity outpatientMainRelEntity = this.mosOutpatientMainRelService.getByMainId(mainId);
        HashMap<Integer, Integer> typeMapping = new HashMap<Integer, Integer>();
        typeMapping.put(DrugTypeEnum.WCTM.getValue(), 1);
        typeMapping.put(DrugTypeEnum.CM.getValue(), 3);
        typeMapping.put(DrugTypeEnum.INSPECT.getValue(), 4);
        typeMapping.put(DrugTypeEnum.CHECKOUT.getValue(), 5);
        typeMapping.put(DrugTypeEnum.TREATMENT.getValue(), 6);
        FrontRequest frontRequest = new FrontRequest();
        ComfirmPayNewReqMsg payNewReqMsg = new ComfirmPayNewReqMsg();
        payNewReqMsg.setSuccess("Y");
        payNewReqMsg.setAccdate(DateUtils.formatDateTime((Date)payNotifyReqVO.getPayTime()));
        ComfirmPayNewReq payNewReq = new ComfirmPayNewReq();
        payNewReq.setId(outpatientMainRelEntity.getHisRegNo());
        payNewReq.setAmount(String.valueOf(drugOrderEntity.getPayAmount()));
        payNewReq.setPayType("owePay");
        payNewReq.setPaychannel(payNotifyReqVO.getPayChannel());
        payNewReq.setFlowNo(payNotifyReqVO.getTradeNo());
        payNewReq.setPresNo(hisPresNoString);
        payNewReq.setPresType(String.valueOf(typeMapping.get(mainEntity.getPresType())));
        payNewReq.setSourceType("ONLINE");
        payNewReq.setRespmsg(payNewReqMsg);
        frontRequest.setBody((Object)payNewReq);
        log.info("\u5904\u65b9\u652f\u4ed8 his-req:{}", (Object)JSONObject.toJSONString((Object)frontRequest));
        String result = null;
        try {
            result = HttpKit.jsonPost((String)(this.nodeConfig.getHis() + "outpatient/outpatientPay"), (String)JSON.toJSONString((Object)frontRequest));
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        2 timeTypeReference = new /* Unavailable Anonymous Inner Class!! */;
        FrontResponse response = (FrontResponse)JSONObject.parseObject((String)result, (Type)timeTypeReference.getType(), (Feature[])new Feature[0]);
        if (!Objects.equals("1", response.getCode())) {
            log.info("\u5904\u65b9\u652f\u4ed8his\u51fa\u9519---\u300b{}", (Object)response.getMessage());
            return BaseResponse.error((String)response.getMessage());
        }
        log.info("=========================\u7ed3\u675f\u652f\u4ed8/his\u5904\u65b9==================================");
        return BaseResponse.success((Object)("\u533b\u5631\u652f\u4ed8HIS\u6210\u529f" + mainId));
    }

    public Boolean hisPayPress(String mainId, PayNotifyReqVO payNotifyReqVO, Integer transType) {
        if (transType == 1) {
            log.info("===========\u652f\u4ed8==========");
        } else {
            log.info("===========\u9000\u6b3e==========");
        }
        try {
            log.info("=========================\u5f00\u59cb\u652f\u4ed8/\u9000\u6b3ehis\u5904\u65b9mainId==========================={},", (Object)mainId);
            DrugMainEntity mainEntity = this.mosDrugMainMapper.queryById(mainId);
            DrugPrescriptionEntity drugPrescriptionEntity = this.mosDrugPrescriptionService.queryByMainId(mainId);
            if (drugPrescriptionEntity == null) {
                log.info("\u672a\u627e\u5230\u5904\u65b9\u4fe1\u606f\uff01mainId={}", (Object)mainId);
                return false;
            }
            DrugOrderEntity drugOrderEntity = this.mosDrugOrderMapper.queryByMainId(mainId);
            List drugDetailEntityList = this.drugDetailService.listByMainId(mainId);
            MosOutpatientMainRelEntity outpatientMainRelEntity = this.mosOutpatientMainRelService.getByMainId(mainId);
            HashMap<Integer, Integer> typeMapping = new HashMap<Integer, Integer>();
            typeMapping.put(DrugTypeEnum.WCTM.getValue(), 1);
            typeMapping.put(DrugTypeEnum.CM.getValue(), 3);
            typeMapping.put(DrugTypeEnum.INSPECT.getValue(), 4);
            typeMapping.put(DrugTypeEnum.CHECKOUT.getValue(), 5);
            typeMapping.put(DrugTypeEnum.TREATMENT.getValue(), 6);
            AdvicePayOrCancelReqVO reqVO = new AdvicePayOrCancelReqVO();
            reqVO.setClinicNo(outpatientMainRelEntity.getHisRegNo());
            reqVO.setType(String.valueOf(typeMapping.get(drugPrescriptionEntity.getPresType())));
            reqVO.setPresNo(drugPrescriptionEntity.getHisRecipeNo());
            if (CollectionUtils.isNotEmpty((Collection)drugDetailEntityList)) {
                reqVO.setItemCode(((DrugDetailEntity)drugDetailEntityList.get(0)).getDrugCommonCode());
            }
            reqVO.setTransType(String.valueOf(transType));
            reqVO.setTotalAmount(String.valueOf(drugOrderEntity.getPayAmount()));
            reqVO.setDealSeq(payNotifyReqVO.getDealTradeNo());
            reqVO.setOrderStatus("1");
            reqVO.setPayTime(String.valueOf(payNotifyReqVO.getPayTime()));
            reqVO.setBankTradeNo(payNotifyReqVO.getTradeNo());
            reqVO.setBusiType("3");
            reqVO.setOrderSeq(drugOrderEntity.getOrderSeq());
            FrontRequest request = new FrontRequest();
            request.setBody((Object)reqVO);
            log.info("\u5904\u65b9\u652f\u4ed8/\u9000\u6b3ehis-req:{}", (Object)JSONObject.toJSONString((Object)request));
            String result = HttpKit.jsonPost((String)(this.nodeConfig.getHis() + "onlineOutpatient/advicePayOrCancel"), (String)JSON.toJSONString((Object)request));
            3 timeTypeReference = new /* Unavailable Anonymous Inner Class!! */;
            FrontResponse response = (FrontResponse)JSONObject.parseObject((String)result, (Type)timeTypeReference.getType(), (Feature[])new Feature[0]);
            if (!Objects.equals("1", response.getCode())) {
                log.info("\u5904\u65b9\u652f\u4ed8/\u9000\u6b3ehis\u51fa\u9519---\u300b{}", (Object)response.getMessage());
                return false;
            }
            log.info("=========================\u7ed3\u675f\u652f\u4ed8/\u9000\u6b3ehis\u5904\u65b9==================================");
            return true;
        }
        catch (Exception e) {
            log.info("\u5904\u65b9\u652f\u4ed8/\u9000\u6b3ehis\u5f02\u5e38--->{}", (Object)e.getMessage());
            return false;
        }
    }

    public BaseResponse<Object> gnCancelPres(String mainId, String clinicNo) {
        Integer mappedType;
        log.info("=========================\u5f00\u59cb\u64a4\u9500\u5904\u65b9==========================={},", (Object)mainId);
        DrugPrescriptionEntity drugPrescriptionEntity = this.mosDrugPrescriptionService.queryByMainId(mainId);
        DrugMainEntity drugMain = this.mosDrugMainMapper.getById(mainId);
        switch (drugMain.getPresType()) {
            case 1: {
                mappedType = 1;
                break;
            }
            case 2: 
            case 3: {
                mappedType = 2;
                break;
            }
            case 6: {
                mappedType = 4;
                break;
            }
            case 5: {
                mappedType = 5;
                break;
            }
            case 7: {
                mappedType = 6;
                break;
            }
            default: {
                throw new IllegalArgumentException("\u672a\u77e5\u7684\u5904\u65b9\u7c7b\u578b: " + drugMain.getPresType());
            }
        }
        if (drugPrescriptionEntity == null) {
            log.info("\u64a4\u9500\u5904\u65b9\u672a\u627e\u5230\u5904\u65b9\u4fe1\u606f\uff01mainId={}", (Object)mainId);
            return BaseResponse.error((String)"\u672a\u627e\u5230\u5904\u65b9\u4fe1\u606f\uff01");
        }
        try {
            CancelAdviceReqVO cancelAdviceReqVO = new CancelAdviceReqVO();
            cancelAdviceReqVO.setClinicNo(clinicNo);
            cancelAdviceReqVO.setCancelTime(DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"yyyy-MM-dd HH:mm:ss"}));
            cancelAdviceReqVO.setType(String.valueOf(mappedType));
            FrontRequest request = new FrontRequest();
            request.setBody((Object)cancelAdviceReqVO);
            String result = HttpKit.jsonPost((String)(this.nodeConfig.getHis() + "onlineOutpatient/cancelAdvice"), (String)JSON.toJSONString((Object)request));
            4 timeTypeReference = new /* Unavailable Anonymous Inner Class!! */;
            FrontResponse response = (FrontResponse)JSONObject.parseObject((String)result, (Type)timeTypeReference.getType(), (Feature[])new Feature[0]);
            if (!Objects.equals("1", response.getCode())) {
                log.info("\u64a4\u9500\u5904\u65b9\u5931\u6548\u51fa\u9519---\u300b{}", (Object)response.getMessage());
                return BaseResponse.error((String)response.getMessage());
            }
            return BaseResponse.success((Object)response.getBody());
        }
        catch (Exception e) {
            log.info("\u64a4\u9500\u5904\u65b9\u5f02\u5e38--->{}", (Object)e.getMessage());
            return BaseResponse.error((String)e.getMessage());
        }
    }

    public BaseResponse<QueryAdviceResVO> hisPres(QueryAdviceReqVO request, String mainId) {
        DrugMainEntity mainEntity = this.mosDrugMainServiceImpl.queryById(mainId);
        BaseResponse queryOrganPmi = this.queryOrganPmi(mainEntity);
        BaseResponse hisClinicNo = this.getHisClinicNo(mainEntity);
        request.setClinicNo((String)hisClinicNo.getData());
        request.setPatientId((String)queryOrganPmi.getData());
        return this.gnQueryPres(request);
    }

    public BaseResponse<QueryAdviceResVO> gnQueryPres(QueryAdviceReqVO request) {
        try {
            FrontRequest frontRequest = new FrontRequest();
            frontRequest.setBody((Object)request);
            String result = HttpKit.jsonPost((String)(this.nodeConfig.getHis() + "onlineOutpatient/queryAdvice"), (String)JSON.toJSONString((Object)frontRequest));
            5 timeTypeReference = new /* Unavailable Anonymous Inner Class!! */;
            FrontResponse response = (FrontResponse)JSONObject.parseObject((String)result, (Type)timeTypeReference.getType(), (Feature[])new Feature[0]);
            if (!Objects.equals("1", response.getCode())) {
                log.info("\u67e5\u8be2his\u5904\u65b9\u51fa\u9519---\u300b{}", (Object)response.getMessage());
                return BaseResponse.error((String)response.getMessage());
            }
            return BaseResponse.success((Object)response.getBody());
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2his\u5904\u65b9\u5f02\u5e38--->{}", (Object)e.getMessage());
            return BaseResponse.error((String)e.getMessage());
        }
    }

    private GetDiagnosticVo getInquiryDiagnostic(String admId, String appCode) {
        log.info("===========\u4f20\u5165\u53c2\u6570admId:{},appCode:{}", (Object)admId, (Object)appCode);
        String url = this.nodeConfig.getAddress() + appCode + "/netinquiry/admission/queryFollowUpCaseRecord";
        QueryAppealOrderTypeDTO queryAppealOrderTypeDTO = new QueryAppealOrderTypeDTO();
        queryAppealOrderTypeDTO.setAdmissionId(admId);
        GetDiagnosticVo diagnosticVo = new GetDiagnosticVo();
        try {
            String result = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)queryAppealOrderTypeDTO), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("\u83b7\u53d6\u5728\u7ebf\u590d\u8bca\u7684\u590d\u8bca\u75c5\u5386\u8bca\u65ad\u7ed3\u679cresult:{}", (Object)result);
            if (ReturnCodeEnum.SUCCEED.getValue().equals(JSONObject.parseObject((String)result).getString("code")) && null != JSONObject.parseObject((String)result).getJSONObject("data")) {
                diagnosticVo = (GetDiagnosticVo)JSONObject.parseObject((String)JSONObject.parseObject((String)result).getString("data"), GetDiagnosticVo.class);
            }
        }
        catch (IOException e) {
            log.info("\u8c03\u7528\u7cfb\u7edf\u670d\u52a1\u83b7\u53d6\u590d\u8bca\u75c5\u5386\u8bca\u65ad\u7ed3\u679c\u5f02\u5e38");
            throw new BusinessException("\u51fa\u73b0\u5f02\u5e38");
        }
        return diagnosticVo;
    }

    public void syncHisPres(PatientListResDTO patientListResDTO) {
        QueryAdviceReqVO queryAdviceReqVO = new QueryAdviceReqVO();
        queryAdviceReqVO.setClinicNo("");
        queryAdviceReqVO.setPatientId((String)patientListResDTO.getPatientIdList().get(0));
        queryAdviceReqVO.setType("");
        queryAdviceReqVO.setSourceType("OFFLINE");
        queryAdviceReqVO.setPresNo("");
        BaseResponse queryAdviceResVOBaseResponse = this.gnQueryPres(queryAdviceReqVO);
        if (queryAdviceResVOBaseResponse.isSuccess()) {
            QueryAdviceResVO presList = (QueryAdviceResVO)queryAdviceResVOBaseResponse.getData();
            List adviceList = presList.getAdviceList();
            log.info("======\u83b7\u53d6\u5904\u65b9\u5217\u8868adviceList:{}", (Object)adviceList);
            List<Object> adviceListFilter = new ArrayList();
            if (!adviceList.isEmpty()) {
                adviceListFilter = adviceList.stream().filter(adviceDTO -> adviceDTO.getSourceType().equals("OFFLINE")).collect(Collectors.toList());
                log.info("=====\u8fc7\u6ee4\u5904\u65b9\u5217\u8868adviceListFilter:{}", (Object)adviceList);
                if (!adviceListFilter.isEmpty()) {
                    for (QueryAdviceResVO.AdviceDTO adviceDTO2 : adviceListFilter) {
                    }
                }
            }
        }
    }

    public PersonnelInfo getDoctorInfo(String emplCode, String doctorName) {
        BaseDTO baseDTO = new BaseDTO();
        baseDTO.setId(Integer.valueOf(this.nodeConfig.getOrganId()));
        BaseResponse listBaseResponse = this.iDoctorApiClient.queryOrganDoctorList(baseDTO);
        List<Object> listBaseResponseFilter = new ArrayList();
        if (listBaseResponse.isSuccess() && listBaseResponse.getData() != null) {
            listBaseResponseFilter = ((List)listBaseResponse.getData()).stream().filter(doctor -> doctor.getName().equals(doctorName)).collect(Collectors.toList());
        }
        if (!listBaseResponseFilter.isEmpty()) {
            PersonnelInfo personnelInfo = new PersonnelInfo();
            for (ManagerDoctorListVO doctor2 : listBaseResponseFilter) {
                String emplCode1;
                QueryPersonnelInfoReq personnelInfoReq = new QueryPersonnelInfoReq();
                personnelInfoReq.setDoctorId(String.valueOf(doctor2.getDoctorId()));
                BaseResponse personnelInfoBaseResponse = this.iDoctorApiClient.queryPersonnelInfo(personnelInfoReq);
                if (!personnelInfoBaseResponse.isSuccess() || personnelInfoBaseResponse.getData() == null || !(emplCode1 = ((PersonnelInfo)personnelInfoBaseResponse.getData()).getEmplCode()).equals(emplCode)) continue;
                personnelInfo = (PersonnelInfo)personnelInfoBaseResponse.getData();
                break;
            }
            return personnelInfo;
        }
        return null;
    }

    public List<QueryCheckLabProjectResVO.ItemDTO> getInspections(QueryCheckLabProjectReqVO param) throws IOException {
        String responseJson;
        log.info("queryItemList param:{}", (Object)JSON.toJSONString((Object)param));
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)param);
        try {
            responseJson = HttpUtils.postNew((String)(this.nodeConfig.getHis() + "/onlineOutpatient/queryCheckLabProject"), (String)JSON.toJSONString((Object)frontRequest));
        }
        catch (IOException e) {
            log.error("HTTP POST \u8bf7\u6c42\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
        6 typeRef = new /* Unavailable Anonymous Inner Class!! */;
        FrontResponse response = (FrontResponse)JSONObject.parseObject((String)responseJson, (Type)typeRef.getType(), (Feature[])new Feature[0]);
        if (response == null || response.getBody() == null || ((QueryCheckLabProjectResVO)response.getBody()).getItem() == null || ((QueryCheckLabProjectResVO)response.getBody()).getItem().isEmpty()) {
            log.warn("\u68c0\u67e5\u68c0\u9a8c\u54cd\u5e94\u5f02\u5e38\u6216\u4e3a\u7a7a");
            return new ArrayList<QueryCheckLabProjectResVO.ItemDTO>();
        }
        log.info("HIS\u67e5\u8be2\u68c0\u67e5\u68c0\u9a8c\u9879\u76ee\u51fa\u53c2===\u300b{}", (Object)JSON.toJSONString((Object)((QueryCheckLabProjectResVO)response.getBody()).getItem()));
        return ((QueryCheckLabProjectResVO)response.getBody()).getItem();
    }

    public List<String> getBbcdm(QueryCheckLabProjectReqVO param) {
        String responseJson;
        log.info("getBbcdm param:{}", (Object)JSON.toJSONString((Object)param));
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)param);
        try {
            responseJson = HttpUtils.postNew((String)(this.nodeConfig.getHis() + "/onlineOutpatient/queryBbdm"), (String)JSON.toJSONString((Object)frontRequest));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        log.info("HIS\u67e5\u8be2\u6807\u672c\u957f\u4ee3\u7801\u51fa\u53c2===\u300b{}", (Object)responseJson);
        JSONObject jsonObject = JSONObject.parseObject((String)responseJson);
        JSONArray body = jsonObject.getJSONArray("body");
        log.info("HIS\u67e5\u8be2\u6807\u672c\u957f\u4ee3\u7801\u51fa\u53c2===\u300b{}", (Object)body);
        return body.toJavaList(String.class);
    }

    public List<GetImplementDeptResVO> getDeptList(GetImplementDeptReqVO param) {
        String responseJson;
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)param);
        try {
            responseJson = HttpUtils.postNew((String)(this.nodeConfig.getHis() + "/onlineOutpatient/queryDeptList"), (String)JSON.toJSONString((Object)frontRequest));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        log.info("HIS\u67e5\u8be2\u6267\u884c\u79d1\u5ba4\u51fa\u53c2===\u300b{}", (Object)responseJson);
        7 typeRef = new /* Unavailable Anonymous Inner Class!! */;
        FrontResponse response = (FrontResponse)JSONObject.parseObject((String)responseJson, (Type)typeRef.getType(), (Feature[])new Feature[0]);
        if (response == null || response.getBody() == null || response.getBody() == null || ((List)response.getBody()).isEmpty()) {
            log.warn("\u6267\u884c\u79d1\u5ba4\u54cd\u5e94\u5f02\u5e38\u6216\u4e3a\u7a7a");
            return new ArrayList<GetImplementDeptResVO>();
        }
        return (List)response.getBody();
    }

    public BaseResponse<String> saveLisApply(DrugMainEntity drugMainEntity, DrugPrescriptionEntity drugPrescriptionEntity, FromOutlineVO fromOutlineVO) {
        BaseResponse queryOrganPmi = this.queryOrganPmi(drugMainEntity);
        if (!queryOrganPmi.isSuccess()) {
            return BaseResponse.error((String)queryOrganPmi.getMsg());
        }
        List detailList = this.mosInspectionDetailMapper.selectListByTypeAndMainId(null, drugMainEntity.getxId());
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            return BaseResponse.error((String)("\u672a\u67e5\u8be2\u5230\u68c0\u9a8c\u9879\u76ee\u4fe1\u606f\uff0cmainId\uff1a" + drugMainEntity.getxId()));
        }
        GetDiagnosticVo diagnostic = this.getInquiryDiagnostic(drugMainEntity.getAdmId(), "GNYFY");
        BaseResponse medicalInfo = this.getMedicalInfo(drugMainEntity);
        if (!medicalInfo.isSuccess()) {
            return BaseResponse.error((String)medicalInfo.getMsg());
        }
        BaseResponse infoBaseResponse = this.queryPersonnelInfo(drugMainEntity.getPresDoctorId());
        if (!infoBaseResponse.isSuccess()) {
            return BaseResponse.error((String)infoBaseResponse.getMsg());
        }
        boolean failFlag = false;
        for (MosInspectionDetailEntity detail : detailList) {
            MosInspectionItemEntity itemMapperById = this.mosInspectionItemMapper.getById(detail.getItemId());
            MosInspectionBbEntity bbEntity = this.mosInspectionBbMapper.selectByDm(detail.getBbdm(), "GNYFY");
            log.info("\u6807\u672c\u8be6\u60c5\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)bbEntity));
            MosInspectionClassifyEntity classifyEntity = this.mosInspectionClassifyMapper.selectByPrimaryKey(detail.getClassifyId());
            LisApplyRequest lisApplyRequest = new LisApplyRequest();
            lisApplyRequest.setExamNo(drugPrescriptionEntity.getxId());
            lisApplyRequest.setPatientId((String)queryOrganPmi.getData());
            lisApplyRequest.setPerformedBy(detail.getImplementDeptId());
            lisApplyRequest.setReqDeptCode("060502");
            lisApplyRequest.setReqDept("\u68c0\u9a8c\u79d1");
            lisApplyRequest.setName(drugMainEntity.getPatientName());
            if (classifyEntity != null) {
                lisApplyRequest.setSpcm(classifyEntity.getClassifyName());
                lisApplyRequest.setSpcmCode(classifyEntity.getClassifyCode());
            }
            lisApplyRequest.setMedicalHistory(fromOutlineVO.getDescription());
            lisApplyRequest.setClinDiag(diagnostic.getIcdName());
            lisApplyRequest.setClinDiagCode(diagnostic.getIcdCode());
            lisApplyRequest.setItemCode(itemMapperById.getClinicalCode());
            lisApplyRequest.setItemName(detail.getItemName());
            if (bbEntity != null) {
                lisApplyRequest.setSampleType(bbEntity.getBbName());
            }
            lisApplyRequest.setDocNo(((PersonnelInfo)infoBaseResponse.getData()).getEmplCode());
            lisApplyRequest.setJzlsh(fromOutlineVO.getClinicCode());
            lisApplyRequest.setOperator1(((PersonnelInfo)infoBaseResponse.getData()).getEmplCode());
            lisApplyRequest.setMainSuit(((MedicalInfoDTO)medicalInfo.getData()).getMainSuit());
            lisApplyRequest.setPhi(((MedicalInfoDTO)medicalInfo.getData()).getMainSuit());
            BaseResponse response = this.saveLisApplyReal(lisApplyRequest);
            if (!response.isSuccess()) {
                log.error("\u4fdd\u5b58\u68c0\u9a8c\u7533\u8bf7\u5355\u5931\u8d25\uff0capplyNo\uff1a{}", response.getData());
                failFlag = true;
                break;
            }
            detail.setApplyNo((String)response.getData());
            log.info("\u66f4\u65b0\u68c0\u9a8c\u7533\u8bf7\u5355\u53f7\u6210\u529f\uff0capplyNo\uff1a{}", response.getData());
            this.mosInspectionDetailMapper.update(detail);
        }
        if (failFlag) {
            return BaseResponse.error((String)"\u4fdd\u5b58\u68c0\u9a8c\u7533\u8bf7\u5355\u5931\u8d25");
        }
        return BaseResponse.success((Object)"\u4fdd\u5b58\u68c0\u9a8c\u7533\u8bf7\u5355\u6210\u529f");
    }

    private BaseResponse<String> saveLisApplyReal(LisApplyRequest lisApplyRequest) {
        String responseJson;
        try {
            responseJson = HttpUtils.postNew((String)(this.nodeConfig.getHis() + "/onlineOutpatient/saveLisApply"), (String)JSON.toJSONString((Object)lisApplyRequest));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        log.info("\u4fdd\u5b58\u68c0\u9a8c\u7533\u8bf7\u5355\u51fa\u53c2===\u300b{}", (Object)responseJson);
        8 typeRef = new /* Unavailable Anonymous Inner Class!! */;
        FrontResponse response = (FrontResponse)JSONObject.parseObject((String)responseJson, (Type)typeRef.getType(), (Feature[])new Feature[0]);
        if (Objects.equals("0", response.getCode())) {
            log.error("\u4fdd\u5b58\u68c0\u9a8c\u7533\u8bf7\u5355\u5931\u8d25\uff1a{}", (Object)response.getMessage());
            return BaseResponse.error((String)response.getMessage());
        }
        return BaseResponse.success((Object)response.getBody());
    }

    public BaseResponse<String> savePacsApply(DrugMainEntity drugMainEntity, DrugPrescriptionEntity drugPrescriptionEntity, FromOutlineVO fromOutlineVO) {
        BaseResponse queryOrganPmi = this.queryOrganPmi(drugMainEntity);
        if (!queryOrganPmi.isSuccess()) {
            return BaseResponse.error((String)queryOrganPmi.getMsg());
        }
        List detailList = this.mosInspectionDetailMapper.selectListByTypeAndMainId(null, drugMainEntity.getxId());
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            return BaseResponse.error((String)("\u672a\u67e5\u8be2\u5230\u68c0\u9a8c\u9879\u76ee\u4fe1\u606f\uff0cmainId\uff1a" + drugMainEntity.getxId()));
        }
        GetDiagnosticVo diagnostic = this.getInquiryDiagnostic(drugMainEntity.getAdmId(), "GNYFY");
        BaseResponse medicalInfo = this.getMedicalInfo(drugMainEntity);
        if (!medicalInfo.isSuccess()) {
            return BaseResponse.error((String)medicalInfo.getMsg());
        }
        BaseResponse infoBaseResponse = this.queryPersonnelInfo(drugMainEntity.getPresDoctorId());
        if (!infoBaseResponse.isSuccess()) {
            return BaseResponse.error((String)infoBaseResponse.getMsg());
        }
        boolean failFlag = false;
        String errorMsg = "";
        for (MosInspectionDetailEntity detail : detailList) {
            BaseResponse response;
            MosInspectionItemEntity itemMapperById = this.mosInspectionItemMapper.getById(detail.getItemId());
            MosInspectionClassifyEntity classifyEntity = this.mosInspectionClassifyMapper.selectByPrimaryKey(detail.getClassifyId());
            PacsApplyRequest pacsApplyRequest = new PacsApplyRequest();
            pacsApplyRequest.setAge(drugMainEntity.getPatientAge());
            pacsApplyRequest.setChargeType("0");
            pacsApplyRequest.setClinDiag(diagnostic.getIcdName());
            pacsApplyRequest.setClinDiagCode(diagnostic.getIcdCode());
            pacsApplyRequest.setClinSymp(((MedicalInfoDTO)medicalInfo.getData()).getMainSuit());
            pacsApplyRequest.setDescription(itemMapperById.getItemName());
            pacsApplyRequest.setDescriptionCode(itemMapperById.getClinicalCode());
            pacsApplyRequest.setDescriptionName(itemMapperById.getItemName());
            pacsApplyRequest.setDescriptionNameCode(itemMapperById.getClinicalCode());
            pacsApplyRequest.setDocNo(((PersonnelInfo)infoBaseResponse.getData()).getEmplCode());
            pacsApplyRequest.setExamClass(itemMapperById.getCsName());
            pacsApplyRequest.setExamClassNo(itemMapperById.getCsNo());
            pacsApplyRequest.setExamNo(drugPrescriptionEntity.getxId());
            pacsApplyRequest.setExamSubClass(classifyEntity.getClassifyName());
            pacsApplyRequest.setExamSubClassNo(classifyEntity.getClassifyNo());
            pacsApplyRequest.setHealthCheckup(((MedicalInfoDTO)medicalInfo.getData()).getPhysicalExamination());
            pacsApplyRequest.setJzlsh(fromOutlineVO.getClinicCode());
            pacsApplyRequest.setMainSuit(((MedicalInfoDTO)medicalInfo.getData()).getMainSuit());
            pacsApplyRequest.setName(drugMainEntity.getPatientName());
            pacsApplyRequest.setPatientId((String)queryOrganPmi.getData());
            pacsApplyRequest.setPerformedBy(detail.getImplementDeptId());
            pacsApplyRequest.setPhi(((MedicalInfoDTO)medicalInfo.getData()).getPrimaryDiagno());
            pacsApplyRequest.setReqDept(detail.getImplementDeptName());
            pacsApplyRequest.setReqDeptCode(detail.getImplementDeptId());
            pacsApplyRequest.setServiceType("\u68c0\u67e5");
            pacsApplyRequest.setSex(drugMainEntity.getPatientGender() == 1 ? "\u7537" : "\u5973");
            if (detail.getExtendJson() != null && !detail.getExtendJson().isEmpty()) {
                JSONArray jsonArray = JSONObject.parseArray((String)detail.getExtendJson());
                jsonArray.forEach(item -> {
                    JSONObject jsonObject = (JSONObject)item;
                    if (Objects.equals(jsonObject.get((Object)"titleCode"), "pushBed")) {
                        pacsApplyRequest.setTcType(jsonObject.get((Object)"dictValue").toString());
                    }
                });
            }
            if (!(response = this.savePacsApplyReal(pacsApplyRequest)).isSuccess()) {
                log.error("\u4fdd\u5b58\u68c0\u67e5\u7533\u8bf7\u5355\u5931\u8d25\uff0capplyNo\uff1a{}", (Object)response.getMsg());
                failFlag = true;
                errorMsg = response.getMsg();
                break;
            }
            detail.setApplyNo((String)response.getData());
            log.info("\u66f4\u65b0\u68c0\u67e5\u7533\u8bf7\u5355\u53f7\u6210\u529f\uff0capplyNo\uff1a{}", response.getData());
            this.mosInspectionDetailMapper.update(detail);
        }
        if (failFlag) {
            return BaseResponse.error((String)errorMsg);
        }
        return BaseResponse.success((Object)"\u4fdd\u5b58\u68c0\u67e5\u7533\u8bf7\u5355\u6210\u529f");
    }

    private BaseResponse<String> savePacsApplyReal(PacsApplyRequest pacsApplyRequest) {
        String responseJson;
        try {
            responseJson = HttpUtils.postNew((String)(this.nodeConfig.getHis() + "/onlineOutpatient/savePacsApply"), (String)JSON.toJSONString((Object)pacsApplyRequest));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        log.info("\u4fdd\u5b58\u68c0\u67e5\u7533\u8bf7\u5355\u51fa\u53c2===\u300b{}", (Object)responseJson);
        9 typeRef = new /* Unavailable Anonymous Inner Class!! */;
        FrontResponse response = (FrontResponse)JSONObject.parseObject((String)responseJson, (Type)typeRef.getType(), (Feature[])new Feature[0]);
        if (response == null || response.getBody() == null || response.getBody() == null || ((String)response.getBody()).isEmpty()) {
            log.warn("\u4fdd\u5b58\u68c0\u67e5\u7533\u8bf7\u5355\u4e3a\u7a7a");
            return BaseResponse.error((String)"\u4fdd\u5b58\u68c0\u67e5\u7533\u8bf7\u5355\u4e3a\u7a7a");
        }
        return BaseResponse.success((Object)response.getBody());
    }

    private BaseResponse<String> queryOrganPmi(DrugMainEntity drugMainEntity) {
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardNo(drugMainEntity.getPatientNo());
        BaseResponse cardResponse = this.cardServiceApi.getHisCardDetails(cardDetailsInfoReqVO);
        if (null == cardResponse || null == cardResponse.getData()) {
            return BaseResponse.error((String)"\u83b7\u53d6\u60a3\u8005his\u4fe1\u606f\u5931\u8d25\uff01");
        }
        return BaseResponse.success((Object)((CardDetailsInfoRespVO)cardResponse.getData()).getOrganPmi());
    }

    private BaseResponse<DoctorEntityInfoVO> getDoctorInfo(DrugMainEntity drugMainEntity) {
        BaseDTO baseDTO = new BaseDTO();
        baseDTO.setId(Integer.valueOf(drugMainEntity.getPresDoctorId()));
        BaseResponse doctorDetailInfo = this.doctorApiClient.endQueryDoctorDetailInfo(baseDTO);
        if (null == doctorDetailInfo || doctorDetailInfo.getData() == null) {
            return BaseResponse.error((String)"\u83b7\u53d6\u533b\u751f\u8eab\u4efd\u8bc1\u53f7\u5931\u8d25");
        }
        return doctorDetailInfo;
    }

    private BaseResponse<PersonnelInfo> queryPersonnelInfo(String doctorId) {
        QueryPersonnelInfoReq infoReq = new QueryPersonnelInfoReq();
        infoReq.setDoctorId(doctorId);
        BaseResponse doctorDetailById = this.doctorApiClient.queryPersonnelInfo(infoReq);
        if (null == doctorDetailById || doctorDetailById.getData() == null) {
            return BaseResponse.error((String)"-\u67e5\u8be2\u533b\u751f\u51fa\u9519");
        }
        return doctorDetailById;
    }

    private BaseResponse<MedicalInfoDTO> getMedicalInfo(DrugMainEntity drugMainEntity) {
        GetHisClinicNoReqVO admId = new GetHisClinicNoReqVO();
        admId.setAdmId(drugMainEntity.getAdmId());
        String jsonnedPost = null;
        try {
            jsonnedPost = HttpKit.jsonPost((String)(this.nodeConfig.getNetInquiry() + "/api/prescase/v1/getMedicalInfoByAdmId"), (String)JSON.toJSONString((Object)admId));
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        JSONObject jsonObject = (JSONObject)JSON.parseObject((String)jsonnedPost, JSONObject.class);
        log.info("inquiryOrderVO========>>>>>:{}", (Object)JSONObject.toJSONString((Object)jsonObject));
        if (null == jsonObject || jsonObject.get((Object)"code") == null || !jsonObject.get((Object)"code").equals("1")) {
            return BaseResponse.error((String)"\u83b7\u53d6\u75c5\u5386\u8be6\u60c5\u7f16\u7801\u5931\u8d25\uff01");
        }
        JSONObject detail = null;
        JSONObject medicalDetail = null;
        String data = jsonObject.getString("data");
        detail = (JSONObject)JSON.parseObject((String)data, JSONObject.class);
        String data2 = detail.getString("medicalDetail");
        medicalDetail = (JSONObject)JSON.parseObject((String)data2, JSONObject.class);
        MedicalInfoDTO infoDTO = new MedicalInfoDTO();
        infoDTO.setMainSuit(detail.getString("mainSuit"));
        infoDTO.setPrimaryDiagno(detail.getString("primaryDiagno"));
        infoDTO.setPresentHistory(medicalDetail.getString("presentHistory"));
        infoDTO.setPhysicalExamination(medicalDetail.getString("physicalExamination"));
        return BaseResponse.success((Object)infoDTO);
    }

    private BaseResponse<String> getHisClinicNo(DrugMainEntity drugMainEntity) {
        GetHisClinicNoReqVO reqVO = new GetHisClinicNoReqVO();
        reqVO.setAdmId(drugMainEntity.getAdmId());
        String clinicNo = null;
        try {
            clinicNo = HttpKit.jsonPost((String)(this.nodeConfig.getNetInquiry() + "/admission/getHisClinicNoByAdmId"), (String)JSON.toJSONString((Object)reqVO));
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        10 icdCodeTypeReference = new /* Unavailable Anonymous Inner Class!! */;
        BaseResponse inquiryOrderVO2 = (BaseResponse)JSONObject.parseObject((String)clinicNo, (Type)icdCodeTypeReference.getType(), (Feature[])new Feature[0]);
        log.info("getHisClinicNo========>>>>>:{}", (Object)JSONObject.toJSONString((Object)inquiryOrderVO2));
        if (null == inquiryOrderVO2 || inquiryOrderVO2.getData() == null) {
            log.info("\u83b7\u53d6his\u6302\u53f7\u7f16\u7801\u5931\u8d25\uff01");
            return BaseResponse.error((String)"\u83b7\u53d6his\u6302\u53f7\u7f16\u7801\u5931\u8d25\uff01");
        }
        return BaseResponse.success((Object)((inquiryOrderVO)inquiryOrderVO2.getData()).getClinicCode());
    }

    public BaseResponse<String> consumeFeeRPres(DrugMainEntity mainEntity, DrugPrescriptionEntity prescriptionEntity, OprationDrugMainDto oprationDrugMainDto) {
        BaseResponse hisClinicNo;
        BaseResponse medicalInfo;
        BaseResponse personnelInfoBaseResponse;
        BaseResponse otherFee = this.getOtherFee(mainEntity.getxId());
        if (!otherFee.isSuccess()) {
            return BaseResponse.error((String)otherFee.getMsg());
        }
        if (((List)otherFee.getData()).isEmpty()) {
            return BaseResponse.success((Object)"\u6ca1\u6709\u8017\u6750\u9700\u8981\u91cd\u65b0\u5f00\u5177\u7684\u533b\u5631");
        }
        BaseResponse queryOrganPmi = this.queryOrganPmi(mainEntity);
        BaseResponse doctorInfo = this.getDoctorInfo(mainEntity);
        if (!doctorInfo.isSuccess()) {
            log.info("\u3010\u8017\u6750\u3011\u67e5\u8be2\u5f00\u65b9\u533b\u751f\u4fe1\u606f\u51fa\u9519");
        }
        if (!(personnelInfoBaseResponse = this.queryPersonnelInfo(oprationDrugMainDto.getOperationId())).isSuccess()) {
            log.info("\u3010\u8017\u6750\u3011\u67e5\u8be2\u5ba1\u6838\u533b\u751f\u4fe1\u606f\u51fa\u9519");
        }
        if ((medicalInfo = this.getMedicalInfo(mainEntity)).getData() == null) {
            log.info("\u3010\u8017\u6750\u3011\u83b7\u53d6\u75c5\u5386\u8be6\u60c5\u5931\u8d25\uff01");
        }
        if (!(hisClinicNo = this.getHisClinicNo(mainEntity)).isSuccess()) {
            log.info("\u3010\u8017\u6750\u3011\u83b7\u53d6hisClinicNo\u5931\u8d25\uff01");
        }
        IssuedUpdateAdviceReqVO issuedUpdateAdviceReqVO = new IssuedUpdateAdviceReqVO();
        issuedUpdateAdviceReqVO.setCardType("0");
        issuedUpdateAdviceReqVO.setCardNo(mainEntity.getPatientNo());
        issuedUpdateAdviceReqVO.setPatientId((String)queryOrganPmi.getData());
        issuedUpdateAdviceReqVO.setClinicNo((String)hisClinicNo.getData());
        issuedUpdateAdviceReqVO.setTotalMoney(String.valueOf(prescriptionEntity.getPrice()));
        issuedUpdateAdviceReqVO.setDescription(mainEntity.getRemark());
        HashMap<Integer, Integer> typeMapping = new HashMap<Integer, Integer>();
        typeMapping.put(DrugTypeEnum.WCTM.getValue(), 1);
        typeMapping.put(DrugTypeEnum.CM.getValue(), 3);
        typeMapping.put(DrugTypeEnum.INSPECT.getValue(), 4);
        typeMapping.put(DrugTypeEnum.CHECKOUT.getValue(), 5);
        typeMapping.put(DrugTypeEnum.TREATMENT.getValue(), 6);
        issuedUpdateAdviceReqVO.setType(String.valueOf(typeMapping.get(mainEntity.getPresType())));
        issuedUpdateAdviceReqVO.setPresNo(prescriptionEntity.getxId());
        issuedUpdateAdviceReqVO.setDeptCode("00100101");
        issuedUpdateAdviceReqVO.setDeptName("\u4e92\u8054\u7f51\u533b\u9662");
        issuedUpdateAdviceReqVO.setDoctorIdcardNo(((DoctorEntityInfoVO)doctorInfo.getData()).getCredNo());
        issuedUpdateAdviceReqVO.setDoctorName(mainEntity.getPresDoctorName());
        issuedUpdateAdviceReqVO.setDoctorCode(mainEntity.getPresDoctorCode());
        issuedUpdateAdviceReqVO.setDoctorCaSign(mainEntity.getDoctorSign());
        issuedUpdateAdviceReqVO.setAuditDoctorCode(((PersonnelInfo)personnelInfoBaseResponse.getData()).getEmplCode());
        issuedUpdateAdviceReqVO.setAuditDoctorName(((PersonnelInfo)personnelInfoBaseResponse.getData()).getDoctorName());
        issuedUpdateAdviceReqVO.setOpenTime(DateUtils.formatDateTime((Date)mainEntity.getxCreateTime()));
        GetDiagnosticVo gnyfy = this.getInquiryDiagnostic(mainEntity.getAdmId(), "GNYFY");
        issuedUpdateAdviceReqVO.setMainSuit(((MedicalInfoDTO)medicalInfo.getData()).getMainSuit());
        issuedUpdateAdviceReqVO.setCurrentHistory(((MedicalInfoDTO)medicalInfo.getData()).getPrimaryDiagno());
        issuedUpdateAdviceReqVO.setPastHistory(((MedicalInfoDTO)medicalInfo.getData()).getPresentHistory());
        issuedUpdateAdviceReqVO.setInspectionPurpose("");
        issuedUpdateAdviceReqVO.setPhysicalExam(((MedicalInfoDTO)medicalInfo.getData()).getPhysicalExamination());
        issuedUpdateAdviceReqVO.setDiagnoseName(gnyfy.getIcdName());
        issuedUpdateAdviceReqVO.setDiagnoseCode(gnyfy.getIcdCode());
        List csNoListByMainId = this.mosInspectionDetailMapper.getCsNoListByMainId(mainEntity.getxId());
        ArrayList detailInfoList = new ArrayList();
        ((List)otherFee.getData()).forEach(fee -> {
            IssuedUpdateAdviceReqVO.DetailInfo detailInfo = new IssuedUpdateAdviceReqVO.DetailInfo();
            detailInfo.setItemCode("0");
            detailInfo.setDoseNoce("0");
            detailInfo.setClinicalCode("0");
            detailInfo.setCommonCode(fee.getHisOrderCode());
            detailInfo.setItemName(fee.getHisOrderName());
            detailInfo.setItemNum(fee.getSqty());
            detailInfo.setPrice(String.valueOf(fee.getPrice()));
            detailInfo.setPriceUnit("\u5143");
            detailInfo.setTcmPasteCnt("1.0000");
            String[] xmdms = fee.getMaterilRelateXmdms().split(",");
            String xmdm = "";
            String finalXmdms = xmdm = xmdms[0] != null && !xmdms[0].isEmpty() ? xmdms[0].substring(1) : xmdms[0];
            log.info("\u3010\u8017\u6750\u3011xmdms:{}", (Object)finalXmdms);
            csNoListByMainId.stream().filter(csNoDTO -> csNoDTO.getCsNo().equals(finalXmdms)).findFirst().ifPresent(csNoDTO -> {
                detailInfo.setImplementDeptId(csNoDTO.getImplementDeptId());
                detailInfo.setImplementDeptName(csNoDTO.getImplementDeptName());
                detailInfo.setStoreCode(csNoDTO.getImplementDeptId());
                detailInfo.setStoreName(csNoDTO.getImplementDeptName());
            });
            detailInfoList.add(detailInfo);
        });
        issuedUpdateAdviceReqVO.setDetailInfoList(detailInfoList);
        FrontRequest request = new FrontRequest();
        request.setBody((Object)issuedUpdateAdviceReqVO);
        log.info("\u3010\u8017\u6750\u3011\u5904\u65b9\u63a8\u9001\u81f3his-req:{}", (Object)JSONObject.toJSONString((Object)request));
        String result = null;
        try {
            result = HttpKit.jsonPost((String)(this.nodeConfig.getHis() + "/onlineOutpatient/issuedUpdateAdvice"), (String)JSON.toJSONString((Object)request));
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        11 timeTypeReference = new /* Unavailable Anonymous Inner Class!! */;
        FrontResponse response = (FrontResponse)JSONObject.parseObject((String)result, (Type)timeTypeReference.getType(), (Feature[])new Feature[0]);
        log.info("\u3010\u8017\u6750\u3011\u5904\u65b9\u63a8\u9001\u81f3his-response:{}", (Object)JSONObject.toJSONString((Object)response));
        if (!Objects.equals("1", response.getCode())) {
            log.info(response.getMessage());
        }
        List list = ((IssuedUpdateAdviceResVO)response.getBody()).getBody().getList();
        String hisPresNo = "";
        if (list.size() < detailInfoList.size()) {
            throw new RuntimeException("HIS\u51fa\u53c2\u5904\u65b9\u53f7\u5f02\u5e38");
        }
        BigDecimal[] totalPrice = new BigDecimal[]{BigDecimal.ZERO};
        for (int i = ((List)otherFee.getData()).size(); i > 0; --i) {
            QueryOtherCostsResVO.MaterialFeeInfo other = (QueryOtherCostsResVO.MaterialFeeInfo)((List)otherFee.getData()).get(((List)otherFee.getData()).size() - i);
            IssuedUpdateAdviceResVO.BodyDTO.HisPresNoDTO hisPresNoDTO = (IssuedUpdateAdviceResVO.BodyDTO.HisPresNoDTO)list.get(list.size() - i);
            MosInspectionDetailEntity mosInspectionDetailEntity = new MosInspectionDetailEntity();
            mosInspectionDetailEntity.setxId(GenSeqUtils.getUniqueNo());
            mosInspectionDetailEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
            mosInspectionDetailEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
            mosInspectionDetailEntity.setAppCode("GNYFY");
            mosInspectionDetailEntity.setMainId(mainEntity.getxId());
            mosInspectionDetailEntity.setPresId(prescriptionEntity.getxId());
            mosInspectionDetailEntity.setPrice(new BigDecimal(other.getPrice()));
            mosInspectionDetailEntity.setType(Integer.valueOf(5));
            mosInspectionDetailEntity.setItemName(other.getHisOrderName());
            mosInspectionDetailEntity.setItemCode(other.getHisOrderCode());
            mosInspectionDetailEntity.setOtherFeeJson(JSON.toJSONString((Object)other));
            mosInspectionDetailEntity.setOtherSqty(other.getSqty());
            mosInspectionDetailEntity.setOtherTotalPrice(new BigDecimal(other.getSummatMoney()));
            mosInspectionDetailEntity.setOtherXmdm(other.getMaterilRelateXmdms());
            mosInspectionDetailEntity.setIsRefund(Integer.valueOf(2));
            mosInspectionDetailEntity.setHisPresNo(hisPresNoDTO.getHisPresNo());
            mosInspectionDetailEntity.setHisDetailNo(hisPresNoDTO.getHisHjmxxh());
            mosInspectionDetailEntity.setHisDetailJe(hisPresNoDTO.getJe());
            this.mosInspectionDetailMapper.insert(mosInspectionDetailEntity);
            totalPrice[0] = totalPrice[0].add(mosInspectionDetailEntity.getPrice());
            hisPresNo = hisPresNoDTO.getHisPresNo();
            log.info("\u4fdd\u5b58\u8017\u6750\u5b9e\u4f53===\u300b{}", (Object)JSON.toJSONString((Object)mosInspectionDetailEntity));
        }
        DrugPrescriptionEntity oldDrugPrescriptionEntity = this.mosDrugPrescriptionService.queryByMainId(oprationDrugMainDto.getMainId());
        oldDrugPrescriptionEntity.setHisRecipeNoOtherFee(hisPresNo);
        this.mosDrugPrescriptionService.update(oldDrugPrescriptionEntity);
        log.info("\u3010\u8017\u6750\u3011\u5904\u65b9\u66f4\u65b0his\u5904\u65b9\u53f7:{}", (Object)JSONObject.toJSONString((Object)oldDrugPrescriptionEntity));
        DrugPrescriptionEntity prescription = new DrugPrescriptionEntity();
        prescription.setxId(prescriptionEntity.getxId());
        prescription.setPrice(prescriptionEntity.getPrice().add(totalPrice[0]));
        prescription.setStorePrice(prescriptionEntity.getPrice().add(totalPrice[0]));
        log.info("===\u66f4\u65b0\u5904\u65b9\u8868\u7684\u4ef7\u683c: {}", (Object)JSON.toJSONString((Object)prescription));
        this.mosDrugPrescriptionService.update(prescription);
        return BaseResponse.success();
    }

    private BaseResponse<List<QueryOtherCostsResVO.MaterialFeeInfo>> getOtherFee(String mainId) {
        log.info("===\u83b7\u53d6\u5176\u4ed6\u8d39\u7528: {}", (Object)mainId);
        DrugMainEntity mainEntity = this.mosDrugMainMapper.queryById(mainId);
        List listByTypeAndMainId = this.mosInspectionDetailMapper.selectListByTypeAndMainId(Integer.valueOf(3), mainId);
        String codeString = this.buildCodeString(listByTypeAndMainId);
        QueryOtherCostsReqVO reqVO = new QueryOtherCostsReqVO();
        reqVO.setAge(mainEntity.getPatientAge());
        reqVO.setCodeString(codeString);
        FrontRequest request = new FrontRequest();
        request.setBody((Object)reqVO);
        String resultString = "";
        try {
            resultString = HttpUtils.postNew((String)(this.nodeConfig.getHis() + "/onlineOutpatient/queryOtherCosts"), (String)JSON.toJSONString((Object)request));
        }
        catch (IOException e) {
            log.error("HTTP POST \u8bf7\u6c42\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
        }
        FrontResponse response = (FrontResponse)JSONObject.parseObject((String)resultString, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        log.info("\u67e5\u8be2\u8017\u6750\u8d39\u8f6c\u6362==={}", (Object)JSON.toJSONString((Object)response));
        if (!Objects.equals("1", response.getCode()) || response.getBody() == null) {
            return BaseResponse.error((String)response.getMessage());
        }
        return BaseResponse.success((Object)response.getBody());
    }

    private String buildCodeString(List<MosInspectionDetailEntity> detailList) {
        if (detailList == null || detailList.isEmpty()) {
            return "";
        }
        StringBuilder codeStringBuilder = new StringBuilder();
        for (MosInspectionDetailEntity detail : detailList) {
            MosInspectionItemEntity item = this.mosInspectionItemMapper.getById(detail.getItemId());
            DrugPrescriptionEntity prescription = this.mosDrugPrescriptionService.queryById(detail.getPresId());
            if (item == null || prescription == null) continue;
            String itemType = "0";
            if (!Objects.equals("1", item.getItemType())) {
                itemType = "1";
            }
            String applyNo = "0";
            String presNo = "0";
            if (Objects.nonNull(detail.getApplyNo())) {
                applyNo = item.getClinicalCode();
            }
            if (Objects.nonNull(prescription.getHisRecipeNo())) {
                presNo = prescription.getHisRecipeNo();
            }
            String code = String.join((CharSequence)",", itemType + item.getCsNoOrExamItemNo(), detail.getBbdm(), "0", "060502", applyNo, presNo);
            codeStringBuilder.append(code).append(";");
        }
        return codeStringBuilder.toString();
    }
}

