/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.manage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ebaiyihui.framework.utils.HttpKit;
import com.ebaiyihui.medicalcloud.common.constants.URLConstant;
import com.ebaiyihui.medicalcloud.common.enums.ReturnCodeEnum;
import com.ebaiyihui.medicalcloud.exception.BusinessException;
import com.ebaiyihui.medicalcloud.manage.MedicareManage;
import com.ebaiyihui.medicalcloud.pojo.vo.PatientInfoRequest;
import com.ebaiyihui.medicalcloud.pojo.vo.YbBaseResponse;
import com.ebaiyihui.medicalcloud.pojo.vo.YbPatientInfoResponse;
import com.ebaiyihui.medicalcloud.pojo.yb.RegistrationRequest;
import com.ebaiyihui.medicalcloud.pojo.yb.UploadInfoRequest;
import com.ebaiyihui.medicalcloud.pojo.yb.YbRegistrationResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MedicareManage {
    private static final Logger log = LoggerFactory.getLogger(MedicareManage.class);
    @Value(value="${medicalcare.url}")
    private String medicalcareUrl;

    public YbPatientInfoResponse getPatientInfo(PatientInfoRequest patientInfoRequest) throws IOException, ExecutionException, InterruptedException {
        YbPatientInfoResponse response = new YbPatientInfoResponse();
        log.info("\u83b7\u53d6\u4eba\u5458\u57fa\u672c\u4fe1\u606f\u8bf7\u6c42url\u662f:{}=========\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)(this.medicalcareUrl + URLConstant.YB_PATIENTINFO_URL), (Object)JSONObject.toJSONString((Object)patientInfoRequest));
        String respStr = HttpKit.jsonPost((String)(this.medicalcareUrl + URLConstant.YB_PATIENTINFO_URL), (String)JSONObject.toJSONString((Object)patientInfoRequest));
        log.info("\u83b7\u53d6\u4eba\u5458\u57fa\u672c\u4fe1\u606f\u7684\u54cd\u5e94\u7ed3\u679c\u662f:{}", (Object)respStr);
        JSONObject result = (JSONObject)JSON.parseObject((String)respStr, JSONObject.class);
        String code = result.get((Object)"code").toString();
        if (!ReturnCodeEnum.SUCCEED.getValue().equals(code) || Objects.isNull(result.get((Object)"body"))) {
            throw new BusinessException("\u83b7\u53d6\u4eba\u5458\u57fa\u672c\u4fe1\u606f\u5931\u8d25," + result.get((Object)"message").toString().replaceAll("[^\\u4E00-\\u9FA5]", ""));
        }
        1 typeReference = new /* Unavailable Anonymous Inner Class!! */;
        YbBaseResponse ybBaseResponseResultResponse = (YbBaseResponse)JSONObject.parseObject((String)result.get((Object)"body").toString(), (Type)typeReference.getType(), (Feature[])new Feature[0]);
        response = (YbPatientInfoResponse)ybBaseResponseResultResponse.getOutput();
        return response;
    }

    public YbRegistrationResponse ybRegistration(RegistrationRequest ybRegistrationRequest) throws IOException, ExecutionException, InterruptedException {
        YbRegistrationResponse response = new YbRegistrationResponse();
        log.info("\u30102201\u3011\u533b\u4fdd\u95e8\u8bca\u767b\u8bb0\u8bf7\u6c42url\u662f:{}=========\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)(this.medicalcareUrl + URLConstant.YB_REGISTRATION_URL), (Object)JSONObject.toJSONString((Object)ybRegistrationRequest));
        String respStr = HttpKit.jsonPost((String)(this.medicalcareUrl + URLConstant.YB_REGISTRATION_URL), (String)JSONObject.toJSONString((Object)ybRegistrationRequest));
        log.info("\u30102201\u3011\u533b\u4fdd\u95e8\u8bca\u767b\u8bb0\u7684\u54cd\u5e94\u7ed3\u679c\u662f:{}", (Object)respStr);
        JSONObject result = (JSONObject)JSON.parseObject((String)respStr, JSONObject.class);
        String code = result.get((Object)"code").toString();
        if (!ReturnCodeEnum.SUCCEED.getValue().equals(code) || Objects.isNull(result.get((Object)"body"))) {
            throw new BusinessException("\u30102201\u3011\u533b\u4fdd\u95e8\u8bca\u767b\u8bb0\u5931\u8d25," + result.get((Object)"message").toString().replaceAll("[^\\u4E00-\\u9FA5]", ""));
        }
        2 typeReference = new /* Unavailable Anonymous Inner Class!! */;
        YbBaseResponse ybBaseResponseResultResponse = (YbBaseResponse)JSONObject.parseObject((String)result.get((Object)"body").toString(), (Type)typeReference.getType(), (Feature[])new Feature[0]);
        response = (YbRegistrationResponse)ybBaseResponseResultResponse.getOutput();
        return response;
    }

    public String ybRegistrationUpload(UploadInfoRequest uploadInfoRequest) throws IOException, ExecutionException, InterruptedException {
        log.info("\u30102203\u3011\u4e0a\u4f20\u8bf7\u6c42url\u662f:{}=========\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)(this.medicalcareUrl + URLConstant.YB_REGISTRATION_UPLOAD_URL), (Object)JSONObject.toJSONString((Object)uploadInfoRequest));
        String respStr = HttpKit.jsonPost((String)(this.medicalcareUrl + URLConstant.YB_REGISTRATION_UPLOAD_URL), (String)JSONObject.toJSONString((Object)uploadInfoRequest));
        log.info("\u30102203\u3011\u4e0a\u4f20\u54cd\u5e94\u7ed3\u679c\u662f:{}", (Object)respStr);
        JSONObject result = (JSONObject)JSON.parseObject((String)respStr, JSONObject.class);
        String code = result.get((Object)"code").toString();
        if (ReturnCodeEnum.SUCCEED.getValue().equals(code) && !Objects.isNull(result.get((Object)"body"))) {
            3 typeReference = new /* Unavailable Anonymous Inner Class!! */;
            YbBaseResponse ybBaseResponseResultResponse = (YbBaseResponse)JSONObject.parseObject((String)result.get((Object)"body").toString(), (Type)typeReference.getType(), (Feature[])new Feature[0]);
            return (String)ybBaseResponseResultResponse.getOutput();
        }
        throw new BusinessException("\u30102203\u3011\u4e0a\u4f20\u8bf7\u6c42\u5931\u8d25," + result.get((Object)"message").toString().replaceAll("[^\\u4E00-\\u9FA5]", ""));
    }
}

