/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.rabbitmq;

import com.alibaba.fastjson.JSON;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.ebaiyihui.medicalcloud.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.medicalcloud.manage.DoctorRetmoteManage;
import com.ebaiyihui.medicalcloud.manage.IhuyiManage;
import com.ebaiyihui.medicalcloud.mapper.MosDrugMainMapper;
import com.ebaiyihui.medicalcloud.mapper.MosPrescriptionAuditScheduleMapper;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosPrescriptionAuditScheduleEntity;
import com.ebaiyihui.medicalcloud.utils.RabbitMqUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.stereotype.Component;

@Component
public class DelayedCallReceiver {
    private static final Logger log = LoggerFactory.getLogger(DelayedCallReceiver.class);
    @Resource
    private MosDrugMainMapper mosDrugMainMapper;
    @Resource
    private MosPrescriptionAuditScheduleMapper auditScheduleMapper;
    @Resource
    private DoctorRetmoteManage doctorRetmoteManage;
    @Resource
    private IhuyiManage ihuyiManage;
    @Resource
    private RabbitTemplate rabbitTemplate;

    @RabbitListener(queues={"call.routing.name.pres"})
    @RabbitHandler
    public void process(String mainId) {
        try {
            log.info("======\u4e00\u5206\u534a\u5206\u949f\u8d85\u65f6\u672a\u5ba1\u65b9MQ\u4efb\u52a1=========: {}", (Object)mainId);
            DrugMainEntity drugMain = this.mosDrugMainMapper.queryById(mainId);
            log.info("==================\u672a\u5ba1\u65b9\u7684\u533b\u5631: {}", (Object)JSON.toJSONString((Object)drugMain));
            if (Objects.equals(drugMain.getItemStatus(), DrugMainStatusEnum.APPROVING.getValue())) {
                LocalDate today = LocalDate.now();
                int dayOfMonth = today.getDayOfMonth();
                MosPrescriptionAuditScheduleEntity scheduleMapperByNowDay = this.auditScheduleMapper.getByNowDay(Integer.valueOf(dayOfMonth), drugMain.getPresOrgan());
                log.info("\u4eca\u65e5\u6392\u73ed\u533b\u751f: {}", (Object)JSON.toJSONString((Object)scheduleMapperByNowDay));
                if (scheduleMapperByNowDay != null) {
                    HashSet<String> idsSet;
                    String[] idsArray;
                    String doctorIds;
                    if (drugMain.getPresType() == 3) {
                        doctorIds = scheduleMapperByNowDay.getZyDoctorIds();
                        idsArray = doctorIds.split(",");
                        idsSet = new HashSet<String>(Arrays.asList(idsArray));
                    } else {
                        doctorIds = scheduleMapperByNowDay.getDoctorIds();
                        idsArray = doctorIds.split(",");
                        idsSet = new HashSet<String>(Arrays.asList(idsArray));
                    }
                    log.info("\u533b\u751fID\u96c6\u5408: {}", idsSet);
                    if (!idsSet.isEmpty()) {
                        ArrayList<String> idList = new ArrayList<String>(idsSet);
                        int randomIndex = ThreadLocalRandom.current().nextInt(idList.size());
                        String randomId = (String)idList.get(randomIndex);
                        log.info("\u968f\u673a\u9009\u62e9\u7684\u533b\u751fID: {}", (Object)randomId);
                        DoctorEntityInfoVO detail = this.doctorRetmoteManage.getDoctorDetailById(Long.valueOf(randomId));
                        if (detail != null) {
                            this.ihuyiManage.callDoctor(detail.getName(), detail.getContactMobile());
                            RabbitMqUtils.senderDelayedCall((RabbitTemplate)this.rabbitTemplate, (String)mainId, (Integer)90);
                        }
                    } else {
                        log.info("{}, \u5ba1\u65b9\u6392\u73ed\u533b\u751f\u4e3a\u7a7a", (Object)LocalDate.now());
                    }
                }
            } else {
                log.info("====\u5904\u65b9\u5df2\u5ba1\u6838\uff01");
            }
        }
        catch (Exception e) {
            log.error("======\u4e00\u5206\u534a\u8d85\u65f6\u672a\u5ba1\u65b9MQ\u4efb\u52a1\u5f02\u5e38=========: {}", (Object)e.getMessage());
        }
    }
}

