/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.service.impl;

import cn.hutool.core.util.IdcardUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.medicalcloud.config.NodeConfig;
import com.ebaiyihui.medicalcloud.manage.GnHisManage;
import com.ebaiyihui.medicalcloud.mapper.MosDrugMainMapper;
import com.ebaiyihui.medicalcloud.mapper.MosInspectionBbMapper;
import com.ebaiyihui.medicalcloud.mapper.MosInspectionClassifyMapper;
import com.ebaiyihui.medicalcloud.mapper.MosInspectionClassifyRelMapper;
import com.ebaiyihui.medicalcloud.mapper.MosInspectionDetailMapper;
import com.ebaiyihui.medicalcloud.mapper.MosInspectionExtendMapper;
import com.ebaiyihui.medicalcloud.mapper.MosInspectionItemMapper;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugPrescriptionEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosInspectionBbEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosInspectionClassifyEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosInspectionClassifyRelEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosInspectionDetailEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosInspectionExtendEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosInspectionItemEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.BbListDTO;
import com.ebaiyihui.medicalcloud.pojo.vo.GetBbReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.GetClassifyListResDTO;
import com.ebaiyihui.medicalcloud.pojo.vo.GetImplementDeptReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.GetImplementDeptResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.GetOtherFeeResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.InspectionListReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.InspectionListResDTO;
import com.ebaiyihui.medicalcloud.pojo.vo.QueryCheckLabProjectReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.QueryCheckLabProjectResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.QueryOtherCostsReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.QueryRequisitionReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.QueryRequisitionResVO;
import com.ebaiyihui.medicalcloud.service.InspectionService;
import com.ebaiyihui.medicalcloud.service.MosDrugPrescriptionService;
import com.ebaiyihui.medicalcloud.service.impl.InspectionServiceImpl;
import com.ebaiyihui.medicalcloud.utils.GenSeqUtils;
import com.ebaiyihui.medicalcloud.utils.HttpUtils;
import com.ebaiyihui.medicalcloud.utils.RedisUtil;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class InspectionServiceImpl
implements InspectionService {
    private static final Logger log = LoggerFactory.getLogger(InspectionServiceImpl.class);
    @Resource
    private NodeConfig nodeConfig;
    @Resource
    private MosInspectionClassifyMapper mosInspectionClassifyMapper;
    @Resource
    private MosInspectionItemMapper mosInspectionItemMapper;
    @Resource
    private MosInspectionClassifyRelMapper relMapper;
    @Resource
    private MosInspectionExtendMapper mosInspectionExtendMapper;
    @Resource
    private MosInspectionBbMapper mosInspectionBbMapper;
    @Resource
    private GnHisManage gnHisManage;
    @Resource
    private MosDrugMainMapper mosDrugMainMapper;
    @Resource
    private MosDrugPrescriptionService mosDrugPrescriptionService;
    @Resource
    private MosInspectionDetailMapper mosInspectionDetailMapper;
    @Resource
    private RedisUtil redisUtil;
    private static final Map<Integer, String> TYPE_MAP = new HashMap();
    private static final int PAGE_SIZE = 1000;
    private static final int THREAD_POOL_SIZE;

    public static String convertType(Integer cloudType) {
        if (TYPE_MAP.containsKey(cloudType)) {
            return (String)TYPE_MAP.get(cloudType);
        }
        throw new IllegalArgumentException("Unknown cloud type: " + cloudType);
    }

    public BaseResponse<PageResult<InspectionListResDTO>> queryItemListPage(PageResult<InspectionListReqVO> param) {
        log.info("\u67e5\u8be2\u672c\u5e93==\u300bqueryItemListPage param:{}", (Object)JSON.toJSONString(param));
        Object map = null;
        PageResult result = new PageResult();
        PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
        InspectionListReqVO reqVO = (InspectionListReqVO)param.getContent().get(0);
        if (reqVO.getType() == null) {
            return BaseResponse.error((String)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        1 typeMapping = new /* Unavailable Anonymous Inner Class!! */;
        Long relType = (Long)typeMapping.get(reqVO.getType());
        String convertType = InspectionServiceImpl.convertType((Integer)((InspectionListReqVO)param.getContent().get(0)).getType());
        Page entityList = this.mosInspectionItemMapper.queryItemListPage(Integer.valueOf(convertType), reqVO.getItemName(), reqVO.getClassifyId());
        if (entityList == null || entityList.isEmpty()) {
            return BaseResponse.success((Object)result);
        }
        ArrayList resDTOList = new ArrayList();
        entityList.forEach(item -> {
            InspectionListResDTO resDTO = new InspectionListResDTO();
            BeanUtils.copyProperties((Object)item, (Object)resDTO);
            if (item.getType() == 3 && item.getServiceOid() != null) {
                List bbList = Arrays.stream(item.getServiceOid().split(";")).filter(StringUtils::isNotBlank).flatMap(serviceOid -> this.mosInspectionBbMapper.getListByOid(serviceOid, "GNYFY").stream()).map(bb -> {
                    BbListDTO bbListDTO = new BbListDTO();
                    bbListDTO.setBbName(bb.getBbName());
                    bbListDTO.setBbdm(bb.getBbdm());
                    return bbListDTO;
                }).collect(Collectors.toList());
                resDTO.setBbList(bbList);
            } else {
                resDTO.setBbList(Collections.emptyList());
            }
            ArrayList<Object> deptList = new ArrayList();
            String key = "GNYFY_" + ((InspectionListReqVO)param.getContent().get(0)).getCampusCode() + "_implement_dept_" + relType;
            Object object = this.redisUtil.get(key);
            log.info("query-- redis key:{}, value:{}", (Object)key, object);
            List deptResVOS = null;
            if (object != null) {
                deptResVOS = JSONObject.parseArray((String)object.toString(), GetImplementDeptResVO.class);
            }
            if (CollectionUtils.isNotEmpty(deptResVOS)) {
                for (GetImplementDeptResVO deptResVO : deptResVOS) {
                    boolean shouldAdd;
                    List conditionList = deptResVO.getConditionList();
                    if (CollectionUtils.isEmpty((Collection)conditionList) || !(shouldAdd = conditionList.stream().anyMatch(condition -> {
                        if (item.getType() == 4) {
                            return true;
                        }
                        if ("\u4e34\u5e8a\u670d\u52a1\u7c7b\u578b\u4ee3\u7801".equals(condition.getCliOrderFlowConditionName())) {
                            return Objects.equals(condition.getConditionValue(), item.getCsTypeCode());
                        }
                        if ("\u4e34\u5e8a\u670d\u52a1".equals(condition.getCliOrderFlowConditionName())) {
                            return Objects.equals(condition.getConditionValue(), item.getCsId());
                        }
                        return false;
                    }))) continue;
                    GetImplementDeptResVO resVO = new GetImplementDeptResVO();
                    resVO.setImplementDeptId(deptResVO.getImplementDeptId());
                    resVO.setImplementDeptName(deptResVO.getImplementDeptName());
                    deptList.add(resVO);
                }
            }
            deptList = new ArrayList<GetImplementDeptResVO>(deptList.stream().collect(Collectors.toMap(GetImplementDeptResVO::getImplementDeptId, deptItem -> deptItem, (existing, replacement) -> existing)).values());
            resDTO.setImplementDeptList(deptList);
            resDTOList.add(resDTO);
        });
        result.setPageNum(param.getPageNum());
        result.setPageSize(param.getPageSize());
        result.setTotalPages(entityList.getPages());
        result.setTotal((int)entityList.getTotal());
        result.setContent(resDTOList);
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<List<GetClassifyListResDTO>> getClassifyList(InspectionListReqVO param) {
        try {
            MosInspectionClassifyEntity classifyEntity = new MosInspectionClassifyEntity();
            classifyEntity.setType(Integer.valueOf(InspectionServiceImpl.convertType((Integer)param.getType())));
            List oneLevelList = this.fetchClassificationsByLevel(classifyEntity, 1, null);
            log.info("\u67e5\u8be2\u51fa\u6765\u7684\u4e00\u7ea7\u5206\u7c7b\u4fe1\u606f: {}", (Object)JSON.toJSONString((Object)oneLevelList));
            if (CollectionUtils.isEmpty((Collection)oneLevelList)) {
                return BaseResponse.success(new ArrayList());
            }
            ArrayList<GetClassifyListResDTO> responseList = new ArrayList<GetClassifyListResDTO>();
            for (MosInspectionClassifyEntity oneItem : oneLevelList) {
                GetClassifyListResDTO dto = this.convertToDtoWithChildren(oneItem);
                responseList.add(dto);
            }
            return BaseResponse.success(responseList);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5206\u7c7b\u5217\u8868\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            return BaseResponse.error((String)"\u83b7\u53d6\u5206\u7c7b\u5217\u8868\u5931\u8d25");
        }
    }

    private List<MosInspectionClassifyEntity> fetchClassificationsByLevel(MosInspectionClassifyEntity entity, int level, String parentId) {
        entity.setClassifyLevel(Integer.valueOf(level));
        entity.setParentId(parentId);
        return this.mosInspectionClassifyMapper.selectList(entity);
    }

    private GetClassifyListResDTO convertToDto(MosInspectionClassifyEntity entity) {
        GetClassifyListResDTO dto = new GetClassifyListResDTO();
        dto.setClassifyName(entity.getClassifyName());
        dto.setClassifyId(entity.getId());
        dto.setClassifyLevel(entity.getClassifyLevel());
        return dto;
    }

    private GetClassifyListResDTO convertToDtoWithChildren(MosInspectionClassifyEntity entity) {
        GetClassifyListResDTO dto = this.convertToDto(entity);
        MosInspectionClassifyEntity childEntity = new MosInspectionClassifyEntity();
        childEntity.setType(entity.getType());
        List children = this.fetchClassificationsByLevel(childEntity, entity.getClassifyLevel() + 1, entity.getId());
        if (!children.isEmpty()) {
            dto.setIsHasChild(Integer.valueOf(1));
            dto.setChild(children.stream().map(arg_0 -> this.convertToDtoWithChildren(arg_0)).collect(Collectors.toList()));
        } else {
            dto.setIsHasChild(Integer.valueOf(0));
        }
        return dto;
    }

    public BaseResponse<List<MosInspectionItemEntity>> queryItemByClassifyId(String classifyId) {
        log.info("===\u6839\u636eclassifyId\u67e5\u8be2\u9879\u76ee\u4fe1\u606f: {}", (Object)classifyId);
        List entityList = this.mosInspectionItemMapper.queryItemByClassifyId(classifyId);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return BaseResponse.success(new ArrayList());
        }
        return BaseResponse.success(new ArrayList());
    }

    private String buildCodeString(List<MosInspectionDetailEntity> detailList) {
        if (detailList == null || detailList.isEmpty()) {
            return "";
        }
        StringBuilder codeStringBuilder = new StringBuilder();
        for (MosInspectionDetailEntity detail : detailList) {
            MosInspectionItemEntity item = this.mosInspectionItemMapper.getById(detail.getItemId());
            DrugPrescriptionEntity prescription = this.mosDrugPrescriptionService.queryById(detail.getPresId());
            if (item == null || prescription == null) continue;
            String itemType = "0";
            if (!Objects.equals("1", item.getItemType())) {
                itemType = "1";
            }
            String applyNo = "0";
            String presNo = "0";
            if (Objects.nonNull(detail.getApplyNo())) {
                applyNo = item.getClinicalCode();
            }
            if (Objects.nonNull(prescription.getHisRecipeNo())) {
                presNo = prescription.getHisRecipeNo();
            }
            String code = String.join((CharSequence)",", itemType + item.getCsNoOrExamItemNo(), detail.getBbdm(), "0", "060502", applyNo, presNo);
            codeStringBuilder.append(code).append(";");
        }
        return codeStringBuilder.toString();
    }

    public BaseResponse<GetOtherFeeResVO> getOtherFee(String mainId) {
        log.info("===\u83b7\u53d6\u5176\u4ed6\u8d39\u7528: {}", (Object)mainId);
        DrugMainEntity mainEntity = this.mosDrugMainMapper.queryById(mainId);
        GetOtherFeeResVO otherFeeResVO = new GetOtherFeeResVO();
        if (mainEntity == null || mainEntity.getPresType() == null || !Objects.equals(mainEntity.getPresType(), 5)) {
            otherFeeResVO.setTotalPrice(new BigDecimal(0));
            otherFeeResVO.setItems(new ArrayList());
            return BaseResponse.success((Object)otherFeeResVO);
        }
        String string = InspectionServiceImpl.convertType((Integer)mainEntity.getPresType());
        List listByTypeAndMainId = this.mosInspectionDetailMapper.selectListByTypeAndMainId(Integer.valueOf(string), mainId);
        if (CollectionUtils.isEmpty((Collection)listByTypeAndMainId)) {
            otherFeeResVO.setTotalPrice(new BigDecimal(0));
            otherFeeResVO.setItems(new ArrayList());
            return BaseResponse.success((Object)otherFeeResVO);
        }
        String codeString = this.buildCodeString(listByTypeAndMainId);
        QueryOtherCostsReqVO reqVO = new QueryOtherCostsReqVO();
        reqVO.setAge(Integer.valueOf(IdcardUtil.getAgeByIdCard((String)mainEntity.getPatientCredNo())));
        reqVO.setCodeString(codeString);
        FrontRequest request = new FrontRequest();
        request.setBody((Object)reqVO);
        String resultString = "";
        try {
            resultString = HttpUtils.postNew((String)(this.nodeConfig.getHis() + "/onlineOutpatient/queryOtherCosts"), (String)JSON.toJSONString((Object)request));
        }
        catch (IOException e) {
            log.error("HTTP POST \u8bf7\u6c42\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
        }
        FrontResponse response = (FrontResponse)JSONObject.parseObject((String)resultString, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        if (response == null || response.getBody() == null) {
            otherFeeResVO.setTotalPrice(new BigDecimal(0));
            otherFeeResVO.setItems(new ArrayList());
            return BaseResponse.success((Object)otherFeeResVO);
        }
        List data = (List)response.getBody();
        if (CollectionUtils.isEmpty((Collection)data)) {
            otherFeeResVO.setTotalPrice(new BigDecimal(0));
            otherFeeResVO.setItems(new ArrayList());
            return BaseResponse.success((Object)otherFeeResVO);
        }
        ArrayList itemDtos = new ArrayList();
        data.forEach(item -> {
            GetOtherFeeResVO.ItemDto itemDto = new GetOtherFeeResVO.ItemDto();
            itemDto.setItemName(item.getHisOrderName());
            itemDto.setPrice(item.getPrice());
            itemDto.setItemType(item.getItemType());
            itemDto.setSqty(item.getSqty());
            itemDtos.add(itemDto);
        });
        BigDecimal total = data.stream().map(item -> new BigDecimal(item.getPrice()).multiply(new BigDecimal(item.getSqty()))).reduce(BigDecimal.ZERO, BigDecimal::add);
        otherFeeResVO.setTotalPrice(total);
        otherFeeResVO.setItems(itemDtos);
        return BaseResponse.success((Object)otherFeeResVO);
    }

    public BaseResponse<List<MosInspectionExtendEntity>> getExtendsInfo(String appCode) {
        return BaseResponse.success((Object)this.mosInspectionExtendMapper.getByAppCode(appCode));
    }

    public BaseResponse<List<MosInspectionBbEntity>> getBb(GetBbReqVO reqVO) {
        return BaseResponse.success((Object)this.mosInspectionBbMapper.selectByBbName(reqVO.getBbName(), reqVO.getAppCode()));
    }

    public BaseResponse<List<GetImplementDeptResVO>> getImplementDept(GetImplementDeptReqVO reqVO) {
        log.info("\u83b7\u53d6\u6267\u884c\u79d1\u5ba4 reqVO:{}", (Object)JSON.toJSONString((Object)reqVO));
        String key = reqVO.getAppCode() + "_implement_dept_" + reqVO.getType() + "_" + reqVO.getCampusCode();
        Object object = this.redisUtil.get(key);
        log.info("query redis key:{},value:{}", (Object)key, object);
        List deptResVOS = null;
        if (object != null) {
            deptResVOS = JSONObject.parseArray((String)object.toString(), GetImplementDeptResVO.class);
        }
        if (deptResVOS != null) {
            return BaseResponse.success(deptResVOS);
        }
        3 typeMapping = new /* Unavailable Anonymous Inner Class!! */;
        int myType = typeMapping.getOrDefault(reqVO.getType(), 0);
        reqVO.setHospitalSOID(Long.valueOf(reqVO.getCampusCode()));
        reqVO.setHospitalAreaIds(reqVO.getCampusCode());
        reqVO.setCsTypeCode(Long.valueOf(myType));
        List deptList = this.gnHisManage.getDeptList(reqVO);
        if (deptList == null || deptList.isEmpty()) {
            return BaseResponse.success(new ArrayList());
        }
        this.redisUtil.set(key, (Object)JSON.toJSONString((Object)deptList), 86400L);
        log.info("save redis key:{},value:{}", (Object)key, object);
        return BaseResponse.success((Object)deptList);
    }

    @Transactional
    public void syncRequisition(String type) {
        4 typeMapping = new /* Unavailable Anonymous Inner Class!! */;
        int myType = typeMapping.getOrDefault(type, 0);
        QueryRequisitionReqVO reqVO = new QueryRequisitionReqVO();
        reqVO.setMethod("8960-0002-03");
        reqVO.setHospitalSOID("994035");
        reqVO.setRequisitionTypeCode(type);
        reqVO.setRequisitionIdlist(new ArrayList());
        reqVO.setKeyword("");
        FrontRequest request = new FrontRequest();
        request.setBody((Object)reqVO);
        String resultString = "";
        try {
            resultString = HttpUtils.postNew((String)(this.nodeConfig.getHis() + "/onlineOutpatient/queryRequisition"), (String)JSON.toJSONString((Object)request));
        }
        catch (IOException e) {
            log.error("HTTP POST \u8bf7\u6c42\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
        }
        FrontResponse response = (FrontResponse)JSONObject.parseObject((String)resultString, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        List requisition = ((QueryRequisitionResVO)response.getBody()).getRequisition();
        requisition.forEach(item -> {
            String uniqueNo = GenSeqUtils.getUniqueNo();
            MosInspectionClassifyEntity byCodeAndLevel = this.mosInspectionClassifyMapper.getByCodeAndLevel(item.getRequisitionDefId(), item.getRequisitionDefName(), Integer.valueOf(1), null);
            if (byCodeAndLevel == null) {
                MosInspectionClassifyEntity first = new MosInspectionClassifyEntity();
                first.setAppCode("GNYFY");
                first.setId(uniqueNo);
                first.setClassifyName(item.getRequisitionDefName());
                first.setClassifyCode(item.getRequisitionDefId());
                first.setCreateTime(new Date());
                first.setUpdateTime(new Date());
                first.setClassifyLevel(Integer.valueOf(1));
                first.setType(Integer.valueOf(myType));
                this.mosInspectionClassifyMapper.insert(first);
                log.info("\u4fdd\u5b58\u4e00\u7ea7\u5206\u7c7b:{}", (Object)JSON.toJSONString((Object)first));
            } else {
                uniqueNo = byCodeAndLevel.getId();
                log.info("\u5df2\u5b58\u5728\u4e00\u7ea7\u5206\u7c7b\uff0c\u5206\u7c7bid\uff1a{},\u5206\u7c7b\u540d\u79f0\uff1a{}", (Object)byCodeAndLevel.getId(), (Object)byCodeAndLevel.getClassifyName());
            }
            if (myType == 2) {
                String finalUniqueNo = uniqueNo;
                item.getRequisitionExamCategoryList().forEach(item2 -> {
                    String uniqueNo1 = GenSeqUtils.getUniqueNo();
                    MosInspectionClassifyEntity level = this.mosInspectionClassifyMapper.getByCodeAndLevel(item2.getExamItemCategoryId(), item2.getExamItemCategoryName(), Integer.valueOf(2), finalUniqueNo);
                    if (level == null) {
                        MosInspectionClassifyEntity second = new MosInspectionClassifyEntity();
                        second.setId(uniqueNo1);
                        second.setAppCode("GNYFY");
                        second.setCreateTime(new Date());
                        second.setUpdateTime(new Date());
                        second.setClassifyName(item2.getExamItemCategoryName());
                        second.setClassifyCode(item2.getExamItemCategoryId());
                        second.setClassifyLevel(Integer.valueOf(2));
                        second.setParentId(finalUniqueNo);
                        second.setType(Integer.valueOf(myType));
                        second.setClassifyNo(item2.getExamItemCategoryNo());
                        this.mosInspectionClassifyMapper.insert(second);
                        log.info("\u4fdd\u5b58\u4e8c\u7ea7\u5206\u7c7b:{}", (Object)JSON.toJSONString((Object)second));
                    } else {
                        uniqueNo1 = level.getId();
                        level.setClassifyNo(item2.getExamItemCategoryNo());
                        this.mosInspectionClassifyMapper.update(level);
                        log.info("\u5df2\u5b58\u5728\u4e8c\u7ea7\u5206\u7c7b\uff0c\u5206\u7c7bid\uff1a{},\u5206\u7c7b\u540d\u79f0\uff1a{}", (Object)level.getId(), (Object)level.getClassifyName());
                    }
                    String finalUniqueNo1 = uniqueNo1;
                    item2.getRequisitionExamItemList().forEach(item3 -> {
                        MosInspectionItemEntity byCodeAndType = this.mosInspectionItemMapper.getByCodeAndType(item3.getExamItemNo(), Integer.valueOf(myType), item3.getExamItemName());
                        if (byCodeAndType == null) {
                            String itemIDUU = GenSeqUtils.getUniqueNo();
                            MosInspectionItemEntity mosInspectionItemEntity = new MosInspectionItemEntity();
                            mosInspectionItemEntity.setxId(itemIDUU);
                            mosInspectionItemEntity.setCsNoOrExamItemNo(item3.getExamItemNo());
                            mosInspectionItemEntity.setItemName(item3.getExamItemName());
                            mosInspectionItemEntity.setType(Integer.valueOf(myType));
                            mosInspectionItemEntity.setxCreateTime(new Date());
                            mosInspectionItemEntity.setCsId(item3.getCsId());
                            mosInspectionItemEntity.setCsNo(item3.getCsNo());
                            mosInspectionItemEntity.setCsName(item3.getCsName());
                            mosInspectionItemEntity.setCsTypeCode(item3.getCsTypeCode());
                            this.mosInspectionItemMapper.insert(mosInspectionItemEntity);
                            log.info("\u4fdd\u5b58\u68c0\u67e5\u9879\u76ee:{}", (Object)JSON.toJSONString((Object)mosInspectionItemEntity));
                            this.saveRel(itemIDUU, finalUniqueNo1);
                        } else {
                            byCodeAndType.setCsId(item3.getCsId());
                            byCodeAndType.setCsNo(item3.getCsNo());
                            byCodeAndType.setCsName(item3.getCsName());
                            byCodeAndType.setCsTypeCode(item3.getCsTypeCode());
                            this.mosInspectionItemMapper.update(byCodeAndType);
                            log.info("\u66f4\u65b0\u68c0\u67e5\u9879\u76ee:{}", (Object)JSON.toJSONString((Object)byCodeAndType));
                            MosInspectionClassifyRelEntity relEntity = this.relMapper.selectByItemIdAndClassifyId(byCodeAndType.getxId(), finalUniqueNo1);
                            if (relEntity == null) {
                                this.saveRel(byCodeAndType.getxId(), finalUniqueNo1);
                            }
                        }
                    });
                });
            } else if (myType == 3) {
                String finalUniqueNo1 = uniqueNo;
                item.getRequisitionExamItemList().forEach(item3 -> {
                    MosInspectionItemEntity byCodeAndType = this.mosInspectionItemMapper.getByCodeAndType(item3.getExamItemNo(), Integer.valueOf(myType), item3.getExamItemName());
                    if (byCodeAndType == null) {
                        String uniqueNo1 = GenSeqUtils.getUniqueNo();
                        MosInspectionItemEntity mosInspectionItemEntity = new MosInspectionItemEntity();
                        mosInspectionItemEntity.setxId(uniqueNo1);
                        mosInspectionItemEntity.setCsNoOrExamItemNo(item3.getExamItemNo());
                        mosInspectionItemEntity.setItemName(item3.getExamItemName());
                        mosInspectionItemEntity.setType(Integer.valueOf(myType));
                        mosInspectionItemEntity.setxCreateTime(new Date());
                        mosInspectionItemEntity.setCsId(item3.getCsId());
                        mosInspectionItemEntity.setCsNo(item3.getCsNo());
                        mosInspectionItemEntity.setCsName(item3.getCsName());
                        mosInspectionItemEntity.setCsTypeCode(item3.getCsTypeCode());
                        log.info("\u4fdd\u5b58\u68c0\u9a8c\u9879\u76ee:{}", (Object)JSON.toJSONString((Object)mosInspectionItemEntity));
                        this.mosInspectionItemMapper.insert(mosInspectionItemEntity);
                        this.saveRel(uniqueNo1, finalUniqueNo1);
                    } else {
                        byCodeAndType.setCsId(item3.getCsId());
                        byCodeAndType.setCsNo(item3.getCsNo());
                        byCodeAndType.setCsName(item3.getCsName());
                        byCodeAndType.setCsTypeCode(item3.getCsTypeCode());
                        this.mosInspectionItemMapper.update(byCodeAndType);
                        log.info("\u66f4\u65b0\u68c0\u9a8c\u9879\u76ee:{}", (Object)JSON.toJSONString((Object)byCodeAndType));
                        MosInspectionClassifyRelEntity relEntity = this.relMapper.selectByItemIdAndClassifyId(byCodeAndType.getxId(), finalUniqueNo1);
                        log.info("\u5df2\u5b58\u5728\u5206\u7c7b\u5173\u8054\u4fe1\u606f\u68c0\u9a8c\u9879\u76eeid:{},\u5206\u7c7bid:{}", (Object)byCodeAndType.getCsNoOrExamItemNo(), (Object)finalUniqueNo1);
                        if (relEntity == null) {
                            this.saveRel(byCodeAndType.getxId(), finalUniqueNo1);
                        }
                    }
                });
            }
        });
    }

    private void saveRel(String itemId, String ClassifyId) {
        MosInspectionClassifyRelEntity relEntity = new MosInspectionClassifyRelEntity();
        relEntity.setCreateTime(new Date());
        relEntity.setUpdateTime(new Date());
        relEntity.setAppCode("GNYFY");
        relEntity.setStatus(Integer.valueOf(1));
        relEntity.setItemId(itemId);
        relEntity.setClassifyId(ClassifyId);
        relEntity.setId(GenSeqUtils.getUniqueNo());
        this.relMapper.insert(relEntity);
        log.info("\u4fdd\u5b58\u5206\u7c7b\u5173\u8054\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)relEntity));
    }

    public void syncRequisitionInfo(Integer type) {
        int pageNumber = 0;
        boolean hasMoreData = true;
        while (hasMoreData) {
            int offset = pageNumber * 1000;
            List items = this.mosInspectionItemMapper.getByTypeWithPagination(type, offset, 1000);
            if (CollectionUtils.isEmpty((Collection)items)) {
                hasMoreData = false;
                break;
            }
            this.processItemsConcurrently(items, type);
            ++pageNumber;
        }
    }

    public void syncHealInfo() {
        QueryCheckLabProjectReqVO reqVO = new QueryCheckLabProjectReqVO();
        reqVO.setType("4");
        try {
            List inspections = this.gnHisManage.getInspections(reqVO);
            if (CollectionUtils.isEmpty((Collection)inspections)) {
                log.info("===\u67e5\u8be2\u6cbb\u7597\u9879\u76ee\u524d\u7f6e\u673a\u8fd4\u56de\u7a7a");
                return;
            }
            inspections.forEach(arg_0 -> this.processInspectionItem(arg_0));
        }
        catch (IOException e) {
            throw new RuntimeException("\u83b7\u53d6\u68c0\u9a8c\u9879\u76ee\u5931\u8d25", e);
        }
    }

    public void syncImplementDept() {
        List<Long> hosCode = Arrays.asList(994035L, 994049L);
        for (Long hos : hosCode) {
            List<Long> typeList = Arrays.asList(98071L, 98078L, 98098L);
            for (Long type2 : typeList) {
                String key = "GNYFY_" + hos + "_implement_dept_" + type2;
                GetImplementDeptReqVO deptReqVO = new GetImplementDeptReqVO();
                deptReqVO.setHospitalSOID(hos);
                deptReqVO.setCsTypeCode(type2);
                deptReqVO.setHospitalAreaIds(String.valueOf(hos));
                List deptList = this.gnHisManage.getDeptList(deptReqVO);
                this.redisUtil.set(key, (Object)JSON.toJSONString((Object)deptList), 86400L);
                log.info("===\u4fdd\u5b58\u6267\u884c\u79d1\u5ba4\u4fe1\u606f\u5230redis key:{}", (Object)key);
                log.info("===\u4fdd\u5b58\u6267\u884c\u79d1\u5ba4\u4fe1\u606f\u5230redis value:{}", (Object)JSON.toJSONString((Object)deptList));
            }
        }
    }

    private void processInspectionItem(QueryCheckLabProjectResVO.ItemDTO item) {
        MosInspectionItemEntity existingItem = this.mosInspectionItemMapper.getByItemCodeAndType(item.getItemCode(), Integer.valueOf(4), item.getItemName());
        if (existingItem != null) {
            this.updateExistingItem(existingItem, item);
        } else {
            String newItemId = this.insertNewItem(item);
            this.associateWithClassify(item, newItemId);
        }
    }

    private void updateExistingItem(MosInspectionItemEntity existingItem, QueryCheckLabProjectResVO.ItemDTO item) {
        existingItem.setxUpdateTime(new Date());
        existingItem.setItemUnit(item.getItemUnit());
        existingItem.setMoney(new BigDecimal(item.getMoney()));
        existingItem.setType(Integer.valueOf(item.getType()));
        existingItem.setDeptCode(item.getDeptCode());
        existingItem.setDeptName(item.getDeptName());
        existingItem.setRemark(item.getRemark());
        existingItem.setMedItemCode(item.getMedItemCode());
        existingItem.setMedItemName(item.getMedItemName());
        existingItem.setItemType(item.getItemType());
        existingItem.setClinicalCode(item.getClinicalCode());
        this.mosInspectionItemMapper.update(existingItem);
    }

    private String insertNewItem(QueryCheckLabProjectResVO.ItemDTO item) {
        String uniqueNo = GenSeqUtils.getUniqueNo();
        MosInspectionItemEntity newItem = new MosInspectionItemEntity();
        newItem.setxId(uniqueNo);
        newItem.setxCreateTime(new Date());
        newItem.setxUpdateTime(new Date());
        newItem.setAppCode("GNYFY");
        newItem.setItemCode(item.getItemCode());
        newItem.setItemName(item.getItemName());
        newItem.setItemUnit(item.getItemUnit());
        newItem.setMoney(new BigDecimal(item.getMoney()));
        newItem.setType(Integer.valueOf(item.getType()));
        newItem.setDeptCode(item.getDeptCode());
        newItem.setDeptName(item.getDeptName());
        newItem.setRemark(item.getRemark());
        newItem.setMedItemCode(item.getMedItemCode());
        newItem.setMedItemName(item.getMedItemName());
        newItem.setItemType(item.getItemType());
        newItem.setClinicalCode(item.getClinicalCode());
        this.mosInspectionItemMapper.insert(newItem);
        log.info("\u4fdd\u5b58\u6cbb\u7597\u9879\u76ee: {}", (Object)JSON.toJSONString((Object)newItem));
        return uniqueNo;
    }

    private void associateWithClassify(QueryCheckLabProjectResVO.ItemDTO item, String itemId) {
        MosInspectionClassifyEntity classifyEntity = this.mosInspectionClassifyMapper.selectTypeAndKeyWords(Integer.valueOf(4), "\u6cbb\u7597\u9879\u76ee");
        if (classifyEntity == null) {
            classifyEntity = this.createNewClassifyEntity();
            this.mosInspectionClassifyMapper.insert(classifyEntity);
            log.info("\u4fdd\u5b58\u6cbb\u7597\u9879\u76ee\u5206\u7c7b\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)classifyEntity));
        }
        this.saveClassifyRelation(itemId, classifyEntity.getId());
    }

    private MosInspectionClassifyEntity createNewClassifyEntity() {
        MosInspectionClassifyEntity entity = new MosInspectionClassifyEntity();
        entity.setId(GenSeqUtils.getUniqueNo());
        entity.setClassifyCode(GenSeqUtils.getUniqueNo());
        entity.setType(Integer.valueOf(4));
        entity.setClassifyLevel(Integer.valueOf(1));
        entity.setClassifyName("\u6cbb\u7597\u9879\u76ee");
        entity.setUpdateTime(new Date());
        entity.setCreateTime(new Date());
        entity.setAppCode("GNYFY");
        return entity;
    }

    private void saveClassifyRelation(String itemId, String classifyId) {
        MosInspectionClassifyRelEntity relEntity = this.relMapper.selectByItemIdAndClassifyId(itemId, classifyId);
        if (relEntity == null) {
            relEntity = new MosInspectionClassifyRelEntity();
            relEntity.setCreateTime(new Date());
            relEntity.setUpdateTime(new Date());
            relEntity.setAppCode("GNYFY");
            relEntity.setStatus(Integer.valueOf(1));
            relEntity.setItemId(itemId);
            relEntity.setClassifyId(classifyId);
            relEntity.setId(GenSeqUtils.getUniqueNo());
            this.relMapper.insert(relEntity);
            log.info("\u4fdd\u5b58\u6cbb\u7597\u9879\u76ee\u5206\u7c7b\u5173\u8054\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)relEntity));
        } else {
            log.info("\u6cbb\u7597\u9879\u76ee\u5206\u7c7b\u5173\u8054\u4fe1\u606f\u5df2\u5b58\u5728{}", (Object)JSON.toJSONString((Object)relEntity));
        }
    }

    private void processItemsConcurrently(List<MosInspectionItemEntity> items, Integer type) {
        ExecutorService executor = Executors.newFixedThreadPool(THREAD_POOL_SIZE);
        ArrayList<CompletableFuture<MosInspectionItemEntity>> futures = new ArrayList<CompletableFuture<MosInspectionItemEntity>>();
        for (MosInspectionItemEntity item : items) {
            CompletableFuture<MosInspectionItemEntity> future = CompletableFuture.supplyAsync(() -> {
                QueryCheckLabProjectReqVO reqVO = new QueryCheckLabProjectReqVO();
                reqVO.setType(String.valueOf(type));
                reqVO.setItemCode(item.getCsNoOrExamItemNo());
                try {
                    List inspections = this.gnHisManage.getInspections(reqVO);
                    if (!CollectionUtils.isEmpty((Collection)inspections)) {
                        return this.updateItemFromInspection(item, (QueryCheckLabProjectResVO.ItemDTO)inspections.get(0));
                    }
                    log.info("===\u901a\u8fc7ItemCode\u67e5\u8be2\u524d\u7f6e\u8fd4\u56de\u7a7a");
                    return null;
                }
                catch (IOException e) {
                    log.error("Error querying inspection data for item code {}", (Object)item.getCsNoOrExamItemNo(), (Object)e);
                    return null;
                }
            }, executor);
            futures.add(future);
        }
        List updatedItems = futures.stream().map(CompletableFuture::join).filter(Objects::nonNull).collect(Collectors.toList());
        if (!updatedItems.isEmpty()) {
            this.batchUpdateItems(updatedItems);
        }
        executor.shutdown();
        try {
            if (!executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private MosInspectionItemEntity updateItemFromInspection(MosInspectionItemEntity item, QueryCheckLabProjectResVO.ItemDTO inspection) {
        item.setItemCode(inspection.getItemCode());
        item.setItemUnit(inspection.getItemUnit());
        item.setMoney(new BigDecimal(inspection.getMoney()));
        item.setDeptCode(inspection.getDeptCode());
        item.setDeptName(inspection.getDeptName());
        item.setRemark(inspection.getRemark());
        item.setMedItemCode(inspection.getMedItemCode());
        item.setMedItemName(inspection.getMedItemName());
        item.setItemType(inspection.getItemType());
        item.setClinicalCode(inspection.getClinicalCode());
        item.setxUpdateTime(new Date());
        return item;
    }

    private void batchUpdateItems(List<MosInspectionItemEntity> updatedItems) {
        try {
            updatedItems.forEach(item -> {
                String serviceOid = "";
                if (item.getType() == 3) {
                    QueryCheckLabProjectReqVO reqVO1 = new QueryCheckLabProjectReqVO();
                    reqVO1.setItemName(item.getItemName());
                    List bbcdm = this.gnHisManage.getBbcdm(reqVO1);
                    if (!CollectionUtils.isEmpty((Collection)bbcdm)) {
                        serviceOid = bbcdm.stream().filter(Objects::nonNull).distinct().collect(Collectors.joining(";"));
                    }
                }
                item.setServiceOid(serviceOid);
                this.mosInspectionItemMapper.update(item);
            });
        }
        catch (Exception e) {
            log.error("Batch update failed", (Throwable)e);
        }
    }

    static {
        TYPE_MAP.put(6, "2");
        TYPE_MAP.put(5, "3");
        TYPE_MAP.put(7, "4");
        THREAD_POOL_SIZE = Runtime.getRuntime().availableProcessors();
    }
}

