/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.doctor.basedata.api.vo.DepartmentDetailVo;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.doctoruser.api.pojo.dto.BaseDTO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorUserInfoVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.HttpUtils;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.framework.utils.UUIDUtils;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.medicalcloud.common.enums.ProfessionEnum;
import com.ebaiyihui.medicalcloud.common.third.PrescPdf;
import com.ebaiyihui.medicalcloud.common.third.PrescPdfPath;
import com.ebaiyihui.medicalcloud.config.PrescPdfConfig;
import com.ebaiyihui.medicalcloud.entity.DoctorYbInfoEntrty;
import com.ebaiyihui.medicalcloud.exception.BusinessException;
import com.ebaiyihui.medicalcloud.feign.IDeptApiClient;
import com.ebaiyihui.medicalcloud.feign.IDoctorApiClient;
import com.ebaiyihui.medicalcloud.manage.DoctorRetmoteManage;
import com.ebaiyihui.medicalcloud.mapper.DrugCompareMapper;
import com.ebaiyihui.medicalcloud.mapper.DrugItemMapper;
import com.ebaiyihui.medicalcloud.mapper.HospitalConfigMapper;
import com.ebaiyihui.medicalcloud.mapper.Icd10CompareMapper;
import com.ebaiyihui.medicalcloud.mapper.MedicalInfoCompareMapper;
import com.ebaiyihui.medicalcloud.mapper.MedicalPresInfoMapper;
import com.ebaiyihui.medicalcloud.mapper.PdfAddressMapper;
import com.ebaiyihui.medicalcloud.mapper.VerifierCompareMapper;
import com.ebaiyihui.medicalcloud.pojo.entity.DiagnosticEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugCompareEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugDetailEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugExtendEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugItemEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugPrescriptionEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.HospitalConfigEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.Icd10CompareEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MedicalInfoCompareEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MedicalPresInfoEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosOutpatientMainRelEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.PdfAddressEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.VerifierCompareEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.DrugDetailPdfVO;
import com.ebaiyihui.medicalcloud.pojo.vo.PresInfoDTO;
import com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.ResultResponse;
import com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.YbMoveUploadInfoEntrty;
import com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.YbUserInfoEntrty;
import com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.request.FixmedinsSignRequest;
import com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.request.RxUodoRequest;
import com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.request.UploadChkRequest;
import com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.response.FileUpldResponse;
import com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.response.FixmedinsSignResponse;
import com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.response.RxUndoResponse;
import com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.response.UploadChkResponse;
import com.ebaiyihui.medicalcloud.pojo.vo.push.DiagnosticEntityPushVO;
import com.ebaiyihui.medicalcloud.pojo.vo.push.DrugDetailEntityPushVO;
import com.ebaiyihui.medicalcloud.pojo.vo.push.DrugExtendEntityPushVO;
import com.ebaiyihui.medicalcloud.pojo.vo.push.DrugMainEntityPushVO;
import com.ebaiyihui.medicalcloud.pojo.vo.push.DrugPrescriptionEntityPushVO;
import com.ebaiyihui.medicalcloud.pojo.vo.push.MedicalMoveMainVO;
import com.ebaiyihui.medicalcloud.pojo.vo.push.MosOutpatientMainRelEntityPushVO;
import com.ebaiyihui.medicalcloud.pojo.vo.webservice.presciption.DiseaseList;
import com.ebaiyihui.medicalcloud.pojo.vo.webservice.presciption.Mdtrtinfos;
import com.ebaiyihui.medicalcloud.pojo.vo.webservice.presciption.PrescBaseResponse;
import com.ebaiyihui.medicalcloud.pojo.vo.webservice.presciption.PrescriptionReqVO;
import com.ebaiyihui.medicalcloud.pojo.yb.Diseinfo;
import com.ebaiyihui.medicalcloud.pojo.yb.FileUpldRequest;
import com.ebaiyihui.medicalcloud.pojo.yb.Mdtrtinfo;
import com.ebaiyihui.medicalcloud.pojo.yb.PrescUploadDto;
import com.ebaiyihui.medicalcloud.pojo.yb.Rxdrugdetail;
import com.ebaiyihui.medicalcloud.pojo.yb.YbMdtrtinfo;
import com.ebaiyihui.medicalcloud.service.MedicarePrescriptionService;
import com.ebaiyihui.medicalcloud.service.impl.MedicarePrescriptionServiceImpl;
import com.ebaiyihui.medicalcloud.utils.BASE64DecodedMultipartFile;
import com.ebaiyihui.medicalcloud.utils.Base64Util;
import com.ebaiyihui.medicalcloud.utils.DateUtils;
import com.ebaiyihui.medicalcloud.utils.JsonUtil;
import com.ebaiyihui.medicalcloud.utils.OSSClientUtil;
import com.ebaiyihui.medicalcloud.utils.RedisUtil;
import com.ebaiyihui.medicalcloud.utils.XmlUtil;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class MedicarePrescriptionServiceImpl
implements MedicarePrescriptionService {
    private static final Logger log = LoggerFactory.getLogger(MedicarePrescriptionServiceImpl.class);
    @Resource
    private IDoctorApiClient doctorApiClient;
    @Resource
    private IDeptApiClient departmentInfoApi;
    @Resource
    private VerifierCompareMapper verifierCompareMapper;
    @Resource
    private DrugItemMapper drugItemMapper;
    @Resource
    private MedicalInfoCompareMapper medicalInfoCompareMapper;
    @Resource
    private HospitalConfigMapper configMapper;
    @Resource
    private PdfAddressMapper pdfAddressMapper;
    @Resource
    private PrescPdfConfig pdfConfig;
    @Resource
    private DoctorRetmoteManage doctorRetmoteManage;
    @Resource
    private ThreadPoolTaskExecutor threadPoolExecutor;
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private Icd10CompareMapper icd10CompareMapper;
    @Resource
    private MedicalPresInfoMapper medicalPresInfoMapper;
    @Resource
    private HospitalConfigMapper hospitalConfigMapper;
    @Resource
    private DrugCompareMapper drugCompareMapper;
    YbMoveUploadInfoEntrty ybMoveUploadInfo;
    YbUserInfoEntrty ybUserInfoEntrty;
    DoctorYbInfoEntrty diagDoctorInfo;
    DoctorYbInfoEntrty doctorYbinfoData;
    @Value(value="${medical.medicalUrl}")
    private String medicalUrl;
    public static final String FIXMEDINS_CODE = "H36070200017";
    public static final String FIXMEDINS_NAME = "\u8d63\u5357\u533b\u5b66\u9662\u7b2c\u4e00\u9644\u5c5e\u533b\u9662";
    public static final int ZERO = 0;

    public BaseResponse<DoctorYbInfoEntrty> getDoctorYbinfo(String doctroId) {
        log.info("\u67e5\u8be2\u533b\u751f\u533b\u4fdd\u4ee3\u7801\uff1adoctroId\uff1a{}", (Object)doctroId);
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(doctroId);
        BaseResponse doctorInfo = this.doctorApiClient.queryPersonnelInfo(queryPersonnelInfoReq);
        log.info("\u67e5\u8be2\u533b\u751f\u670d\u52a1\u627e\u5230\u5bf9\u5e94his\u533b\u751f\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)doctorInfo));
        if (null == doctorInfo || doctorInfo.getData() == null) {
            return BaseResponse.error((String)"\u67e5\u8be2\u533b\u751f\u51fa\u9519");
        }
        String doctroCode = ((PersonnelInfo)doctorInfo.getData()).getEmplCode();
        FrontResponse frontResponse = new FrontResponse();
        DoctorYbInfoEntrty doctorYbInfoEntrty = new DoctorYbInfoEntrty();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("doctorCode", doctroCode);
        map.put("deptCode", "");
        String result = HttpRequest.post((String)"https://ihos.chinachdu.com/hisfront-gnyfy-test/ybBusiness/getYbDoctorInfo").body(JSONObject.toJSONString(map)).execute().body();
        log.info("\u67e5\u8be2\u533b\u751f\u533b\u4fdd\u4ee3\u7801result:{}", (Object)result);
        if (StringUtils.isEmpty((Object)result)) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u533b\u751f\u7684\u533b\u4fdd\u4ee3\u7801");
        }
        1 typeReference = new /* Unavailable Anonymous Inner Class!! */;
        frontResponse = (FrontResponse)JSONObject.parseObject((String)result, (Type)typeReference.getType(), (Feature[])new Feature[0]);
        if (frontResponse.getCode().equals("0")) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u533b\u751f\u533b\u4fdd\u767b\u8bb0\u4fe1\u606f");
        }
        doctorYbInfoEntrty = (DoctorYbInfoEntrty)frontResponse.getBody();
        log.info("\u67e5\u8be2\u533b\u751f\u533b\u4fdd\u767b\u8bb0\u4fe1\u606f\u51fa\u53c2\uff1a" + doctorYbInfoEntrty);
        return BaseResponse.success((Object)doctorYbInfoEntrty);
    }

    public BaseResponse revokePresc(String mainId, String message) {
        MedicalPresInfoEntity undoMedicalPresInfo = this.medicalPresInfoMapper.selectMedicalPresInfo(mainId);
        if (Objects.isNull(undoMedicalPresInfo)) {
            return BaseResponse.error((String)"\u672a\u67e5\u5230\u6709\u6548\u7684\u4e0a\u4f20\u5904\u65b9\uff01");
        }
        String undoUrl = this.medicalUrl + "prescription/rxUndoNew";
        RxUodoRequest rxUodoRequest = new RxUodoRequest();
        rxUodoRequest.setHiRxno(undoMedicalPresInfo.getHiRxno());
        rxUodoRequest.setFixmedinsCode(FIXMEDINS_CODE);
        rxUodoRequest.setUndoDrCertType("01");
        rxUodoRequest.setUndoDrCertno(undoMedicalPresInfo.getDrCertno());
        rxUodoRequest.setUndoDrName(undoMedicalPresInfo.getDrName());
        rxUodoRequest.setDrCode(undoMedicalPresInfo.getDrCode());
        rxUodoRequest.setUndoTime(DateUtils.getDate((String)"yyyy-MM-dd HH:mm:ss"));
        rxUodoRequest.setUndoRea(message);
        log.info("==========\u7701\u4e2d\u5fc3\u7535\u5b50\u5904\u65b9\u64a4\u9500\uff1aurl\uff1a{},data\uff1a{}", (Object)undoUrl, (Object)JSONObject.toJSONString((Object)rxUodoRequest));
        String rxUndoResult = HttpUtil.post((String)undoUrl, (String)JSONObject.toJSONString((Object)rxUodoRequest), (int)450000);
        log.info("==========\u7701\u4e2d\u5fc3\u7535\u5b50\u5904\u65b9\u64a4\u9500\u8fd4\u56de\u7ed3\u679c\uff1adata\uff1a{}", (Object)rxUndoResult);
        ResultResponse upldResponseResponse = (ResultResponse)JSONObject.parseObject((String)rxUndoResult, (Type)new /* Unavailable Anonymous Inner Class!! */.getType(), (Feature[])new Feature[0]);
        if (upldResponseResponse.isSuccess() && "3".equals(((RxUndoResponse)upldResponseResponse.getBody()).getRxStasCodg())) {
            MedicalPresInfoEntity medicalPresInfoEntity = new MedicalPresInfoEntity();
            medicalPresInfoEntity.setHiRxno(((RxUndoResponse)upldResponseResponse.getBody()).getHiRxno());
            medicalPresInfoEntity.setRxStasCodg(((RxUndoResponse)upldResponseResponse.getBody()).getRxStasCodg());
            medicalPresInfoEntity.setRxStasName(((RxUndoResponse)upldResponseResponse.getBody()).getRxStasName());
            medicalPresInfoEntity.setMainId(mainId);
            this.medicalPresInfoMapper.updateMedicalPresInfo(medicalPresInfoEntity);
            return BaseResponse.success((Object)"\u64a4\u9500\u6210\u529f\uff01");
        }
        return BaseResponse.error((String)("\u64a4\u9500\u5931\u8d25\uff0c" + upldResponseResponse.getMessage()));
    }

    private UploadChkRequest uplChk(PrescriptionReqVO prescriptionReqVO) {
        UploadChkRequest uploadChkRequest = new UploadChkRequest();
        uploadChkRequest.setOrganCode("360");
        uploadChkRequest.setMdtrtCertType(prescriptionReqVO.getMdtrtCertType());
        uploadChkRequest.setMdtrtCertNo(prescriptionReqVO.getMdtrtCertNo());
        uploadChkRequest.setBizTypeCode("01");
        uploadChkRequest.setHospRxno(prescriptionReqVO.getPresNo());
        uploadChkRequest.setRxTypeCode("1");
        uploadChkRequest.setPrscTime(prescriptionReqVO.getOpenTime());
        uploadChkRequest.setRxDrugCnt(prescriptionReqVO.getRxDrugCnt());
        uploadChkRequest.setValiDays(prescriptionReqVO.getValiDays());
        uploadChkRequest.setValiEndTime(prescriptionReqVO.getValiEndTime());
        uploadChkRequest.setRxCotnFlag(prescriptionReqVO.getRxCotnFlag());
        uploadChkRequest.setInsuPlcNo(prescriptionReqVO.getInsuPlcNo());
        ArrayList list = new ArrayList();
        prescriptionReqVO.getDrugList().forEach(drug -> {
            com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.request.Rxdrugdetail rxdrugdetail = new com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.request.Rxdrugdetail();
            rxdrugdetail.setMedListCodg(drug.getMedListCodg());
            rxdrugdetail.setFixmedinsHilistId(drug.getFixmedinsHilistId());
            rxdrugdetail.setRxItemTypeCode(drug.getRxItemTypeCode());
            rxdrugdetail.setDrugGenname(drug.getDrugGenname());
            rxdrugdetail.setDrugDosform(drug.getDrugDosform());
            rxdrugdetail.setDrugSpec(drug.getDrugSpec() + drug.getSinDosunt() + "/" + drug.getDrugTotlcntEmp());
            rxdrugdetail.setMedcWayCodg(drug.getMedcWayCodg());
            rxdrugdetail.setMedcWayDscr(drug.getMedcWayDscr());
            rxdrugdetail.setMedcBegntime(drug.getMedcBegntime());
            rxdrugdetail.setMedcEndtime(drug.getMedcEndtime());
            rxdrugdetail.setMedcDays(drug.getMedcDays());
            rxdrugdetail.setDrugCnt(this.subZeroAndDot(drug.getDrugCnt()));
            rxdrugdetail.setDrugDosunt(drug.getDrugDosunt());
            rxdrugdetail.setDrugTotlcnt(this.subZeroAndDot(drug.getDrugTotlcnt()));
            rxdrugdetail.setDrugTotlcntEmp(drug.getDrugTotlcntEmp());
            rxdrugdetail.setSinDoscnt(this.subZeroAndDot(drug.getSinDoscnt()));
            rxdrugdetail.setSinDosunt(drug.getSinDosunt());
            rxdrugdetail.setUsedFrquCodg(drug.getUsedFrquCodg());
            rxdrugdetail.setUsedFrquName(drug.getUsedFrquName());
            rxdrugdetail.setHospApprFlag("0");
            list.add(rxdrugdetail);
        });
        log.info("====\u7ec4\u88c5\u7684\u5904\u65b9\u4fe1\u606fData\uff1a{}", (Object)JSONObject.toJSONString(list));
        uploadChkRequest.setRxdrugdetail(list);
        com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.request.Mdtrtinfo mdtrtinfo = new com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.request.Mdtrtinfo();
        Mdtrtinfos hisMdtrtinfos = prescriptionReqVO.getMdtrtinfos();
        mdtrtinfo.setDiseCodg(hisMdtrtinfos.getDiseCodg());
        mdtrtinfo.setDiseName(hisMdtrtinfos.getDiseName());
        mdtrtinfo.setFixmedinsName(prescriptionReqVO.getFixmedinsName());
        mdtrtinfo.setFixmedinsCode(prescriptionReqVO.getFixmedinsCode());
        mdtrtinfo.setMedType(hisMdtrtinfos.getMedType());
        mdtrtinfo.setIptOtpNo(hisMdtrtinfos.getIptOtpNo());
        mdtrtinfo.setMdtrtId(hisMdtrtinfos.getMdtrtId());
        uploadChkRequest.setAuthNo("");
        mdtrtinfo.setPsnNo(hisMdtrtinfos.getPsnNo());
        mdtrtinfo.setPatnName(hisMdtrtinfos.getPatnName());
        mdtrtinfo.setPsnCertType(hisMdtrtinfos.getPsnCertType());
        mdtrtinfo.setCertno(hisMdtrtinfos.getCertno());
        mdtrtinfo.setPatnAge(hisMdtrtinfos.getPatnAge());
        mdtrtinfo.setGend(hisMdtrtinfos.getGend());
        mdtrtinfo.setPrscDeptCode(prescriptionReqVO.getDeptCode());
        mdtrtinfo.setPrscDeptName(prescriptionReqVO.getDeptName());
        mdtrtinfo.setDrCode(prescriptionReqVO.getDoctorCode());
        mdtrtinfo.setPrscDrName(prescriptionReqVO.getDoctorName());
        mdtrtinfo.setDrProfttlCodg(prescriptionReqVO.getDoctorTitleCode());
        mdtrtinfo.setDrProfttlName(prescriptionReqVO.getDoctorTitle());
        mdtrtinfo.setDrDeptCode(prescriptionReqVO.getDeptCode());
        mdtrtinfo.setDrDeptName(prescriptionReqVO.getDeptName());
        mdtrtinfo.setCaty(hisMdtrtinfos.getCaty());
        mdtrtinfo.setMdtrtTime(hisMdtrtinfos.getMdtrtTime());
        mdtrtinfo.setSpDiseFlag(hisMdtrtinfos.getSpDiseFlag());
        log.info("=====\u7ec4\u88c5\u7684\u5c31\u8bca\u4fe1\u606fmdtrtinfos\uff1a{}", (Object)JSONObject.toJSONString((Object)mdtrtinfo));
        uploadChkRequest.setMdtrtinfo(mdtrtinfo);
        ArrayList diseinfos = new ArrayList();
        List diseaseList = prescriptionReqVO.getDiseaseList();
        diseaseList.forEach(disease -> {
            if ("1".equals(disease.getMaindiagFlag())) {
                mdtrtinfo.setMaindiagCode(disease.getDiagCode());
                mdtrtinfo.setMaindiagName(disease.getDiagName());
            }
            com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.request.Diseinfo diseinfo = new com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.request.Diseinfo();
            BeanUtils.copyProperties((Object)disease, (Object)diseinfo);
            diseinfos.add(diseinfo);
        });
        uploadChkRequest.setDiseinfo(diseinfos);
        return uploadChkRequest;
    }

    public String uploadPresc(PrescriptionReqVO prescriptionReqVO) {
        this.redisUtil.set("prescriptionReqVO_" + prescriptionReqVO.getPresNo(), (Object)JSONObject.toJSONString((Object)prescriptionReqVO));
        Mdtrtinfos mdtrtinfos = prescriptionReqVO.getMdtrtinfos();
        UploadChkRequest uploadChkRequest = this.uplChk(prescriptionReqVO);
        String chKUrl = this.medicalUrl + "prescription/uploadChkNew";
        log.info("==========\u7701\u4e2d\u5fc3\u7535\u5b50\u5904\u65b9\u9884\u6821\u9a8c\uff1aurl\uff1a{},data\uff1a{}", (Object)chKUrl, (Object)JSONObject.toJSONString((Object)uploadChkRequest));
        String chkResult = HttpUtil.post((String)chKUrl, (String)JSONObject.toJSONString((Object)uploadChkRequest), (int)450000);
        log.info("==========\u7701\u4e2d\u5fc3\u7535\u5b50\u5904\u65b9\u9884\u6821\u9a8c\u8fd4\u56de\u7ed3\u679c\uff1adata\uff1a{}", (Object)chkResult);
        ResultResponse chkUploadResponse = (ResultResponse)JSONObject.parseObject((String)chkResult, (Type)new /* Unavailable Anonymous Inner Class!! */.getType(), (Feature[])new Feature[0]);
        if (!chkUploadResponse.isSuccess() || Objects.isNull(chkUploadResponse.getBody())) {
            log.error("\u63a8\u9001\u5904\u65b9\u9884\u6821\u9a8c\u5931\u8d25" + JSONObject.toJSONString((Object)chkUploadResponse));
            PrescBaseResponse error = PrescBaseResponse.error((String)chkUploadResponse.getMessage());
            return XmlUtil.convertToXml((Object)error);
        }
        this.redisUtil.set("medicareChk_" + prescriptionReqVO.getPresNo(), (Object)JSONObject.toJSONString((Object)chkUploadResponse.getBody()));
        UploadChkResponse uploadChkResult = (UploadChkResponse)chkUploadResponse.getBody();
        com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.request.FileUpldRequest fileUpldRequest = new com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.request.FileUpldRequest();
        fileUpldRequest.setRxTraceCode(uploadChkResult.getRxTraceCode());
        fileUpldRequest.setHiRxno(uploadChkResult.getHiRxno());
        fileUpldRequest.setMdtrtId(mdtrtinfos.getMdtrtId());
        fileUpldRequest.setPatnName(mdtrtinfos.getPatnName());
        fileUpldRequest.setPsnCertType(mdtrtinfos.getPsnCertType());
        fileUpldRequest.setCertno(mdtrtinfos.getCertno());
        fileUpldRequest.setFixmedinsName(prescriptionReqVO.getFixmedinsName());
        fileUpldRequest.setFixmedinsCode(prescriptionReqVO.getFixmedinsCode());
        fileUpldRequest.setDrCode(prescriptionReqVO.getDoctorCode());
        fileUpldRequest.setPrscDrName(prescriptionReqVO.getDoctorName());
        fileUpldRequest.setPharDeptCode(prescriptionReqVO.getAuditDeptCode());
        fileUpldRequest.setPharDeptName(prescriptionReqVO.getAuditDeptName());
        fileUpldRequest.setPharProfttlName(prescriptionReqVO.getAuditDoctorTitle());
        fileUpldRequest.setPharProfttlCodg(prescriptionReqVO.getAuditDoctorTitleCode());
        fileUpldRequest.setPharCode(prescriptionReqVO.getAuditDoctorCode());
        fileUpldRequest.setPharName(prescriptionReqVO.getAuditDoctorName());
        fileUpldRequest.setPharChkTime(prescriptionReqVO.getAuditPrescTime());
        this.threadPoolExecutor.execute(() -> {
            String uploadPrescStr = JSONObject.toJSONString((Object)fileUpldRequest);
            BaseResponse fixmedinsSign = this.hisFixmedinsSign(prescriptionReqVO, uploadPrescStr);
            if (!fixmedinsSign.isSuccess() || Objects.isNull(fixmedinsSign.getData())) {
                log.info("==\u533b\u4fdd\u7535\u5b50\u5904\u65b9\u7b7e\u540d\u5931\u8d25=====" + fixmedinsSign.getMsg());
                PrescBaseResponse prescBaseResponse = PrescBaseResponse.error((String)("\u533b\u4fdd\u7535\u5b50\u5904\u65b9\u7b7e\u540d\u5931\u8d25\uff1a" + fixmedinsSign.getMsg()));
            }
            FixmedinsSignResponse fixmedinsSignData = (FixmedinsSignResponse)fixmedinsSign.getData();
            fileUpldRequest.setRxFile(fixmedinsSignData.getRxFile());
            fileUpldRequest.setSignDigest(fixmedinsSignData.getSignDigest());
            String ulpUrl = this.medicalUrl + "prescription/fileUpldNew";
            log.info("==========\u7701\u4e2d\u5fc3\u7535\u5b50\u5904\u65b9\u7535\u5b50\u5904\u65b9\u4e0a\u4f20\uff1aurl\uff1a{},data\uff1a{}", (Object)ulpUrl, (Object)JSONObject.toJSONString((Object)fileUpldRequest));
            String ulpResult = HttpUtil.post((String)ulpUrl, (String)JSONObject.toJSONString((Object)fileUpldRequest), (int)450000);
            log.info("==========\u7701\u4e2d\u5fc3\u7535\u5b50\u5904\u65b9\u7535\u5b50\u5904\u65b9\u4e0a\u4f20\u8fd4\u56de\u7ed3\u679c\uff1adata\uff1a{}", (Object)ulpResult);
            ResultResponse upldResponseResponse = (ResultResponse)JSONObject.parseObject((String)ulpResult, (Type)new /* Unavailable Anonymous Inner Class!! */.getType(), (Feature[])new Feature[0]);
            if (!upldResponseResponse.isSuccess() || Objects.isNull(upldResponseResponse)) {
                log.info("=====\u7701\u4e2d\u5fc3\u7535\u5b50\u5904\u65b9\u7535\u5b50\u5904\u65b9\u4e0a\u4f20\u5931\u8d25\uff01=====" + upldResponseResponse.getMessage());
            }
            MedicalPresInfoEntity medicalPresInfoEntity = new MedicalPresInfoEntity();
            medicalPresInfoEntity.setxId(UUIDUtils.getUUID());
            medicalPresInfoEntity.setHiRxno(uploadChkResult.getHiRxno());
            medicalPresInfoEntity.setRxTraceCode(uploadChkResult.getRxTraceCode());
            medicalPresInfoEntity.setRxStasCodg(((FileUpldResponse)upldResponseResponse.getBody()).getRxStasCodg());
            medicalPresInfoEntity.setRxStasName(((FileUpldResponse)upldResponseResponse.getBody()).getRxStasName());
            medicalPresInfoEntity.setMainId(prescriptionReqVO.getPresNo());
            medicalPresInfoEntity.setRxFile(((FixmedinsSignResponse)fixmedinsSign.getData()).getRxFile());
            medicalPresInfoEntity.setSignCertDn(((FixmedinsSignResponse)fixmedinsSign.getData()).getSignCertDn());
            medicalPresInfoEntity.setSignCertSn(((FixmedinsSignResponse)fixmedinsSign.getData()).getSignCertSn());
            medicalPresInfoEntity.setSignDigest(((FixmedinsSignResponse)fixmedinsSign.getData()).getSignDigest());
            medicalPresInfoEntity.setPdfAddress(((FixmedinsSignResponse)fixmedinsSign.getData()).getPdfAddress());
            medicalPresInfoEntity.setDrCode(prescriptionReqVO.getDrCode());
            medicalPresInfoEntity.setDrName(prescriptionReqVO.getDoctorName());
            this.medicalPresInfoMapper.insertMedicalPresInfo(medicalPresInfoEntity);
        });
        PrescBaseResponse success = PrescBaseResponse.success();
        success.setPresNo(prescriptionReqVO.getPresNo());
        success.setHiRxno(uploadChkResult.getHiRxno());
        success.setRxTraceCode(uploadChkResult.getRxTraceCode());
        return XmlUtil.convertToXml((Object)success);
    }

    private BaseResponse<FixmedinsSignResponse> hisFixmedinsSign(PrescriptionReqVO prescriptionReqVO, String uploadPrescStr) {
        FixmedinsSignRequest fixmedinsSignRequest = new FixmedinsSignRequest();
        fixmedinsSignRequest.setFixmedinsCode(FIXMEDINS_CODE);
        fixmedinsSignRequest.setOriginalValue(com.ebaiyihui.framework.utils.Base64Util.encodeBase64((byte[])uploadPrescStr.getBytes(StandardCharsets.UTF_8)));
        String ossUrl = this.genPrescPdf(prescriptionReqVO);
        byte[] imageFromNetByUrl = com.ebaiyihui.framework.utils.Base64Util.getImageFromNetByUrl((String)ossUrl);
        String prescriptionBase64 = com.ebaiyihui.framework.utils.Base64Util.encodeBase64((byte[])imageFromNetByUrl);
        fixmedinsSignRequest.setOriginalRxFile(prescriptionBase64);
        fixmedinsSignRequest.setOrganCode("360");
        String signUrl = this.medicalUrl + "prescription/fixmedinsSignNew";
        log.info("==========\u7701\u4e2d\u5fc3\u7535\u5b50\u5904\u65b9\u7535\u5b50\u5904\u65b9\u533b\u4fdd\u7b7e\u540d\uff1aurl\uff1a{},data\uff1a{}", (Object)signUrl, (Object)JSONObject.toJSONString((Object)fixmedinsSignRequest));
        String signResult = HttpUtil.post((String)signUrl, (String)JSONObject.toJSONString((Object)fixmedinsSignRequest), (int)450000);
        log.info("==========\u7701\u4e2d\u5fc3\u7535\u5b50\u5904\u65b9\u7535\u5b50\u5904\u65b9\u533b\u4fdd\u7b7e\u540d\u8fd4\u56de\u7ed3\u679c\uff1adata\uff1a{}", (Object)signResult);
        ResultResponse fixmedinSignResponse = (ResultResponse)JSONObject.parseObject((String)signResult, (Type)new /* Unavailable Anonymous Inner Class!! */.getType(), (Feature[])new Feature[0]);
        if (!fixmedinSignResponse.isSuccess() || Objects.isNull(fixmedinSignResponse)) {
            return BaseResponse.error((String)"\u7535\u5b50\u5904\u65b9\u7535\u5b50\u5904\u65b9\u533b\u4fdd\u7b7e\u540d\u5931\u8d25\uff01");
        }
        this.redisUtil.set("medicareSign_" + prescriptionReqVO.getPresNo(), (Object)JSONObject.toJSONString((Object)fixmedinSignResponse));
        ((FixmedinsSignResponse)fixmedinSignResponse.getBody()).setPdfAddress(ossUrl);
        return BaseResponse.success((Object)fixmedinSignResponse.getBody());
    }

    private String genLocalPrescPdf(MedicalMoveMainVO medicalMoveMainVO) {
        PdfAddressEntity pdfAddressEntity;
        log.info("=======>\u751f\u6210\u4e0a\u4f20\u7701\u4e2d\u53f0\u5904\u65b9\u7b3apdf - \u53c2\u6570 - {}", (Object)JSONObject.toJSONString((Object)medicalMoveMainVO));
        DrugPrescriptionEntityPushVO drugPrescriptionEntity = medicalMoveMainVO.getDrugPrescriptionEntity();
        DiagnosticEntityPushVO diagnosticEntity = medicalMoveMainVO.getDiagnosticEntity();
        DrugMainEntityPushVO drugMainEntity = medicalMoveMainVO.getDrugMainEntity();
        List drugDetailEntity = medicalMoveMainVO.getDrugDetailEntity();
        DrugExtendEntityPushVO drugExtendEntity = medicalMoveMainVO.getDrugExtendEntity();
        ArrayList<PresInfoDTO> list = new ArrayList<PresInfoDTO>();
        PresInfoDTO dto = new PresInfoDTO();
        dto.setPatientNo(drugMainEntity.getPatientCredNo());
        String diagnostic = diagnosticEntity.getDiagnostic();
        diagnostic = diagnostic.replace(";", "\u3001");
        dto.setMoneyType("\u533b\u4fdd");
        dto.setDiagnostic(diagnostic);
        dto.setPresCode(drugPrescriptionEntity.getxId());
        dto.setpAge(drugMainEntity.getPatientAge());
        dto.setpSex("M".equals(IdCardUtil.getGenderByIdCard((String)drugMainEntity.getPatientCredNo())) ? "1" : "2");
        dto.setpName(drugMainEntity.getPatientName());
        dto.setCreateTime(drugMainEntity.getxCreateTime());
        Long deptIdL = Long.valueOf(drugMainEntity.getPresDeptCode());
        BaseResponse departmentDetail = this.departmentInfoApi.getDepartmentDetail(deptIdL);
        if (!departmentDetail.isSuccess() || Objects.isNull(departmentDetail.getData())) {
            log.info("\u67e5\u8be2\u5f00\u65b9\u79d1\u5ba4code\u5931\u8d25!");
        }
        log.info("his\u79d1\u5ba4code:" + JSON.toJSONString((Object)departmentDetail));
        dto.setPresDeptName(((DepartmentDetailVo)departmentDetail.getData()).getDeptName());
        dto.setMainId(drugPrescriptionEntity.getxId());
        ArrayList drugInfos = new ArrayList();
        drugDetailEntity.forEach(drug -> {
            DrugDetailPdfVO drugDetailPdfVO = new DrugDetailPdfVO();
            drugDetailPdfVO.setDrugName(drug.getDrugName());
            drugDetailPdfVO.setDrugSpec(drug.getDrugSpec());
            drugDetailPdfVO.setAmount(this.subZeroAndDot(String.valueOf(drug.getAmount())));
            drugDetailPdfVO.setMinBillPackingUnit(drug.getMinBillPackingUnit());
            drugDetailPdfVO.setWholePackingUnit(drug.getWholePackingUnit());
            drugDetailPdfVO.setUsageDesc(drug.getUsageDesc());
            drugDetailPdfVO.setSingleDose(drug.getSingleDose());
            drugDetailPdfVO.setMeasureUnit(drug.getMeasureUnit());
            drugDetailPdfVO.setFrequencyDesc(drug.getFrequencyDesc());
            drugInfos.add(drugDetailPdfVO);
        });
        dto.setDrugInfos(drugInfos);
        dto.setDoctorSign(drugMainEntity.getDoctorSign());
        dto.setVerifySign(drugExtendEntity.getVerifySign());
        list.add(dto);
        log.info("=======>\u751f\u6210pdf - \u5904\u65b9\u8be6\u60c5 - list:{}", (Object)JsonUtil.convertObject(list));
        HospitalConfigEntity configEntity = this.configMapper.selectByAppcode("GNYFY");
        if (configEntity != null) {
            Configuration configuration = new Configuration(Configuration.VERSION_2_3_25);
            StringTemplateLoader stringLoader = new StringTemplateLoader();
            String templateContent = "";
            templateContent = PrescPdf.getZryhTemplateName((String)this.pdfConfig.getBasePath(), (String)"dev-gnyfyTemplate.html");
            stringLoader.putTemplate("prescTemplate", templateContent);
            configuration.setTemplateLoader((TemplateLoader)stringLoader);
            this.pdfConfig.setConfiguration(configuration);
        }
        if ((pdfAddressEntity = this.pdfAddressMapper.selectByAppcode("GNYFY")) != null) {
            PrescPdf prescPdf = new PrescPdf(list, this.pdfConfig, pdfAddressEntity.getOssHost(), pdfAddressEntity.getHtmlPath());
            boolean pdfSuccess = prescPdf.toPdf();
            if (!pdfSuccess) {
                throw new BusinessException("\u751f\u6210pdf\u5e76\u53d1\u9001\u81f3oss\u5931\u8d25");
            }
            log.info("\u751f\u6210pdf\u6210\u529f\u5730\u5740\uff1a{}", (Object)prescPdf.getPdfPath());
            List pdfPath = prescPdf.getPdfPath();
            return ((PrescPdfPath)pdfPath.get(0)).getOssPath();
        }
        return "";
    }

    private String genPrescPdf(PrescriptionReqVO prescriptionReqVO) {
        PdfAddressEntity pdfAddressEntity;
        log.info("=======>\u751f\u6210his\u5904\u65b9\u7b3apdf - \u53c2\u6570 - {}", (Object)prescriptionReqVO);
        Mdtrtinfos mdtrtinfos = prescriptionReqVO.getMdtrtinfos();
        ArrayList<PresInfoDTO> list = new ArrayList<PresInfoDTO>();
        PresInfoDTO dto = new PresInfoDTO();
        dto.setPatientNo(prescriptionReqVO.getMdtrtinfos().getIptOtpNo());
        List diseaseList = prescriptionReqVO.getDiseaseList();
        String diagnostic = "";
        for (int i = 0; i < diseaseList.size(); ++i) {
            diagnostic = diagnostic + ((DiseaseList)diseaseList.get(i)).getDiagName() + "\u3001";
        }
        dto.setMoneyType("\u533b\u4fdd");
        dto.setDiagnostic(diagnostic.substring(0, diagnostic.length() - 1));
        dto.setPresCode(prescriptionReqVO.getPresNo());
        dto.setpAge(Integer.valueOf(mdtrtinfos.getPatnAge()));
        dto.setpSex("M".equals(IdCardUtil.getGenderByIdCard((String)mdtrtinfos.getCertno())) ? "1" : "2");
        dto.setpName(mdtrtinfos.getPatnName());
        dto.setCreateTime(DateUtils.parseFullFormatDate((String)prescriptionReqVO.getOpenTime()));
        dto.setPresDeptName(mdtrtinfos.getPrscDeptName());
        dto.setMainId(prescriptionReqVO.getPresNo());
        ArrayList drugInfos = new ArrayList();
        List drugList = prescriptionReqVO.getDrugList();
        drugList.forEach(drug -> {
            DrugDetailPdfVO drugDetailPdfVO = new DrugDetailPdfVO();
            drugDetailPdfVO.setDrugName(drug.getDrugGenname());
            drugDetailPdfVO.setDrugSpec(drug.getDrugSpec());
            drugDetailPdfVO.setAmount(this.subZeroAndDot(drug.getDrugTotlcnt()));
            drugDetailPdfVO.setMinBillPackingUnit(drug.getSinDosunt());
            drugDetailPdfVO.setWholePackingUnit(drug.getDrugTotlcntEmp());
            drugDetailPdfVO.setUsageDesc(drug.getMedcWayDscr());
            drugDetailPdfVO.setSingleDose(new BigDecimal(this.subZeroAndDot(drug.getSinDoscnt())));
            drugDetailPdfVO.setMeasureUnit(drug.getSinDosunt());
            drugDetailPdfVO.setFrequencyDesc(drug.getUsedFrquName());
            drugInfos.add(drugDetailPdfVO);
        });
        dto.setDrugInfos(drugInfos);
        String doctorFileName = OSSClientUtil.uploadImg2OssNew((MultipartFile)BASE64DecodedMultipartFile.base64ToMultipart((String)("data:image/png;base64," + prescriptionReqVO.getDoctorSign())), (String)"GNYFY_SIGN_");
        String doctorSignUrl = OSSClientUtil.getUrl((String)doctorFileName);
        dto.setDoctorSign(doctorSignUrl);
        String verifyFileName = OSSClientUtil.uploadImg2OssNew((MultipartFile)BASE64DecodedMultipartFile.base64ToMultipart((String)("data:image/png;base64," + prescriptionReqVO.getAuditDoctorSign())), (String)"GNYFY_SIGN_");
        String verifySignUrl = OSSClientUtil.getUrl((String)verifyFileName);
        dto.setVerifySign(verifySignUrl);
        list.add(dto);
        log.info("=======>\u751f\u6210pdf - \u5904\u65b9\u8be6\u60c5 - list:{}", (Object)JsonUtil.convertObject(list));
        HospitalConfigEntity configEntity = this.configMapper.selectByAppcode("GNYFY");
        if (configEntity != null) {
            Configuration configuration = new Configuration(Configuration.VERSION_2_3_25);
            StringTemplateLoader stringLoader = new StringTemplateLoader();
            String templateContent = "";
            templateContent = PrescPdf.getZryhTemplateName((String)this.pdfConfig.getBasePath(), (String)"dev-gnyfyTemplate.html");
            stringLoader.putTemplate("prescTemplate", templateContent);
            configuration.setTemplateLoader((TemplateLoader)stringLoader);
            this.pdfConfig.setConfiguration(configuration);
        }
        if ((pdfAddressEntity = this.pdfAddressMapper.selectByAppcode("GNYFY")) != null) {
            PrescPdf prescPdf = new PrescPdf(list, this.pdfConfig, pdfAddressEntity.getOssHost(), pdfAddressEntity.getHtmlPath());
            boolean pdfSuccess = prescPdf.toPdf();
            if (!pdfSuccess) {
                throw new BusinessException("\u751f\u6210pdf\u5e76\u53d1\u9001\u81f3oss\u5931\u8d25");
            }
            log.info("\u751f\u6210pdf\u6210\u529f\u5730\u5740\uff1a{}", (Object)prescPdf.getPdfPath());
            List pdfPath = prescPdf.getPdfPath();
            return ((PrescPdfPath)pdfPath.get(0)).getOssPath();
        }
        return "";
    }

    private BaseResponse<DoctorYbInfoEntrty> getDoctorYbinfoByHisCode(String doctorCode) {
        FrontResponse frontResponse = new FrontResponse();
        DoctorYbInfoEntrty doctorYbInfoEntrty = new DoctorYbInfoEntrty();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("doctorCode", doctorCode);
        map.put("deptCode", "");
        String result = HttpRequest.post((String)"https://ihos.chinachdu.com/hisfront-gnyfy-test/ybBusiness/getYbDoctorInfo").body(JSONObject.toJSONString(map)).execute().body();
        if (StringUtils.isEmpty((Object)result)) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u533b\u751f\u7684\u533b\u4fdd\u4ee3\u7801");
        }
        6 typeReference = new /* Unavailable Anonymous Inner Class!! */;
        frontResponse = (FrontResponse)JSONObject.parseObject((String)result, (Type)typeReference.getType(), (Feature[])new Feature[0]);
        if (frontResponse.getCode().equals("0")) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u533b\u751f\u533b\u4fdd\u767b\u8bb0\u4fe1\u606f");
        }
        doctorYbInfoEntrty = (DoctorYbInfoEntrty)frontResponse.getBody();
        log.info("\u67e5\u8be2\u533b\u751f\u533b\u4fdd\u767b\u8bb0\u4fe1\u606f\u51fa\u53c2\uff1a" + doctorYbInfoEntrty);
        return BaseResponse.success((Object)doctorYbInfoEntrty);
    }

    private BaseResponse<UploadChkResponse> chkUpload(MedicalMoveMainVO medicalMoveMainVO) throws Exception {
        log.info("=======\u8fdb\u5165\u7535\u5b50\u5904\u65b9\u9884\u6821\u9a8c\u63a5\u53e3==========");
        UploadChkRequest uploadChkRequest = new UploadChkRequest();
        DrugMainEntityPushVO drugMainEntity = medicalMoveMainVO.getDrugMainEntity();
        DrugPrescriptionEntityPushVO drugPrescriptionEntity = medicalMoveMainVO.getDrugPrescriptionEntity();
        List drugDetailList = medicalMoveMainVO.getDrugDetailEntity();
        DiagnosticEntityPushVO diagnosticEntity = medicalMoveMainVO.getDiagnosticEntity();
        MosOutpatientMainRelEntityPushVO mosOutpatientMainRelEntity = medicalMoveMainVO.getMosOutpatientMainRelEntity();
        uploadChkRequest.setOrganCode(drugMainEntity.getPresOrgan());
        uploadChkRequest.setMdtrtCertType("02");
        uploadChkRequest.setMdtrtCertNo(drugMainEntity.getPatientCredNo());
        uploadChkRequest.setBizTypeCode("01");
        uploadChkRequest.setHospRxno(drugPrescriptionEntity.getxId());
        uploadChkRequest.setRxTypeCode("1");
        uploadChkRequest.setPrscTime(DateUtils.formatDateTime((Date)drugMainEntity.getxCreateTime()));
        uploadChkRequest.setRxDrugCnt(String.valueOf(drugDetailList.size()));
        uploadChkRequest.setValiDays("3");
        uploadChkRequest.setValiEndTime(DateUtils.formatDateTime((Date)DateUtils.addDay((Date)drugMainEntity.getxCreateTime(), (int)3)));
        uploadChkRequest.setRxCotnFlag("0");
        ArrayList<com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.request.Rxdrugdetail> list = new ArrayList<com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.request.Rxdrugdetail>();
        for (int i = 0; i < drugDetailList.size(); ++i) {
            DrugDetailEntityPushVO drug = (DrugDetailEntityPushVO)drugDetailList.get(i);
            com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.request.Rxdrugdetail rxdrugdetail = new com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.request.Rxdrugdetail();
            DrugItemEntity drugItem = this.drugItemMapper.getById(drug.getDrugId());
            log.info("\u67e5\u8be2\u7684\u836f\u54c1\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)drugItem));
            MedicalInfoCompareEntity medicalInfoCompareEntity = this.getMedicalCompare(drugItem.getProductCode());
            if (Objects.isNull(medicalInfoCompareEntity)) {
                return BaseResponse.error((String)("\u4e0a\u4f20\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230" + drugItem.getCommonName() + "\u7684\u533b\u4fdd\u7f16\u7801\uff01"));
            }
            rxdrugdetail.setMedListCodg(medicalInfoCompareEntity.getMedicalCode());
            rxdrugdetail.setFixmedinsHilistId(medicalInfoCompareEntity.getHospCode());
            rxdrugdetail.setRxItemTypeCode("11");
            rxdrugdetail.setDrugGenname(drugItem.getCommonName());
            rxdrugdetail.setDrugDosform(drugItem.getDosageForm());
            rxdrugdetail.setDrugSpec(drugItem.getDrugSpec() + drugItem.getMinBillPackingUnitName() + "/" + drugItem.getWholePackingUnitName());
            rxdrugdetail.setMedcWayCodg(drug.getUsageId());
            rxdrugdetail.setMedcWayDscr(drug.getUsageDesc());
            rxdrugdetail.setMedcBegntime(DateUtils.formatDateTime((Date)drugMainEntity.getxUpdateTime()));
            rxdrugdetail.setMedcEndtime(DateUtils.formatDateTime((Date)DateUtils.addDay((Date)drugMainEntity.getxUpdateTime(), (int)drug.getDuration())));
            rxdrugdetail.setMedcDays(drug.getDuration().toString());
            rxdrugdetail.setDrugCnt(this.subZeroAndDot(drug.getAmount().toString()));
            rxdrugdetail.setDrugDosunt(drugItem.getWholePackingUnitName());
            rxdrugdetail.setDrugTotlcnt(this.subZeroAndDot(drug.getAmount().toString()));
            rxdrugdetail.setDrugTotlcntEmp(medicalInfoCompareEntity.getUnit());
            rxdrugdetail.setSinDoscnt(this.subZeroAndDot(drug.getSingleDose().toString()));
            rxdrugdetail.setSinDosunt(drugItem.getMinBillPackingUnitName());
            rxdrugdetail.setUsedFrquCodg(drug.getFrequencyId());
            rxdrugdetail.setUsedFrquName(drug.getFrequencyDesc());
            rxdrugdetail.setHospApprFlag("0");
            list.add(rxdrugdetail);
        }
        log.info("====\u7ec4\u88c5\u7684\u5904\u65b9\u4fe1\u606fData\uff1a{}", (Object)JSONObject.toJSONString(list));
        uploadChkRequest.setRxdrugdetail(list);
        com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.request.Mdtrtinfo mdtrtinfo = new com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.request.Mdtrtinfo();
        String queryUploadResultUrl = this.medicalUrl + "cz/medicalBusiness/queryMedicareUploadResult" + "?orderId=" + mosOutpatientMainRelEntity.getOrderId();
        log.info("==========\u67e5\u8be2\u533b\u4fdd\u7ed3\u7b97\u65f6\u4e0a\u4f20\u7ed3\u679c\uff1aqueryUploadResultUrl{}", (Object)queryUploadResultUrl);
        String uploadResult = HttpUtils.get((String)queryUploadResultUrl);
        ResultResponse ybMoveUploadInfoResponse = (ResultResponse)JSONObject.parseObject((String)uploadResult, (Type)new /* Unavailable Anonymous Inner Class!! */.getType(), (Feature[])new Feature[0]);
        if (!ybMoveUploadInfoResponse.isSuccess()) {
            log.info("==========\u67e5\u8be2\u533b\u4fdd\u7ed3\u7b97\u65f6\u4e0a\u4f20\u7ed3\u679c\uff1aqueryUploadResultUrl{}", (Object)queryUploadResultUrl);
            return BaseResponse.error((String)"\u67e5\u8be2\u533b\u4fdd\u7ed3\u7b97\u65f6\u4e0a\u4f20\u7ed3\u679c\u5931\u8d25\uff01\u53ea\u80fd\u4e0a\u4f20\u533b\u4fdd\u5904\u65b9\uff01");
        }
        this.ybMoveUploadInfo = (YbMoveUploadInfoEntrty)ybMoveUploadInfoResponse.getBody();
        mdtrtinfo.setFixmedinsName(FIXMEDINS_NAME);
        mdtrtinfo.setFixmedinsCode(FIXMEDINS_CODE);
        mdtrtinfo.setMedType("11");
        mdtrtinfo.setIptOtpNo(mosOutpatientMainRelEntity.getOrderId());
        mdtrtinfo.setMdtrtId(this.ybMoveUploadInfo.getMdtrtId());
        uploadChkRequest.setAuthNo("");
        String getMedicarePatientInfo = this.medicalUrl + "cz/medicalBusiness/queryPatientInfo" + "?idNo=" + drugMainEntity.getPatientCredNo();
        log.info("==========\u67e5\u8be2\u4e2a\u4eba\u53c2\u4fdd\u4fe1\u606f\uff1agetMedicarePatientInfo{}", (Object)getMedicarePatientInfo);
        String patientInfo = HttpUtils.get((String)getMedicarePatientInfo);
        log.info("==========\u67e5\u8be2\u4e2a\u4eba\u53c2\u4fdd\u8fd4\u56de\u4fe1\u606f\uff1agetMedicarePatientInfo{}", (Object)patientInfo);
        ResultResponse patientResponse = (ResultResponse)JSONObject.parseObject((String)patientInfo, (Type)new /* Unavailable Anonymous Inner Class!! */.getType(), (Feature[])new Feature[0]);
        if (!patientResponse.isSuccess()) {
            log.info("==========\u67e5\u8be2\u4e2a\u4eba\u53c2\u4fdd\u4fe1\u606f\u5931\u8d25\uff1agetMedicarePatientInfo{}", (Object)getMedicarePatientInfo);
            return BaseResponse.error((String)"\u67e5\u8be2\u4e2a\u4eba\u53c2\u4fdd\u4fe1\u606f\u5931\u8d25\uff01");
        }
        this.ybUserInfoEntrty = (YbUserInfoEntrty)patientResponse.getBody();
        mdtrtinfo.setPsnNo(this.ybUserInfoEntrty.getPsn_no());
        mdtrtinfo.setPatnName(this.ybUserInfoEntrty.getPsn_name());
        mdtrtinfo.setPsnCertType(this.ybUserInfoEntrty.getPsn_cert_type());
        mdtrtinfo.setCertno(this.ybUserInfoEntrty.getCertno());
        mdtrtinfo.setPatnAge(String.valueOf(drugMainEntity.getPatientAge()));
        mdtrtinfo.setGend(this.ybUserInfoEntrty.getGend());
        Long deptIdL = Long.valueOf(drugMainEntity.getPresDeptCode());
        BaseResponse departmentDetail = this.departmentInfoApi.getDepartmentDetail(deptIdL);
        if (!departmentDetail.isSuccess() || Objects.isNull(departmentDetail.getData())) {
            log.info("\u67e5\u8be2\u5f00\u65b9\u79d1\u5ba4code\u5931\u8d25!");
            return BaseResponse.error((String)"\u67e5\u8be2\u5f00\u65b9\u79d1\u5ba4\u4fe1\u606f\u5931\u8d25!");
        }
        log.info("his\u79d1\u5ba4code:" + JSON.toJSONString((Object)departmentDetail));
        mdtrtinfo.setPrscDeptName(((DepartmentDetailVo)departmentDetail.getData()).getDeptName());
        mdtrtinfo.setPrscDeptCode(((DepartmentDetailVo)departmentDetail.getData()).getDeptCode());
        BaseResponse doctorYbinfo = this.getDoctorYbinfo(drugMainEntity.getPresDoctorId());
        if (!doctorYbinfo.isSuccess()) {
            log.info("\u67e5\u8be2\u5f00\u65b9\u533b\u751f\u533b\u4fdd\u4ee3\u7801\u5931\u8d25");
            return BaseResponse.error((String)"\u67e5\u8be2\u5f00\u65b9\u533b\u751f\u533b\u4fdd\u4ee3\u7801\u5931\u8d25\uff01");
        }
        this.doctorYbinfoData = (DoctorYbInfoEntrty)doctorYbinfo.getData();
        mdtrtinfo.setDrCode(this.doctorYbinfoData.getDoctorYbCode());
        mdtrtinfo.setPrscDrName(this.doctorYbinfoData.getDoctorYbName());
        DoctorEntityInfoVO doctorVo = this.doctorRetmoteManage.getDoctorDetailById(Long.valueOf(Long.parseLong(drugMainEntity.getPresDoctorId())));
        log.info("=========\u67e5\u8be2\u533b\u751f\u4fe1\u606f\uff0c\u83b7\u53d6\u76f8\u5173\u533b\u751f\u804c\u79f0\u4fe1\u606fdata:{}", (Object)JSONObject.toJSONString((Object)doctorVo));
        mdtrtinfo.setDrProfttlCodg(ProfessionEnum.getDesc((String)doctorVo.getProfession()));
        mdtrtinfo.setDrProfttlName(doctorVo.getProfession());
        mdtrtinfo.setDrDeptCode(((DepartmentDetailVo)departmentDetail.getData()).getDeptCode());
        mdtrtinfo.setDrDeptName(((DepartmentDetailVo)departmentDetail.getData()).getDeptName());
        mdtrtinfo.setCaty("1");
        mdtrtinfo.setMdtrtTime(DateUtils.formatDateTime((Date)mosOutpatientMainRelEntity.getXCreateTime()));
        mdtrtinfo.setSpDiseFlag("0");
        log.info("=====\u7ec4\u88c5\u7684\u5c31\u8bca\u4fe1\u606fmdtrtinfos\uff1a{}", (Object)JSONObject.toJSONString((Object)mdtrtinfo));
        uploadChkRequest.setMdtrtinfo(mdtrtinfo);
        uploadChkRequest.setInsuPlcNo(this.ybUserInfoEntrty.getInsuplc_admdvs());
        String[] icdCodes = diagnosticEntity.getIcdCode().split(";");
        String[] icdNames = diagnosticEntity.getIcdName().split(";");
        this.handleDiagnostic(icdCodes, icdNames);
        mdtrtinfo.setMaindiagCode(icdCodes[0]);
        mdtrtinfo.setMaindiagName(icdNames[0]);
        ArrayList<com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.request.Diseinfo> diseinfos = new ArrayList<com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.request.Diseinfo>();
        for (int i = 0; i < icdCodes.length; ++i) {
            com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.request.Diseinfo diseinfo = new com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.request.Diseinfo();
            diseinfo.setDiagType("1");
            if (i == 0) {
                diseinfo.setMaindiagFlag("1");
            } else {
                diseinfo.setMaindiagFlag("0");
            }
            diseinfo.setDiagSrtNo(String.valueOf(i + 1));
            diseinfo.setDiagCode(icdCodes[i]);
            diseinfo.setDiagName(icdNames[i]);
            diseinfo.setDiagDept(((DepartmentDetailVo)departmentDetail.getData()).getDeptCode());
            BaseResponse diagDoctorYbinfo = this.getDoctorYbinfoByHisCode(diagnosticEntity.getDoctorCode());
            if (!diagDoctorYbinfo.isSuccess()) {
                log.info("\u67e5\u8be2\u5f00\u8bca\u65ad\u533b\u751f\u533b\u4fdd\u4ee3\u7801\u5931\u8d25!");
                return BaseResponse.error((String)"\u67e5\u8be2\u5f00\u8bca\u65ad\u533b\u751f\u533b\u4fdd\u4ee3\u7801\u5931\u8d25");
            }
            this.diagDoctorInfo = (DoctorYbInfoEntrty)diagDoctorYbinfo.getData();
            diseinfo.setDiagDrName(this.diagDoctorInfo.getDoctorYbName());
            diseinfo.setDiagDrNo(this.diagDoctorInfo.getDoctorYbCode());
            diseinfo.setDiagTime(DateUtils.formatDateTime((Date)diagnosticEntity.getxUpdateTime()));
            diseinfos.add(diseinfo);
        }
        log.info("========\u7ec4\u88c5\u7684\u8bca\u65ad\u4fe1\u606fdiseinfos\uff1a{}", (Object)JSONObject.toJSONString(diseinfos));
        uploadChkRequest.setDiseinfo(diseinfos);
        String chKUrl = this.medicalUrl + "prescription/uploadChkNew";
        log.info("==========\u7701\u4e2d\u5fc3\u7535\u5b50\u5904\u65b9\u9884\u6821\u9a8c\uff1aurl\uff1a{},data\uff1a{}", (Object)chKUrl, (Object)JSONObject.toJSONString((Object)uploadChkRequest));
        String chkResult = HttpUtil.post((String)chKUrl, (String)JSONObject.toJSONString((Object)uploadChkRequest), (int)450000);
        log.info("==========\u7701\u4e2d\u5fc3\u7535\u5b50\u5904\u65b9\u9884\u6821\u9a8c\u8fd4\u56de\u7ed3\u679c\uff1adata\uff1a{}", (Object)chkResult);
        ResultResponse chkUploadResponse = (ResultResponse)JSONObject.parseObject((String)chkResult, (Type)new /* Unavailable Anonymous Inner Class!! */.getType(), (Feature[])new Feature[0]);
        if (!chkUploadResponse.isSuccess() || Objects.isNull(chkUploadResponse.getBody())) {
            log.error("\u63a8\u9001\u5904\u65b9\u9884\u6821\u9a8c\u5931\u8d25" + JSONObject.toJSONString((Object)chkUploadResponse));
            return BaseResponse.error((String)("\u63a8\u9001\u5904\u65b9\u9884\u6821\u9a8c\u5931\u8d25!" + chkUploadResponse.getMessage()));
        }
        this.redisUtil.set("medicareChk_" + drugMainEntity.getxId(), (Object)JSONObject.toJSONString((Object)chkUploadResponse.getBody()));
        return BaseResponse.success((Object)chkUploadResponse.getBody());
    }

    private MedicalInfoCompareEntity getMedicalCompare(String productCode) {
        return this.medicalInfoCompareMapper.getDrugMedicalInfo(productCode);
    }

    private void handleDiagnostic(String[] icdCodes, String[] icdNames) {
        log.info("\u67e5\u8be2icd\u5bf9\u7167" + icdCodes + icdNames);
        for (int i = 0; i < icdCodes.length; ++i) {
            Icd10CompareEntity medicalIcd = this.icd10CompareMapper.getByIcdCode(icdCodes[i]);
            log.info("\u67e5\u8be2icd\u5bf9\u7167:{}" + JSONObject.toJSONString((Object)medicalIcd));
            icdCodes[i] = medicalIcd.getMedicalCode();
            icdNames[i] = medicalIcd.getMedicalName();
        }
    }

    private BaseResponse<FixmedinsSignResponse> fixmedinsSign(MedicalMoveMainVO medicalMoveMainVO, String uploadPrescStr) throws Exception {
        DrugMainEntityPushVO drugMainEntity = medicalMoveMainVO.getDrugMainEntity();
        String pdfAddress = this.genLocalPrescPdf(medicalMoveMainVO);
        FixmedinsSignRequest fixmedinsSignRequest = new FixmedinsSignRequest();
        fixmedinsSignRequest.setFixmedinsCode(FIXMEDINS_CODE);
        fixmedinsSignRequest.setOriginalValue(com.ebaiyihui.framework.utils.Base64Util.encodeBase64((byte[])uploadPrescStr.getBytes(StandardCharsets.UTF_8)));
        byte[] imageFromNetByUrl = Base64Util.getImageFromNetByUrl((String)pdfAddress);
        String prescriptionBase64 = Base64Util.encodeBase64((byte[])imageFromNetByUrl);
        fixmedinsSignRequest.setOriginalRxFile(prescriptionBase64);
        fixmedinsSignRequest.setOrganCode(drugMainEntity.getPresOrgan());
        String signUrl = this.medicalUrl + "prescription/fixmedinsSignNew";
        log.info("==========\u7701\u4e2d\u5fc3\u7535\u5b50\u5904\u65b9\u7535\u5b50\u5904\u65b9\u533b\u4fdd\u7b7e\u540d\uff1aurl\uff1a{},data\uff1a{}", (Object)signUrl, (Object)JSONObject.toJSONString((Object)fixmedinsSignRequest));
        String signResult = HttpUtil.post((String)signUrl, (String)JSONObject.toJSONString((Object)fixmedinsSignRequest), (int)450000);
        log.info("==========\u7701\u4e2d\u5fc3\u7535\u5b50\u5904\u65b9\u7535\u5b50\u5904\u65b9\u533b\u4fdd\u7b7e\u540d\u8fd4\u56de\u7ed3\u679c\uff1adata\uff1a{}", (Object)signResult);
        ResultResponse fixmedinSignResponse = (ResultResponse)JSONObject.parseObject((String)signResult, (Type)new /* Unavailable Anonymous Inner Class!! */.getType(), (Feature[])new Feature[0]);
        if (!fixmedinSignResponse.isSuccess() || Objects.isNull(fixmedinSignResponse)) {
            return BaseResponse.error((String)"\u7535\u5b50\u5904\u65b9\u7535\u5b50\u5904\u65b9\u533b\u4fdd\u7b7e\u540d\u5931\u8d25\uff01");
        }
        this.redisUtil.set("medicareSign_" + drugMainEntity.getxId(), (Object)JSONObject.toJSONString((Object)fixmedinSignResponse));
        ((FixmedinsSignResponse)fixmedinSignResponse.getBody()).setPdfAddress(pdfAddress);
        return BaseResponse.success((Object)fixmedinSignResponse.getBody());
    }

    public void pushPrescription(MedicalMoveMainVO medicalMoveMainVO) {
        log.info("=======\u8fdb\u5165\u7701\u4e2d\u5fc3\u63a8\u9001\u5904\u65b9data\uff1a{}", (Object)JSONObject.toJSONString((Object)medicalMoveMainVO));
        try {
            Thread.sleep(20000L);
            DrugMainEntityPushVO drugMainEntity = medicalMoveMainVO.getDrugMainEntity();
            MosOutpatientMainRelEntityPushVO mosOutpatientMainRelEntity = medicalMoveMainVO.getMosOutpatientMainRelEntity();
            DrugExtendEntityPushVO drugExtendEntity = medicalMoveMainVO.getDrugExtendEntity();
            BaseResponse uploadChkResponseBaseResponse = this.chkUpload(medicalMoveMainVO);
            if (!uploadChkResponseBaseResponse.isSuccess() || Objects.isNull(uploadChkResponseBaseResponse.getData())) {
                log.info("\u4e0a\u4f20\u5904\u65b9\u9884\u6821\u9a8c\u5931\u8d25\uff1a{}", (Object)JSONObject.toJSONString((Object)uploadChkResponseBaseResponse));
                return;
            }
            UploadChkResponse uploadChkResult = (UploadChkResponse)uploadChkResponseBaseResponse.getData();
            com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.request.FileUpldRequest fileUpldRequest = new com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.request.FileUpldRequest();
            fileUpldRequest.setRxTraceCode(uploadChkResult.getRxTraceCode());
            fileUpldRequest.setHiRxno(uploadChkResult.getHiRxno());
            fileUpldRequest.setMdtrtId(this.ybMoveUploadInfo.getMdtrtId());
            fileUpldRequest.setPatnName(drugMainEntity.getPatientName());
            fileUpldRequest.setPsnCertType(this.ybUserInfoEntrty.getPsn_cert_type());
            fileUpldRequest.setCertno(this.ybUserInfoEntrty.getCertno());
            fileUpldRequest.setFixmedinsName(FIXMEDINS_NAME);
            fileUpldRequest.setFixmedinsCode(FIXMEDINS_CODE);
            fileUpldRequest.setDrCode(this.doctorYbinfoData.getDoctorYbCode());
            fileUpldRequest.setPrscDrName(this.doctorYbinfoData.getDoctorYbName());
            log.info("\u67e5\u8be2\u836f\u5e08\u4fe1\u606f\uff1adoctroId\uff1a{}", (Object)drugExtendEntity.getVerifierCode());
            BaseDTO baseDTO = new BaseDTO();
            baseDTO.setId(Integer.valueOf(drugExtendEntity.getVerifierCode()));
            BaseResponse doctorInfo = this.doctorApiClient.queryDoctorUserInfo(baseDTO);
            log.info("\u67e5\u8be2\u533b\u751f\u670d\u52a1\u627e\u5230\u5bf9\u5e94\u836f\u5e08\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)doctorInfo));
            if (!doctorInfo.isSuccess() || null == doctorInfo || doctorInfo.getData() == null) {
                return;
            }
            fileUpldRequest.setPharDeptCode("23");
            fileUpldRequest.setPharDeptName("\u836f\u5b66\u90e8");
            VerifierCompareEntity verifierCompare = this.verifierCompareMapper.getByCerdNo(((DoctorUserInfoVO)doctorInfo.getData()).getCredNo());
            fileUpldRequest.setPharProfttlName(verifierCompare.getTitle());
            fileUpldRequest.setPharProfttlCodg(ProfessionEnum.getDesc((String)verifierCompare.getTitle()));
            fileUpldRequest.setPharCode(verifierCompare.getVerifierCode());
            fileUpldRequest.setPharName(verifierCompare.getVerifierName());
            fileUpldRequest.setPharChkTime(DateUtils.formatDateTime((Date)drugExtendEntity.getVerifyTime()));
            String uploadPrescStr = JSONObject.toJSONString((Object)fileUpldRequest);
            BaseResponse fixmedinsSign = this.fixmedinsSign(medicalMoveMainVO, uploadPrescStr);
            if (!fixmedinsSign.isSuccess() || Objects.isNull(fixmedinsSign.getData())) {
                log.info("==\u533b\u4fdd\u7535\u5b50\u5904\u65b9\u7b7e\u540d\u5931\u8d25=====");
                return;
            }
            FixmedinsSignResponse fixmedinsSignData = (FixmedinsSignResponse)fixmedinsSign.getData();
            fileUpldRequest.setRxFile(fixmedinsSignData.getRxFile());
            fileUpldRequest.setSignDigest(fixmedinsSignData.getSignDigest());
            String ulpUrl = this.medicalUrl + "prescription/fileUpldNew";
            log.info("==========\u7701\u4e2d\u5fc3\u7535\u5b50\u5904\u65b9\u7535\u5b50\u5904\u65b9\u4e0a\u4f20\uff1aurl\uff1a{},data\uff1a{}", (Object)ulpUrl, (Object)JSONObject.toJSONString((Object)fileUpldRequest));
            String ulpResult = HttpUtil.post((String)ulpUrl, (String)JSONObject.toJSONString((Object)fileUpldRequest), (int)450000);
            log.info("==========\u7701\u4e2d\u5fc3\u7535\u5b50\u5904\u65b9\u7535\u5b50\u5904\u65b9\u4e0a\u4f20\u8fd4\u56de\u7ed3\u679c\uff1adata\uff1a{}", (Object)ulpResult);
            ResultResponse upldResponseResponse = (ResultResponse)JSONObject.parseObject((String)ulpResult, (Type)new /* Unavailable Anonymous Inner Class!! */.getType(), (Feature[])new Feature[0]);
            if (!upldResponseResponse.isSuccess() || Objects.isNull(upldResponseResponse)) {
                log.info("=====\u7701\u4e2d\u5fc3\u7535\u5b50\u5904\u65b9\u7535\u5b50\u5904\u65b9\u4e0a\u4f20\u5931\u8d25\uff01=====");
                return;
            }
            this.redisUtil.set("medicareUpload_" + drugMainEntity.getxId(), (Object)JSONObject.toJSONString((Object)upldResponseResponse));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("===\u5904\u65b9\u4e0a\u4f20\u5931\u8d25===" + e.getMessage());
        }
    }

    public String subZeroAndDot(String s) {
        if (s.indexOf(".") > 0) {
            s = s.replaceAll("0+?$", "");
            s = s.replaceAll("[.]$", "");
            return s;
        }
        return s;
    }

    public BaseResponse pushPrescriptionNew(MedicalMoveMainVO medicalMoveMainVO) {
        log.info("=======\u8fdb\u5165\u7701\u4e2d\u5fc3\u63a8\u9001\u5904\u65b9data\uff1a{}", (Object)JSONObject.toJSONString((Object)medicalMoveMainVO));
        try {
            DrugMainEntityPushVO drugMainEntity = medicalMoveMainVO.getDrugMainEntity();
            DrugExtendEntityPushVO drugExtendEntity = medicalMoveMainVO.getDrugExtendEntity();
            BaseResponse uploadChkResponseBaseResponse = this.chkUpload(medicalMoveMainVO);
            if (!uploadChkResponseBaseResponse.isSuccess() || Objects.isNull(uploadChkResponseBaseResponse.getData())) {
                log.info("\u4e0a\u4f20\u5904\u65b9\u9884\u6821\u9a8c\u5931\u8d25\uff1a{}", (Object)JSONObject.toJSONString((Object)uploadChkResponseBaseResponse));
                return uploadChkResponseBaseResponse;
            }
            UploadChkResponse uploadChkResult = (UploadChkResponse)uploadChkResponseBaseResponse.getData();
            com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.request.FileUpldRequest fileUpldRequest = new com.ebaiyihui.medicalcloud.pojo.vo.medicarePrescription.request.FileUpldRequest();
            fileUpldRequest.setRxTraceCode(uploadChkResult.getRxTraceCode());
            fileUpldRequest.setHiRxno(uploadChkResult.getHiRxno());
            fileUpldRequest.setMdtrtId(this.ybMoveUploadInfo.getMdtrtId());
            fileUpldRequest.setPatnName(drugMainEntity.getPatientName());
            fileUpldRequest.setPsnCertType(this.ybUserInfoEntrty.getPsn_cert_type());
            fileUpldRequest.setCertno(this.ybUserInfoEntrty.getCertno());
            fileUpldRequest.setFixmedinsName(FIXMEDINS_NAME);
            fileUpldRequest.setFixmedinsCode(FIXMEDINS_CODE);
            fileUpldRequest.setDrCode(this.doctorYbinfoData.getDoctorYbCode());
            fileUpldRequest.setPrscDrName(this.doctorYbinfoData.getDoctorYbName());
            log.info("\u67e5\u8be2\u836f\u5e08\u4fe1\u606f\uff1adoctroId\uff1a{}", (Object)drugExtendEntity.getVerifierCode());
            BaseDTO baseDTO = new BaseDTO();
            baseDTO.setId(Integer.valueOf(drugExtendEntity.getVerifierCode()));
            BaseResponse doctorInfo = this.doctorApiClient.queryDoctorUserInfo(baseDTO);
            log.info("\u67e5\u8be2\u533b\u751f\u670d\u52a1\u627e\u5230\u5bf9\u5e94\u836f\u5e08\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)doctorInfo));
            if (!doctorInfo.isSuccess() || null == doctorInfo || doctorInfo.getData() == null) {
                return BaseResponse.error((String)"\u67e5\u8be2\u836f\u5e08\u4fe1\u606f\u5931\u8d25\uff01");
            }
            fileUpldRequest.setPharDeptCode("23");
            fileUpldRequest.setPharDeptName("\u836f\u5b66\u90e8");
            VerifierCompareEntity verifierCompare = this.verifierCompareMapper.getByCerdNo(((DoctorUserInfoVO)doctorInfo.getData()).getCredNo());
            if (Objects.isNull(verifierCompare)) {
                return BaseResponse.error((String)"\u67e5\u8be2\u5ba1\u65b9\u836f\u5e08\u8d2f\u6807\u7801\u4e3a\u7a7a\uff01");
            }
            fileUpldRequest.setPharProfttlName(verifierCompare.getTitle());
            fileUpldRequest.setPharProfttlCodg(ProfessionEnum.getDesc((String)verifierCompare.getTitle()));
            fileUpldRequest.setPharCode(verifierCompare.getVerifierCode());
            fileUpldRequest.setPharName(verifierCompare.getVerifierName());
            fileUpldRequest.setPharChkTime(DateUtils.formatDateTime((Date)drugExtendEntity.getVerifyTime()));
            String uploadPrescStr = JSONObject.toJSONString((Object)fileUpldRequest);
            BaseResponse fixmedinsSign = this.fixmedinsSign(medicalMoveMainVO, uploadPrescStr);
            if (!fixmedinsSign.isSuccess() || Objects.isNull(fixmedinsSign.getData())) {
                log.info("==\u533b\u4fdd\u7535\u5b50\u5904\u65b9\u7b7e\u540d\u5931\u8d25=====");
                return fixmedinsSign;
            }
            FixmedinsSignResponse fixmedinsSignData = (FixmedinsSignResponse)fixmedinsSign.getData();
            fileUpldRequest.setRxFile(fixmedinsSignData.getRxFile());
            fileUpldRequest.setSignDigest(fixmedinsSignData.getSignDigest());
            String ulpUrl = this.medicalUrl + "prescription/fileUpldNew";
            log.info("==========\u7701\u4e2d\u5fc3\u7535\u5b50\u5904\u65b9\u7535\u5b50\u5904\u65b9\u4e0a\u4f20\uff1aurl\uff1a{},data\uff1a{}", (Object)ulpUrl, (Object)JSONObject.toJSONString((Object)fileUpldRequest));
            String ulpResult = HttpUtil.post((String)ulpUrl, (String)JSONObject.toJSONString((Object)fileUpldRequest), (int)450000);
            log.info("==========\u7701\u4e2d\u5fc3\u7535\u5b50\u5904\u65b9\u7535\u5b50\u5904\u65b9\u4e0a\u4f20\u8fd4\u56de\u7ed3\u679c\uff1adata\uff1a{}", (Object)ulpResult);
            ResultResponse upldResponseResponse = (ResultResponse)JSONObject.parseObject((String)ulpResult, (Type)new /* Unavailable Anonymous Inner Class!! */.getType(), (Feature[])new Feature[0]);
            if (!upldResponseResponse.isSuccess() || Objects.isNull(upldResponseResponse)) {
                log.info("=====\u7701\u4e2d\u5fc3\u7535\u5b50\u5904\u65b9\u7535\u5b50\u5904\u65b9\u4e0a\u4f20\u5931\u8d25\uff01=====");
                return BaseResponse.error((String)upldResponseResponse.getMessage());
            }
            this.redisUtil.set("medicareUpload_" + drugMainEntity.getxId(), (Object)JSONObject.toJSONString((Object)upldResponseResponse), 604800L);
            MedicalPresInfoEntity medicalPresInfoEntity = new MedicalPresInfoEntity();
            medicalPresInfoEntity.setxId(UUIDUtils.getUUID());
            medicalPresInfoEntity.setHiRxno(((UploadChkResponse)uploadChkResponseBaseResponse.getData()).getHiRxno());
            medicalPresInfoEntity.setRxTraceCode(((UploadChkResponse)uploadChkResponseBaseResponse.getData()).getRxTraceCode());
            medicalPresInfoEntity.setRxStasCodg(((FileUpldResponse)upldResponseResponse.getBody()).getRxStasCodg());
            medicalPresInfoEntity.setRxStasName(((FileUpldResponse)upldResponseResponse.getBody()).getRxStasName());
            medicalPresInfoEntity.setMainId(drugMainEntity.getxId());
            medicalPresInfoEntity.setRxFile(((FixmedinsSignResponse)fixmedinsSign.getData()).getRxFile());
            medicalPresInfoEntity.setSignCertDn(((FixmedinsSignResponse)fixmedinsSign.getData()).getSignCertDn());
            medicalPresInfoEntity.setSignCertSn(((FixmedinsSignResponse)fixmedinsSign.getData()).getSignCertSn());
            medicalPresInfoEntity.setSignDigest(((FixmedinsSignResponse)fixmedinsSign.getData()).getSignDigest());
            medicalPresInfoEntity.setPdfAddress(((FixmedinsSignResponse)fixmedinsSign.getData()).getPdfAddress());
            medicalPresInfoEntity.setDrCode(this.doctorYbinfoData.getDoctorYbCode());
            medicalPresInfoEntity.setDrName(this.doctorYbinfoData.getDoctorYbName());
            DoctorEntityInfoVO doctorVo = this.doctorRetmoteManage.getDoctorDetailById(Long.valueOf(Long.parseLong(drugMainEntity.getPresDoctorId())));
            medicalPresInfoEntity.setDrCertno(doctorVo.getCredNo());
            this.medicalPresInfoMapper.insertMedicalPresInfo(medicalPresInfoEntity);
            return BaseResponse.success((Object)"\u4e0a\u4f20\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("===\u5904\u65b9\u4e0a\u4f20\u5931\u8d25===" + e.getMessage());
            return BaseResponse.error((String)("\u4e0a\u4f20\u5931\u8d25" + e.getMessage()));
        }
    }

    public String revokeHisPresc(PrescriptionReqVO prescriptionReqVO) {
        String chkInfo = this.redisUtil.get("medicareChk_" + prescriptionReqVO.getPresNo()).toString();
        UploadChkResponse uploadChkResponse = (UploadChkResponse)JSONObject.parseObject((String)chkInfo, UploadChkResponse.class);
        String undoUrl = this.medicalUrl + "prescription/rxUndoNew";
        RxUodoRequest rxUodoRequest = new RxUodoRequest();
        if (Objects.isNull(prescriptionReqVO.getHiRxno()) || "".equals(prescriptionReqVO.getHiRxno())) {
            rxUodoRequest.setHiRxno(uploadChkResponse.getHiRxno());
        } else {
            rxUodoRequest.setHiRxno(prescriptionReqVO.getHiRxno());
        }
        rxUodoRequest.setFixmedinsCode(prescriptionReqVO.getFixmedinsCode());
        rxUodoRequest.setUndoDrCertType(prescriptionReqVO.getUndoDrCertType());
        rxUodoRequest.setUndoDrCertno(prescriptionReqVO.getUndoDrCertno());
        rxUodoRequest.setUndoDrName(prescriptionReqVO.getUndoDrName());
        rxUodoRequest.setDrCode(prescriptionReqVO.getDrCode());
        rxUodoRequest.setUndoTime(DateUtils.getDate((String)"yyyy-MM-dd HH:mm:ss"));
        rxUodoRequest.setUndoRea(prescriptionReqVO.getUndoRea());
        log.info("==========\u7701\u4e2d\u5fc3\u7535\u5b50\u5904\u65b9\u64a4\u9500\uff1aurl\uff1a{},data\uff1a{}", (Object)undoUrl, (Object)JSONObject.toJSONString((Object)rxUodoRequest));
        String rxUndoResult = HttpUtil.post((String)undoUrl, (String)JSONObject.toJSONString((Object)rxUodoRequest), (int)450000);
        log.info("==========\u7701\u4e2d\u5fc3\u7535\u5b50\u5904\u65b9\u64a4\u9500\u8fd4\u56de\u7ed3\u679c\uff1adata\uff1a{}", (Object)rxUndoResult);
        ResultResponse rxUndoResponse = (ResultResponse)JSONObject.parseObject((String)rxUndoResult, (Type)new /* Unavailable Anonymous Inner Class!! */.getType(), (Feature[])new Feature[0]);
        if (rxUndoResponse.isSuccess() && "3".equals(((RxUndoResponse)rxUndoResponse.getBody()).getRxStasCodg())) {
            MedicalPresInfoEntity medicalPresInfoEntity = new MedicalPresInfoEntity();
            medicalPresInfoEntity.setHiRxno(((RxUndoResponse)rxUndoResponse.getBody()).getHiRxno());
            medicalPresInfoEntity.setRxStasCodg(((RxUndoResponse)rxUndoResponse.getBody()).getRxStasCodg());
            medicalPresInfoEntity.setRxStasName(((RxUndoResponse)rxUndoResponse.getBody()).getRxStasName());
            medicalPresInfoEntity.setMainId(prescriptionReqVO.getPresNo());
            this.medicalPresInfoMapper.updateMedicalPresInfo(medicalPresInfoEntity);
            PrescBaseResponse success = PrescBaseResponse.success();
            success.setPresNo(prescriptionReqVO.getPresNo());
            success.setHiRxno(((RxUndoResponse)rxUndoResponse.getBody()).getHiRxno());
            success.setRxStasCodg(((RxUndoResponse)rxUndoResponse.getBody()).getRxStasCodg());
            return XmlUtil.convertToXml((Object)success);
        }
        PrescBaseResponse error = PrescBaseResponse.error((String)rxUndoResponse.getMessage());
        return XmlUtil.convertToXml((Object)error);
    }

    public BaseResponse bmPushPrescriptionNew(PrescUploadDto prescUploadDto) {
        log.info("=======\u8fdb\u5165\u7701\u4e2d\u5fc3\u63a8\u9001\u5904\u65b9data\uff1a{}", (Object)JSONObject.toJSONString((Object)prescUploadDto));
        try {
            DrugMainEntity drugMainEntity = prescUploadDto.getDrugMainEntity();
            DrugExtendEntity drugExtendEntity = prescUploadDto.getDrugExtendEntity();
            YbMdtrtinfo ybMdtrtinfo = prescUploadDto.getYbMdtrtinfo();
            BaseResponse uploadChkResponseBaseResponse = this.bmChkUpload(prescUploadDto);
            if (!uploadChkResponseBaseResponse.isSuccess() || Objects.isNull(uploadChkResponseBaseResponse.getData())) {
                log.info("\u4e0a\u4f20\u5904\u65b9\u9884\u6821\u9a8c\u5931\u8d25\uff1a{}", (Object)JSONObject.toJSONString((Object)uploadChkResponseBaseResponse));
                return uploadChkResponseBaseResponse;
            }
            HospitalConfigEntity configEntity = this.hospitalConfigMapper.selectByAppcode(drugMainEntity.getPresOrgan());
            if (Objects.isNull(configEntity) || Objects.isNull(configEntity.getFixmedinsCode()) || Objects.isNull(configEntity.getFixmedinsName()) || Objects.isNull(configEntity.getHospitalId())) {
                log.info("\u533b\u9662\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a+appcode{}", (Object)JSON.toJSONString((Object)drugMainEntity.getPresOrgan()));
                return BaseResponse.error((String)(drugMainEntity.getPresOrgan() + "\u533b\u9662\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a"));
            }
            com.ebaiyihui.medicalcloud.pojo.yb.UploadChkResponse uploadChkResult = (com.ebaiyihui.medicalcloud.pojo.yb.UploadChkResponse)uploadChkResponseBaseResponse.getData();
            FileUpldRequest fileUpldRequest = new FileUpldRequest();
            fileUpldRequest.setRxTraceCode(uploadChkResult.getRxTraceCode());
            fileUpldRequest.setHiRxno(uploadChkResult.getHiRxno());
            fileUpldRequest.setMdtrtId(ybMdtrtinfo.getMdtrtId());
            fileUpldRequest.setPatnName(drugMainEntity.getPatientName());
            fileUpldRequest.setPsnCertType(ybMdtrtinfo.getPsnCertType());
            fileUpldRequest.setCertno(ybMdtrtinfo.getCertno());
            fileUpldRequest.setFixmedinsName(configEntity.getFixmedinsName());
            fileUpldRequest.setFixmedinsCode(configEntity.getFixmedinsCode());
            fileUpldRequest.setDrCode(ybMdtrtinfo.getDrCode());
            fileUpldRequest.setPrscDrName(ybMdtrtinfo.getDrName());
            log.info("\u67e5\u8be2\u836f\u5e08\u4fe1\u606f\uff1adoctroId\uff1a{}", (Object)drugExtendEntity.getVerifierCode());
            BaseDTO baseDTO = new BaseDTO();
            baseDTO.setId(Integer.valueOf(drugExtendEntity.getVerifierCode()));
            BaseResponse doctorInfo = this.doctorApiClient.queryDoctorUserInfo(baseDTO);
            log.info("\u67e5\u8be2\u533b\u751f\u670d\u52a1\u627e\u5230\u5bf9\u5e94\u836f\u5e08\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)doctorInfo));
            if (!doctorInfo.isSuccess() || null == doctorInfo || doctorInfo.getData() == null) {
                return BaseResponse.error((String)"\u67e5\u8be2\u836f\u5e08\u4fe1\u606f\u5931\u8d25\uff01");
            }
            fileUpldRequest.setPharDeptCode("0006");
            fileUpldRequest.setPharDeptName("\u836f\u5242\u79d1");
            VerifierCompareEntity verifierCompare = this.verifierCompareMapper.getByCerdNo(((DoctorUserInfoVO)doctorInfo.getData()).getCredNo());
            if (Objects.isNull(verifierCompare) && Objects.isNull(verifierCompare = this.verifierCompareMapper.getByNameAndHospitalName(((DoctorUserInfoVO)doctorInfo.getData()).getName(), drugMainEntity.getPresOrganName()))) {
                return BaseResponse.error((String)"\u67e5\u8be2\u5ba1\u65b9\u836f\u5e08\u8d2f\u6807\u7801\u4e3a\u7a7a\uff01");
            }
            fileUpldRequest.setPharProfttlName(verifierCompare.getTitle());
            fileUpldRequest.setPharProfttlCodg(verifierCompare.getTitleCode());
            fileUpldRequest.setPharCode(verifierCompare.getVerifierCode());
            fileUpldRequest.setPharName(verifierCompare.getVerifierName());
            fileUpldRequest.setPharCertType("01");
            fileUpldRequest.setPharCertno(verifierCompare.getCerdNo());
            fileUpldRequest.setPharPracCertNo(verifierCompare.getApprovalProfessional());
            fileUpldRequest.setPharChkTime(DateUtils.formatDateTime((Date)drugExtendEntity.getVerifyTime()));
            String uploadPrescStr = JSONObject.toJSONString((Object)fileUpldRequest);
            BaseResponse fixmedinsSign = this.bmFixmedinsSign(prescUploadDto, uploadPrescStr);
            if (!fixmedinsSign.isSuccess() || Objects.isNull(fixmedinsSign.getData())) {
                log.info("==\u533b\u4fdd\u7535\u5b50\u5904\u65b9\u7b7e\u540d\u5931\u8d25=====");
                return fixmedinsSign;
            }
            com.ebaiyihui.medicalcloud.pojo.yb.FixmedinsSignResponse fixmedinsSignData = (com.ebaiyihui.medicalcloud.pojo.yb.FixmedinsSignResponse)fixmedinsSign.getData();
            fileUpldRequest.setRxFile(fixmedinsSignData.getRxFile());
            fileUpldRequest.setSignDigest(fixmedinsSignData.getSignDigest());
            fileUpldRequest.setOrganCode(configEntity.getHospitalId());
            String ulpUrl = this.medicalUrl + "prescription/fileUpldNew";
            log.info("==========\u7701\u4e2d\u5fc3\u7535\u5b50\u5904\u65b9\u7535\u5b50\u5904\u65b9\u4e0a\u4f20\uff1aurl\uff1a{},data\uff1a{}", (Object)ulpUrl, (Object)JSONObject.toJSONString((Object)fileUpldRequest));
            String ulpResult = HttpUtil.post((String)ulpUrl, (String)JSONObject.toJSONString((Object)fileUpldRequest), (int)450000);
            log.info("==========\u7701\u4e2d\u5fc3\u7535\u5b50\u5904\u65b9\u7535\u5b50\u5904\u65b9\u4e0a\u4f20\u8fd4\u56de\u7ed3\u679c\uff1adata\uff1a{}", (Object)ulpResult);
            ResultResponse upldResponseResponse = (ResultResponse)JSONObject.parseObject((String)ulpResult, (Type)new /* Unavailable Anonymous Inner Class!! */.getType(), (Feature[])new Feature[0]);
            if (!upldResponseResponse.isSuccess() || Objects.isNull(upldResponseResponse)) {
                log.info("=====\u7701\u4e2d\u5fc3\u7535\u5b50\u5904\u65b9\u7535\u5b50\u5904\u65b9\u4e0a\u4f20\u5931\u8d25\uff01=====");
                return BaseResponse.error((String)upldResponseResponse.getMessage());
            }
            MedicalPresInfoEntity medicalPresInfoEntity = new MedicalPresInfoEntity();
            medicalPresInfoEntity.setxId(UUIDUtils.getUUID());
            medicalPresInfoEntity.setHiRxno(((com.ebaiyihui.medicalcloud.pojo.yb.UploadChkResponse)uploadChkResponseBaseResponse.getData()).getHiRxno());
            medicalPresInfoEntity.setRxTraceCode(((com.ebaiyihui.medicalcloud.pojo.yb.UploadChkResponse)uploadChkResponseBaseResponse.getData()).getRxTraceCode());
            medicalPresInfoEntity.setRxStasCodg(((com.ebaiyihui.medicalcloud.pojo.yb.FileUpldResponse)upldResponseResponse.getBody()).getRxStasCodg());
            medicalPresInfoEntity.setRxStasName(((com.ebaiyihui.medicalcloud.pojo.yb.FileUpldResponse)upldResponseResponse.getBody()).getRxStasName());
            medicalPresInfoEntity.setMainId(drugMainEntity.getxId());
            medicalPresInfoEntity.setRxFile(((com.ebaiyihui.medicalcloud.pojo.yb.FixmedinsSignResponse)fixmedinsSign.getData()).getRxFile());
            medicalPresInfoEntity.setSignCertDn(((com.ebaiyihui.medicalcloud.pojo.yb.FixmedinsSignResponse)fixmedinsSign.getData()).getSignCertDn());
            medicalPresInfoEntity.setSignCertSn(((com.ebaiyihui.medicalcloud.pojo.yb.FixmedinsSignResponse)fixmedinsSign.getData()).getSignCertSn());
            medicalPresInfoEntity.setSignDigest(((com.ebaiyihui.medicalcloud.pojo.yb.FixmedinsSignResponse)fixmedinsSign.getData()).getSignDigest());
            medicalPresInfoEntity.setPdfAddress(((com.ebaiyihui.medicalcloud.pojo.yb.FixmedinsSignResponse)fixmedinsSign.getData()).getPdfAddress());
            medicalPresInfoEntity.setDrCode(ybMdtrtinfo.getDrCode());
            medicalPresInfoEntity.setDrName(ybMdtrtinfo.getDrName());
            DoctorEntityInfoVO doctorVo = this.doctorRetmoteManage.getDoctorDetailById(Long.valueOf(Long.parseLong(drugMainEntity.getPresDoctorId())));
            medicalPresInfoEntity.setDrCertno(doctorVo.getCredNo());
            this.medicalPresInfoMapper.insertMedicalPresInfo(medicalPresInfoEntity);
            return BaseResponse.success((Object)"\u4e0a\u4f20\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("===\u5904\u65b9\u4e0a\u4f20\u5931\u8d25===" + e);
            return BaseResponse.error((String)"\u4e0a\u4f20\u5931\u8d25,\u5e93\u5b58\u4e0d\u8db3\uff01");
        }
    }

    private BaseResponse<com.ebaiyihui.medicalcloud.pojo.yb.UploadChkResponse> bmChkUpload(PrescUploadDto prescUploadDto) throws Exception {
        log.info("=======\u8fdb\u5165\u7535\u5b50\u5904\u65b9\u9884\u6821\u9a8c\u63a5\u53e3==========");
        com.ebaiyihui.medicalcloud.pojo.yb.UploadChkRequest uploadChkRequest = new com.ebaiyihui.medicalcloud.pojo.yb.UploadChkRequest();
        DrugMainEntity drugMainEntity = prescUploadDto.getDrugMainEntity();
        DrugPrescriptionEntity drugPrescriptionEntity = prescUploadDto.getDrugPrescriptionEntity();
        List drugDetailList = prescUploadDto.getDrugDetailList();
        DiagnosticEntity diagnosticEntity = prescUploadDto.getDiagnosticEntity();
        MosOutpatientMainRelEntity mosOutpatientMainRelEntity = prescUploadDto.getMosOutpatientMainRelEntity();
        uploadChkRequest.setOrganCode(drugMainEntity.getOrganId());
        uploadChkRequest.setMdtrtCertType("02");
        uploadChkRequest.setMdtrtCertNo(drugMainEntity.getPatientCredNo());
        uploadChkRequest.setBizTypeCode("01");
        uploadChkRequest.setHospRxno(drugPrescriptionEntity.getxId());
        if (drugMainEntity.getPresType() == 4) {
            uploadChkRequest.setRxTypeCode("1");
        } else {
            uploadChkRequest.setRxTypeCode("2");
        }
        uploadChkRequest.setPrscTime(DateUtils.formatDateTime((Date)drugMainEntity.getxCreateTime()));
        uploadChkRequest.setRxDrugCnt(String.valueOf(drugDetailList.size()));
        uploadChkRequest.setValiDays("3");
        uploadChkRequest.setValiEndTime(DateUtils.formatDateTime((Date)DateUtils.addDay((Date)drugMainEntity.getxCreateTime(), (int)3)));
        uploadChkRequest.setRxCotnFlag("0");
        uploadChkRequest.setRxExraAttrCode("02");
        HospitalConfigEntity configEntity = this.hospitalConfigMapper.selectByAppcode(drugMainEntity.getPresOrgan());
        if (Objects.isNull(configEntity) || Objects.isNull(configEntity.getFixmedinsCode()) || Objects.isNull(configEntity.getFixmedinsName()) || Objects.isNull(configEntity.getHospitalId())) {
            log.info("\u533b\u9662\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0cappcode{}", (Object)JSON.toJSONString((Object)drugMainEntity.getPresOrgan()));
            return BaseResponse.error((String)(drugMainEntity.getPresOrgan() + "\u533b\u9662\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a"));
        }
        ArrayList<Rxdrugdetail> list = new ArrayList<Rxdrugdetail>();
        for (int i = 0; i < drugDetailList.size(); ++i) {
            DrugDetailEntity drug = (DrugDetailEntity)drugDetailList.get(i);
            Rxdrugdetail rxdrugdetail = new Rxdrugdetail();
            DrugItemEntity drugItem = this.drugItemMapper.queryByCommonCode(drug.getDrugCommonCode(), configEntity.getAppCode());
            log.info("\u67e5\u8be2\u7684\u836f\u54c1\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)drugItem));
            DrugCompareEntity drugCompareEntity = this.drugCompareMapper.getByCommonCode(drug.getDrugCommonCode(), configEntity.getAppCode());
            if (!Objects.isNull(drugCompareEntity)) {
                rxdrugdetail.setMednTypeCode(drugCompareEntity.getMednTypeCode());
                rxdrugdetail.setMednTypeName(drugCompareEntity.getMednTypeName());
            } else {
                rxdrugdetail.setMednTypeCode("9999");
                rxdrugdetail.setMednTypeName("\u5176\u5b83\u5316\u5b66\u836f");
            }
            rxdrugdetail.setMedListCodg(drugItem.getProductCode());
            rxdrugdetail.setFixmedinsHilistId(String.valueOf(drugItem.getxRowid()));
            if (drugMainEntity.getPresType() == 3) {
                rxdrugdetail.setRxItemTypeCode("13");
                rxdrugdetail.setMedcWayCodg(String.valueOf(drugMainEntity.getUseMethod()));
                rxdrugdetail.setMedcWayDscr(drugMainEntity.getDecoction());
                rxdrugdetail.setMedcBegntime(DateUtils.formatDateTime((Date)drugMainEntity.getxUpdateTime()));
                rxdrugdetail.setMedcEndtime(DateUtils.formatDateTime((Date)DateUtils.addDay((Date)drugMainEntity.getxUpdateTime(), (int)((DrugDetailEntity)drugDetailList.get(0)).getDuration())));
                rxdrugdetail.setMedcDays(String.valueOf(drugPrescriptionEntity.getAgeNum()));
                rxdrugdetail.setTcmdrugTypeCode("3");
            } else {
                rxdrugdetail.setRxItemTypeCode("11");
                rxdrugdetail.setMedcWayCodg(drug.getUsageId());
                rxdrugdetail.setMedcWayDscr(drug.getUsageDesc());
                rxdrugdetail.setMedcBegntime(DateUtils.formatDateTime((Date)drugMainEntity.getxUpdateTime()));
                rxdrugdetail.setMedcEndtime(DateUtils.formatDateTime((Date)DateUtils.addDay((Date)drugMainEntity.getxUpdateTime(), (int)drug.getDuration())));
                rxdrugdetail.setMedcDays(drug.getDuration().toString());
                rxdrugdetail.setSinDoscnt(this.subZeroAndDot(drug.getSingleDose().toString()));
                rxdrugdetail.setSinDosunt(drugItem.getMinBillPackingUnitName());
                rxdrugdetail.setUsedFrquCodg(drug.getFrequencyId());
                rxdrugdetail.setUsedFrquName(drug.getFrequencyDesc());
            }
            rxdrugdetail.setDrugCnt(this.subZeroAndDot(drug.getAmount().toString()));
            rxdrugdetail.setDrugDosunt(drugItem.getWholePackingUnitName());
            rxdrugdetail.setDrugCnt(this.subZeroAndDot(drug.getMinBillPackingNum().multiply(drug.getAmount()).toString()));
            rxdrugdetail.setDrugDosunt(drug.getMinBillPackingUnit());
            rxdrugdetail.setDrugTotlcnt(this.subZeroAndDot(drug.getAmount().toString()));
            rxdrugdetail.setDrugTotlcntEmp(drugItem.getStockPackingUnitName());
            rxdrugdetail.setDrugSpec(drugItem.getDrugSpec().replace("\u00d7", "*"));
            rxdrugdetail.setDrugDosform(drugItem.getDosageForm());
            rxdrugdetail.setDrugGenname(drugItem.getCommonName());
            rxdrugdetail.setHospApprFlag("0");
            list.add(rxdrugdetail);
        }
        log.info("====\u7ec4\u88c5\u7684\u5904\u65b9\u4fe1\u606fData\uff1a{}", (Object)JSONObject.toJSONString(list));
        uploadChkRequest.setRxdrugdetail(list);
        Mdtrtinfo mdtrtinfo = new Mdtrtinfo();
        YbMdtrtinfo ybMdtrtinfo = prescUploadDto.getYbMdtrtinfo();
        mdtrtinfo.setFixmedinsName(configEntity.getFixmedinsName());
        mdtrtinfo.setFixmedinsCode(configEntity.getFixmedinsCode());
        mdtrtinfo.setMedType("11");
        mdtrtinfo.setIptOtpNo(mosOutpatientMainRelEntity.getOrderId());
        mdtrtinfo.setMdtrtId(ybMdtrtinfo.getMdtrtId());
        mdtrtinfo.setHiFeesetlType("1");
        mdtrtinfo.setHiFeesetlName("\u672c\u5730\u533b\u7597\u4fdd\u9669\u7ed3\u7b97");
        uploadChkRequest.setAuthNo("");
        if (drugMainEntity.getPresType() == 3) {
            if ("\u6c34\u714e\u670d".equals(drugMainEntity.getDecoction())) {
                uploadChkRequest.setRxUsedWayCodg("1");
                uploadChkRequest.setRxUsedWayName("\u53e3\u670d");
            } else {
                uploadChkRequest.setRxUsedWayCodg("9");
                uploadChkRequest.setRxUsedWayName("\u5176\u4ed6\u7ed9\u836f\u9014\u5f84");
            }
            uploadChkRequest.setRxDoscnt(String.valueOf(((DrugDetailEntity)drugDetailList.get(0)).getDuration()));
            uploadChkRequest.setRxDosunt("1");
            uploadChkRequest.setRxFrquCodg(String.valueOf(drugMainEntity.getUseMethod()));
            uploadChkRequest.setRxFrquName(((DrugDetailEntity)drugDetailList.get(0)).getFrequencyDesc());
            uploadChkRequest.setRxDrordDscr("");
        }
        mdtrtinfo.setPsnNo(ybMdtrtinfo.getPsnNo());
        mdtrtinfo.setPatnName(ybMdtrtinfo.getPatnName());
        mdtrtinfo.setPsnCertType(ybMdtrtinfo.getPsnCertType());
        mdtrtinfo.setCertno(ybMdtrtinfo.getCertno());
        mdtrtinfo.setPatnAge(String.valueOf(drugMainEntity.getPatientAge()));
        mdtrtinfo.setGend(ybMdtrtinfo.getGend());
        Long deptIdL = Long.valueOf(drugMainEntity.getPresDeptCode());
        BaseResponse departmentDetail = this.departmentInfoApi.getDepartmentDetail(deptIdL);
        if (!departmentDetail.isSuccess() || Objects.isNull(departmentDetail.getData())) {
            log.info("\u67e5\u8be2\u5f00\u65b9\u79d1\u5ba4code\u5931\u8d25!");
            return BaseResponse.error((String)"\u67e5\u8be2\u5f00\u65b9\u79d1\u5ba4\u4fe1\u606f\u5931\u8d25!");
        }
        log.info("his\u79d1\u5ba4code:" + JSON.toJSONString((Object)departmentDetail));
        mdtrtinfo.setPrscDeptName(((DepartmentDetailVo)departmentDetail.getData()).getDeptName());
        mdtrtinfo.setPrscDeptCode(((DepartmentDetailVo)departmentDetail.getData()).getDeptCode());
        DoctorEntityInfoVO doctorVo = this.doctorRetmoteManage.getDoctorDetailById(Long.valueOf(Long.parseLong(drugMainEntity.getPresDoctorId())));
        log.info("=========\u67e5\u8be2\u533b\u751f\u4fe1\u606f\uff0c\u83b7\u53d6\u76f8\u5173\u533b\u751f\u804c\u79f0\u4fe1\u606fdata:{}", (Object)JSONObject.toJSONString((Object)doctorVo));
        mdtrtinfo.setDrProfttlCodg(ProfessionEnum.getDesc((String)doctorVo.getProfession()));
        mdtrtinfo.setDrProfttlName(doctorVo.getProfession());
        mdtrtinfo.setPrscDrCertType("01");
        mdtrtinfo.setPrscDrCertno(doctorVo.getCredNo());
        mdtrtinfo.setDrDeptCode(((DepartmentDetailVo)departmentDetail.getData()).getDeptCode());
        mdtrtinfo.setDrDeptName(((DepartmentDetailVo)departmentDetail.getData()).getDeptName());
        mdtrtinfo.setDrCode(ybMdtrtinfo.getDrCode());
        mdtrtinfo.setPrscDrName(ybMdtrtinfo.getDrName());
        mdtrtinfo.setCaty("A03.05");
        mdtrtinfo.setMdtrtTime(DateUtils.formatDateTime((Date)mosOutpatientMainRelEntity.getXCreateTime()));
        mdtrtinfo.setSpDiseFlag("0");
        log.info("=====\u7ec4\u88c5\u7684\u5c31\u8bca\u4fe1\u606fmdtrtinfos\uff1a{}", (Object)JSONObject.toJSONString((Object)mdtrtinfo));
        uploadChkRequest.setMdtrtinfo(mdtrtinfo);
        uploadChkRequest.setInsuPlcNo(ybMdtrtinfo.getInsuplcAdmdvs());
        String[] icdCodes = diagnosticEntity.getIcdCode().split(";");
        String[] icdNames = diagnosticEntity.getIcdName().split(";");
        this.handleDiagnostic(icdCodes, icdNames);
        mdtrtinfo.setMaindiagCode(icdCodes[0]);
        mdtrtinfo.setMaindiagName(icdNames[0]);
        ArrayList<Diseinfo> diseinfos = new ArrayList<Diseinfo>();
        for (int i = 0; i < icdCodes.length; ++i) {
            Diseinfo diseinfo = new Diseinfo();
            diseinfo.setDiagType("1");
            if (i == 0) {
                diseinfo.setMaindiagFlag("1");
            } else {
                diseinfo.setMaindiagFlag("0");
            }
            diseinfo.setDiagSrtNo(String.valueOf(i + 1));
            diseinfo.setDiagCode(icdCodes[i]);
            diseinfo.setDiagName(icdNames[i]);
            diseinfo.setDiagDept(((DepartmentDetailVo)departmentDetail.getData()).getDeptName());
            diseinfo.setDiagDeptCode(((DepartmentDetailVo)departmentDetail.getData()).getDeptCode());
            diseinfo.setDiagDrName(ybMdtrtinfo.getDrName());
            diseinfo.setDiagDrNo(ybMdtrtinfo.getDrCode());
            diseinfo.setDiagTime(DateUtils.formatDateTime((Date)diagnosticEntity.getxUpdateTime()));
            diseinfos.add(diseinfo);
        }
        log.info("========\u7ec4\u88c5\u7684\u8bca\u65ad\u4fe1\u606fdiseinfos\uff1a{}", (Object)JSONObject.toJSONString(diseinfos));
        uploadChkRequest.setDiseinfo(diseinfos);
        String chKUrl = this.medicalUrl + "prescription/uploadChkNew";
        log.info("==========\u7701\u4e2d\u5fc3\u7535\u5b50\u5904\u65b9\u9884\u6821\u9a8c\uff1aurl\uff1a{},data\uff1a{}", (Object)chKUrl, (Object)JSONObject.toJSONString((Object)uploadChkRequest));
        String chkResult = HttpUtil.post((String)chKUrl, (String)JSONObject.toJSONString((Object)uploadChkRequest), (int)450000);
        log.info("==========\u7701\u4e2d\u5fc3\u7535\u5b50\u5904\u65b9\u9884\u6821\u9a8c\u8fd4\u56de\u7ed3\u679c\uff1adata\uff1a{}", (Object)chkResult);
        ResultResponse chkUploadResponse = (ResultResponse)JSONObject.parseObject((String)chkResult, (Type)new /* Unavailable Anonymous Inner Class!! */.getType(), (Feature[])new Feature[0]);
        if (!chkUploadResponse.isSuccess() || Objects.isNull(chkUploadResponse.getBody())) {
            log.error("\u63a8\u9001\u5904\u65b9\u9884\u6821\u9a8c\u5931\u8d25" + JSONObject.toJSONString((Object)chkUploadResponse));
            return BaseResponse.error((String)("\u63a8\u9001\u5904\u65b9\u9884\u6821\u9a8c\u5931\u8d25!" + chkUploadResponse.getMessage()));
        }
        this.redisUtil.set("medicareChk_" + drugMainEntity.getxId(), (Object)JSONObject.toJSONString((Object)chkUploadResponse.getBody()));
        return BaseResponse.success((Object)chkUploadResponse.getBody());
    }

    private BaseResponse<com.ebaiyihui.medicalcloud.pojo.yb.FixmedinsSignResponse> bmFixmedinsSign(PrescUploadDto prescUploadDto, String uploadPrescStr) throws Exception {
        DrugMainEntity drugMainEntity = prescUploadDto.getDrugMainEntity();
        String pdfAddress = prescUploadDto.getDrugPrescriptionEntity().getOssUrl();
        HospitalConfigEntity configEntity = this.hospitalConfigMapper.selectByAppcode(drugMainEntity.getPresOrgan());
        if (Objects.isNull(configEntity) || Objects.isNull(configEntity.getFixmedinsCode()) || Objects.isNull(configEntity.getFixmedinsName()) || Objects.isNull(configEntity.getHospitalId())) {
            log.info("\u533b\u9662\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a-appcode{}", (Object)JSON.toJSONString((Object)drugMainEntity.getPresOrgan()));
            return BaseResponse.error((String)(drugMainEntity.getPresOrgan() + "\u533b\u9662\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a"));
        }
        com.ebaiyihui.medicalcloud.pojo.yb.FixmedinsSignRequest fixmedinsSignRequest = new com.ebaiyihui.medicalcloud.pojo.yb.FixmedinsSignRequest();
        fixmedinsSignRequest.setFixmedinsCode(configEntity.getFixmedinsCode());
        fixmedinsSignRequest.setOriginalValue(com.ebaiyihui.framework.utils.Base64Util.encodeBase64((byte[])uploadPrescStr.getBytes(StandardCharsets.UTF_8)));
        byte[] imageFromNetByUrl = Base64Util.getImageFromNetByUrl((String)pdfAddress);
        String prescriptionBase64 = Base64Util.encodeBase64((byte[])imageFromNetByUrl);
        fixmedinsSignRequest.setOriginalRxFile(prescriptionBase64);
        fixmedinsSignRequest.setOrganCode(drugMainEntity.getOrganId());
        String signUrl = this.medicalUrl + "prescription/fixmedinsSignNew";
        log.info("==========\u7701\u4e2d\u5fc3\u7535\u5b50\u5904\u65b9\u7535\u5b50\u5904\u65b9\u533b\u4fdd\u7b7e\u540d\uff1aurl\uff1a{},data\uff1a{}", (Object)signUrl, (Object)JSONObject.toJSONString((Object)fixmedinsSignRequest));
        String signResult = HttpUtil.post((String)signUrl, (String)JSONObject.toJSONString((Object)fixmedinsSignRequest), (int)450000);
        log.info("==========\u7701\u4e2d\u5fc3\u7535\u5b50\u5904\u65b9\u7535\u5b50\u5904\u65b9\u533b\u4fdd\u7b7e\u540d\u8fd4\u56de\u7ed3\u679c\uff1adata\uff1a{}", (Object)signResult);
        ResultResponse fixmedinSignResponse = (ResultResponse)JSONObject.parseObject((String)signResult, (Type)new /* Unavailable Anonymous Inner Class!! */.getType(), (Feature[])new Feature[0]);
        if (!fixmedinSignResponse.isSuccess() || Objects.isNull(fixmedinSignResponse)) {
            return BaseResponse.error((String)"\u7535\u5b50\u5904\u65b9\u7535\u5b50\u5904\u65b9\u533b\u4fdd\u7b7e\u540d\u5931\u8d25\uff01");
        }
        this.redisUtil.set("medicareSign_" + drugMainEntity.getxId(), (Object)JSONObject.toJSONString((Object)fixmedinSignResponse));
        ((com.ebaiyihui.medicalcloud.pojo.yb.FixmedinsSignResponse)fixmedinSignResponse.getBody()).setPdfAddress(pdfAddress);
        return BaseResponse.success((Object)fixmedinSignResponse.getBody());
    }
}

