/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.medicalcloud.entity.DoctorYbInfoEntrty;
import com.ebaiyihui.medicalcloud.pojo.vo.push.DiagnosticEntityPushVO;
import com.ebaiyihui.medicalcloud.pojo.vo.push.DrugDetailEntityPushVO;
import com.ebaiyihui.medicalcloud.pojo.vo.push.DrugExtendEntityPushVO;
import com.ebaiyihui.medicalcloud.pojo.vo.push.DrugMainEntityPushVO;
import com.ebaiyihui.medicalcloud.pojo.vo.push.DrugPrescriptionEntityPushVO;
import com.ebaiyihui.medicalcloud.pojo.vo.push.MedicalMoveMainVO;
import com.ebaiyihui.medicalcloud.service.MedicarePrescriptionService;
import com.ebaiyihui.medicalcloud.service.RscRecipePushService;
import com.ebaiyihui.medicalcloud.utils.ApiSignUtil;
import com.ebaiyihui.medicalcloud.utils.HttpUtils;
import com.ebaiyihui.medicalcloud.utils.RedisUtil;
import com.ebaiyihui.medicalcloud.utils.StringUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class RscRecipePushServiceImpl
implements RscRecipePushService {
    private static final Logger log = LoggerFactory.getLogger(RscRecipePushServiceImpl.class);
    @Value(value="${RSC.rscUrl}")
    private String rscUrl;
    @Value(value="${RSC.orgId}")
    private String orgId;
    @Value(value="${RSC.nonce}")
    private String nonce;
    @Autowired
    private MedicarePrescriptionService medicarePrescriptionService;
    private static final String accessTokenKey = "RSC_ACCESS_TOKEN_";
    private static char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static String DEFAULT_CHARSET = "UTF-8";
    @Autowired
    private RedisUtil redisUtil;

    public void pushToRsc(MedicalMoveMainVO medicalMoveMainVO) throws Exception {
        String appId = "753i48w7l3h9wq1p6j";
        String appKey = "b2d9pa776j0kmr1lstm44p6r";
        String appSecret = "9xh25vh776l18lquvex5w9152b92xbxi";
        log.info("====\u533b\u7597\u673a\u6784 HIS \u7cfb\u7edf\u4e0e\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\uff08RSC\uff09-\u63a8\u9001\u5904\u65b9\u5f00\u59cb");
        String rscAccessToken = this.getRscAccessToken(appId, appKey, appSecret);
        if (StringUtils.isEmpty((String)rscAccessToken)) {
            log.info("\u83b7\u53d6token\u5931\u8d25");
            return;
        }
        String recipePostResponse = this.recipePost(medicalMoveMainVO, rscAccessToken, appSecret);
        if (StringUtils.isEmpty((String)recipePostResponse)) {
            log.info("===\u5411rsc\u63d0\u4ea4\u7535\u5b50\u5904\u65b9\u5931\u8d25\uff0c\u54cd\u5e94\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        String resultCode = JSON.parseObject((String)recipePostResponse).getString("Result_Code");
        if (StringUtils.isEmpty((String)resultCode) || !"0".equals(resultCode)) {
            log.info("===\u5411rsc\u63d0\u4ea4\u7535\u5b50\u5904\u65b9\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)JSON.parseObject((String)recipePostResponse).getString("Result_Msg"));
            return;
        }
        String recipeInspectionResponse = this.recipeInspection(medicalMoveMainVO, rscAccessToken, JSON.parseObject((String)recipePostResponse).getString("Recipe_ID"), appSecret);
        if (StringUtils.isEmpty((String)recipeInspectionResponse)) {
            log.info("===\u5411rsc\u63d0\u4ea4\u5ba1\u65b9\u7ed3\u679c\u5931\u8d25\uff0c\u54cd\u5e94\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        String recipeResultCode = JSON.parseObject((String)recipeInspectionResponse).getString("Result_Code");
        if (StringUtils.isEmpty((String)recipeResultCode) || !"0".equals(recipeResultCode)) {
            log.info("===\u5411rsc\u63d0\u4ea4\u5ba1\u65b9\u7ed3\u679c\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)JSON.parseObject((String)recipeInspectionResponse).getString("Result_Msg"));
            return;
        }
    }

    public String getAccessToken(String appId, String appKey, String appSecret) throws Exception {
        log.info("====\u533b\u7597\u673a\u6784 HIS \u7cfb\u7edf\u4e0e\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\uff08RSC\uff09-\u83b7\u53d6AccessToken");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("App_ID", (Object)appId);
        jsonObject.put("Time_Stamp", (Object)System.currentTimeMillis());
        jsonObject.put("App_Key", (Object)appKey);
        String genSignData = RscRecipePushServiceImpl.genSignData((JSONObject)jsonObject);
        jsonObject.put("Nonce", (Object)this.nonce);
        String signData = genSignData + "&Nonce=" + this.nonce + "&Key=" + appSecret;
        log.info("\u7b7e\u540d\u4e32\uff1a{}", (Object)signData);
        String sign = RscRecipePushServiceImpl.MD5en((String)signData);
        jsonObject.put("Sign", (Object)sign);
        String url = this.rscUrl + "rsc/api/access_auth";
        log.info("=====\u533b\u7597\u673a\u6784 HIS \u7cfb\u7edf\u4e0e\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\uff08RSC\uff09\u83b7\u53d6AccessToken---\u53c2\u6570\u7ec4\u88c5\u5b8c\u6210-\u53c2\u6570\uff1a{},url:{}", (Object)jsonObject, (Object)url);
        String post = HttpUtils.post((String)url, (String)JSON.toJSONString((Object)jsonObject));
        log.info("=====\u533b\u7597\u673a\u6784 HIS \u7cfb\u7edf\u4e0e\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\uff08RSC\uff09\u83b7\u53d6AccessToken\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)post);
        return post;
    }

    public String refresshAccessToken(String accessToken, String appSecret) throws Exception {
        log.info("====\u533b\u7597\u673a\u6784 HIS \u7cfb\u7edf\u4e0e\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\uff08RSC\uff09-\u66f4\u65b0AccessToken");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Access_Token", (Object)accessToken);
        jsonObject.put("Time_Stamp", (Object)System.currentTimeMillis());
        String genSignData = RscRecipePushServiceImpl.genSignData((JSONObject)jsonObject);
        jsonObject.put("Nonce", (Object)this.nonce);
        String signData = genSignData + "&Nonce=" + this.nonce + "&Key=" + appSecret;
        log.info("\u7b7e\u540d\u4e32\uff1a{}", (Object)signData);
        String sign = RscRecipePushServiceImpl.MD5en((String)signData);
        jsonObject.put("Sign", (Object)sign);
        String url = this.rscUrl + "rsc/api/auth_refresh";
        log.info("=====\u533b\u7597\u673a\u6784 HIS \u7cfb\u7edf\u4e0e\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\uff08RSC\uff09\u66f4\u65b0AccessToken---\u53c2\u6570\u7ec4\u88c5\u5b8c\u6210-\u53c2\u6570\uff1a{},url:{}", (Object)jsonObject, (Object)url);
        String post = HttpUtils.post((String)url, (String)JSON.toJSONString((Object)jsonObject));
        log.info("=====\u533b\u7597\u673a\u6784 HIS \u7cfb\u7edf\u4e0e\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\uff08RSC\uff09\u66f4\u65b0AccessToken\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)post);
        return post;
    }

    public String recipePost(MedicalMoveMainVO medicalMoveMainVO, String accessToken, String appSecret) throws Exception {
        log.info("====\u533b\u7597\u673a\u6784HIS\u7cfb\u7edf\u4e0e\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\uff08RSC\uff09-\u63d0\u4ea4\u7535\u5b50\u5904\u65b9");
        DrugPrescriptionEntityPushVO drugPrescriptionEntity = medicalMoveMainVO.getDrugPrescriptionEntity();
        List drugDetailEntity = medicalMoveMainVO.getDrugDetailEntity();
        DrugMainEntityPushVO drugMainEntity = medicalMoveMainVO.getDrugMainEntity();
        DiagnosticEntityPushVO diagnosticEntity = medicalMoveMainVO.getDiagnosticEntity();
        JSONObject data = new JSONObject();
        JSONArray recipeGroups = new JSONArray();
        if (CollectionUtils.isNotEmpty((Collection)drugDetailEntity)) {
            for (DrugDetailEntityPushVO drugDetailEntityPushVO : drugDetailEntity) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("Art_ID", drugDetailEntityPushVO.getDrugId());
                jsonObject.put("Medicine_Desc", drugDetailEntityPushVO.getDrugName() + "/" + drugDetailEntityPushVO.getDrugSpec() + "/" + drugDetailEntityPushVO.getMinBillPackingUnit());
                jsonObject.put("Dose_Unit", drugDetailEntityPushVO.getMeasureUnit());
                BigDecimal singleDose = drugDetailEntityPushVO.getSingleDose();
                jsonObject.put("Meal_Doses", singleDose);
                jsonObject.put("Cell_Unit", drugDetailEntityPushVO.getMinBillPackingUnit());
                BigDecimal measureNum = drugDetailEntityPushVO.getMeasureNum();
                BigDecimal divide = singleDose.divide(measureNum, 2, RoundingMode.HALF_UP);
                jsonObject.put("Meal_Cells", divide);
                jsonObject.put("Meal_Desc", drugDetailEntityPushVO.getUsageDesc());
                jsonObject.put("Unit", drugDetailEntityPushVO.getWholePackingUnit());
                jsonObject.put("Unit_Type", 2);
                jsonObject.put("Total", drugDetailEntityPushVO.getAmount());
                JSONArray groupArts = new JSONArray();
                groupArts.add((Object)jsonObject);
                JSONObject recipeGroup = new JSONObject();
                recipeGroup.put("Group_No", drugDetailEntity.indexOf(drugDetailEntityPushVO) + 1);
                recipeGroup.put("Freq_Code", drugDetailEntityPushVO.getUsageId());
                recipeGroup.put("Route_Desc", drugDetailEntityPushVO.getUsageDesc());
                recipeGroup.put("Sig_Desc", drugDetailEntityPushVO.getFrequencyDesc());
                recipeGroup.put("Period_Desc", drugDetailEntityPushVO.getDuration() + "\u65e5");
                recipeGroup.put("Period_Cycles", drugDetailEntityPushVO.getDuration());
                recipeGroup.put("Group_Arts", groupArts);
                recipeGroups.add((Object)recipeGroup);
            }
        }
        JSONObject recipeData = new JSONObject();
        if (Objects.nonNull(drugPrescriptionEntity) && Objects.nonNull(drugMainEntity)) {
            Date date = drugPrescriptionEntity.getxCreateTime();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String recipeDate = simpleDateFormat.format(date);
            log.info("\u5904\u65b9\u5f00\u5177\u65f6\u95f4\uff1a{}", (Object)recipeDate);
            recipeData.put("Recipe_Date", StringUtils.substringBefore((String)recipeDate, (String)" "));
            recipeData.put("Recipe_Time", StringUtils.substringAfter((String)recipeDate, (String)" "));
            recipeData.put("Visit_ID", drugPrescriptionEntity.getAdmId());
            recipeData.put("Dept_Code", drugMainEntity.getPresHisDeptCode());
            recipeData.put("Dept_Name", drugMainEntity.getPresDeptName());
            recipeData.put("Patient_Name", drugMainEntity.getPatientName());
            recipeData.put("Age", IdCardUtil.getAgeByIdCard((String)drugMainEntity.getPatientCredNo()));
            recipeData.put("Gender", 1 == drugMainEntity.getPatientGender() ? "\u7537" : "\u5973");
            recipeData.put("Contact_Tel", drugMainEntity.getPatientPhone());
            recipeData.put("Diag_Name", diagnosticEntity.getIcdName());
            recipeData.put("Times", drugMainEntity.getDrugAmount());
            recipeData.put("Recipe_Groups", recipeGroups);
            recipeData.put("Notice", drugMainEntity.getRemark());
            BaseResponse doctorYbinfo = this.medicarePrescriptionService.getDoctorYbinfo(medicalMoveMainVO.getDrugMainEntity().getPresDoctorId());
            if (doctorYbinfo.isSuccess() && !Objects.isNull(doctorYbinfo.getData())) {
                recipeData.put("Clinician_Code", ((DoctorYbInfoEntrty)doctorYbinfo.getData()).getDoctorYbCode());
            } else {
                recipeData.put("Clinician_Code", drugMainEntity.getPresDoctorId());
            }
            recipeData.put("Clinician_Name", drugMainEntity.getPresDoctorName());
            recipeData.put("DSignature", drugMainEntity.getDoctorSign());
            recipeData.put("Recipe_Type", "1");
            recipeData.put("Cert_Type_ID", "01");
            recipeData.put("Cert_IDNO", drugMainEntity.getPatientCredNo());
        }
        data.put("Access_Token", accessToken);
        data.put("Org_ID", this.orgId);
        data.put("Rx_No", drugPrescriptionEntity.getMainId());
        data.put("Recipe_Data", recipeData);
        log.info("==========\u533b\u7597\u673a\u6784HIS\u7cfb\u7edf\u4e0e\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\uff08RSC\uff09-\u63d0\u4ea4\u7535\u5b50\u5904\u65b9\u53c2\u6570\u7ec4\u88c5\u5b8c\u6210\uff1a{}", (Object)data);
        String signStr = ApiSignUtil.signStr((Map)data, (String)this.nonce, (String)appSecret);
        data.put("Recipe_Data", new JSONObject((Map)recipeData));
        log.info("\u7b7e\u540d\u4e32\uff1a{}", (Object)signStr);
        data.put("Sign", signStr);
        String url = this.rscUrl + "rsc/api/recipe_post";
        log.info("=====\u533b\u7597\u673a\u6784 HIS \u7cfb\u7edf\u4e0e\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\uff08RSC\uff09\u63d0\u4ea4\u7535\u5b50\u5904\u65b9---\u53c2\u6570\u7ec4\u88c5\u5b8c\u6210-\u53c2\u6570\uff1a{},url:{}", (Object)data, (Object)url);
        log.info("\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)data));
        String post = HttpUtils.post((String)url, (String)JSON.toJSONString((Object)data));
        log.info("x\uff1a{}", (Object)post);
        return post;
    }

    public String recipeInspection(MedicalMoveMainVO medicalMoveMainVO, String accessToken, String RecipeId, String appSecret) throws Exception {
        log.info("====\u533b\u7597\u673a\u6784HIS\u7cfb\u7edf\u4e0e\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\uff08RSC\uff09-\u63d0\u4ea4\u5ba1\u65b9\u7ed3\u679c");
        DrugExtendEntityPushVO drugExtendEntity = medicalMoveMainVO.getDrugExtendEntity();
        JSONObject data = new JSONObject();
        if (Objects.nonNull(drugExtendEntity)) {
            data.put("Access_Token", (Object)accessToken);
            data.put("Recipe_ID", (Object)RecipeId);
            BaseResponse doctorYbinfo = this.medicarePrescriptionService.getDoctorYbinfo(drugExtendEntity.getVerifierCode());
            if (doctorYbinfo.isSuccess() && !Objects.isNull(doctorYbinfo.getData())) {
                data.put("Pharmacist_Code", (Object)((DoctorYbInfoEntrty)doctorYbinfo.getData()).getDoctorYbCode());
            } else {
                data.put("Pharmacist_Code", (Object)"1");
            }
            data.put("Status", (Object)drugExtendEntity.getAuditStatus());
            data.put("Notes", (Object)(Objects.isNull(drugExtendEntity.getVerifyRemark()) ? "" : drugExtendEntity.getVerifyRemark()));
            data.put("DSignature", (Object)drugExtendEntity.getVerifySign());
            log.info("==========\u533b\u7597\u673a\u6784HIS\u7cfb\u7edf\u4e0e\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\uff08RSC\uff09-\u63d0\u4ea4\u5ba1\u65b9\u7ed3\u679c\u53c2\u6570\u7ec4\u88c5\u5b8c\u6210\uff1a{}", (Object)data);
            String genSignData = RscRecipePushServiceImpl.genSignData((JSONObject)data);
            String signData = genSignData + "&Nonce=" + this.nonce + "&Key=" + appSecret;
            log.info("\u7b7e\u540d\u4e32\uff1a{}", (Object)signData);
            String sign = RscRecipePushServiceImpl.MD5en((String)signData);
            data.put("Sign", (Object)sign);
            String url = this.rscUrl + "rsc/api/recipe_inspection";
            log.info("=====\u533b\u7597\u673a\u6784 HIS \u7cfb\u7edf\u4e0e\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\uff08RSC\uff09\u63d0\u4ea4\u5ba1\u65b9\u7ed3\u679c---\u53c2\u6570\u7ec4\u88c5\u5b8c\u6210-\u53c2\u6570\uff1a{},url:{}", (Object)data, (Object)url);
            String post = HttpUtils.post((String)url, (String)JSON.toJSONString((Object)data));
            log.info("=====\u533b\u7597\u673a\u6784 HIS \u7cfb\u7edf\u4e0e\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\uff08RSC\uff09\u63d0\u4ea4\u5ba1\u65b9\u7ed3\u679c\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)post);
            return post;
        }
        return null;
    }

    public String getRscAccessToken(String appId, String appKey, String appSecret) throws Exception {
        Object accessTokenObject = this.redisUtil.get("RSC_ACCESS_TOKEN_" + appId);
        String accessToken = null;
        if (Objects.isNull(accessTokenObject)) {
            String response = this.getAccessToken(appId, appKey, appSecret);
            if (StringUtils.isEmpty((String)response)) {
                log.info("----\u7533\u8bf7rsc\u7cfb\u7edfAccess_Token\u5931\u8d25");
                return null;
            }
            JSONObject responseData = JSON.parseObject((String)response);
            String resultCode = responseData.getString("Result_Code");
            if (StringUtils.isEmpty((String)resultCode) || !"0".equals(resultCode)) {
                log.info("\u7533\u8bf7rsc\u7cfb\u7edfAccess_Token\u5931\u8d25----");
                log.info("\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)responseData.getString("Result_Msg"));
                return null;
            }
            accessToken = responseData.get((Object)"Access_Token").toString();
            String expiry = responseData.get((Object)"Expiry").toString();
            log.info("-======rsc\u7cfbaccessToken:{},\u5230\u671f\u65f6\u95f4\u6233expiry:{}", (Object)accessToken, (Object)expiry);
            long millis = System.currentTimeMillis();
            long time = Long.parseLong(expiry) - millis;
            this.redisUtil.set("RSC_ACCESS_TOKEN_" + appId, (Object)accessToken, time / 1000L + 300L);
        } else {
            accessToken = accessTokenObject.toString();
            long expire = this.redisUtil.getExpire("RSC_ACCESS_TOKEN_" + appId);
            log.info("\u5f53\u524drsc\u7cfb\u7edftoken\uff1a{},ttl:{}", (Object)accessToken, (Object)expire);
            if (expire < 600L) {
                String response = this.refresshAccessToken(accessToken, appSecret);
                if (StringUtils.isEmpty((String)response)) {
                    log.info("====\u66f4\u65b0rsc\u7cfb\u7edfAccess_Token\u5931\u8d25");
                    return accessToken;
                }
                JSONObject responseData = JSON.parseObject((String)response);
                String resultCode = responseData.getString("Result_Code");
                if (StringUtils.isEmpty((String)resultCode) || !"0".equals(resultCode)) {
                    log.info("\u66f4\u65b0rsc\u7cfb\u7edfAccess_Token\u5931\u8d25====");
                    log.info("\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)responseData.getString("Result_Msg"));
                    log.info("\u91cd\u65b0\u83b7\u53d6rsc\u7cfb\u7edfAccess_Token");
                    String tokenResponse = this.getAccessToken(appId, appKey, appSecret);
                    if (StringUtils.isEmpty((String)response)) {
                        log.info("\u7533\u8bf7rsc\u7cfb\u7edfAccess_Token\u5931\u8d25!!!!");
                        return accessToken;
                    }
                    JSONObject resp = JSON.parseObject((String)tokenResponse);
                    String code = resp.getString("Result_Code");
                    if (StringUtils.isEmpty((String)code) || !"0".equals(code)) {
                        log.info("\u7533\u8bf7rsc\u7cfb\u7edfAccess_Token\u5931\u8d25!!!---===");
                        log.info("\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)resp.getString("Result_Msg"));
                        return accessToken;
                    }
                    accessToken = resp.get((Object)"Access_Token").toString();
                    String expiry = resp.get((Object)"Expiry").toString();
                    long millis = System.currentTimeMillis();
                    long time = Long.parseLong(expiry) - millis;
                    this.redisUtil.set("RSC_ACCESS_TOKEN_" + appId, (Object)accessToken, time / 1000L + 300L);
                    return accessToken;
                }
                accessToken = responseData.get((Object)"Access_Token").toString();
                String expiry = responseData.get((Object)"Expiry").toString();
                long millis = System.currentTimeMillis();
                long time = Long.parseLong(expiry) - millis;
                this.redisUtil.set("RSC_ACCESS_TOKEN_" + appId, (Object)accessToken, time / 1000L + 300L);
                return accessToken;
            }
        }
        return accessToken;
    }

    public String getRscSign(Map<String, Object> data, String appSecret) {
        return ApiSignUtil.signStr(data, (String)this.nonce, (String)appSecret);
    }

    public static String genSignData(JSONObject jsonObject) {
        StringBuffer content = new StringBuffer();
        ArrayList keys = new ArrayList(jsonObject.keySet());
        Collections.sort(keys, String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < keys.size(); ++i) {
            String value;
            String key = (String)keys.get(i);
            if ("sign".equals(key) || StringUtil.isBlank((String)(value = jsonObject.getString(key)))) continue;
            content.append((i == 0 ? "" : "&") + key + "=" + value);
        }
        String signSrc = content.toString();
        if (signSrc.startsWith("&")) {
            signSrc = signSrc.replaceFirst("&", "");
        }
        return signSrc;
    }

    public static String sortData(JSONObject jsonObject) {
        StringBuffer content = new StringBuffer();
        ArrayList keys = new ArrayList(jsonObject.keySet());
        Collections.sort(keys, String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < keys.size(); ++i) {
            String value;
            String key = (String)keys.get(i);
            if ("sign".equals(key) || StringUtil.isBlank((String)(value = jsonObject.getString(key)))) continue;
            content.append((i == 0 ? "" : ",") + key + "=" + value);
        }
        String signSrc = content.toString();
        if (signSrc.startsWith("&")) {
            signSrc = signSrc.replaceFirst("&", "");
        }
        return signSrc;
    }

    public static String MD5en(String str) {
        if (str == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(str.getBytes());
            return RscRecipePushServiceImpl.getFormattedText((byte[])messageDigest.digest()).toUpperCase();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getFormattedText(byte[] bytes) {
        int len = bytes.length;
        StringBuilder buf = new StringBuilder(len * 2);
        for (int j = 0; j < len; ++j) {
            buf.append(HEX_DIGITS[bytes[j] >> 4 & 0xF]);
            buf.append(HEX_DIGITS[bytes[j] & 0xF]);
        }
        return buf.toString();
    }

    public static Map<String, Object> sort(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        TreeMap<String, Object> result = new TreeMap<String, Object>((o1, o2) -> o1.compareTo((String)o2));
        result.putAll(map);
        return result;
    }
}

