/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.service.impl;

import com.ebaiyihui.medicalcloud.common.enums.PayBillOrderStatusEnum;
import com.ebaiyihui.medicalcloud.mapper.ServicePayBillMapper;
import com.ebaiyihui.medicalcloud.pojo.entity.ServicePayBillEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.bill.GetPayBillReqVo;
import com.ebaiyihui.medicalcloud.service.ServicePayBillService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServicePayBillServiceImpl
implements ServicePayBillService {
    @Autowired
    private ServicePayBillMapper servicePayBillMapper;

    public void save(ServicePayBillEntity servicePayBillEntity) {
        this.servicePayBillMapper.insertSelective(servicePayBillEntity);
    }

    public ServicePayBillEntity selectByOutTradeNoAndStatus(String outTradeNo, Integer status) {
        ServicePayBillEntity servicePayBillEntity = this.servicePayBillMapper.selectByOutTradeNoAndStatus(outTradeNo, status);
        return servicePayBillEntity;
    }

    public List<ServicePayBillEntity> selectByOutTradeNoAndStatusList(String orderSeq, Integer status) {
        return this.servicePayBillMapper.selectByOutTradeNoAndStatusList(orderSeq, status);
    }

    public List<ServicePayBillEntity> getPayBill(GetPayBillReqVo getPayBillReqVo) {
        List servicePayBillEntities = this.servicePayBillMapper.selectPayBill(getPayBillReqVo);
        List<ServicePayBillEntity> billEntityList = servicePayBillEntities.stream().filter(str -> str.getStatus().equals(PayBillOrderStatusEnum.PAID.getValue()) || str.getStatus().equals(PayBillOrderStatusEnum.REFUNDED.getValue())).collect(Collectors.toList());
        return billEntityList;
    }

    public void update(ServicePayBillEntity servicePayBillEntity) {
        this.servicePayBillMapper.updateByPrimaryKeySelective(servicePayBillEntity);
    }
}

