/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.mercury.client.handle;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.mercury.client.config.SpringBeanFactory;
import com.ebaiyihui.mercury.client.heart.HeartbeatClient;
import com.ebaiyihui.mercury.client.model.CustomProtocol;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.CharsetUtil;
import java.net.InetAddress;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoClientHandle
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final Logger log = LoggerFactory.getLogger(EchoClientHandle.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(EchoClientHandle.class);

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        IdleStateEvent idleStateEvent;
        if (evt instanceof IdleStateEvent && (idleStateEvent = (IdleStateEvent)evt).state() == IdleState.WRITER_IDLE) {
            log.info("\u5411\u670d\u52a1\u7684\u53d1\u9001\u6d88\u606f\uff1a channel Id->{} send time -> {}", (Object)ctx.channel().id(), (Object)new Date());
            CustomProtocol heartBeat = SpringBeanFactory.getBean("heartBeat", CustomProtocol.class);
            InetAddress address = InetAddress.getLocalHost();
            heartBeat.setContent(address.getHostAddress());
            ctx.writeAndFlush((Object)heartBeat);
        }
        super.userEventTriggered(ctx, evt);
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf byteBuf) throws Exception {
        String result = byteBuf.toString(CharsetUtil.UTF_8);
        CustomProtocol customProtocol = (CustomProtocol)JSON.parseObject((String)result, CustomProtocol.class);
        LOGGER.info("\u5ba2\u6237\u7aef\u6536\u5230\u6d88\u606f={}", (Object)customProtocol.toString());
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        log.error("The {} client is inactive, try to connect server after 10s", (Object)ctx.channel().id());
        Thread.sleep(5000L);
        HeartbeatClient heartbeatClient = SpringBeanFactory.getBean(HeartbeatClient.class);
        heartbeatClient.start();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error("\u8fde\u63a5\u51fa\u73b0\u5f02\u5e38" + cause.getLocalizedMessage());
        cause.getStackTrace();
    }
}

