/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.aspect;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.utils.IPUtils;
import com.ebaiyihui.server.annotation.PreventDuplication;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DigestUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class PreventDuplicationAspect {
    private static final Logger log = LoggerFactory.getLogger(PreventDuplicationAspect.class);
    @Autowired
    private RedisTemplate redisTemplate;
    @Value(value="${spring.application.name}")
    private String applicationName;
    private static final String PREVENT_DUPLICATION_PREFIX = "PREVENT_DUPLICATION_PREFIX:";

    @Pointcut(value="@annotation(com.ebaiyihui.server.annotation.PreventDuplication)")
    public void preventDuplication() {
    }

    @Around(value="preventDuplication()")
    public Object before(ProceedingJoinPoint joinPoint) throws Throwable {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        Assert.notNull((Object)request, (String)"request cannot be null.");
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        PreventDuplication annotation = method.getAnnotation(PreventDuplication.class);
        String name = method.getName();
        String ipAddress = IPUtils.getIpAddress((HttpServletRequest)request);
        String redisKey = PREVENT_DUPLICATION_PREFIX.concat(this.applicationName).concat(":").concat(name).concat(":").concat(ipAddress).concat(":").concat(this.getMethodSign(method, joinPoint.getArgs()));
        String redisValue = redisKey.concat(":").concat(annotation.value()).concat(":").concat("submit duplication");
        log.info("redisKey : {} ", (Object)redisKey);
        log.info("redisValue : {} ", (Object)redisValue);
        if (!this.redisTemplate.hasKey((Object)redisKey).booleanValue()) {
            this.redisTemplate.opsForValue().set((Object)redisKey, (Object)redisValue, annotation.expireSeconds(), TimeUnit.SECONDS);
            try {
                return joinPoint.proceed();
            }
            catch (Throwable throwable) {
                this.redisTemplate.delete((Object)redisKey);
                throw new RuntimeException(throwable);
            }
        }
        log.info("\u8868\u5355\u91cd\u590d\u63d0\u4ea4\uff1a {} ", (Object)redisKey);
        throw new RuntimeException("\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
    }

    private String getMethodSign(Method method, Object ... args) {
        StringBuilder sb = new StringBuilder(method.toString());
        for (Object arg : args) {
            sb.append(this.toString(arg));
        }
        return DigestUtils.sha1DigestAsHex((String)sb.toString());
    }

    private String toString(Object arg) {
        if (Objects.isNull(arg)) {
            return "null";
        }
        if (arg instanceof Number) {
            return arg.toString();
        }
        return JSONObject.toJSONString((Object)arg);
    }
}

