/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.ebaiyihui.common.pojo.vo.VercodeRespVo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.RandomUtil;
import com.ebaiyihui.framework.utils.VerifyCodeUtil;
import com.ebaiyihui.server.service.ICommonService;
import com.ebaiyihui.server.util.RedisUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import sun.misc.BASE64Encoder;

@Service
public class CommonServiceImpl
implements ICommonService {
    private static final Logger log = LoggerFactory.getLogger(CommonServiceImpl.class);
    @Autowired
    RedisUtil redisUtil;

    public BaseResponse<VercodeRespVo> getVerCode(int width, int height) {
        if (width == 0 || height == 0) {
            width = 100;
            height = 40;
        }
        VerifyCodeUtil vc = new VerifyCodeUtil();
        if (height != 0 && width != 0) {
            vc.setHeight(height);
            vc.setWidth(width);
        }
        BufferedImage image = vc.getImage();
        String text = vc.getText();
        String random = RandomUtil.getRandom();
        this.redisUtil.set("vercode_" + random, (Object)text, 600L);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", baos);
        }
        catch (IOException e) {
            log.info("\u83b7\u53d6\u56fe\u6587\u9a8c\u8bc1\u7801 \u5f02\u5e38", (Object)e.getMessage());
            log.error("\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        byte[] bytes = baos.toByteArray();
        BASE64Encoder encoder = new BASE64Encoder();
        String png_base64 = encoder.encodeBuffer(bytes).trim();
        png_base64 = png_base64.replaceAll("\n", "").replaceAll("\r", "");
        VercodeRespVo vercodeRespVo = new VercodeRespVo();
        vercodeRespVo.setVercodeKey("vercode_" + random);
        vercodeRespVo.setVercodeValue(text);
        vercodeRespVo.setPng_base64("data:image/jpeg;base64," + png_base64);
        log.info("\u83b7\u53d6\u56fe\u6587\u9a8c\u8bc1\u7801 \u9a8c\u8bc1\u7801:" + text);
        return BaseResponse.success((Object)vercodeRespVo);
    }
}

