/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.pojo.entity;

import com.ebaiyihui.common.pojo.vo.AccountRegisterReqVO;
import com.ebaiyihui.common.pojo.vo.LoginWithMailReqVo;
import com.ebaiyihui.server.enums.AccountEnums;
import com.ebaiyihui.server.util.PasswordAndSalt;
import com.ebaiyihui.server.util.PasswordUtil;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class UcAccountEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer id;
    private Date createTime;
    private Date updateTime;
    private String accountId;
    private String userId;
    private String accountNo;
    private String accountPw;
    private String pwSalt;
    private Short userType;
    private Short accountType;
    private String appCode;
    private String lastLoginIp;
    private Date lastLoginTime;
    private String registerChannel;
    private Short status;
    private Short isActive;
    private String realName;
    private String loginName;
    private String relatedMobileNumber;
    private String language;

    public UcAccountEntity() {
    }

    public UcAccountEntity(AccountRegisterReqVO accountRegisterReqVO, String userId) {
        this.accountNo = accountRegisterReqVO.getAccountNo();
        if (AccountEnums.AccountTypeEnum.CELL_PHONE.getValue().equals(accountRegisterReqVO.getAccountType())) {
            this.relatedMobileNumber = this.accountNo;
        }
        if (StringUtils.isBlank((CharSequence)accountRegisterReqVO.getPwSalt())) {
            PasswordAndSalt passwordAndSalt = PasswordUtil.mix((String)accountRegisterReqVO.getPassword());
            this.accountPw = passwordAndSalt.getMixedPassword();
            this.pwSalt = passwordAndSalt.getSalt();
        } else {
            this.accountPw = accountRegisterReqVO.getPassword();
            this.pwSalt = accountRegisterReqVO.getPwSalt();
        }
        this.accountType = accountRegisterReqVO.getAccountType();
        this.appCode = accountRegisterReqVO.getAppCode();
        this.registerChannel = accountRegisterReqVO.getChannelCode();
        this.status = AccountEnums.AccountStatusEnum.NORMAL.getValue();
        this.userId = userId;
        this.userType = accountRegisterReqVO.getUserType();
    }

    public UcAccountEntity(LoginWithMailReqVo reqVo, Short accountStatus, String accountId) {
        this.accountNo = reqVo.getMailAddress();
        this.accountType = AccountEnums.AccountTypeEnum.EMAIL.getValue();
        this.appCode = reqVo.getAppCode();
        this.registerChannel = reqVo.getChannelCode();
        this.status = accountStatus;
        this.accountId = accountId;
        this.userType = reqVo.getUserType();
    }

    public Integer getId() {
        return this.id;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getAccountNo() {
        return this.accountNo;
    }

    public String getAccountPw() {
        return this.accountPw;
    }

    public String getPwSalt() {
        return this.pwSalt;
    }

    public Short getUserType() {
        return this.userType;
    }

    public Short getAccountType() {
        return this.accountType;
    }

    public String getAppCode() {
        return this.appCode;
    }

    public String getLastLoginIp() {
        return this.lastLoginIp;
    }

    public Date getLastLoginTime() {
        return this.lastLoginTime;
    }

    public String getRegisterChannel() {
        return this.registerChannel;
    }

    public Short getStatus() {
        return this.status;
    }

    public Short getIsActive() {
        return this.isActive;
    }

    public String getRealName() {
        return this.realName;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public String getRelatedMobileNumber() {
        return this.relatedMobileNumber;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setAccountNo(String accountNo) {
        this.accountNo = accountNo;
    }

    public void setAccountPw(String accountPw) {
        this.accountPw = accountPw;
    }

    public void setPwSalt(String pwSalt) {
        this.pwSalt = pwSalt;
    }

    public void setUserType(Short userType) {
        this.userType = userType;
    }

    public void setAccountType(Short accountType) {
        this.accountType = accountType;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public void setLastLoginIp(String lastLoginIp) {
        this.lastLoginIp = lastLoginIp;
    }

    public void setLastLoginTime(Date lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }

    public void setRegisterChannel(String registerChannel) {
        this.registerChannel = registerChannel;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    public void setIsActive(Short isActive) {
        this.isActive = isActive;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public void setRelatedMobileNumber(String relatedMobileNumber) {
        this.relatedMobileNumber = relatedMobileNumber;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UcAccountEntity)) {
            return false;
        }
        UcAccountEntity other = (UcAccountEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$updateTime = this.getUpdateTime();
        Date other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$accountNo = this.getAccountNo();
        String other$accountNo = other.getAccountNo();
        if (this$accountNo == null ? other$accountNo != null : !this$accountNo.equals(other$accountNo)) {
            return false;
        }
        String this$accountPw = this.getAccountPw();
        String other$accountPw = other.getAccountPw();
        if (this$accountPw == null ? other$accountPw != null : !this$accountPw.equals(other$accountPw)) {
            return false;
        }
        String this$pwSalt = this.getPwSalt();
        String other$pwSalt = other.getPwSalt();
        if (this$pwSalt == null ? other$pwSalt != null : !this$pwSalt.equals(other$pwSalt)) {
            return false;
        }
        Short this$userType = this.getUserType();
        Short other$userType = other.getUserType();
        if (this$userType == null ? other$userType != null : !((Object)this$userType).equals(other$userType)) {
            return false;
        }
        Short this$accountType = this.getAccountType();
        Short other$accountType = other.getAccountType();
        if (this$accountType == null ? other$accountType != null : !((Object)this$accountType).equals(other$accountType)) {
            return false;
        }
        String this$appCode = this.getAppCode();
        String other$appCode = other.getAppCode();
        if (this$appCode == null ? other$appCode != null : !this$appCode.equals(other$appCode)) {
            return false;
        }
        String this$lastLoginIp = this.getLastLoginIp();
        String other$lastLoginIp = other.getLastLoginIp();
        if (this$lastLoginIp == null ? other$lastLoginIp != null : !this$lastLoginIp.equals(other$lastLoginIp)) {
            return false;
        }
        Date this$lastLoginTime = this.getLastLoginTime();
        Date other$lastLoginTime = other.getLastLoginTime();
        if (this$lastLoginTime == null ? other$lastLoginTime != null : !((Object)this$lastLoginTime).equals(other$lastLoginTime)) {
            return false;
        }
        String this$registerChannel = this.getRegisterChannel();
        String other$registerChannel = other.getRegisterChannel();
        if (this$registerChannel == null ? other$registerChannel != null : !this$registerChannel.equals(other$registerChannel)) {
            return false;
        }
        Short this$status = this.getStatus();
        Short other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Short this$isActive = this.getIsActive();
        Short other$isActive = other.getIsActive();
        if (this$isActive == null ? other$isActive != null : !((Object)this$isActive).equals(other$isActive)) {
            return false;
        }
        String this$realName = this.getRealName();
        String other$realName = other.getRealName();
        if (this$realName == null ? other$realName != null : !this$realName.equals(other$realName)) {
            return false;
        }
        String this$loginName = this.getLoginName();
        String other$loginName = other.getLoginName();
        if (this$loginName == null ? other$loginName != null : !this$loginName.equals(other$loginName)) {
            return false;
        }
        String this$relatedMobileNumber = this.getRelatedMobileNumber();
        String other$relatedMobileNumber = other.getRelatedMobileNumber();
        if (this$relatedMobileNumber == null ? other$relatedMobileNumber != null : !this$relatedMobileNumber.equals(other$relatedMobileNumber)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        return !(this$language == null ? other$language != null : !this$language.equals(other$language));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UcAccountEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $accountNo = this.getAccountNo();
        result = result * 59 + ($accountNo == null ? 43 : $accountNo.hashCode());
        String $accountPw = this.getAccountPw();
        result = result * 59 + ($accountPw == null ? 43 : $accountPw.hashCode());
        String $pwSalt = this.getPwSalt();
        result = result * 59 + ($pwSalt == null ? 43 : $pwSalt.hashCode());
        Short $userType = this.getUserType();
        result = result * 59 + ($userType == null ? 43 : ((Object)$userType).hashCode());
        Short $accountType = this.getAccountType();
        result = result * 59 + ($accountType == null ? 43 : ((Object)$accountType).hashCode());
        String $appCode = this.getAppCode();
        result = result * 59 + ($appCode == null ? 43 : $appCode.hashCode());
        String $lastLoginIp = this.getLastLoginIp();
        result = result * 59 + ($lastLoginIp == null ? 43 : $lastLoginIp.hashCode());
        Date $lastLoginTime = this.getLastLoginTime();
        result = result * 59 + ($lastLoginTime == null ? 43 : ((Object)$lastLoginTime).hashCode());
        String $registerChannel = this.getRegisterChannel();
        result = result * 59 + ($registerChannel == null ? 43 : $registerChannel.hashCode());
        Short $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Short $isActive = this.getIsActive();
        result = result * 59 + ($isActive == null ? 43 : ((Object)$isActive).hashCode());
        String $realName = this.getRealName();
        result = result * 59 + ($realName == null ? 43 : $realName.hashCode());
        String $loginName = this.getLoginName();
        result = result * 59 + ($loginName == null ? 43 : $loginName.hashCode());
        String $relatedMobileNumber = this.getRelatedMobileNumber();
        result = result * 59 + ($relatedMobileNumber == null ? 43 : $relatedMobileNumber.hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        return result;
    }

    public String toString() {
        return "UcAccountEntity(id=" + this.getId() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", accountId=" + this.getAccountId() + ", userId=" + this.getUserId() + ", accountNo=" + this.getAccountNo() + ", accountPw=" + this.getAccountPw() + ", pwSalt=" + this.getPwSalt() + ", userType=" + this.getUserType() + ", accountType=" + this.getAccountType() + ", appCode=" + this.getAppCode() + ", lastLoginIp=" + this.getLastLoginIp() + ", lastLoginTime=" + this.getLastLoginTime() + ", registerChannel=" + this.getRegisterChannel() + ", status=" + this.getStatus() + ", isActive=" + this.getIsActive() + ", realName=" + this.getRealName() + ", loginName=" + this.getLoginName() + ", relatedMobileNumber=" + this.getRelatedMobileNumber() + ", language=" + this.getLanguage() + ")";
    }
}

