/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.util;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class HanyupinyinUtil {
    private static final Logger log = LoggerFactory.getLogger(HanyupinyinUtil.class);
    private static final String MATCH = "[\u4e00-\u9fa5]+";
    private static final String CHARACTERS_CANNOT_CONVERTED = "\u5b57\u7b26\u4e0d\u80fd\u8f6c\u6210\u6c49\u8bed\u62fc\u97f3 {}";

    public static String getPinyinString(String ChineseLanguage) {
        char[] cl_chars = ChineseLanguage.trim().toCharArray();
        String hanyupinyin = "";
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        defaultFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
        try {
            for (int i = 0; i < cl_chars.length; ++i) {
                hanyupinyin = String.valueOf(cl_chars[i]).matches("[\u4e00-\u9fa5]+") ? hanyupinyin + PinyinHelper.toHanyuPinyinStringArray((char)cl_chars[i], (HanyuPinyinOutputFormat)defaultFormat)[0] + " " : hanyupinyin + cl_chars[i];
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            log.info("\u5b57\u7b26\u4e0d\u80fd\u8f6c\u6210\u6c49\u8bed\u62fc\u97f3 {}", (Throwable)e);
        }
        return hanyupinyin;
    }

    public static String getFirstLettersUp(String ChineseLanguage) {
        return HanyupinyinUtil.getFirstLetters((String)ChineseLanguage, (HanyuPinyinCaseType)HanyuPinyinCaseType.UPPERCASE);
    }

    public static String getFirstLettersLo(String ChineseLanguage) {
        return HanyupinyinUtil.getFirstLetters((String)ChineseLanguage, (HanyuPinyinCaseType)HanyuPinyinCaseType.LOWERCASE);
    }

    public static String getFirstLetters(String ChineseLanguage, HanyuPinyinCaseType caseType) {
        char[] cl_chars = ChineseLanguage.trim().toCharArray();
        String hanyupinyin = "";
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(caseType);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        hanyupinyin = HanyupinyinUtil.getHanYuPinYinString((char[])cl_chars, (String)hanyupinyin, (HanyuPinyinOutputFormat)defaultFormat);
        return hanyupinyin;
    }

    public static String getFirstLetter(String ChineseLanguage) {
        char[] cl_chars = ChineseLanguage.trim().toCharArray();
        String hanyupinyin = "";
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.UPPERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        try {
            String str = String.valueOf(cl_chars[0]);
            if (str.matches("[\u4e00-\u9fa5]+")) {
                hanyupinyin = PinyinHelper.toHanyuPinyinStringArray((char)cl_chars[0], (HanyuPinyinOutputFormat)defaultFormat)[0].substring(0, 1);
            } else if (str.matches("[0-9]+")) {
                hanyupinyin = hanyupinyin + cl_chars[0];
            } else if (str.matches("[a-zA-Z]+")) {
                hanyupinyin = hanyupinyin + cl_chars[0];
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            log.info("\u5b57\u7b26\u4e0d\u80fd\u8f6c\u6210\u6c49\u8bed\u62fc\u97f3 {}", (Throwable)e);
        }
        return hanyupinyin;
    }

    private static String getHanYuPinYinString(char[] cl_chars, String hanyupinyin, HanyuPinyinOutputFormat defaultFormat) {
        try {
            for (int i = 0; i < cl_chars.length; ++i) {
                String str = String.valueOf(cl_chars[i]);
                hanyupinyin = str.matches("[\u4e00-\u9fa5]+") ? hanyupinyin + PinyinHelper.toHanyuPinyinStringArray((char)cl_chars[i], (HanyuPinyinOutputFormat)defaultFormat)[0].substring(0, 1) : (str.matches("[0-9]+") ? hanyupinyin + cl_chars[i] : (str.matches("[a-zA-Z]+") ? hanyupinyin + cl_chars[i] : hanyupinyin + cl_chars[i]));
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            log.info("\u5b57\u7b26\u4e0d\u80fd\u8f6c\u6210\u6c49\u8bed\u62fc\u97f3 {}", (Throwable)e);
        }
        return hanyupinyin;
    }

    public static void main(String[] args) {
        System.out.println("getPinyinString===============" + HanyupinyinUtil.getPinyinString((String)"\u590d\u5174\u8def"));
        System.out.println("getFirstLettersUp===============" + HanyupinyinUtil.getFirstLettersUp((String)"\u590d\u5174\u8def"));
        System.out.println("getFirstLettersLo===============" + HanyupinyinUtil.getFirstLettersLo((String)"\u590d\u5174\u8def"));
        System.out.println("getFirstLetter===============" + HanyupinyinUtil.getFirstLetter((String)"\u590d\u5174\u8def"));
    }
}

