/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.util;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.server.config.ProjProperties;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
public class MessageUtils {
    private static Logger logger = LoggerFactory.getLogger(MessageUtils.class);
    @Autowired
    private static MessageSource messageSource;
    @Autowired
    private ProjProperties projProperties;

    public MessageUtils(MessageSource messageSource) {
        MessageUtils.messageSource = messageSource;
    }

    public String get(String msgKey) {
        Locale locale = this.projProperties.getI18nEnabled() == null ? LocaleContextHolder.getLocale() : (this.projProperties.getI18nEnabled() != false ? this.getLocale() : Locale.CHINA);
        try {
            logger.info("-----\u56fd\u9645\u5316------msgKey:{},-----locale:{}", (Object)msgKey, (Object)JSON.toJSONString((Object)locale));
            String message = messageSource.getMessage(msgKey, null, locale);
            return message;
        }
        catch (Exception e) {
            logger.info("-----\u56fd\u9645\u5316\u5f02\u5e38------msgKey\uff1a" + msgKey + "----------" + e);
            return msgKey;
        }
    }

    private Locale getLocale() {
        Locale locale = new Locale(Locale.CHINA.getLanguage());
        if (this.projProperties.getI18nLocale() != null) {
            switch (this.projProperties.getI18nLocale()) {
                case "zh": {
                    locale = new Locale(Locale.CHINA.getLanguage());
                    break;
                }
                case "en": {
                    locale = new Locale(Locale.ENGLISH.getLanguage());
                    break;
                }
                case "ko": {
                    locale = new Locale(Locale.KOREA.getLanguage());
                    break;
                }
                case "ja": {
                    locale = new Locale(Locale.JAPANESE.getLanguage());
                    break;
                }
                default: {
                    locale = new Locale(Locale.CHINA.getLanguage());
                }
            }
        }
        return locale;
    }
}

