/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.common.enums.ErrorEnum;
import com.ebaiyihui.framework.utils.ByhHttpUtil;
import com.ebaiyihui.server.exception.UserCenterRuntimeException;
import com.ebaiyihui.server.pojo.vo.IdCardValidateResponseVo;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AliCloudIdCardUtil {
    private static final Logger log = LoggerFactory.getLogger(AliCloudIdCardUtil.class);
    @Value(value="${idRealnameAuthentication.requestMethod}")
    private String requestMethod;
    @Value(value="${idRealnameAuthentication.old.host}")
    private String old_host;
    @Value(value="${idRealnameAuthentication.old.path}")
    private String old_path;
    @Value(value="${idRealnameAuthentication.old.appCode}")
    private String old_appcode;
    @Value(value="${idRealnameAuthentication.new.host}")
    private String new_host;
    @Value(value="${idRealnameAuthentication.new.path}")
    private String new_path;
    @Value(value="${idRealnameAuthentication.new.appCode}")
    private String new_appcode;
    @Value(value="${idRealnameAuthentication.new.zkAppCode}")
    private String zk_appcode;

    public String verifyIdWithName(String idCard, String name) {
        log.info("==============\u5f00\u59cb\u8fdb\u5165\u8eab\u4efd\u8bc1\u6821\u9a8c==================");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "APPCODE " + this.old_appcode);
        HashMap<String, String> querys = new HashMap<String, String>();
        querys.put("idcard", idCard);
        querys.put("name", name);
        try {
            HttpResponse response = ByhHttpUtil.doGet((String)this.old_host, (String)this.old_path, (String)this.requestMethod, headers, querys);
            String entityString = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("\u8eab\u4efd\u8bc1\u6821\u9a8c\u5b8c\u6210:" + entityString);
            return entityString;
        }
        catch (Exception e) {
            log.info("\u8eab\u4efd\u8bc1\u6821\u9a8c\u51fa\u9519{}", (Throwable)e);
            return null;
        }
    }

    public IdCardValidateResponseVo verifyIdWithNameV2(String idCard, String name) {
        log.info("==============\u5f00\u59cb\u8fdb\u5165V2\u8eab\u4efd\u8bc1\u6821\u9a8c==================,\u53c2\u6570idCard:{}, name:{}", (Object)idCard, (Object)name);
        if (StringUtils.isEmpty((String)idCard) || StringUtils.isEmpty((String)name)) {
            throw new UserCenterRuntimeException(ErrorEnum.MISSING_PARAMETER, "\u53c2\u6570\u5f02\u5e38: idCard:[" + idCard + "], name:[" + name + "]");
        }
        HashMap<String, String> queryParams = new HashMap<String, String>(2);
        queryParams.put("idCard", idCard);
        queryParams.put("name", name);
        HashMap<String, String> headers = new HashMap<String, String>(5);
        headers.put("Authorization", "APPCODE " + this.new_appcode);
        IdCardValidateResponseVo idCardValidateResponseEntity = new IdCardValidateResponseVo();
        try {
            HttpResponse httpResponse = ByhHttpUtil.doGet((String)this.new_host, (String)this.new_path, (String)this.requestMethod, headers, queryParams);
            String jsonString = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            if (jsonString != null) {
                log.info("\u8fd4\u56de\u503cjsonString:" + jsonString);
                idCardValidateResponseEntity = (IdCardValidateResponseVo)JSONObject.parseObject((String)jsonString, IdCardValidateResponseVo.class);
            }
            log.info("\u8c03\u7528\u8fd4\u56de\u503c\u4e3a:jsonString:" + jsonString + ",idCardValidateResponseEntity:" + idCardValidateResponseEntity);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return idCardValidateResponseEntity;
    }

    public IdCardValidateResponseVo zkVerifyIdWithNameV2(String idCard, String name) {
        log.info("==============\u5f00\u59cb\u8fdb\u5165V2\u8eab\u4efd\u8bc1\u6821\u9a8c==================,\u53c2\u6570idCard:{}, name:{}", (Object)idCard, (Object)name);
        if (StringUtils.isEmpty((String)idCard) || StringUtils.isEmpty((String)name)) {
            throw new UserCenterRuntimeException(ErrorEnum.MISSING_PARAMETER, "\u53c2\u6570\u5f02\u5e38: idCard:[" + idCard + "], name:[" + name + "]");
        }
        HashMap<String, String> queryParams = new HashMap<String, String>(2);
        queryParams.put("idCard", idCard);
        queryParams.put("name", name);
        HashMap<String, String> headers = new HashMap<String, String>(5);
        headers.put("Authorization", "APPCODE " + this.zk_appcode);
        IdCardValidateResponseVo idCardValidateResponseEntity = new IdCardValidateResponseVo();
        try {
            HttpResponse httpResponse = ByhHttpUtil.doGet((String)this.new_host, (String)this.new_path, (String)this.requestMethod, headers, queryParams);
            String jsonString = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            if (jsonString != null) {
                log.info("\u8fd4\u56de\u503cjsonString:{}", (Object)jsonString);
                idCardValidateResponseEntity = (IdCardValidateResponseVo)JSONObject.parseObject((String)jsonString, IdCardValidateResponseVo.class);
            }
            log.info("idCardValidateResponseEntity:{}", (Object)JSON.toJSONString((Object)idCardValidateResponseEntity));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return idCardValidateResponseEntity;
    }
}

