/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.config;

import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.apache.http.client.HttpClient;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnClass(value={RestTemplate.class, HttpClient.class})
public class RestTemplateConfig {
    @Value(value="${remote.maxTotalConnect:100}")
    private int maxTotalConnect;
    @Value(value="${remote.maxConnectPerRoute:200}")
    private int maxConnectPerRoute;
    @Value(value="${remote.connectTimeout:10000}")
    private int connectTimeout;
    @Value(value="${remote.readTimeout:30000}")
    private int readTimeout;

    private ClientHttpRequestFactory createFactory() {
        SSLContext sslcontext = SSLContexts.createDefault();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)socketFactory).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connectionManager.setMaxTotal(this.maxTotalConnect);
        connectionManager.setDefaultMaxPerRoute(this.maxConnectPerRoute);
        CloseableHttpClient httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connectionManager).setMaxConnPerRoute(this.maxConnectPerRoute).setConnectionManagerShared(true).build();
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        factory.setConnectTimeout(this.connectTimeout);
        factory.setReadTimeout(this.readTimeout);
        return factory;
    }

    @Bean
    @ConditionalOnMissingBean(value={RestTemplate.class})
    public RestTemplate restTemplate() {
        RestTemplate restTemplate = new RestTemplate(this.createFactory());
        List converterList = restTemplate.getMessageConverters();
        HttpMessageConverter converterTarget = null;
        for (HttpMessageConverter item : converterList) {
            if (StringHttpMessageConverter.class != item.getClass()) continue;
            converterTarget = item;
            break;
        }
        if (null != converterTarget) {
            converterList.remove(converterTarget);
        }
        converterList.add(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        return restTemplate;
    }
}

