/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.interceptor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.common.enums.ErrorEnum;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.server.config.ProjProperties;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class LanguageNationalInterceptor
implements ResponseBodyAdvice {
    private static final Logger log = LoggerFactory.getLogger(LanguageNationalInterceptor.class);
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private ProjProperties projProperties;

    public boolean supports(MethodParameter methodParameter, Class aClass) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter methodParameter, MediaType mediaType, Class aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        if (this.projProperties.getI18nEnabled() != null && !this.projProperties.getI18nEnabled().booleanValue()) {
            return body;
        }
        if (serverHttpRequest.getURI().toString().contains("swagger") || serverHttpRequest.getURI().toString().contains("v2/api-docs")) {
            return body;
        }
        BaseResponse baseResponse = (BaseResponse)JSONObject.parseObject((String)JSON.toJSONString((Object)body), BaseResponse.class);
        if (baseResponse != null && "0".equals(baseResponse.getCode())) {
            String errCode = baseResponse.getErrCode();
            if (!IError.PARAM_CHECK_FAILD.getErrCode().equalsIgnoreCase(errCode) && !ErrorEnum.OTHER_SERVICE_ERROR_DEFAULT_CODE.getErrCode().equals(errCode)) {
                Locale locale = LocaleContextHolder.getLocale();
                String msg = this.messageSource.getMessage(errCode, null, errCode, locale);
                log.info("\u8282\u70b9----\u56fd\u9645\u5316:" + locale.getLanguage() + "---->errCode:" + errCode + "--->msg:" + msg);
                if (!errCode.equalsIgnoreCase(msg)) {
                    BaseResponse error = BaseResponse.error((IError)ErrorEnum.getEnum((String)errCode), (String)msg);
                    log.info("\u8282\u70b9----\u56fd\u9645\u5316\u8fd4\u56de\u54cd\u5e94:" + JSON.toJSONString((Object)error));
                    return error;
                }
            }
        }
        return body;
    }
}

