/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.common.enums.ErrorEnum;
import com.ebaiyihui.common.token.TokenBody;
import com.ebaiyihui.common.token.TokenJson;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.server.config.ProjProperties;
import com.ebaiyihui.server.enums.UserEnums;
import com.ebaiyihui.server.service.IAccessTokenService;
import com.ebaiyihui.server.service.ICacheService;
import com.ebaiyihui.server.util.RedisUtil;
import com.ebaiyihui.server.util.Tokenutil;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class AccessTokenServiceImpl
implements IAccessTokenService {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICacheService cacheService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ProjProperties projProperties;
    @Resource
    private HttpServletRequest request;
    @Autowired
    private RedisTemplate redisTemplate;
    private static final String PERMISSIONS_KEY_BREAK_RULES = "[***]";

    public BaseResponse<TokenBody> validateAccessToken(String accessToken) {
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return BaseResponse.error((IError)ErrorEnum.NO_PERMISSION);
        }
        TokenBody parseToken = null;
        try {
            parseToken = Tokenutil.parse((String)accessToken, (String)"hxgy-ehospital");
            this.log.info("\u89e3\u6790Token\u4e3a: " + String.valueOf(parseToken.getTokenJson()));
        }
        catch (Exception e) {
            this.log.error("Token\u53c2\u6570\u89e3\u6790\u5931\u8d25\uff0cToken\u4fe1\u606f[{}]", (Object)accessToken, (Object)e);
            return BaseResponse.error((IError)ErrorEnum.NO_PERMISSION);
        }
        if (parseToken == null || !Tokenutil.validateToken((String)accessToken, (String)"hxgy-ehospital")) {
            this.log.error("Token\u5408\u6cd5\u6027\u5931\u8d25\uff0cToken\u4fe1\u606f[{}]", (Object)parseToken);
            return BaseResponse.error((IError)ErrorEnum.NO_PERMISSION);
        }
        TokenJson tokenJson = parseToken.getTokenJson();
        this.log.info("");
        String appCode = tokenJson.getAppCode();
        this.log.info("appCode: {},", (Object)appCode);
        String tokenKey = Tokenutil.genTokenKey((String)tokenJson.getUserId(), (String)appCode, (String)tokenJson.getDeviceType());
        this.log.info("tokenKey: {},", (Object)tokenKey);
        this.log.info("tokenJson.getUserId(): {},", (Object)tokenJson.getUserId());
        this.log.info("tokenJson.getDeviceType(): {},", (Object)tokenJson.getDeviceType());
        String loginToken = this.getCacheToken(tokenKey);
        this.log.info("loginToken: {},", (Object)loginToken);
        if (StringUtils.isBlank((CharSequence)loginToken)) {
            this.log.error("Token\u767b\u5f55\u4fe1\u606f\u5df2\u5931\u6548\uff0cToken\u4fe1\u606f[{}]", (Object)parseToken);
            return BaseResponse.error((IError)ErrorEnum.NO_PERMISSION);
        }
        if (!accessToken.equals(loginToken)) {
            this.log.error("Token\u767b\u5f55\u4fe1\u606f\u5df2\u5931\u6548\uff0c\u7528\u6237\u5728\u5176\u4ed6\u8bbe\u5907\u91cd\u65b0\u767b\u5f55,Token\u4fe1\u606f[{}]", (Object)accessToken);
            return BaseResponse.error((IError)ErrorEnum.NO_PERMISSION);
        }
        String accountId = tokenJson.getAccountId();
        String lastOperationTimeKey = "last_operation_time_" + accountId;
        if (this.projProperties.getAutoExitAppcode() != null && this.projProperties.getAutoExitAppcode().contains(appCode)) {
            this.log.info("\u81ea\u52a8\u9000\u51faAppcode:{}", (Object)JSON.toJSONString((Object)this.projProperties.getAutoExitAppcode()));
            if (this.redisUtil.hasKey(lastOperationTimeKey)) {
                Object lastOperationTime = this.redisUtil.get(lastOperationTimeKey);
                if (lastOperationTime instanceof Integer) {
                    Integer lastOperationTime1 = (Integer)lastOperationTime;
                    long epochSecondNow = Instant.now().getEpochSecond();
                    this.log.info("\u81ea\u52a8\u9000\u51falastOperationTimeKey:{},appcode:{},lastOperationTime1:{},epochSecondNow:{}", new Object[]{lastOperationTimeKey, JSON.toJSONString((Object)this.projProperties.getAutoExitAppcode()), lastOperationTime1, epochSecondNow});
                    Integer autoExitDuration = this.projProperties.getAutoExitDuration();
                    if (epochSecondNow - (long)lastOperationTime1.intValue() <= (long)(autoExitDuration == null || autoExitDuration == 0 ? 1800 : autoExitDuration * 60)) {
                        this.redisUtil.set(lastOperationTimeKey, (Object)epochSecondNow, 35L, TimeUnit.MINUTES);
                        return BaseResponse.success((Object)parseToken);
                    }
                    this.log.info("\u81ea\u52a8\u9000\u51fa--\u8ddd\u79bb\u4e0a\u6b21\u64cd\u4f5c {}\u5206\u949f", (Object)((epochSecondNow - (long)lastOperationTime1.intValue()) / 60L));
                }
                return BaseResponse.error((IError)ErrorEnum.NO_PERMISSION);
            }
            this.log.error("\u7528\u6237\u957f\u65f6\u95f4\u672a\u64cd\u4f5c\u6821\u9a8c-->\u7f13\u5b58\u4e2d\u672a\u83b7\u53d6\u5230\u6700\u540e\u4e00\u6b21\u767b\u5f55\u65f6\u95f4 lastOperationTimeKey=" + lastOperationTimeKey);
            return BaseResponse.error((IError)ErrorEnum.NO_PERMISSION);
        }
        return BaseResponse.success((Object)parseToken);
    }

    public BaseResponse validateAccessTokenV2(String accessToken, String url) {
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return BaseResponse.error((IError)ErrorEnum.ACCESS_TOKEN_NOT_NULL);
        }
        if (StringUtils.isBlank((CharSequence)url)) {
            return BaseResponse.error((IError)ErrorEnum.URL_NO_NULL);
        }
        TokenBody parseToken = null;
        try {
            parseToken = Tokenutil.parse((String)accessToken, (String)"hxgy-ehospital");
        }
        catch (Exception e) {
            this.log.error("Token\u53c2\u6570\u89e3\u6790\u5931\u8d25\uff0cToken\u4fe1\u606f[{}]", (Object)accessToken, (Object)e);
            return BaseResponse.error((IError)ErrorEnum.TOKEN_PARSE_FAIL);
        }
        if (parseToken == null || !Tokenutil.validateToken((String)accessToken, (String)"hxgy-ehospital")) {
            this.log.error("Token\u5408\u6cd5\u6027\u5931\u8d25\uff0cToken\u4fe1\u606f[{}]", (Object)parseToken);
            return BaseResponse.error((IError)ErrorEnum.ACCESS_TOKEN_NOT_ILLEGAL);
        }
        TokenJson tokenJson = parseToken.getTokenJson();
        String appCode = tokenJson.getAppCode();
        String tokenKey = Tokenutil.genTokenKey((String)tokenJson.getUserId(), (String)appCode, (String)tokenJson.getDeviceType());
        String loginToken = this.getCacheToken(tokenKey);
        if (StringUtils.isBlank((CharSequence)loginToken)) {
            this.log.error("Token\u767b\u5f55\u4fe1\u606f\u5df2\u5931\u6548\uff0cToken\u4fe1\u606f[{}]", (Object)parseToken);
            return BaseResponse.error((IError)ErrorEnum.ACCESS_TOKEN_EXPIRED);
        }
        if (!accessToken.equals(loginToken)) {
            this.log.error("Token\u767b\u5f55\u4fe1\u606f\u5df2\u5931\u6548\uff0c\u7528\u6237\u5728\u5176\u4ed6\u8bbe\u5907\u91cd\u65b0\u767b\u5f55,Token\u4fe1\u606f[{}]", (Object)accessToken);
            return BaseResponse.error((IError)ErrorEnum.ACCESS_TOKEN_EXPIRED);
        }
        String accountId = tokenJson.getAccountId();
        String lastOperationTimeKey = "last_operation_time_" + accountId;
        if (this.projProperties.getAutoExitAppcode() != null && this.projProperties.getAutoExitAppcode().contains(appCode)) {
            this.log.info("\u81ea\u52a8\u9000\u51faAppcode:{}", (Object)JSON.toJSONString((Object)this.projProperties.getAutoExitAppcode()));
            if (this.redisUtil.hasKey(lastOperationTimeKey)) {
                Object lastOperationTime = this.redisUtil.get(lastOperationTimeKey);
                if (lastOperationTime instanceof Integer) {
                    Integer lastOperationTime1 = (Integer)lastOperationTime;
                    long epochSecondNow = Instant.now().getEpochSecond();
                    this.log.info("\u81ea\u52a8\u9000\u51falastOperationTimeKey:{},appcode:{},lastOperationTime1:{},epochSecondNow:{}", new Object[]{lastOperationTimeKey, JSON.toJSONString((Object)this.projProperties.getAutoExitAppcode()), lastOperationTime1, epochSecondNow});
                    Integer autoExitDuration = this.projProperties.getAutoExitDuration();
                    if (epochSecondNow - (long)lastOperationTime1.intValue() <= (long)(autoExitDuration == null || autoExitDuration == 0 ? 1800 : autoExitDuration * 60)) {
                        this.redisUtil.set(lastOperationTimeKey, (Object)epochSecondNow, 35L, TimeUnit.MINUTES);
                        return BaseResponse.success((Object)parseToken);
                    }
                    this.log.info("\u81ea\u52a8\u9000\u51fa--\u8ddd\u79bb\u4e0a\u6b21\u64cd\u4f5c {}\u5206\u949f", (Object)((epochSecondNow - (long)lastOperationTime1.intValue()) / 60L));
                }
                return BaseResponse.error((IError)ErrorEnum.ACCESS_TOKEN_EXPIRED);
            }
            this.log.error("\u7528\u6237\u957f\u65f6\u95f4\u672a\u64cd\u4f5c\u6821\u9a8c-->\u7f13\u5b58\u4e2d\u672a\u83b7\u53d6\u5230\u6700\u540e\u4e00\u6b21\u767b\u5f55\u65f6\u95f4 lastOperationTimeKey=" + lastOperationTimeKey);
            return BaseResponse.error((IError)ErrorEnum.ACCESS_TOKEN_EXPIRED);
        }
        this.log.info("=========\u5f00\u59cb\u6743\u9650\u6821\u9a8c======url:" + url);
        short userType = tokenJson.getUserType();
        this.log.info("=========\u6743\u9650\u6821\u9a8c======\u7528\u6237\u7c7b\u578b\u4e3a:" + userType);
        if (userType != UserEnums.UserTypeEnum.MANAGER.getUserTypeValue()) {
            return BaseResponse.success((Object)parseToken);
        }
        List roles = tokenJson.getRoles();
        this.log.info("accountId:" + accountId + "====\u7528\u6237\u7684\u89d2\u8272\u4e3a:[" + roles + "]");
        Boolean permissions = false;
        if (roles != null) {
            for (String role : roles) {
                permissions = this.permissionToHandle(appCode, role, url);
                if (!permissions.booleanValue()) continue;
                return BaseResponse.success((Object)parseToken);
            }
            return BaseResponse.error((IError)ErrorEnum.ACCOUNT_NOT_PAGE_ACCESS);
        }
        return BaseResponse.error((IError)ErrorEnum.NO_PERMISSION);
    }

    public String getCacheToken(String tokenKey) {
        return this.cacheService.getLoginToken(tokenKey);
    }

    public String generatePermissionsKey(String appCode, String role) {
        return "permission:appCode:" + appCode + ":role:" + role;
    }

    public Boolean permissionToHandle(String appCode, String role, String url) {
        if (StringUtils.isBlank((CharSequence)appCode) || StringUtils.isBlank((CharSequence)role) || StringUtils.isBlank((CharSequence)url)) {
            this.log.error("\u6743\u9650\u6821\u9a8c: \u53c2\u6570\u6821\u9a8c\u5f02\u5e38:appCode:[" + appCode + "],headerRole:[" + role + "]\uff0curl:[" + url + "]");
            return false;
        }
        String permissionsKey = this.generatePermissionsKey(appCode, role);
        Boolean permissions = this.redisTemplate.opsForSet().isMember((Object)permissionsKey, (Object)url);
        this.log.info("permissions: " + permissions + "\t key: " + permissionsKey + "\t url: " + url);
        if (permissions != null && !permissions.booleanValue()) {
            return permissions;
        }
        return true;
    }
}

