/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.ebaiyihui.server.config.LoginConfig;
import com.ebaiyihui.server.service.ICacheService;
import com.ebaiyihui.server.util.RedisUtil;
import java.time.LocalTime;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CacheServiceImpl
implements ICacheService {
    @Autowired
    LoginConfig loginConfig;
    private static final Logger log = LoggerFactory.getLogger(CacheServiceImpl.class);
    @Resource
    private RedisUtil redisUtil;

    public String getLoginToken(String tokenKey) {
        return (String)this.redisUtil.get(tokenKey);
    }

    public boolean delLoginToken(String tokenKey) {
        log.info("\u5220\u9664\u767b\u5f55\u7f13\u5b58\uff0ctokenKey[{}]", (Object)tokenKey);
        this.redisUtil.del(new String[]{tokenKey});
        return true;
    }

    public boolean addLoginToken(String tokenKey, String token, String source) {
        Integer expiryTime = null;
        if ("integrated_management".equals(source)) {
            log.info("\u6dfb\u52a0\u7ba1\u7406\u7aef\u767b\u5f55\u7f13\u5b58\uff0c\u6709\u6548\u65f6\u957f[{}],tokenKey[{}],token[{}]", new Object[]{this.loginConfig.getManagementTokenTime(), tokenKey, token});
            expiryTime = this.loginConfig.getManagementTokenTime();
        } else if ("small_program".equals(source)) {
            log.info("\u6dfb\u52a0\u5c0f\u7a0b\u5e8f\u767b\u5f55\u7f13\u5b58\uff0c\u6709\u6548\u65f6\u957f[{}],tokenKey[{}],token[{}]", new Object[]{this.loginConfig.getProgramTokenTime(), tokenKey, token});
            expiryTime = this.loginConfig.getProgramTokenTime();
        } else {
            log.info("\u6dfb\u52a0\u9ed8\u8ba4\u767b\u5f55\u7f13\u5b58\uff0c\u6709\u6548\u65f6\u957f[{}],tokenKey[{}],token[{}]", new Object[]{this.loginConfig.getDefaultTokenTime(), tokenKey, token});
            expiryTime = this.loginConfig.getDefaultTokenTime();
        }
        return this.redisUtil.set(tokenKey, (Object)token, (long)expiryTime.intValue(), TimeUnit.MINUTES);
    }

    public String cacheWxSessionKey(String sessionKey, String openId) {
        String sessionId = "getwxsessionkey_" + openId + "_" + LocalTime.now().getSecond();
        log.info("sessionkey\u7f13\u5b58 sessionId:{},sessionKey:{}", (Object)sessionId, (Object)sessionKey);
        this.redisUtil.set(sessionId, (Object)sessionKey, 86400L);
        return sessionId;
    }
}

