/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.aspect;

import com.ebaiyihui.common.annotations.ResponseDesensitization;
import com.ebaiyihui.common.utils.DesensitizationUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ResponseDesensitizationAspect {
    private static final Logger log = LoggerFactory.getLogger(ResponseDesensitizationAspect.class);

    @Around(value="@annotation(responseDesensitization)")
    public Object around(ProceedingJoinPoint point, ResponseDesensitization responseDesensitization) throws Throwable {
        Object result = point.proceed();
        if (!responseDesensitization.enabled()) {
            return result;
        }
        try {
            log.debug("\u5f00\u59cb\u5bf9\u65b9\u6cd5 {} \u7684\u8fd4\u56de\u503c\u8fdb\u884c\u8131\u654f\u5904\u7406", (Object)point.getSignature().getName());
            result = DesensitizationUtils.desensitize((Object)result);
            log.debug("\u8131\u654f\u5904\u7406\u5b8c\u6210");
        }
        catch (Exception e) {
            log.error("\u54cd\u5e94\u8131\u654f\u5904\u7406\u5931\u8d25", (Throwable)e);
        }
        return result;
    }
}

