/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="redisUtil")
public class RedisUtil {
    private static final Logger log = LoggerFactory.getLogger(RedisUtil.class);
    private static final String FIND_EXCEPTION = "\u51fa\u73b0\u5f02\u5e38:";
    @Resource
    private RedisTemplate redisTemplate;

    public boolean expire(String key, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
            }
            return true;
        }
        catch (Exception e) {
            log.error(FIND_EXCEPTION + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public boolean hasKey(String key) {
        try {
            return this.redisTemplate.hasKey((Object)key);
        }
        catch (Exception e) {
            log.error(FIND_EXCEPTION + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void del(String ... key) {
        if (key != null && key.length > 0) {
            if (key.length == 1) {
                this.redisTemplate.delete((Object)key[0]);
            } else {
                this.redisTemplate.delete((Collection)CollectionUtils.arrayToList((Object)key));
            }
        }
    }

    public Object get(String key) {
        return key == null ? null : this.redisTemplate.opsForValue().get((Object)key);
    }

    public boolean set(String key, Object value) {
        try {
            this.redisTemplate.opsForValue().set((Object)key, value);
            return true;
        }
        catch (Exception e) {
            log.error(FIND_EXCEPTION + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean set(String key, Object value, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.SECONDS);
            } else {
                this.set(key, value);
            }
            return true;
        }
        catch (Exception e) {
            log.info("\u666e\u901a\u7f13\u5b58\u653e\u5165\u5e76\u8bbe\u7f6e\u65f6\u95f4 \u5f02\u5e38e:{}", (Throwable)e);
            log.error(FIND_EXCEPTION + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean set(String key, Object value, long time, TimeUnit timeUnit) {
        try {
            if (time > 0L) {
                this.redisTemplate.opsForValue().set((Object)key, value, time, timeUnit);
            } else {
                this.set(key, value);
            }
            return true;
        }
        catch (Exception e) {
            log.error(FIND_EXCEPTION + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public long incr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, delta);
    }

    public long decr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, -delta);
    }

    public Object hget(String key, String item) {
        return this.redisTemplate.opsForHash().get((Object)key, (Object)item);
    }

    public Map<Object, Object> hmget(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public boolean hmset(String key, Map<String, Object> map) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            return true;
        }
        catch (Exception e) {
            log.error(FIND_EXCEPTION + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean hmset(String key, Map<String, Object> map, long time) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.error(FIND_EXCEPTION + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean hset(String key, String item, Object value) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            return true;
        }
        catch (Exception e) {
            log.error(FIND_EXCEPTION + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean hset(String key, String item, Object value, long time) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.error(FIND_EXCEPTION + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void hdel(String key, Object ... item) {
        this.redisTemplate.opsForHash().delete((Object)key, item);
    }

    public boolean hHasKey(String key, String item) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)item);
    }

    public double hincr(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, by);
    }

    public double hdecr(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, -by);
    }

    public Set<Object> sGet(String key) {
        try {
            return this.redisTemplate.opsForSet().members((Object)key);
        }
        catch (Exception e) {
            log.error(FIND_EXCEPTION + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean sHasKey(String key, Object value) {
        try {
            return this.redisTemplate.opsForSet().isMember((Object)key, value);
        }
        catch (Exception e) {
            log.error(FIND_EXCEPTION + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public long sSet(String key, Object ... values) {
        try {
            return this.redisTemplate.opsForSet().add((Object)key, values);
        }
        catch (Exception e) {
            log.error(FIND_EXCEPTION + e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public long sSetAndTime(String key, long time, Object ... values) {
        try {
            Long count = this.redisTemplate.opsForSet().add((Object)key, values);
            if (time > 0L) {
                this.expire(key, time);
            }
            return count;
        }
        catch (Exception e) {
            log.error(FIND_EXCEPTION + e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public long sGetSetSize(String key) {
        try {
            return this.redisTemplate.opsForSet().size((Object)key);
        }
        catch (Exception e) {
            log.error(FIND_EXCEPTION + e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public long setRemove(String key, Object ... values) {
        try {
            Long count = this.redisTemplate.opsForSet().remove((Object)key, values);
            return count;
        }
        catch (Exception e) {
            log.error(FIND_EXCEPTION + e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public List<Object> lGet(String key, long start, long end) {
        try {
            return this.redisTemplate.opsForList().range((Object)key, start, end);
        }
        catch (Exception e) {
            log.error(FIND_EXCEPTION + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public long lGetListSize(String key) {
        try {
            return this.redisTemplate.opsForList().size((Object)key);
        }
        catch (Exception e) {
            log.error(FIND_EXCEPTION + e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public Object lGetIndex(String key, long index) {
        try {
            return this.redisTemplate.opsForList().index((Object)key, index);
        }
        catch (Exception e) {
            log.error(FIND_EXCEPTION + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean lSet(String key, Object value) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            return true;
        }
        catch (Exception e) {
            log.error(FIND_EXCEPTION + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean lSet(String key, Object value, long time) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.info("\u5c06list\u653e\u5165\u7f13\u5b58{}", (Throwable)e);
            log.error(FIND_EXCEPTION + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean lSet(String key, List<Object> value) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            return true;
        }
        catch (Exception e) {
            log.error(FIND_EXCEPTION + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean lSet(String key, List<Object> value, long time) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.error(FIND_EXCEPTION + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean lUpdateIndex(String key, long index, Object value) {
        try {
            this.redisTemplate.opsForList().set((Object)key, index, value);
            return true;
        }
        catch (Exception e) {
            log.error(FIND_EXCEPTION + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public long lRemove(String key, long count, Object value) {
        try {
            Long remove = this.redisTemplate.opsForList().remove((Object)key, count, value);
            return remove;
        }
        catch (Exception e) {
            log.error(FIND_EXCEPTION + e.getMessage(), (Throwable)e);
            return 0L;
        }
    }
}

