/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.patient.server.controller;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.patient.server.exception.PatientException;
import com.ebaiyihui.patient.server.service.PatientMedicalTagService;
import com.ebaiyihui.patient.server.vo.DeletePatientMedicalTagReqVo;
import com.ebaiyihui.patient.server.vo.PatientMedicalTagReqVO;
import com.ebaiyihui.patient.server.vo.PatientMedicalTagResVO;
import com.ebaiyihui.patient.server.vo.SavePatientMedicalTagReqVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/medicalTag"})
@Api(description="\u75c5\u4f8b\u6807\u7b7eapi")
public class PatientMedicalTagController {
    private static final Logger log = LoggerFactory.getLogger(PatientMedicalTagController.class);
    @Autowired
    private PatientMedicalTagService patientMedicalTagService;

    @ApiOperation(value="\u67e5\u8be2\u75c5\u4f8b\u6807\u7b7e\u5217\u8868", notes="\u67e5\u8be2\u75c5\u4f8b\u6807\u7b7e\u5217\u8868")
    @GetMapping(value={"/getPatientMedicalTagList"})
    public BaseResponse<List<PatientMedicalTagResVO>> getPatientMedicalTagList(@Valid PatientMedicalTagReqVO patientMedicalTagReqVO, BindingResult bindingResult) {
        if (bindingResult.hasFieldErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        List patientMedicalTagResVOList = this.patientMedicalTagService.getPatientMedicalTagList(patientMedicalTagReqVO);
        return BaseResponse.success((Object)patientMedicalTagResVOList);
    }

    @ApiOperation(value="\u65b0\u589e\u75c5\u4f8b\u6807\u7b7e", notes="\u65b0\u589e\u75c5\u4f8b\u6807\u7b7e")
    @PostMapping(value={"/savePatientMedicalTag"})
    public BaseResponse<String> savePatientMedicalTag(@RequestBody @Valid SavePatientMedicalTagReqVo savePatientMedicalTagReqVo, BindingResult bindingResult) {
        if (bindingResult.hasFieldErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        try {
            this.patientMedicalTagService.savePatientMedicalTag(savePatientMedicalTagReqVo);
        }
        catch (PatientException e) {
            log.error("savePatientMedicalTag(): " + e.getMessage());
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success();
    }

    @ApiOperation(value="\u5220\u9664\u75c5\u4f8b\u6807\u7b7e", notes="\u5220\u9664\u75c5\u4f8b\u6807\u7b7e")
    @PostMapping(value={"/deletePatientMedicalTagById"})
    public BaseResponse<String> deletePatientMedicalTagById(@RequestBody @Valid DeletePatientMedicalTagReqVo deletePatientMedicalTagReqVo, BindingResult bindingResult) {
        if (bindingResult.hasFieldErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        this.patientMedicalTagService.deletePatientMedicalTagById(deletePatientMedicalTagReqVo);
        return BaseResponse.success();
    }
}

