/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.patient.server.service.impl;

import com.ebaiyihui.patient.common.model.PsPatientEntity;
import com.ebaiyihui.patient.common.vo.PatientDiseasePictureVo;
import com.ebaiyihui.patient.common.vo.PatientMedicalRecordDetailVO;
import com.ebaiyihui.patient.common.vo.SavePatientMedicalRecordReqVO;
import com.ebaiyihui.patient.server.dao.IPatientInfoMapper;
import com.ebaiyihui.patient.server.dao.PatientMedicalPictureMapper;
import com.ebaiyihui.patient.server.dao.PatientMedicalRecordMapper;
import com.ebaiyihui.patient.server.entity.PatientMedicalPictureEntity;
import com.ebaiyihui.patient.server.entity.PatientMedicalRecordEntity;
import com.ebaiyihui.patient.server.enums.MedicalPictureTypeEnum;
import com.ebaiyihui.patient.server.service.PatientMedicalRecordService;
import com.ebaiyihui.patient.server.vo.ServicePkgPatientMedicalRecordReqVo;
import com.ebaiyihui.patient.server.vo.ServicePkgPatientMedicalRecordResVo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PatientMedicalRecordServiceImpl
implements PatientMedicalRecordService {
    @Autowired
    private PatientMedicalRecordMapper patientMedicalRecordMapper;
    @Autowired
    private PatientMedicalPictureMapper patientMedicalPictureMapper;
    @Autowired
    private IPatientInfoMapper patientInfoMapper;

    public List<ServicePkgPatientMedicalRecordResVo> getServicePkgPatientMedicalRecordList(ServicePkgPatientMedicalRecordReqVo servicePkgPatientMedicalRecordReqVo) {
        List servicePkgPatientMedicalRecordResVoList = this.patientMedicalRecordMapper.getServicePkgPatientMedicalRecordList(servicePkgPatientMedicalRecordReqVo);
        return servicePkgPatientMedicalRecordResVoList;
    }

    public PatientMedicalRecordDetailVO getPatientMedicalRecordDetailById(Long id) {
        PatientMedicalRecordEntity patientMedicalRecordEntity = this.patientMedicalRecordMapper.selectByPrimaryKey(id);
        PatientMedicalRecordDetailVO patientMedicalRecordDetailVO = new PatientMedicalRecordDetailVO();
        BeanUtils.copyProperties((Object)patientMedicalRecordEntity, (Object)patientMedicalRecordDetailVO);
        List patientMedicalPictureEntityList = this.patientMedicalPictureMapper.getPatientMedicalPictureByMedicalRecordId(id);
        if (CollectionUtils.isEmpty((Collection)patientMedicalPictureEntityList)) {
            return patientMedicalRecordDetailVO;
        }
        Map<Integer, List<PatientMedicalPictureEntity>> patientMedicalPictureEntityMap = patientMedicalPictureEntityList.stream().collect(Collectors.groupingBy(PatientMedicalPictureEntity::getMedicalPictureType));
        patientMedicalPictureEntityMap.keySet().forEach(medicalPictureType -> {
            if (MedicalPictureTypeEnum.DISEASE_PICTURE_TYPE.getValue().equals(medicalPictureType)) {
                List patientDiseasePictureVoList = this.getPatientDiseasePictureVoList(patientMedicalPictureEntityMap, medicalPictureType);
                patientMedicalRecordDetailVO.setPatientDiseasePictureVoList(patientDiseasePictureVoList);
            }
        });
        return patientMedicalRecordDetailVO;
    }

    public Long savePatientMedicalRecord(SavePatientMedicalRecordReqVO patientMedicalRecordReqVO) {
        PatientMedicalRecordEntity patientMedicalRecordEntity = new PatientMedicalRecordEntity();
        BeanUtils.copyProperties((Object)patientMedicalRecordReqVO, (Object)patientMedicalRecordEntity);
        PsPatientEntity psPatientEntity = this.patientInfoMapper.findByPatientId(patientMedicalRecordReqVO.getPatientId());
        patientMedicalRecordEntity.setPatientIdCard(psPatientEntity.getCredNo());
        patientMedicalRecordEntity.setPatientName(psPatientEntity.getPatientName());
        this.patientMedicalRecordMapper.insertSelective(patientMedicalRecordEntity);
        List patientDiseasePictureVoList = patientMedicalRecordReqVO.getPatientDiseasePictureVoList();
        if (!patientDiseasePictureVoList.isEmpty()) {
            patientDiseasePictureVoList.forEach(patientDiseasePictureVo -> {
                PatientMedicalPictureEntity patientMedicalPictureEntity = new PatientMedicalPictureEntity();
                BeanUtils.copyProperties((Object)patientDiseasePictureVo, (Object)patientMedicalPictureEntity);
                patientMedicalPictureEntity.setMedicalRecordId(patientMedicalRecordEntity.getId());
                this.patientMedicalPictureMapper.insertSelective(patientMedicalPictureEntity);
            });
        }
        return patientMedicalRecordEntity.getId();
    }

    private List<PatientDiseasePictureVo> getPatientDiseasePictureVoList(Map<Integer, List<PatientMedicalPictureEntity>> patientMedicalPictureEntityMap, Integer medicalPictureType) {
        List<PatientMedicalPictureEntity> patientDiseasePictureEntityList = patientMedicalPictureEntityMap.get(medicalPictureType);
        return patientDiseasePictureEntityList.stream().map(patientMedicalPictureEntity -> {
            PatientDiseasePictureVo patientDiseasePictureVo = new PatientDiseasePictureVo();
            BeanUtils.copyProperties((Object)patientMedicalPictureEntity, (Object)patientDiseasePictureVo);
            patientDiseasePictureVo.setMedicalPictureTypeName(MedicalPictureTypeEnum.DISEASE_PICTURE_TYPE.getDisplay());
            return patientDiseasePictureVo;
        }).collect(Collectors.toList());
    }
}

