/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.nst.server.aop;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class HttpAspect {
    private static final Logger log = LoggerFactory.getLogger(HttpAspect.class);

    @Pointcut(value="execution(* com.ebaiyihui.nst.server.controller.*.*(..))")
    public void myLog() {
    }

    @Before(value="myLog()")
    public void reqMessage(JoinPoint joinpoint) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        log.info("*********\u6253\u5370\u8bf7\u6c42\u4fe1\u606f\u5f00\u59cb**********");
        log.info("URL : " + request.getRequestURL().toString());
        log.info("HTTP_METHOD : " + request.getMethod());
        log.info("RequestParam:{}", (Object)Arrays.toString(joinpoint.getArgs()));
        log.info("*********\u6253\u5370\u8bf7\u6c42\u4fe1\u606f\u7ed3\u675f**********");
    }

    @AfterReturning(returning="object", pointcut="myLog()")
    public void resMessage(Object object) {
        log.info("*********\u6253\u5370\u7ed3\u679c\u4fe1\u606f\u5f00\u59cb**********");
        log.info("RESULT:" + object);
        log.info("*********\u6253\u5370\u7ed3\u679c\u4fe1\u606f\u7ed3\u675f**********");
    }
}

