/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.nst.server.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.nst.server.enums.OrderEnum;
import com.ebaiyihui.nst.server.mapper.TEquipBackMapper;
import com.ebaiyihui.nst.server.pojo.entity.TEquipBack;
import com.ebaiyihui.nst.server.pojo.entity.TOrder;
import com.ebaiyihui.nst.server.pojo.vo.RefundVo;
import com.ebaiyihui.nst.server.pojo.vo.SaveEquipBackVo;
import com.ebaiyihui.nst.server.pojo.vo.UpdateEquipBackVo;
import com.ebaiyihui.nst.server.service.OrderTradeService;
import com.ebaiyihui.nst.server.service.TEquipBackService;
import com.ebaiyihui.nst.server.service.TOrderService;
import java.math.BigDecimal;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class TEquipBackServiceImpl
extends ServiceImpl<TEquipBackMapper, TEquipBack>
implements TEquipBackService {
    private static final Logger log = LoggerFactory.getLogger(TEquipBackServiceImpl.class);
    private static final String ORDER_NO_EXIST = "\u8ba2\u5355\u4e0d\u5b58\u5728";
    @Resource
    private TOrderService orderService;
    @Resource
    private OrderTradeService orderTradeService;

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> addEquipBackInfo(SaveEquipBackVo saveEquipBackVo) {
        TOrder order = (TOrder)this.orderService.getOne((Wrapper)new LambdaUpdateWrapper().eq(TOrder::getId, (Object)saveEquipBackVo.getOrderId()));
        if (ObjectUtils.isEmpty((Object)order)) {
            return BaseResponse.error((String)ORDER_NO_EXIST);
        }
        if (order.getStatus().equals(OrderEnum.FINISHED.getStatus())) {
            return BaseResponse.error((String)"\u6b64\u8ba2\u5355\u5df2\u5b8c\u6210");
        }
        TEquipBack back = (TEquipBack)this.getOne((Wrapper)new LambdaQueryWrapper().eq(TEquipBack::getOrderId, (Object)saveEquipBackVo.getOrderId()));
        if (!ObjectUtils.isEmpty((Object)back)) {
            BeanUtils.copyProperties((Object)saveEquipBackVo, (Object)back);
            this.updateById((Object)back);
        } else {
            TEquipBack tEquipBack = new TEquipBack();
            BeanUtils.copyProperties((Object)saveEquipBackVo, (Object)tEquipBack);
            this.save((Object)tEquipBack);
            order.setStatus(OrderEnum.UN_BACK.getStatus());
            order.setBackFlag(Integer.valueOf(1));
            order.setBackId(tEquipBack.getId());
            this.orderService.updateById((Object)order);
        }
        return BaseResponse.success((Object)order.getId());
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> handleBack(UpdateEquipBackVo updateEquipBackVo) {
        TOrder order = (TOrder)this.orderService.getOne((Wrapper)new LambdaUpdateWrapper().eq(TOrder::getId, (Object)updateEquipBackVo.getOrderId()));
        if (ObjectUtils.isEmpty((Object)order)) {
            return BaseResponse.error((String)ORDER_NO_EXIST);
        }
        if (!order.getStatus().equals(OrderEnum.UN_BACK.getStatus())) {
            return BaseResponse.error((String)"\u60a8\u53ea\u80fd\u5904\u7406\u56de\u6536\u4e2d\u7684\u8ba2\u5355");
        }
        if (updateEquipBackVo.getRefundDeposit().compareTo(order.getDeposit()) > 0) {
            return BaseResponse.error((String)"\u9000\u8fd8\u62bc\u91d1\u4e0d\u80fd\u5927\u4e8e\u8ba2\u5355\u62bc\u91d1");
        }
        TEquipBack back = (TEquipBack)this.getOne((Wrapper)new LambdaQueryWrapper().eq(TEquipBack::getOrderId, (Object)updateEquipBackVo.getOrderId()));
        if (ObjectUtils.isEmpty((Object)back)) {
            return BaseResponse.error((String)"\u6b64\u8ba2\u5355\u6ca1\u6709\u8bbe\u5907\u5f52\u8fd8\u4fe1\u606f");
        }
        BeanUtils.copyProperties((Object)updateEquipBackVo, (Object)back);
        back.setReceiveTime(new Date());
        this.updateById((Object)back);
        RefundVo refundVo = new RefundVo();
        refundVo.setOrderId(order.getId());
        refundVo.setDeposit(updateEquipBackVo.getRefundDeposit());
        BigDecimal refundPrice = refundVo.getDeposit();
        if (refundPrice.compareTo(BigDecimal.ZERO) == 0) {
            order.setStatus(OrderEnum.FINISHED.getStatus());
            this.orderService.updateById((Object)order);
            return BaseResponse.success();
        }
        BaseResponse response = this.orderTradeService.refund(refundVo);
        log.info("\u9000\u6b3e\u8bf7\u6c42\u8fd4\u56de\u503c{}", (Object)JSONObject.toJSONString((Object)response));
        if (response.getCode().equals("1")) {
            return BaseResponse.success();
        }
        log.error("\u9000\u6b3e\u5931\u8d25{}", (Object)response.getMsg());
        throw new RuntimeException("\u9000\u6b3e\u5931\u8d25");
    }
}

