/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.nst.server.controller;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.nst.server.pojo.dto.OrderDetailDto;
import com.ebaiyihui.nst.server.pojo.dto.OrderExcelListDtoLy;
import com.ebaiyihui.nst.server.pojo.dto.OrderListPageDto;
import com.ebaiyihui.nst.server.pojo.dto.SmallProgamOrderDto;
import com.ebaiyihui.nst.server.pojo.vo.OrderListPageVo;
import com.ebaiyihui.nst.server.pojo.vo.OrderListVo;
import com.ebaiyihui.nst.server.pojo.vo.SaveOrderVo;
import com.ebaiyihui.nst.server.service.TOrderService;
import com.ebaiyihui.nst.server.util.ExcelUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tOrder"})
@Api(tags={"\u8ba2\u5355API"})
public class TOrderController {
    @Resource
    private TOrderService orderService;

    @ApiOperation(value="\u65b0\u589e\u8ba2\u5355")
    @PostMapping(value={"/newOrder"})
    public BaseResponse<String> newOrder(@RequestBody @Validated SaveOrderVo saveOrderVo) {
        return this.orderService.newOrder(saveOrderVo);
    }

    @ApiOperation(value="\u8ba2\u5355\u8be6\u60c5")
    @GetMapping(value={"/orderDetail"})
    public BaseResponse<OrderDetailDto> orderDetail(@RequestParam String id) {
        return this.orderService.orderDetail(id);
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u8ba2\u5355\u5217\u8868")
    @PostMapping(value={"/orderListBySmallProgram"})
    public BaseResponse<List<SmallProgamOrderDto>> orderListBySmallProgram(@RequestBody @Validated OrderListVo orderListVo) {
        return this.orderService.orderListBySmallProgram(orderListVo);
    }

    @ApiOperation(value="\u7ba1\u7406\u7aef\u8ba2\u5355\u5217\u8868")
    @PostMapping(value={"/orderListByManager"})
    public BaseResponse<OrderListPageDto> orderListByManager(@RequestBody @Validated OrderListPageVo orderListPageVo) {
        return this.orderService.orderListByManager(orderListPageVo);
    }

    @GetMapping(value={"/download/excel"}, produces={"application/vnd.ms-excel"})
    @ApiOperation(value="\u5bfc\u51fa\u8ba2\u5355")
    public BaseResponse<String> downloadOrderExcel(@RequestParam(value="organId", required=false) Integer organId, @RequestParam(value="createTimeBegin", required=false) String createTimeBegin, @RequestParam(value="createTimeEnd", required=false) String createTimeEnd, @RequestParam(value="status", required=false) Integer status, @RequestParam(value="search", required=false) String search, @RequestParam(value="id", required=false) String id, @RequestParam(value="organName", required=false) String organName, HttpServletResponse response) {
        OrderListVo orderListVo = new OrderListVo();
        orderListVo.setOrderId(id);
        orderListVo.setOrganId(organId);
        orderListVo.setSearch(search);
        orderListVo.setStatus(status);
        orderListVo.setStartTime(createTimeBegin);
        orderListVo.setEndTime(createTimeEnd);
        orderListVo.setOrganName(organName);
        List list = this.orderService.getLyExportExcelOrderList(orderListVo);
        try {
            ExcelUtils.exportExcel((List)list, (String)"\u8ba2    \u5355    \u6570    \u636e    \u5bfc    \u51fa    \u8868    \u683c", (String)"\u8ba2\u5355\u6570\u636e\u5bfc\u51fa", OrderExcelListDtoLy.class, (String)"\u8ba2\u5355\u6570\u636e\u5bfc\u51fa\u8868\u683c", (HttpServletResponse)response);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

