/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.nst.server.mq;

import com.ebaiyihui.nst.server.enums.OrderEnum;
import com.ebaiyihui.nst.server.pojo.entity.TOrder;
import com.ebaiyihui.nst.server.service.TOrderService;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Component
public class NewOrderListener {
    private static final Logger log = LoggerFactory.getLogger(NewOrderListener.class);
    @Resource
    private TOrderService orderService;

    @RabbitHandler
    @RabbitListener(queues={"new.txyjorder.queue"})
    @Transactional(rollbackFor={Exception.class})
    public void process(String info) {
        log.info("\u5f85\u652f\u4ed8\u8ba2\u5355\u5b9a\u65f6\u53d6\u6d88\uff0c\u8fdb\u5165\u6d88\u606f\u5904\u7406,\u53c2\u6570\u4e3a\uff1a{}", (Object)info);
        if (StringUtils.isEmpty((CharSequence)info)) {
            log.info("\u6d88\u606f\u53c2\u6570\u4e3a\u7a7a\uff0c\u9000\u51fa");
            return;
        }
        TOrder order = (TOrder)this.orderService.getById((Serializable)((Object)info));
        if (ObjectUtils.isEmpty((Object)order)) {
            log.info("\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u9000\u51fa,id={}", (Object)info);
            return;
        }
        if (!Objects.equals(order.getStatus(), OrderEnum.UN_PAD.getStatus())) {
            log.info("\u8ba2\u5355\u72b6\u6001\u4e0d\u662f\u5f85\u652f\u4ed8\uff0c\u9000\u51fa");
            return;
        }
        order.setStatus(OrderEnum.CANCEL.getStatus());
        this.orderService.updateById((Object)order);
        log.info("\u961f\u5217\u6d88\u8d39\u5b8c\u6bd5\uff01");
    }
}

