/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.nst.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.nst.server.config.ProjProperties;
import com.ebaiyihui.nst.server.enums.OrderEnum;
import com.ebaiyihui.nst.server.enums.ReturnCodeEnum;
import com.ebaiyihui.nst.server.listener.EventManager;
import com.ebaiyihui.nst.server.listener.event.OrderPayEvent;
import com.ebaiyihui.nst.server.listener.event.RefundEvent;
import com.ebaiyihui.nst.server.mapper.OrderTradeMapper;
import com.ebaiyihui.nst.server.pojo.entity.OrderTrade;
import com.ebaiyihui.nst.server.pojo.entity.ServiceMerchantConfig;
import com.ebaiyihui.nst.server.pojo.entity.ServicePayBill;
import com.ebaiyihui.nst.server.pojo.entity.TOrder;
import com.ebaiyihui.nst.server.pojo.vo.AggregationPayWxVo;
import com.ebaiyihui.nst.server.pojo.vo.PayCallbackVo;
import com.ebaiyihui.nst.server.pojo.vo.PayParamVo;
import com.ebaiyihui.nst.server.pojo.vo.RefundCallbackVo;
import com.ebaiyihui.nst.server.pojo.vo.RefundHttpVo;
import com.ebaiyihui.nst.server.pojo.vo.RefundVo;
import com.ebaiyihui.nst.server.service.OrderTradeService;
import com.ebaiyihui.nst.server.service.ServiceMerchantConfigService;
import com.ebaiyihui.nst.server.service.ServicePayBillService;
import com.ebaiyihui.nst.server.service.TOrderService;
import com.ebaiyihui.nst.server.util.HttpUtils;
import com.ebaiyihui.nst.server.util.SignUtil;
import com.ebaiyihui.nst.server.util.UniqueKeyUtil;
import com.ebaiyihui.nst.server.util.pinyinUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class OrderTradeServiceImpl
extends ServiceImpl<OrderTradeMapper, OrderTrade>
implements OrderTradeService {
    private static final Logger log = LoggerFactory.getLogger(OrderTradeServiceImpl.class);
    @Resource
    private TOrderService orderService;
    @Resource
    private ServiceMerchantConfigService merchantConfigService;
    @Resource
    private ProjProperties projProperties;
    @Resource
    private OrderTradeService orderTradeService;
    @Resource
    private ServicePayBillService servicePayBillService;
    @Resource
    private EventManager eventManager;

    public BaseResponse<String> orderPay(PayParamVo payParamVo) {
        String orderId = payParamVo.getOrderId();
        TOrder order = (TOrder)this.orderService.getById((Serializable)((Object)orderId));
        if (ObjectUtils.isEmpty((Object)order)) {
            return BaseResponse.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        ServiceMerchantConfig merchantConfig = (ServiceMerchantConfig)this.merchantConfigService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ServiceMerchantConfig::getAppCode, (Object)this.projProperties.getAppCode())).eq(ServiceMerchantConfig::getStatus, (Object)1));
        if (ObjectUtils.isEmpty((Object)merchantConfig)) {
            throw new RuntimeException("\u652f\u4ed8\u914d\u7f6e\u4e3a\u7a7a");
        }
        log.info("\u652f\u4ed8\u914d\u7f6e\u2014\u2014serviceMerchantConfig\uff1a{}\uff1b", (Object)JSONObject.toJSONString((Object)merchantConfig));
        String serviceCode = this.projProperties.getAppCode() + "_TXJH";
        String outTradeNo = String.valueOf(UniqueKeyUtil.generateViewId());
        AggregationPayWxVo aggregationPayWxVo = new AggregationPayWxVo();
        aggregationPayWxVo.setPayChannel(payParamVo.getPayChannel());
        aggregationPayWxVo.setPayType(payParamVo.getPayType());
        aggregationPayWxVo.setMchCode(merchantConfig.getMerchantSeq());
        aggregationPayWxVo.setServiceCode(serviceCode);
        aggregationPayWxVo.setUserSign(payParamVo.getOpenId());
        aggregationPayWxVo.setOutTradeNo(outTradeNo);
        aggregationPayWxVo.setTotalAmount(payParamVo.getPayPrice());
        aggregationPayWxVo.setActuallyAmount(payParamVo.getPayPrice());
        aggregationPayWxVo.setProductInfo("\u80ce\u513f\u76d1\u62a4\u4eea\u62bc\u91d1");
        aggregationPayWxVo.setAuthCode("");
        aggregationPayWxVo.setNonceStr(pinyinUtil.getRandomString((int)32));
        aggregationPayWxVo.setPayNotifyUrl(this.projProperties.getPAY_CALLBACK());
        aggregationPayWxVo.setApplyCode(merchantConfig.getMerchantSeq());
        String[] str = new String[]{};
        Map map = SignUtil.getKeyAndValue((Object)aggregationPayWxVo);
        String sign = SignUtil.createSign((Map)map, (String)merchantConfig.getApplyKey(), (String[])str);
        aggregationPayWxVo.setSign(sign);
        String url = this.projProperties.getPAY_HTTP_WX_XCX();
        log.info("\u652f\u4ed8\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u7684\u8bf7\u6c42url\u662f:{}=========\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)aggregationPayWxVo));
        String respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)aggregationPayWxVo), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
        log.info("\u8bf7\u6c42\u9884\u652f\u4ed8\u7684\u54cd\u5e94\u7ed3\u679c\u662f:{}", (Object)respStr);
        String code = JSON.parseObject((String)respStr).getString("code");
        if (ReturnCodeEnum.SUCCEED.getValue().equals(code) && JSON.parseObject((String)respStr).getJSONObject("data") != null) {
            OrderTrade orderTradeOne = (OrderTrade)((LambdaQueryChainWrapper)this.lambdaQuery().eq(OrderTrade::getOrderId, (Object)orderId)).one();
            if (orderTradeOne != null) {
                OrderTrade orderTrade = new OrderTrade();
                orderTrade.setOrderId(orderId);
                orderTrade.setOutTradeNo(outTradeNo);
                boolean save = this.save((Object)orderTrade);
                log.info("\u9884\u652f\u4ed8\u6210\u529f\uff0c\u5411order_trade\u8868\u4e2d\u63d2\u5165\u8ba2\u5355\u6d41\u6c34\u53f7\u7684\u7ed3\u679c\uff1a[{}]", (Object)save);
            } else {
                orderTradeOne.setOutTradeNo(outTradeNo);
                boolean save = this.updateById((Object)orderTradeOne);
                log.info("\u9884\u652f\u4ed8\u6210\u529f\uff0c\u5411order_trade\u8868\u4e2d\u63d2\u5165\u8ba2\u5355\u6d41\u6c34\u53f7\u7684\u7ed3\u679c\uff1a[{}]", (Object)save);
            }
            return BaseResponse.success((Object)JSON.parseObject((String)respStr).getJSONObject("data").toString());
        }
        return BaseResponse.error((String)JSON.parseObject((String)respStr).getString("msg"));
    }

    public BaseResponse<String> payCallback(PayCallbackVo payCallbackVo) {
        log.info("\u56de\u8c03\u53c2\u6570payCallbackVo\uff1a{}\uff1b", (Object)JSONObject.toJSONString((Object)payCallbackVo));
        ServicePayBill payBill = (ServicePayBill)this.servicePayBillService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ServicePayBill::getOutTradeNo, (Object)payCallbackVo.getOutTradeNo())).eq(ServicePayBill::getStatus, (Object)3));
        if (!ObjectUtils.isEmpty((Object)payBill)) {
            log.info("\u8ba2\u5355\u652f\u4ed8\u56de\u8c03\u91cd\u590d");
            return BaseResponse.success((Object)"SUCCESS");
        }
        ServiceMerchantConfig merchantConfig = (ServiceMerchantConfig)this.merchantConfigService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ServiceMerchantConfig::getAppCode, (Object)this.projProperties.getAppCode())).eq(ServiceMerchantConfig::getStatus, (Object)1));
        if (ObjectUtils.isEmpty((Object)merchantConfig)) {
            throw new RuntimeException("\u652f\u4ed8\u914d\u7f6e\u4e3a\u7a7a");
        }
        Map map = SignUtil.getKeyAndValue((Object)payCallbackVo);
        Boolean bool = SignUtil.checkSign((Map)map, (String)merchantConfig.getApplyKey());
        log.info("\u652f\u4ed8\u8d26\u5355\u2014\u2014\u9a8c\u7b7e\u7ed3\u679cbool\uff1a{}\uff1b", (Object)bool);
        if (!bool.booleanValue()) {
            log.error("\u9a8c\u7b7e\u5931\u8d25");
            return BaseResponse.error((String)"FAIL");
        }
        ServicePayBill servicePayBillEntity = new ServicePayBill();
        servicePayBillEntity.setStatus(Integer.valueOf(3));
        servicePayBillEntity.setAppCode(merchantConfig.getAppCode());
        servicePayBillEntity.setOrganName("");
        servicePayBillEntity.setWorkServiceCode("TXJH");
        servicePayBillEntity.setApplyCode(merchantConfig.getMerchantSeq());
        servicePayBillEntity.setPayChannel(payCallbackVo.getPayChannel());
        servicePayBillEntity.setTradeTime(payCallbackVo.getPayTime());
        servicePayBillEntity.setTradeNo(payCallbackVo.getTradeNo());
        servicePayBillEntity.setOutTradeNo(payCallbackVo.getOutTradeNo());
        servicePayBillEntity.setTradeStatus("SUCCESS");
        servicePayBillEntity.setOrderAmount(payCallbackVo.getTotalAmount());
        servicePayBillEntity.setDealAmount(payCallbackVo.getTotalAmount());
        servicePayBillEntity.setServiceCode(payCallbackVo.getServiceCode());
        servicePayBillEntity.setDealTradeNo(payCallbackVo.getDealTradeNo());
        log.info("\u652f\u4ed8\u8d26\u5355\u2014\u2014\u805a\u5408\u652f\u4ed8\u56de\u8c03\u6570\u636e\u4fdd\u5b58servicePayBillEntity\uff1a{}\uff1b", (Object)servicePayBillEntity);
        boolean save = this.servicePayBillService.save((Object)servicePayBillEntity);
        log.info("\u652f\u4ed8\u8d26\u5355\u4fdd\u5b58\u7ed3\u679c{}", (Object)save);
        OrderTrade orderTrade = (OrderTrade)this.orderTradeService.getOne((Wrapper)new LambdaQueryWrapper().eq(OrderTrade::getOutTradeNo, (Object)servicePayBillEntity.getOutTradeNo()));
        TOrder order = (TOrder)this.orderService.getById((Serializable)((Object)orderTrade.getOrderId()));
        OrderPayEvent orderPayEvent = new OrderPayEvent();
        BeanUtils.copyProperties((Object)order, (Object)orderPayEvent);
        this.eventManager.post((Object)orderPayEvent);
        order.setStatus(OrderEnum.IN_RENT.getStatus());
        this.orderService.updateById((Object)order);
        return BaseResponse.success((Object)"SUCCESS");
    }

    public BaseResponse<String> refund(RefundVo refundVo) {
        List orderTradeList = this.orderTradeService.list((Wrapper)new LambdaQueryWrapper().eq(OrderTrade::getOrderId, (Object)refundVo.getOrderId()));
        if (CollectionUtils.isEmpty((Collection)orderTradeList)) {
            log.info("\u8ba2\u5355{}\u7684order_trade\u8bb0\u5f55\u4e3a\u7a7a", (Object)refundVo.getOrderId());
            return BaseResponse.error((String)"FAIL");
        }
        ServiceMerchantConfig merchantConfig = (ServiceMerchantConfig)this.merchantConfigService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ServiceMerchantConfig::getAppCode, (Object)this.projProperties.getAppCode())).eq(ServiceMerchantConfig::getStatus, (Object)1));
        if (ObjectUtils.isEmpty((Object)merchantConfig)) {
            throw new RuntimeException("\u652f\u4ed8\u914d\u7f6e\u4e3a\u7a7a");
        }
        int size = orderTradeList.size();
        BigDecimal refundPrice = refundVo.getDeposit();
        String respStr = "";
        OrderTrade orderTrade = (OrderTrade)orderTradeList.get(0);
        String outTradeNo = orderTrade.getOutTradeNo();
        respStr = this.goRefund(merchantConfig, refundPrice, outTradeNo);
        if (null == respStr) {
            return BaseResponse.error((String)"FAIL");
        }
        String code = JSON.parseObject((String)respStr).getString("code");
        if (ReturnCodeEnum.SUCCEED.getValue().equals(code) && JSON.parseObject((String)respStr).getString("data") != null) {
            TOrder order = (TOrder)this.orderService.getById((Serializable)((Object)refundVo.getOrderId()));
            order.setStatus(OrderEnum.FINISHED.getStatus());
            this.orderService.updateById((Object)order);
            return BaseResponse.success((Object)JSON.parseObject((String)respStr).getString("data").toString());
        }
        return BaseResponse.error((String)JSON.parseObject((String)respStr).getString("msg"));
    }

    private String goRefund(ServiceMerchantConfig merchantConfig, BigDecimal refundPrice, String outTradeNo) {
        ServicePayBill servicePayBill = (ServicePayBill)this.servicePayBillService.getOne((Wrapper)new LambdaQueryWrapper().eq(ServicePayBill::getOutTradeNo, (Object)outTradeNo));
        if (ObjectUtils.isEmpty((Object)servicePayBill)) {
            log.info("\u652f\u4ed8\u8d26\u5355\u4e0d\u5b58\u5728,outTradeNo={}", (Object)outTradeNo);
            return null;
        }
        RefundHttpVo refundHttpVo = new RefundHttpVo();
        refundHttpVo.setPayChannel(servicePayBill.getPayChannel());
        refundHttpVo.setMchCode(servicePayBill.getApplyCode());
        refundHttpVo.setOutTradeNo(servicePayBill.getOutTradeNo());
        refundHttpVo.setDealTradeNo(servicePayBill.getDealTradeNo());
        refundHttpVo.setTotalAmount(servicePayBill.getOrderAmount());
        refundHttpVo.setRefundAmount(refundPrice);
        refundHttpVo.setNonceStr(pinyinUtil.getRandomString((int)32));
        refundHttpVo.setRefundNotifyUrl(this.projProperties.getPAY_REFUND_CALLBACK());
        refundHttpVo.setApplyCode(servicePayBill.getApplyCode());
        String[] str = new String[]{};
        Map map = SignUtil.getKeyAndValue((Object)refundHttpVo);
        String sign = SignUtil.createSign((Map)map, (String)merchantConfig.getApplyKey(), (String[])str);
        refundHttpVo.setSign(sign);
        String url = this.projProperties.getPAY_REFUND_HTTP();
        log.info("\u9000\u6b3e\u8bf7\u6c42url\u662f:{} http\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)refundHttpVo));
        String respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)refundHttpVo), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
        log.info("\u8d26\u5355\u4e3a{},\u9000\u6b3e\u8bf7\u6c42\u8fd4\u56de\u503c{}", (Object)outTradeNo, (Object)respStr);
        return respStr;
    }

    public BaseResponse<String> refundCallback(RefundCallbackVo refundCallbackVo) {
        log.info("\u9000\u6b3e\u56de\u8c03\u53c2\u6570{}", (Object)JSONObject.toJSONString((Object)refundCallbackVo));
        ServicePayBill refundBill = (ServicePayBill)this.servicePayBillService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ServicePayBill::getOutTradeNo, (Object)refundCallbackVo.getOutTradeNo())).eq(ServicePayBill::getStatus, (Object)6));
        if (!ObjectUtils.isEmpty((Object)refundBill)) {
            log.info("\u9000\u6b3e\u56de\u8c03\u91cd\u590d");
            return BaseResponse.success((Object)"SUCCESS");
        }
        ServiceMerchantConfig merchantConfig = (ServiceMerchantConfig)this.merchantConfigService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ServiceMerchantConfig::getApplyId, (Object)refundCallbackVo.getApplyId())).eq(ServiceMerchantConfig::getStatus, (Object)1));
        if (ObjectUtils.isEmpty((Object)merchantConfig)) {
            log.info("\u652f\u4ed8\u914d\u7f6e\u4e3a\u7a7a");
            return BaseResponse.error((String)"FAIL");
        }
        List servicePayBillList = this.servicePayBillService.list((Wrapper)new LambdaQueryWrapper().eq(ServicePayBill::getOutTradeNo, (Object)refundCallbackVo.getOutTradeNo()));
        if (CollectionUtils.isEmpty((Collection)servicePayBillList)) {
            log.info("\u9000\u6b3e\u56de\u8c03\u627e\u4e0d\u5230\u652f\u4ed8\u8d26\u5355outTradeNo={}", (Object)refundCallbackVo.getOutTradeNo());
            return BaseResponse.error((String)"FAIL");
        }
        Map map = SignUtil.getKeyAndValue((Object)refundCallbackVo);
        boolean bool = SignUtil.checkSign((Map)map, (String)merchantConfig.getApplyKey());
        if (!bool) {
            log.error("\u9000\u6b3e\u56de\u8c03\u9a8c\u7b7e\u5931\u8d25,\u56de\u8c03\u53c2\u6570{}", (Object)JSONObject.toJSONString((Object)refundCallbackVo));
            return BaseResponse.error((String)"FAIL");
        }
        ServicePayBill servicePayBill = (ServicePayBill)servicePayBillList.get(0);
        ServicePayBill refundPayBillEntity = new ServicePayBill();
        refundPayBillEntity.setStatus(Integer.valueOf(6));
        refundPayBillEntity.setRemark("");
        refundPayBillEntity.setAppCode(merchantConfig.getAppCode());
        refundPayBillEntity.setOrganName("");
        refundPayBillEntity.setWorkServiceCode("TXJH");
        refundPayBillEntity.setApplyCode(merchantConfig.getMerchantSeq());
        refundPayBillEntity.setPayChannel(refundCallbackVo.getPayChannel());
        refundPayBillEntity.setTradeTime(servicePayBill.getTradeTime());
        refundPayBillEntity.setTradeNo(servicePayBill.getTradeNo());
        refundPayBillEntity.setOutTradeNo(refundCallbackVo.getOutTradeNo());
        refundPayBillEntity.setTradeStatus("SUCCESS");
        refundPayBillEntity.setOrderAmount(refundCallbackVo.getTotalAmount());
        refundPayBillEntity.setDealAmount(refundCallbackVo.getTotalAmount());
        refundPayBillEntity.setRefundNo(refundCallbackVo.getRefundNo());
        refundPayBillEntity.setOutRefundNo(refundCallbackVo.getOutRefundNo());
        refundPayBillEntity.setRefundTime(refundCallbackVo.getRefundTime());
        refundPayBillEntity.setRefundAmount(refundCallbackVo.getRefundMoney());
        refundPayBillEntity.setServiceCode(refundCallbackVo.getServiceCode());
        refundPayBillEntity.setDealTradeNo(refundCallbackVo.getDealTradeNo());
        boolean save = this.servicePayBillService.save((Object)refundPayBillEntity);
        log.info("\u9000\u6b3e\u56de\u8c03\u4fdd\u5b58\u8d26\u5355\u7ed3\u679c{}", (Object)save);
        RefundEvent event = new RefundEvent();
        OrderTrade orderTrade = (OrderTrade)this.orderTradeService.getOne((Wrapper)new LambdaQueryWrapper().eq(OrderTrade::getOutTradeNo, (Object)refundCallbackVo.getOutTradeNo()));
        TOrder order = (TOrder)this.orderService.getById((Serializable)((Object)orderTrade.getOrderId()));
        event.setUserId(order.getUserId());
        event.setOrderId(order.getId());
        event.setPatientName(order.getPatientName());
        event.setAmount(refundCallbackVo.getRefundMoney());
        this.eventManager.post((Object)event);
        return BaseResponse.success((Object)"SUCCESS");
    }
}

