/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.nst.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.nst.server.mapper.TOrganInfoMapper;
import com.ebaiyihui.nst.server.pojo.dto.OrganInfoListPageDto;
import com.ebaiyihui.nst.server.pojo.dto.OrganListDto;
import com.ebaiyihui.nst.server.pojo.entity.TOrganInfo;
import com.ebaiyihui.nst.server.pojo.vo.OrganListPageVo;
import com.ebaiyihui.nst.server.pojo.vo.SaveOrganInfoVo;
import com.ebaiyihui.nst.server.service.TOrganInfoService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TOrganInfoServiceImpl
extends ServiceImpl<TOrganInfoMapper, TOrganInfo>
implements TOrganInfoService {
    private static final Logger log = LoggerFactory.getLogger(TOrganInfoServiceImpl.class);
    @Resource
    private TOrganInfoService tOrganInfoService;
    @Resource
    private TOrganInfoMapper tOrganInfoMapper;

    public BaseResponse<TOrganInfo> newOrganInfo(SaveOrganInfoVo saveOrganInfoVo) {
        if (StringUtils.isEmpty((CharSequence)saveOrganInfoVo.getId())) {
            Integer count = ((LambdaQueryChainWrapper)this.tOrganInfoService.lambdaQuery().eq(TOrganInfo::getOrganId, (Object)saveOrganInfoVo.getOrganId())).count();
            if (count > 0) {
                return BaseResponse.error((String)"\u533b\u9662\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
            }
            Integer num = ((LambdaQueryChainWrapper)this.tOrganInfoService.lambdaQuery().eq(TOrganInfo::getOrganName, (Object)saveOrganInfoVo.getOrganName())).count();
            if (num > 0) {
                return BaseResponse.error((String)"\u533b\u9662\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
            }
            TOrganInfo tOrganInfo = new TOrganInfo();
            BeanUtils.copyProperties((Object)saveOrganInfoVo, (Object)tOrganInfo);
            this.tOrganInfoService.save((Object)tOrganInfo);
            return BaseResponse.success((Object)tOrganInfo);
        }
        TOrganInfo tOrganInfo = this.tOrganInfoService.getByInfoId(saveOrganInfoVo.getId());
        System.out.println(tOrganInfo);
        if (tOrganInfo == null) {
            return BaseResponse.error((String)"\u672a\u627e\u5230\u533b\u9662\u4fe1\u606f");
        }
        Integer count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.tOrganInfoService.lambdaQuery().eq(TOrganInfo::getOrganId, (Object)saveOrganInfoVo.getOrganId())).ne(TOrganInfo::getId, (Object)saveOrganInfoVo.getId())).count();
        if (count > 0) {
            return BaseResponse.error((String)"\u533b\u9662\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
        }
        Integer num = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.tOrganInfoService.lambdaQuery().eq(TOrganInfo::getOrganName, (Object)saveOrganInfoVo.getOrganName())).ne(TOrganInfo::getId, (Object)saveOrganInfoVo.getId())).count();
        if (num > 0) {
            return BaseResponse.error((String)"\u533b\u9662\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
        }
        tOrganInfo.setOrganId(saveOrganInfoVo.getOrganId());
        tOrganInfo.setOrganName(saveOrganInfoVo.getOrganName());
        tOrganInfo.setDeposit(saveOrganInfoVo.getDeposit());
        tOrganInfo.setId(saveOrganInfoVo.getId());
        this.tOrganInfoService.updateById((Object)tOrganInfo);
        return BaseResponse.success((Object)tOrganInfo);
    }

    public BaseResponse<OrganInfoListPageDto> organInfoListByManager(OrganListPageVo organListPageVo) {
        OrganInfoListPageDto organInfoListPageDto = new OrganInfoListPageDto();
        Page organPage = new Page();
        organPage.setSize((long)organListPageVo.getPageSize().intValue());
        organPage.setCurrent((long)organListPageVo.getPageIndex().intValue());
        String search = organListPageVo.getSearch();
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)search)) {
            queryWrapper.and(wrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.like((Object)"organ_name", (Object)search)).or()).like((Object)"organ_id", (Object)search);
            });
        }
        queryWrapper.orderByDesc((Object)"update_time");
        Page page = (Page)this.page((IPage)organPage, (Wrapper)queryWrapper);
        List organInfoList = page.getRecords();
        ArrayList organListDtoList = new ArrayList();
        organInfoList.forEach(tOrganInfo -> {
            OrganListDto organListDto = new OrganListDto();
            BeanUtils.copyProperties((Object)tOrganInfo, (Object)organListDto);
            organListDtoList.add(organListDto);
        });
        organInfoListPageDto.setOrganListDtoList(organListDtoList);
        organInfoListPageDto.setPageIndex(organListPageVo.getPageIndex());
        organInfoListPageDto.setPageSize(organListPageVo.getPageSize());
        organInfoListPageDto.setPageNum(Integer.valueOf((int)page.getPages()));
        organInfoListPageDto.setTotal(Integer.valueOf((int)page.getTotal()));
        return BaseResponse.success((Object)organInfoListPageDto);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> deleteOrganInfo(Long id) {
        this.removeById((Serializable)id);
        return BaseResponse.success();
    }

    public TOrganInfo getByInfoId(String id) {
        return this.tOrganInfoMapper.getByInfoId(id);
    }
}

