/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.doctor.client;

import com.ebaiyihui.doctor.client.error.DoctorError;
import com.ebaiyihui.doctor.common.DoctorDetailInfoEntity;
import com.ebaiyihui.doctor.common.vo.DoctorListVo;
import com.ebaiyihui.doctor.common.vo.DoctorServiceRequest;
import com.ebaiyihui.framework.common.PageResult;
import com.ebaiyihui.framework.common.ResultInfo;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="service-doctor", fallback=DoctorError.class)
public interface DoctorDetailInfoClient {
    @PostMapping(value={"/api/v1/doctordetailinfo/save"})
    public ResultInfo saveDoctorDetailInfo(@RequestBody DoctorDetailInfoEntity var1);

    @PostMapping(value={"/api/v1/doctordetailinfo/savedetail"})
    public ResultInfo saveDetail(@RequestBody DoctorDetailInfoEntity var1);

    @GetMapping(value={"/api/v1/doctordetailinfo/{id}"})
    public ResultInfo<DoctorDetailInfoEntity> getDoctorDetailInfo(@PathVariable(value="id") Long var1);

    @GetMapping(value={"/api/v1/doctordetailinfo/primarykey/{id}"})
    public ResultInfo<DoctorDetailInfoEntity> getDoctorDetailInfoByPrimaryKey(@PathVariable(value="id") Long var1);

    @PostMapping(value={"/api/v1/doctordetailinfo/update"})
    public ResultInfo updateDoctorDetailInfo(@RequestBody DoctorDetailInfoEntity var1);

    @PostMapping(value={"/api/v1/doctordetailinfo/delete"})
    public ResultInfo deleteDoctorDetailInfo(@RequestParam(value="id", required=true) Long var1);

    @PostMapping(value={"/api/v1/doctordetailinfo/selectbydeptid"})
    public ResultInfo<Map<String, DoctorDetailInfoEntity>> selectBydeptId(@RequestParam(value="deptId", required=true) Long var1);

    @PostMapping(value={"/api/v1/doctordetailinfo/selectbyhospitalid"})
    public ResultInfo<List<DoctorDetailInfoEntity>> selectByHospitalId(@RequestParam(value="hospitalId", required=true) String var1);

    @PostMapping(value={"/api/v1/doctordetailinfo/selectbyidlist"})
    public ResultInfo<Map<String, DoctorDetailInfoEntity>> selectByIdList(@RequestBody List<String> var1);

    @PostMapping(value={"/api/v1/doctordetailinfo/selectbyprofession"})
    public ResultInfo<List<DoctorDetailInfoEntity>> selectByProfession(@RequestParam(value="hospitalId", required=true) Long var1);

    @PostMapping(value={"/api/v1/doctordetailinfo/select_deptnumbyhos"})
    public ResultInfo<Map<String, Map<String, Object>>> selectDeptNumByHos(@RequestParam(value="hospitalId", required=true) Long var1);

    @PostMapping(value={"/api/v1/doctordetailinfo/selectdoctor_byhosanddept"})
    public ResultInfo<List<DoctorDetailInfoEntity>> selectDoctorByHosAndDept(@RequestParam(value="hospitalId", required=true) Long var1, @RequestParam(value="hosDeptId", required=true) Long var2);

    @PostMapping(value={"/api/v1/doctordetailinfo//getlistbyids"})
    public ResultInfo<List<DoctorDetailInfoEntity>> getListByIds(@RequestBody List<Long> var1);

    @PostMapping(value={"/api/v1/doctordetailinfo/getdoctors"})
    public ResultInfo<List<DoctorDetailInfoEntity>> getDoctors(@RequestParam(value="serachParam", required=false) String var1, @RequestParam(value="loginUserId", required=true) Long var2);

    @PostMapping(value={"/api/v1/doctordetailinfo/selectdoctor_bydist"})
    public ResultInfo<PageResult<List<DoctorListVo>>> getByCondition(@RequestBody DoctorServiceRequest var1);

    @PostMapping(value={"/api/v1/doctordetailinfo/getdoctorcountlist"})
    public ResultInfo<Map<Long, Long>> getDoctorCountList(@RequestBody List<Long> var1);

    @PostMapping(value={"/api/v1/doctordetailinfo/offlineByHosId"})
    public ResultInfo<String> offlineByHosId(@RequestParam(value="hospitalId") Long var1);

    @PostMapping(value={"/api/v1/doctordetailinfo/onlineByHosId"})
    public ResultInfo<String> onlineByHosId(@RequestParam(value="hospitalId") Long var1);
}

