/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.feign;

import com.ebaiyihui.feign.error.OssFeignClientError;
import com.ebaiyihui.framework.common.ResultInfo;
import com.ebaiyihui.oss.common.model.OssFileEntity;
import java.io.InputStream;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@FeignClient(name="service-oss-server", fallbackFactory=OssFeignClientError.class)
@Component
public interface OssFeignClient {
    @PostMapping(value={"/api/file/store/v1/delete"})
    public ResultInfo<String> delete(@RequestParam(value="id", defaultValue="0") Long var1);

    @PostMapping(value={"/api/file/store/v1/save"}, consumes={"multipart/form-data"})
    public ResultInfo<OssFileEntity> save(@RequestParam(value="file") CommonsMultipartFile var1);

    @GetMapping(value={"/api/file/store/v1/detail/id/{id}"})
    public ResultInfo<OssFileEntity> detailById(@PathVariable(value="id") Long var1);

    @GetMapping(value={"/api/file/store/v1/detail/viewId/{viewId}"})
    public ResultInfo<OssFileEntity> detailByViewId(@PathVariable(value="viewId") String var1);

    @PostMapping(value={"/api/file/store/v1/update"}, consumes={"multipart/form-data"})
    public ResultInfo<OssFileEntity> updateOssFile(@RequestParam(value="id", defaultValue="0") Long var1, @RequestParam(value="file") CommonsMultipartFile var2);

    @PostMapping(value={"/api/file/store/v1/saveLargerFile"}, consumes={"multipart/form-data"})
    public ResultInfo<OssFileEntity> saveLargerFile(@RequestParam(value="file") CommonsMultipartFile var1);

    @PostMapping(value={"/api/file/store/v1/saveFiles"}, consumes={"multipart/form-data"})
    public ResultInfo<List<OssFileEntity>> saveFiles(@RequestParam(value="files") List<CommonsMultipartFile> var1);

    @GetMapping(value={"/api/file/store/v1/getListByOssFileIds"})
    public ResultInfo<List<OssFileEntity>> getListByOssFileIds(@RequestParam(value="ids", defaultValue="") String var1);

    @PostMapping(value={"/api/file/store/v1/uploadInputstream"})
    public ResultInfo<OssFileEntity> uploadInputStream(@RequestParam(value="inputstream") InputStream var1, @RequestParam(value="prex", defaultValue="") String var2);
}

