/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.referral.server.controller;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.service.referral.common.model.ReferralOrderEntity;
import com.ebaiyihui.service.referral.common.vo.MgrReferralInRecordAllResVo;
import com.ebaiyihui.service.referral.common.vo.MgrReferralOutRecordAllResVo;
import com.ebaiyihui.service.referral.common.vo.ReqMgrReferralInRecordVo;
import com.ebaiyihui.service.referral.common.vo.ReqMgrReferralOutRecordVo;
import com.ebaiyihui.service.referral.common.vo.ResPatientReferralRecordVo;
import com.ebaiyihui.service.referral.server.exception.DepartmentException;
import com.ebaiyihui.service.referral.server.exception.DoctorException;
import com.ebaiyihui.service.referral.server.exception.ReferralException;
import com.ebaiyihui.service.referral.server.service.DepartmentService;
import com.ebaiyihui.service.referral.server.service.DoctorService;
import com.ebaiyihui.service.referral.server.service.ReferralOrderService;
import com.ebaiyihui.service.referral.server.util.DigitalUtil;
import com.ebaiyihui.service.referral.server.util.FileUtils;
import com.ebaiyihui.service.referral.server.util.WordUtils;
import com.ebaiyihui.service.referral.server.vo.BaseReqVo;
import com.ebaiyihui.service.referral.server.vo.CreateReferralOrderReqVo;
import com.ebaiyihui.service.referral.server.vo.DoctorDetailsVO;
import com.ebaiyihui.service.referral.server.vo.ExportParamVo;
import com.ebaiyihui.service.referral.server.vo.HospitalInfoResVo;
import com.ebaiyihui.service.referral.server.vo.MgrReferralArrangementReq;
import com.ebaiyihui.service.referral.server.vo.MgrReferralRecordDetailResVo;
import com.ebaiyihui.service.referral.server.vo.OrganDeptInfoVO;
import com.ebaiyihui.service.referral.server.vo.OrganIdReq;
import com.ebaiyihui.service.referral.server.vo.PatientSignReqVo;
import com.ebaiyihui.service.referral.server.vo.ReferralOrderDetailForAppResVo;
import com.ebaiyihui.service.referral.server.vo.ReferralOrderListForAppDoctorReqVo;
import com.ebaiyihui.service.referral.server.vo.ReferralOrderListForAppDoctorResVo;
import com.ebaiyihui.service.referral.server.vo.ReferralOrderListForInWebDoctorReqVo;
import com.ebaiyihui.service.referral.server.vo.ReferralOrderListForOutWebDoctorReqVo;
import com.ebaiyihui.service.referral.server.vo.ReferralOrderListForWebDoctorResVo;
import com.ebaiyihui.service.referral.server.vo.ReqUpdateReferralStatusVo;
import com.ebaiyihui.service.referral.server.vo.SelectPatientRecordReqVo;
import com.ebaiyihui.service.referral.server.vo.UpdatePatientSignatureReqVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/referral/"})
@Api(tags={"\u8f6c\u8bca\u8ba2\u5355\u63a5\u53e3"})
public class ReferralOrderController {
    private static final Logger log = LoggerFactory.getLogger(ReferralOrderController.class);
    @Autowired
    private ReferralOrderService referralOrderService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private DoctorService doctorService;

    @PostMapping(value={"createReferralOrder"})
    @ApiOperation(value="\u521b\u5efa\u8f6c\u8bca\u5355")
    public BaseResponse<Long> createReferralOrder(@Valid @RequestBody CreateReferralOrderReqVo createReferralOrderReqVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        Long id = null;
        try {
            id = this.referralOrderService.createReferralOrder(createReferralOrderReqVo);
        }
        catch (ReferralException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        try {
            log.info("createReferralOrder\u52a0\u5bc6\u524d\u53c2\u6570\uff1a" + id);
            if (id != null) {
                id = DigitalUtil.encrypt((String)id.toString());
            }
            log.info("createReferralOrder\u52a0\u5bc6\u540e\u53c2\u6570\uff1a" + id);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return BaseResponse.success((Object)id);
    }

    @PostMapping(value={"getReferralOrderListForAppDoctor"})
    @ApiOperation(value="\u533b\u751fapp\u7aef\u67e5\u8be2\u8f6c\u8bca\u5355\u5217\u8868")
    public BaseResponse<List<ReferralOrderListForAppDoctorResVo>> getReferralOrderListForAppDoctor(@Valid @RequestBody ReferralOrderListForAppDoctorReqVo referralOrderListForAppDoctorReqVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        List list = this.referralOrderService.getReferralOrderListForAppDoctor(referralOrderListForAppDoctorReqVo);
        return BaseResponse.success((Object)list);
    }

    @PostMapping(value={"getReferralOrderDetailForApp"})
    @ApiOperation(value="app\u7aef\uff08\u533b\u751f\u60a3\u8005\u516c\u7528\uff09\u67e5\u8be2\u8f6c\u8bca\u5355\u8be6\u60c5")
    public BaseResponse<ReferralOrderDetailForAppResVo> getReferralOrderDetailForApp(@RequestParam String id) {
        if (id == null) {
            return BaseResponse.error((String)"\u5931\u8d25");
        }
        try {
            log.info("getReferralOrderDetailForApp\u89e3\u5bc6\u524d\u53c2\u6570\uff1a" + id);
            id = DigitalUtil.decrypt((String)id.toString()).toString();
            log.info("getReferralOrderDetailForApp\u89e3\u5bc6\u540e\u53c2\u6570\uff1a" + id);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        ReferralOrderDetailForAppResVo referralOrderListForApp = this.referralOrderService.getReferralOrderDetailForApp(id);
        return BaseResponse.success((Object)referralOrderListForApp);
    }

    @PostMapping(value={"patientSign"})
    @ApiOperation(value="\u533b\u751f\u7aef\u60a3\u8005\u7b7e\u7f72\u7b7e\u540d")
    public BaseResponse<String> patientSign(@Valid @RequestBody PatientSignReqVo patientSignReqVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        Long id = patientSignReqVo.getId();
        try {
            log.info("patientSign\u89e3\u5bc6\u524d\u53c2\u6570\uff1a" + id);
            id = DigitalUtil.decrypt((String)id.toString());
            log.info("patientSign\u89e3\u5bc6\u540e\u53c2\u6570\uff1a" + id);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        patientSignReqVo.setId(id);
        this.referralOrderService.patientSign(patientSignReqVo);
        return BaseResponse.success((Object)"\u66f4\u65b0\u6210\u529f");
    }

    @PostMapping(value={"rejectReferralOrder"})
    @ApiOperation(value="(app\u548cweb\u7aef\u5171\u7528)\u533b\u751f\u62d2\u7edd\u8f6c\u8bca\u5355")
    public BaseResponse<String> rejectReferralOrder(@RequestParam Long id) {
        if (id == null) {
            return BaseResponse.error((String)"\u5931\u8d25");
        }
        try {
            log.info("rejectReferralOrder\u89e3\u5bc6\u524d\u53c2\u6570\uff1a" + id);
            id = DigitalUtil.decrypt((String)id.toString());
            log.info("rejectReferralOrder\u89e3\u5bc6\u540e\u53c2\u6570\uff1a" + id);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        Long newId = this.referralOrderService.rejectReferralOrder(id);
        try {
            log.info("rejectReferralOrder\u52a0\u5bc6\u524d\uff1a" + newId);
            newId = DigitalUtil.encrypt((String)newId.toString());
            log.info("rejectReferralOrder\u52a0\u5bc6\u540e\uff1a" + newId);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return BaseResponse.success((Object)newId.toString());
    }

    @PostMapping(value={"getOutReferralOrderListForWebDoctor"})
    @ApiOperation(value="\u533b\u751fweb\u7aef\u8f6c\u51fa\u5355\u5217\u8868\u67e5\u8be2")
    public BaseResponse<ReferralOrderListForWebDoctorResVo> getOutReferralOrderListForWebDoctor(@Valid @RequestBody BaseReqVo<ReferralOrderListForOutWebDoctorReqVo> baseReqVo, BindingResult bindingResult) {
        ReferralOrderListForWebDoctorResVo outReferralOrderListForWebDoctor = this.referralOrderService.getOutReferralOrderListForWebDoctor(baseReqVo);
        return BaseResponse.success((Object)outReferralOrderListForWebDoctor);
    }

    @PostMapping(value={"getInReferralOrderListForWebDoctor"})
    @ApiOperation(value="\u533b\u751fweb\u7aef\u8f6c\u5165\u5355\u5217\u8868\u67e5\u8be2")
    public BaseResponse<ReferralOrderListForWebDoctorResVo> getInReferralOrderListForWebDoctor(@Valid @RequestBody BaseReqVo<ReferralOrderListForInWebDoctorReqVo> baseReqVo, BindingResult bindingResult) {
        ReferralOrderListForWebDoctorResVo outReferralOrderListForWebDoctor = this.referralOrderService.getInReferralOrderListForWebDoctor(baseReqVo);
        return BaseResponse.success((Object)outReferralOrderListForWebDoctor);
    }

    @ApiOperation(value="web\u7aef\u67e5\u8be2\u60a3\u8005\u8f6c\u8bca\u8be6\u60c5")
    @GetMapping(value={"getReferralROrderDetail"})
    public BaseResponse<MgrReferralRecordDetailResVo> getReferralROrderDetail(@RequestParam(value="id") Long id, @RequestHeader(value="doctorId", defaultValue="") String doctorId, @RequestHeader(value="app_channel", defaultValue="") String appChannel, @RequestHeader(value="channelSource", defaultValue="") String channelSource, @RequestParam(value="type", defaultValue="1") Integer type) {
        if (id == null || id.intValue() == 0) {
            return BaseResponse.error((String)"\u67e5\u8be2\u9519\u8bef\uff0cid\u4e3a\u7a7a");
        }
        try {
            log.info("getReferralROrderDetail\u89e3\u5bc6\u524d\u53c2\u6570\uff1a" + id);
            id = DigitalUtil.decrypt((String)id.toString());
            log.info("getReferralROrderDetail\u89e3\u5bc6\u540e\u53c2\u6570\uff1a" + id);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        Boolean flag = this.referralOrderService.judgeOneself(id, doctorId, appChannel, channelSource, type);
        if (!flag.booleanValue()) {
            return BaseResponse.error((String)"\u975e\u672c\u4eba\u8ba2\u5355");
        }
        MgrReferralRecordDetailResVo mgrReferralRecordDetailResVo = this.referralOrderService.getReferralROrderDetail(id);
        return BaseResponse.success((Object)mgrReferralRecordDetailResVo);
    }

    @ApiOperation(value="\u68c0\u67e5\u60a3\u8005\u662f\u5426\u5df2\u7ecf\u7b7e\u7f72\u8fc7\u7b7e\u540d\uff0c1\u7b7e\u7f72\u8fc7\uff0c0\u672a\u7b7e\u7f72")
    @GetMapping(value={"checkPatientHavaSign"})
    public BaseResponse<Integer> checkPatientHavaSign(@RequestParam(value="id") Long id) {
        if (id == null) {
            return BaseResponse.error((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            log.info("checkPatientHavaSign \u89e3\u5bc6\u524d\u53c2\u6570\uff1a" + id);
            id = DigitalUtil.decrypt((String)id.toString());
            log.info("checkPatientHavaSign \u89e3\u5bc6\u540e\u53c2\u6570\uff1a" + id);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        Integer flag = this.referralOrderService.checkPatientHavaSign(id);
        return BaseResponse.success((Object)flag);
    }

    @ApiOperation(value="\u83b7\u53d6\u60a3\u8005app\u7aef\u8f6c\u8bca\u8ba2\u5355\u5217\u8868")
    @PostMapping(value={"getPatientReferralRecord"})
    public BaseResponse<List<ResPatientReferralRecordVo>> getPatientAppReferralRecord(@Valid @RequestBody SelectPatientRecordReqVo selectPatientRecordReqVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        if (StringUtils.isBlank((String)selectPatientRecordReqVo.getPatientId())) {
            BaseResponse.success(new ArrayList());
        }
        List patientAppReferralRecordList = this.referralOrderService.getPatientReferralRecord(selectPatientRecordReqVo);
        patientAppReferralRecordList.forEach(e -> {
            Integer id = e.getReferralId();
            try {
                log.info("getReferralOrderListForAppDoctor\u52a0\u5bc6\u524dId\uff1a" + id);
                id = DigitalUtil.encrypt((String)id.toString()).intValue();
                log.info("getReferralOrderListForAppDoctor\u52a0\u5bc6\u540eId\uff1a" + id);
            }
            catch (Exception exception) {
                log.error(exception.getMessage());
            }
            e.setReferralId(id);
        });
        return BaseResponse.success((Object)patientAppReferralRecordList);
    }

    @ApiOperation(value="\u83b7\u53d6\u7ba1\u7406\u7aef\u8f6c\u51fa\u8ba2\u5355\u5217\u8868")
    @PostMapping(value={"getMgrReferralOutRecord"})
    public BaseResponse<MgrReferralOutRecordAllResVo> getMgrReferralOutRecord(@Valid @RequestBody ReqMgrReferralOutRecordVo reqMgrReferralOutRecordVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        log.info("\u8f93\u5165\u53c2\u6570\uff1a{}", (Object)reqMgrReferralOutRecordVo.toString());
        MgrReferralOutRecordAllResVo mgrReferralOutRecord = this.referralOrderService.getMgrReferralOutRecord(reqMgrReferralOutRecordVo);
        return BaseResponse.success((Object)mgrReferralOutRecord);
    }

    @ApiOperation(value="\u6839\u636e\u8ba2\u5355id\u66f4\u65b0\u8f6c\u8bca\u5355\u72b6\u6001")
    @PostMapping(value={"updateReferralStatus"})
    public BaseResponse updateReferralStatus(@Valid @RequestBody ReqUpdateReferralStatusVo reqUpdateReferralStatusVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        Long id = reqUpdateReferralStatusVo.getId();
        try {
            log.info("updateReferralStatus \u89e3\u5bc6\u524d\u53c2\u6570\uff1a" + id);
            id = DigitalUtil.decrypt((String)id.toString());
            log.info("updateReferralStatus \u89e3\u5bc6\u540e\u53c2\u6570\uff1a" + id);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        reqUpdateReferralStatusVo.setId(id);
        this.referralOrderService.updateReferralStatus(reqUpdateReferralStatusVo);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u83b7\u53d6\u7ba1\u7406\u7aef\u8f6c\u5165\u8ba2\u5355\u5217\u8868")
    @PostMapping(value={"getMgrReferralInRecord"})
    public BaseResponse<MgrReferralInRecordAllResVo> getMgrReferralInRecord(@Valid @RequestBody ReqMgrReferralInRecordVo reqMgrReferralInRecordVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        log.info("\u8f93\u5165\u53c2\u6570\uff1a{}", (Object)reqMgrReferralInRecordVo.toString());
        MgrReferralInRecordAllResVo mgrReferralInRecordAllResVo = this.referralOrderService.getMgrReferralInRecord(reqMgrReferralInRecordVo);
        return BaseResponse.success((Object)mgrReferralInRecordAllResVo);
    }

    @ApiOperation(value="\u8f6c\u8bca\u5355\u5bfc\u51fa")
    @PostMapping(value={"exportReferralApplyOrderWord"})
    public void exportReferralApplyOrderWord(@RequestBody ExportParamVo exportParamVo, HttpServletResponse response, @RequestHeader(value="doctorId", defaultValue="") String doctorId) {
        Long id = exportParamVo.getId();
        if (id != null) {
            try {
                log.info("exportReferralApplyOrderWord \u89e3\u5bc6\u524d\u53c2\u6570\uff1a" + id);
                id = DigitalUtil.decrypt((String)id.toString());
                log.info("exportReferralApplyOrderWord \u89e3\u5bc6\u540e\u53c2\u6570\uff1a" + id);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        this.referralOrderService.exportReferralApplyOrderWord(id, response);
    }

    @ApiOperation(value="\u8f6c\u8bca\u5355\u5bfc\u51fa")
    @PostMapping(value={"exportReferralApplyOrderZip"})
    public void exportReferralApplyOrderZip(@RequestBody ExportParamVo exportParamVo, HttpServletResponse response, @RequestHeader(value="doctorId", defaultValue="") String doctorId) {
        List idList = exportParamVo.getIdList();
        ArrayList newIdList = new ArrayList();
        idList.forEach(e -> {
            Long id = e;
            Boolean flag = true;
            try {
                log.info("exportReferralApplyOrderZip \u89e3\u5bc6\u524d\u53c2\u6570\uff1a" + id);
                id = DigitalUtil.decrypt((String)id.toString());
                log.info("exportReferralApplyOrderZip \u89e3\u5bc6\u540e\u53c2\u6570\uff1a" + id);
            }
            catch (Exception exception) {
                log.error(exception.getMessage());
            }
            newIdList.add(id);
        });
        this.referralOrderService.exportReferralApplyOrderZip(newIdList, response);
    }

    @ApiOperation(value="\u4fdd\u5b58\u60a3\u8005\u7b7e\u540d")
    @PostMapping(value={"savePatientSignature"})
    public BaseResponse savePatientSignature(@Valid @RequestBody UpdatePatientSignatureReqVo updatePatientSignatureReqVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        Long id = updatePatientSignatureReqVo.getId();
        try {
            log.info("savePatientSignature \u89e3\u5bc6\u524d\u53c2\u6570\uff1a" + id);
            id = DigitalUtil.decrypt((String)id.toString());
            log.info("savePatientSignature \u89e3\u5bc6\u540e\u53c2\u6570\uff1a" + id);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        updatePatientSignatureReqVo.setId(id);
        this.referralOrderService.updatePatientSignature(updatePatientSignatureReqVo);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u7ba1\u7406\u7aef\u8f6c\u8bca\u5b89\u6392")
    @PostMapping(value={"MgrReferralArrangement"})
    public BaseResponse MgrReferralArrangement(@Valid @RequestBody MgrReferralArrangementReq mgrReferralArrangementReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        Long id = mgrReferralArrangementReq.getId();
        try {
            log.info("MgrReferralArrangement \u89e3\u5bc6\u524d\u53c2\u6570\uff1a" + id);
            id = DigitalUtil.decrypt((String)id.toString());
            log.info("MgrReferralArrangement \u89e3\u5bc6\u540e\u53c2\u6570\uff1a" + id);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        mgrReferralArrangementReq.setId(id);
        this.referralOrderService.updateArrangement(mgrReferralArrangementReq);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u5bfc\u51fa\u77e5\u60c5\u540c\u610f\u4e66")
    @PostMapping(value={"exportInformedConsent"})
    public void exportInformedConsent(@RequestBody ExportParamVo exportParamVo, HttpServletResponse response) {
        String receiveHospitalName = exportParamVo.getReceiveHospitalName();
        try {
            receiveHospitalName = URLDecoder.decode(receiveHospitalName, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String path = this.getClass().getClassLoader().getResource("application.yml").getPath();
        log.info("path: " + path);
        String wordPath = FileUtils.getPath((String)path, (String)"word/");
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("receiveHospitalName", receiveHospitalName);
        String informedConsentPath = "template/informedConsent.docx";
        WordUtils.exportWord((String)informedConsentPath, (String)wordPath, (String)"\u53cc\u5411\u8f6c\u8bca\u77e5\u60c5\u540c\u610f\u4e66.docx", param, (HttpServletResponse)response);
    }

    @ApiOperation(value="\u7ba1\u7406\u7aef\u8f6c\u51fa\u8ba2\u5355\u6279\u91cf\u5bfc\u51faExcel")
    @GetMapping(value={"exportReferralOutRecord"})
    public void exportReferralOutRecord(@RequestParam List<Long> idList, HttpServletResponse response) {
        this.referralOrderService.exportReferralExcel(idList, response);
    }

    @ApiOperation(value="\u7ba1\u7406\u7aef\u8f6c\u5165\u8ba2\u5355\u6279\u91cf\u5bfc\u51faExcel")
    @PostMapping(value={"exportReferralInExcel"})
    public void exportReferralInExcel(@RequestBody ExportParamVo exportParamVo, HttpServletResponse response) {
        List idList = exportParamVo.getIdList();
        this.referralOrderService.exportReferralExcel(idList, response);
    }

    @ApiOperation(value="\u7ba1\u7406\u7aef\u5df2\u62d2\u7edd\u8fc7\u8be5\u5355\u7684\u6240\u6709\u533b\u751fid")
    @GetMapping(value={"getRejectDoctors"})
    public BaseResponse<List<String>> getRejectDoctors(@RequestParam(value="id") Long id) {
        if (id == null) {
            return BaseResponse.error((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            log.info("getRejectDoctors \u89e3\u5bc6\u524d\u53c2\u6570\uff1a" + id);
            id = DigitalUtil.decrypt((String)id.toString());
            log.info("getRejectDoctors \u89e3\u5bc6\u540e\u53c2\u6570\uff1a" + id);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        List rejectDoctors = this.referralOrderService.getRejectDoctors(id);
        return BaseResponse.success((Object)rejectDoctors);
    }

    @ApiOperation(value="\u6839\u636e\u533b\u9662\u67e5\u51fa\u6240\u6709\u79d1\u5ba4\u5217\u8868")
    @PostMapping(value={"getListOrganDept"})
    public BaseResponse<List<OrganDeptInfoVO>> getListOrganDept(@Valid @RequestBody OrganIdReq organIdReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        List organDeptInfoVOList = null;
        try {
            organDeptInfoVOList = this.departmentService.listOrganDept(organIdReq);
        }
        catch (DepartmentException e) {
            BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)organDeptInfoVOList);
    }

    @ApiOperation(value="\u67e5\u8be2\u533b\u9662\u79d1\u5ba4\u533b\u751f,\u7b5b\u9009\u8fc7\u5df2\u62d2\u7edd\u5f53\u524d\u5355\u5b50\u7684\u533b\u751f")
    @GetMapping(value={"getDepartmentDoctor"})
    public BaseResponse<List<DoctorDetailsVO>> getDepartmentDoctor(@RequestParam String appCode, @RequestParam Integer deptId, @RequestParam(value="id") Long id) {
        List departmentDoctor = null;
        if (StringUtils.isBlank((String)appCode)) {
            BaseResponse.error((String)"\u67e5\u8be2\u9519\u8bef\uff0cappCode\u4e3a\u7a7a");
        }
        if (null == deptId) {
            BaseResponse.error((String)"\u67e5\u8be2\u9519\u8bef\uff0cdeptId\u4e3a\u7a7a");
        }
        if (null == id) {
            BaseResponse.error((String)"\u67e5\u8be2\u9519\u8bef\uff0cid\u4e3a\u7a7a");
        }
        try {
            log.info("getDepartmentDoctor \u89e3\u5bc6\u524d\u53c2\u6570\uff1a" + id);
            id = DigitalUtil.decrypt((String)id.toString());
            log.info("getDepartmentDoctor \u89e3\u5bc6\u540e\u53c2\u6570\uff1a" + id);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        try {
            departmentDoctor = this.doctorService.getDepartmentDoctor(appCode, deptId, id);
        }
        catch (DoctorException e) {
            BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)departmentDoctor);
    }

    @ApiOperation(value="\u67e5\u8be2\u533b\u9662\u79d1\u5ba4\u533b\u751f,\u533b\u751f\u4e0b\u5355\u65f6\u5019\u4f7f\u7528")
    @GetMapping(value={"getDepartmentDoctorForCreateOrder"})
    public BaseResponse<List<DoctorDetailsVO>> getDepartmentDoctorForCreateOrder(@RequestParam String appCode, @RequestParam Integer deptId) {
        List departmentDoctor = null;
        if (StringUtils.isBlank((String)appCode)) {
            BaseResponse.error((String)"\u67e5\u8be2\u9519\u8bef\uff0cappCode\u4e3a\u7a7a");
        }
        if (null == deptId) {
            BaseResponse.error((String)"\u67e5\u8be2\u9519\u8bef\uff0cdeptId\u4e3a\u7a7a");
        }
        try {
            departmentDoctor = this.doctorService.getDepartmentDoctorForCreateOrder(appCode, deptId);
        }
        catch (DoctorException e) {
            BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)departmentDoctor);
    }

    @ApiOperation(value="\u7ba1\u7406\u5458\u7aef\u67e5\u8be2 \u63a5\u6536\u673a\u6784 \u7b5b\u9009\u6761\u4ef6")
    @GetMapping(value={"getReceiveHospitalList"})
    public BaseResponse<List<HospitalInfoResVo>> getReceiveHospitalList(@RequestParam String appCode, @RequestParam String userId) {
        List hospitalInfoResVoList = this.referralOrderService.getReceiveHospitalList(appCode, userId);
        return BaseResponse.success((Object)hospitalInfoResVoList);
    }

    @ApiOperation(value="\u7ba1\u7406\u5458\u7aef\u67e5\u8be2 \u53d1\u8d77\u673a\u6784 \u7b5b\u9009\u6761\u4ef6")
    @GetMapping(value={"getLaunchHospitalList"})
    public BaseResponse<List<HospitalInfoResVo>> getLaunchHospitalList(@RequestParam String appCode, @RequestParam String userId) {
        List hospitalInfoResVoList = this.referralOrderService.getLaunchHospitalList(appCode, userId);
        return BaseResponse.success((Object)hospitalInfoResVoList);
    }

    @ApiOperation(value="\u6570\u636e\u5e93\u76d1\u63a7")
    @GetMapping(value={"check_health"})
    public BaseResponse monitoring() {
        ReferralOrderEntity referralOrderEntity = this.referralOrderService.getOneContent();
        return BaseResponse.success();
    }
}

