/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.referral.server.rabbitmq;

import com.ebaiyihui.service.referral.common.model.ReferralOrderEntity;
import com.ebaiyihui.service.referral.server.enums.ReferralStatusEnum;
import com.ebaiyihui.service.referral.server.service.ReferralOrderService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DelayedRefferalOrderReceiver {
    private static final Logger log = LoggerFactory.getLogger(DelayedRefferalOrderReceiver.class);
    @Autowired
    private ReferralOrderService referralOrderService;

    @RabbitListener(queues={"referral.delayed.order"})
    @RabbitHandler
    public void process(String id) {
        log.info("Fetch referral info from rabbit mq\uff1a " + id);
        ReferralOrderEntity referralOrderEntity = this.referralOrderService.getById(Long.valueOf(Long.parseLong(id)));
        if (null == referralOrderEntity) {
            log.info("Fetch referral info from rabbit mq:->\u67e5\u8be2\u8f6c\u8bca\u5355\u4e3a\u7a7a");
            return;
        }
        if (ReferralStatusEnum.TO_BE_SIGNED.getValue() == referralOrderEntity.getReferralStatus()) {
            log.info("\u8d85\u65f6\u672a\u7b7e\u7f72\u81ea\u52a8\u53d6\u6d88 ->" + id);
            referralOrderEntity.setReferralStatus(ReferralStatusEnum.ALREADY_CANCEL.getValue());
            referralOrderEntity.setUpdateTime(new Date());
            this.referralOrderService.update(referralOrderEntity);
            log.info("\u8d85\u65f6\u672a\u7b7e\u7f72\u81ea\u52a8\u53d6\u6d88 ->\u6210\u529f\uff01");
        }
    }
}

