/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.referral.server.rabbitmq;

import java.util.HashMap;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.CustomExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RabbitMqConfig {
    public static final String DELAYED_QUEUE_NAME = "referral.delayed.order";
    public static final String EXCHANGE_NAME = "referral_delayed_exchange";
    public static final String DELAY_ORDER_ROUTING_KEY = "referral_delay_order_routing_key";

    @Bean
    public Queue queue() {
        return new Queue(DELAYED_QUEUE_NAME);
    }

    @Bean
    CustomExchange customExchange() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("x-delayed-type", "direct");
        return new CustomExchange(EXCHANGE_NAME, "x-delayed-message", true, false, args);
    }

    @Bean
    Binding binding() {
        return BindingBuilder.bind((Queue)this.queue()).to((Exchange)this.customExchange()).with(DELAY_ORDER_ROUTING_KEY).noargs();
    }
}

