/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.referral.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.service.referral.server.config.RemoteUrls;
import com.ebaiyihui.service.referral.server.exception.DoctorException;
import com.ebaiyihui.service.referral.server.service.DoctorService;
import com.ebaiyihui.service.referral.server.service.ReferralOrderService;
import com.ebaiyihui.service.referral.server.util.HttpKit;
import com.ebaiyihui.service.referral.server.vo.BaseDTO;
import com.ebaiyihui.service.referral.server.vo.DoctorDetailsVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DoctorServiceImpl
implements DoctorService {
    private static final Logger log = LoggerFactory.getLogger(DoctorServiceImpl.class);
    @Autowired
    private ReferralOrderService referralOrderService;
    private String queryUrl = "/basedata/organization/list/doctor";
    private String serviceCode = "sxzz";
    @Autowired
    private RemoteUrls remoteUrls;

    public List<DoctorDetailsVO> getDepartmentDoctor(String appCode, Integer id, Long referralId) throws DoctorException {
        BaseResponse baseResponse = null;
        List<DoctorDetailsVO> doctorDetailsVOList = new ArrayList();
        BaseDTO baseDTO = new BaseDTO();
        baseDTO.setId(id);
        baseDTO.setCode(this.serviceCode);
        try {
            log.info("getDepartmentDoctor->\u67e5\u8be2\u533b\u9662\u79d1\u5ba4\u533b\u751f,\u67e5\u8be2\u53c2\u6570\u4e3a:appCode: {},deptId :{}", (Object)appCode, (Object)id);
            String body = HttpKit.jsonPost((String)(this.remoteUrls.getRootUrl() + appCode + this.queryUrl), (String)JSON.toJSONString((Object)baseDTO));
            baseResponse = (BaseResponse)JSON.parseObject((String)body, BaseResponse.class);
            doctorDetailsVOList = JSON.parseArray((String)JSON.toJSONString((Object)baseResponse.getData()), DoctorDetailsVO.class);
            log.info("\u8c03\u7528\u533b\u751f\u670d\u52a1\u67e5\u8be2\u5230\u7684\u6570\u636e\u4e3a:{}", (Object)doctorDetailsVOList.toString());
        }
        catch (Exception e2) {
            log.error("getDepartmentDoctor->\u67e5\u8be2\u533b\u9662\u79d1\u5ba4\u533b\u751f\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a{}", (Throwable)e2);
            throw new DoctorException("\u67e5\u8be2\u533b\u9662\u79d1\u5ba4\u533b\u751f\u5f02\u5e38");
        }
        List rejectDoctorIdList = this.referralOrderService.getRejectDoctors(referralId);
        log.info("\u67e5\u8be2\u6240\u6709\u62d2\u7edd\u8fc7\u5f53\u524d\u5355\u5b50\u7684\u533b\u751fid\uff0c\u5f53\u524d\u5355\u5b50\u7684id\u4e3a:{},\u62d2\u7edd\u8fc7\u8be5\u5355\u5b50\u7684\u533b\u751fid\u4e3a:{}", (Object)referralId.toString(), (Object)rejectDoctorIdList.toString());
        if (!CollectionUtils.isEmpty((Collection)rejectDoctorIdList)) {
            List<DoctorDetailsVO> doctorEntitys = doctorDetailsVOList.stream().filter(e -> !rejectDoctorIdList.contains(e.getDoctorCode())).collect(Collectors.toList());
            return doctorEntitys;
        }
        return doctorDetailsVOList;
    }

    public List<DoctorDetailsVO> getDepartmentDoctorForCreateOrder(String appCode, Integer id) throws DoctorException {
        BaseResponse baseResponse = null;
        ArrayList<DoctorDetailsVO> doctorDetailsVOList = new ArrayList();
        BaseDTO baseDTO = new BaseDTO();
        baseDTO.setId(id);
        baseDTO.setCode(this.serviceCode);
        try {
            log.info("getDepartmentDoctorForCreateOrder->\u67e5\u8be2\u533b\u9662\u79d1\u5ba4\u533b\u751f,\u67e5\u8be2\u53c2\u6570\u4e3a:appCode: {},deptId :{}", (Object)appCode, (Object)id);
            String body = HttpKit.jsonPost((String)(this.remoteUrls.getRootUrl() + appCode + this.queryUrl), (String)JSON.toJSONString((Object)baseDTO));
            baseResponse = (BaseResponse)JSON.parseObject((String)body, BaseResponse.class);
            doctorDetailsVOList = JSON.parseArray((String)JSON.toJSONString((Object)baseResponse.getData()), DoctorDetailsVO.class);
        }
        catch (Exception e) {
            log.error("getDepartmentDoctorForCreateOrder->\u67e5\u8be2\u533b\u9662\u79d1\u5ba4\u533b\u751f\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a{}", (Throwable)e);
            throw new DoctorException("\u67e5\u8be2\u533b\u9662\u79d1\u5ba4\u533b\u751f\u5f02\u5e38");
        }
        return doctorDetailsVOList;
    }
}

