/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.referral.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.service.referral.common.model.ReferralOrderEntity;
import com.ebaiyihui.service.referral.common.model.ReferralPictureInfoEntity;
import com.ebaiyihui.service.referral.common.vo.MgrReferralInRecordAllResVo;
import com.ebaiyihui.service.referral.common.vo.MgrReferralOutRecordAllResVo;
import com.ebaiyihui.service.referral.common.vo.MgrReferralRecordCountResVo;
import com.ebaiyihui.service.referral.common.vo.ReqMgrReferralInRecordVo;
import com.ebaiyihui.service.referral.common.vo.ReqMgrReferralOutRecordVo;
import com.ebaiyihui.service.referral.common.vo.ResMgrReferralInRecordVo;
import com.ebaiyihui.service.referral.common.vo.ResMgrReferralOutRecordVo;
import com.ebaiyihui.service.referral.common.vo.ResPatientReferralRecordVo;
import com.ebaiyihui.service.referral.server.config.RemoteUrls;
import com.ebaiyihui.service.referral.server.enums.ChannelEnum;
import com.ebaiyihui.service.referral.server.enums.FeeTypeEnum;
import com.ebaiyihui.service.referral.server.enums.ItemTypeCodeEnum;
import com.ebaiyihui.service.referral.server.enums.PatientGenderEnum;
import com.ebaiyihui.service.referral.server.enums.PatientSignatureTypeEnum;
import com.ebaiyihui.service.referral.server.enums.ReferralProjectEnum;
import com.ebaiyihui.service.referral.server.enums.ReferralStatusEnum;
import com.ebaiyihui.service.referral.server.enums.ReferralTypeEnum;
import com.ebaiyihui.service.referral.server.enums.RejectStatusEnum;
import com.ebaiyihui.service.referral.server.enums.RemoteConsultationEnum;
import com.ebaiyihui.service.referral.server.enums.StatusEnum;
import com.ebaiyihui.service.referral.server.exception.ReferralException;
import com.ebaiyihui.service.referral.server.mapper.ReferralOrderMapper;
import com.ebaiyihui.service.referral.server.mapper.ReferralPictureInfoMapper;
import com.ebaiyihui.service.referral.server.service.ReferralOrderService;
import com.ebaiyihui.service.referral.server.service.impl.GoeasyServiceImpl;
import com.ebaiyihui.service.referral.server.service.impl.UmAndroidPushServiceImpl;
import com.ebaiyihui.service.referral.server.service.impl.UmIosPushServiceImpl;
import com.ebaiyihui.service.referral.server.service.remotecall.CloudUserScopeService;
import com.ebaiyihui.service.referral.server.service.remotecall.RemoteConsultationService;
import com.ebaiyihui.service.referral.server.service.remotecall.UserCenterService;
import com.ebaiyihui.service.referral.server.util.CommonUtil;
import com.ebaiyihui.service.referral.server.util.DigitalUtil;
import com.ebaiyihui.service.referral.server.util.ExcelUtils;
import com.ebaiyihui.service.referral.server.util.FileUtils;
import com.ebaiyihui.service.referral.server.util.HttpUtils;
import com.ebaiyihui.service.referral.server.util.RabbitMqUtils;
import com.ebaiyihui.service.referral.server.util.SnowflakeIdWorker;
import com.ebaiyihui.service.referral.server.util.WordUtils;
import com.ebaiyihui.service.referral.server.util.ZipUtils;
import com.ebaiyihui.service.referral.server.vo.AssayDataResVo;
import com.ebaiyihui.service.referral.server.vo.AssayDataVo;
import com.ebaiyihui.service.referral.server.vo.BaseReqVo;
import com.ebaiyihui.service.referral.server.vo.CaseDataResVo;
import com.ebaiyihui.service.referral.server.vo.CaseInformationVo;
import com.ebaiyihui.service.referral.server.vo.CreateReferralOrderReqVo;
import com.ebaiyihui.service.referral.server.vo.DcomVo;
import com.ebaiyihui.service.referral.server.vo.DoctorAdviceVo;
import com.ebaiyihui.service.referral.server.vo.DoctorReferralRecordCountResVo;
import com.ebaiyihui.service.referral.server.vo.HealthPlanResVo;
import com.ebaiyihui.service.referral.server.vo.HospitalInfoReqVo;
import com.ebaiyihui.service.referral.server.vo.HospitalInfoResVo;
import com.ebaiyihui.service.referral.server.vo.MedicalInformationResVo;
import com.ebaiyihui.service.referral.server.vo.MgrReferralArrangementReq;
import com.ebaiyihui.service.referral.server.vo.MgrReferralCaseInfoResVo;
import com.ebaiyihui.service.referral.server.vo.MgrReferralExcel;
import com.ebaiyihui.service.referral.server.vo.MgrReferralInfoResVo;
import com.ebaiyihui.service.referral.server.vo.MgrReferralNoteResVo;
import com.ebaiyihui.service.referral.server.vo.MgrReferralRecordDetailResVo;
import com.ebaiyihui.service.referral.server.vo.OperationRecordVo;
import com.ebaiyihui.service.referral.server.vo.OrganizationResVO;
import com.ebaiyihui.service.referral.server.vo.PatientSignReqVo;
import com.ebaiyihui.service.referral.server.vo.RecoveryPlanVo;
import com.ebaiyihui.service.referral.server.vo.ReferralOrderDetailForAppResVo;
import com.ebaiyihui.service.referral.server.vo.ReferralOrderListForAppDoctor;
import com.ebaiyihui.service.referral.server.vo.ReferralOrderListForAppDoctorReqVo;
import com.ebaiyihui.service.referral.server.vo.ReferralOrderListForAppDoctorResVo;
import com.ebaiyihui.service.referral.server.vo.ReferralOrderListForInWebDoctorReqVo;
import com.ebaiyihui.service.referral.server.vo.ReferralOrderListForOutWebDoctorReqVo;
import com.ebaiyihui.service.referral.server.vo.ReferralOrderListForWebDoctorResVo;
import com.ebaiyihui.service.referral.server.vo.ReferralOrderResForDoctorWebVo;
import com.ebaiyihui.service.referral.server.vo.ReferralOrderResVo;
import com.ebaiyihui.service.referral.server.vo.ReqUpdateReferralStatusVo;
import com.ebaiyihui.service.referral.server.vo.SelectPatientRecordReqVo;
import com.ebaiyihui.service.referral.server.vo.SurgicalRecordResVo;
import com.ebaiyihui.service.referral.server.vo.TransferReqVo;
import com.ebaiyihui.service.referral.server.vo.TransferResVo;
import com.ebaiyihui.service.referral.server.vo.UpdatePatientSignatureReqVo;
import com.ebaiyihui.service.referral.server.vo.VideoMaterialResVo;
import com.ebaiyihui.service.referral.server.vo.VideoMaterialVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ReferralOrderServiceImpl
implements ReferralOrderService {
    private static final Logger log = LoggerFactory.getLogger(ReferralOrderServiceImpl.class);
    public static final Integer REJECT = 1;
    public static final Integer AREADY_SIGNED = 1;
    public static final Integer TO_BE_SIGN = 0;
    public static final Integer CHANGE_INTO = 2;
    public static final Integer CHANGE_OUT = 1;
    public static final Integer ONE = 1;
    public static final Integer TWO = 2;
    public static final String All_ORGANCODE_HOSPITAL_ID = "-1";
    @Autowired
    private ReferralOrderMapper referralOrderMapper;
    @Autowired
    private ReferralPictureInfoMapper referralPictureInfoMapper;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private RemoteConsultationService remoteConsultationService;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private UserCenterService useCenterService;
    @Autowired
    private RemoteUrls remoteUrls;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private CloudUserScopeService cloudUserScopeService;
    @Autowired
    private GoeasyServiceImpl goeasyService;
    @Autowired
    private UmAndroidPushServiceImpl umAndroidPushService;
    @Autowired
    private UmIosPushServiceImpl umIosPushService;

    public Long save(ReferralOrderEntity referralOrderEntity) {
        log.info("\u8f6c\u8bca\u8ba2\u5355\u7684\u4fdd\u5b58\u5185\u5bb9\uff1a{}", (Object)referralOrderEntity.toString());
        this.referralOrderMapper.insert((Object)referralOrderEntity);
        return referralOrderEntity.getId();
    }

    public void update(ReferralOrderEntity referralOrderEntity) {
        log.info("\u8f6c\u8bca\u8ba2\u5355\u7684\u66f4\u65b0\u5185\u5bb9\uff1a{}", (Object)referralOrderEntity.toString());
        this.referralOrderMapper.updateById((Object)referralOrderEntity);
    }

    public ReferralOrderEntity getById(Long id) {
        log.info("\u8f6c\u8bca\u8ba2\u5355\u7684\u67e5\u8be2id\uff1a{}", (Object)id);
        return (ReferralOrderEntity)this.referralOrderMapper.selectById((Serializable)id);
    }

    public void deleteById(Long id) {
        log.info("\u8f6c\u8bca\u8ba2\u5355\u7684\u5220\u9664id\uff1a{}", (Object)id);
        this.referralOrderMapper.deleteById((Serializable)id);
    }

    public List<ResPatientReferralRecordVo> getPatientReferralRecord(SelectPatientRecordReqVo selectPatientRecordReqVo) {
        log.info("\u67e5\u8be2\u8f6c\u8bca\u8ba2\u5355\u7684\u60a3\u8005id:{},appCode:{}", (Object)selectPatientRecordReqVo.toString());
        List patientReferralRecordList = this.referralOrderMapper.getPatientReferralRecord(selectPatientRecordReqVo);
        log.info("\u67e5\u8be2\u60a3\u8005\u5217\u8868\u7ed3\u679c\uff0c\u603b\u6570\u4e3a:{},\u6bcf\u6761\u4e3a:{}====", (Object)patientReferralRecordList.size(), (Object)patientReferralRecordList.toString());
        return patientReferralRecordList;
    }

    public MgrReferralOutRecordAllResVo getMgrReferralOutRecord(ReqMgrReferralOutRecordVo reqMgrReferralOutRecordVo) {
        log.info("\u8f93\u5165\u53c2\u6570\u7684\u5185\u5bb9\uff1a{}", (Object)reqMgrReferralOutRecordVo.toString());
        BaseResponse cloudUserScope = this.cloudUserScopeService.getCloudUserScope(reqMgrReferralOutRecordVo.getUserId(), reqMgrReferralOutRecordVo.getAppCode());
        log.info("\u901a\u8fc7\u7ba1\u7406\u5458id\u8fd4\u56de\u8be5\u7ba1\u7406\u5458\u4e0b\u6240\u6709\u533b\u9662id\uff1a{}", (Object)cloudUserScope.toString());
        String data = (String)cloudUserScope.getData();
        log.info("\u901a\u8fc7\u7ba1\u7406\u5458id\u8fd4\u56de\u8be5\u7ba1\u7406\u5458\u4e0b\u6240\u6709\u533b\u9662id\uff1a{}", (Object)data.toString());
        if (null != data && !All_ORGANCODE_HOSPITAL_ID.equals(data)) {
            log.info("===========\u6743\u9650\u4e0d\u4e3a-1==========");
            String[] idArray = data.split(",");
            ArrayList<String> idList = new ArrayList<String>(Arrays.asList(idArray));
            reqMgrReferralOutRecordVo.setIds(idList);
        } else {
            log.info("===========\u6743\u9650\u4e3a-1==========");
            List organizationResVOList = this.getNodeOrganInfos(reqMgrReferralOutRecordVo.getAppCode());
            log.info("\u8f6c\u51fa\u8ba2\u5355\u5217\u8868\u83b7\u53d6\u5168\u90e8\u533b\u9662\u8fd4\u56de\u4fe1\u606f\u4e3a\uff1a{}", (Object)organizationResVOList);
            List hosIdList = organizationResVOList.stream().map(OrganizationResVO::getOrganId).collect(Collectors.toList());
            reqMgrReferralOutRecordVo.setIds(hosIdList);
            log.info("\u8f6c\u51fa\u8ba2\u5355\u5217\u8868appCode\uff1a{},\u5168\u90e8\u533b\u9662id\u4e3a\uff1a{}", (Object)reqMgrReferralOutRecordVo.getAppCode(), hosIdList);
        }
        PageHelper.startPage((int)reqMgrReferralOutRecordVo.getPageNum(), (int)reqMgrReferralOutRecordVo.getPageSize());
        Page mgrReferralOutRecordList = this.referralOrderMapper.getMgrReferralOutRecord(reqMgrReferralOutRecordVo);
        log.info("\u8f6c\u8bca\u8bb0\u5f55\u96c6\u5408\uff1a{}", (Object)mgrReferralOutRecordList.toString());
        ArrayList<TransferReqVo> transferReqVoList = new ArrayList<TransferReqVo>();
        for (ResMgrReferralOutRecordVo mgrReferralOutRecord2 : mgrReferralOutRecordList) {
            TransferReqVo transferReqVo = new TransferReqVo();
            transferReqVo.setPatientId(mgrReferralOutRecord2.getPatientId());
            transferReqVo.setAppCode(mgrReferralOutRecord2.getAppCode());
            transferReqVoList.add(transferReqVo);
        }
        BaseResponse remoteConsultationList = this.remoteConsultationService.getRemoteConsultationMark(transferReqVoList);
        log.info("\u8fdc\u7a0b\u4f1a\u8bca\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)remoteConsultationList.toString());
        HashMap<String, TransferResVo> transferResMap = new HashMap<String, TransferResVo>();
        List transferResDataList = (List)remoteConsultationList.getData();
        if (null == transferResDataList) {
            mgrReferralOutRecordList.forEach(mgrReferralOutRecord -> mgrReferralOutRecord.setRemoteConsultationMark(RemoteConsultationEnum.NOTDONE.getValue()));
        }
        for (TransferResVo transferResVo : transferResDataList) {
            transferResMap.put(transferResVo.getAppCode() + transferResVo.getPatientId(), transferResVo);
        }
        log.info("\u505a\u8fc7\u8fdc\u7a0b\u533b\u7597\u7684\u60a3\u8005\uff1a{}", (Object)((Object)transferResMap).toString());
        for (ResMgrReferralOutRecordVo mgrReferralOutRecord3 : mgrReferralOutRecordList) {
            String appAndPatientId = mgrReferralOutRecord3.getAppCode() + mgrReferralOutRecord3.getPatientId();
            if (transferResMap.containsKey(appAndPatientId)) {
                mgrReferralOutRecord3.setRemoteConsultationMark(RemoteConsultationEnum.TDONE.getValue());
                mgrReferralOutRecord3.setRemoteConsultationOrderId(((TransferResVo)transferResMap.get(appAndPatientId)).getOrderId());
                mgrReferralOutRecord3.setRemoteConsultationOrderViewId(((TransferResVo)transferResMap.get(appAndPatientId)).getOrderViewId());
                continue;
            }
            mgrReferralOutRecord3.setRemoteConsultationMark(RemoteConsultationEnum.NOTDONE.getValue());
        }
        log.info("\u6dfb\u52a0\u4f1a\u8bca\u6807\u8bc6\u540e\u7684\u8f6c\u8bca\u96c6\u5408\uff1a{}", (Object)mgrReferralOutRecordList.toString());
        PageResult pageResult = new PageResult();
        pageResult.setTotal(Long.valueOf(mgrReferralOutRecordList.getTotal()).intValue());
        pageResult.setTotalPages(Long.valueOf(mgrReferralOutRecordList.getPages()).intValue());
        mgrReferralOutRecordList.forEach(e -> {
            Long id = e.getReferralId();
            try {
                log.info("getMgrReferralOutRecord \u52a0\u5bc6\u524dId\uff1a" + id);
                id = DigitalUtil.encrypt((String)id.toString());
                log.info("getMgrReferralOutRecord \u52a0\u5bc6\u540eId\uff1a" + id);
            }
            catch (Exception exception) {
                log.error(exception.getMessage());
            }
            e.setReferralId(id);
        });
        pageResult.setContent(mgrReferralOutRecordList.getResult());
        Integer mgrReferralOutRecordTotal = this.referralOrderMapper.getMgrReferralOutRecordTotal(reqMgrReferralOutRecordVo);
        Integer mgrReferralOutUnderRecordTotal = this.referralOrderMapper.getMgrReferralOutUnderRecordTotal(reqMgrReferralOutRecordVo);
        Integer mgrReferralOutUpperRecordTotal = this.referralOrderMapper.getMgrReferralOutUpperRecordTotal(reqMgrReferralOutRecordVo);
        MgrReferralRecordCountResVo mgrReferralRecordCountResVo = new MgrReferralRecordCountResVo();
        mgrReferralRecordCountResVo.setTotalRecord(mgrReferralOutRecordTotal);
        mgrReferralRecordCountResVo.setUnderRecordTotal(mgrReferralOutUnderRecordTotal);
        mgrReferralRecordCountResVo.setUpperRecordTotal(mgrReferralOutUpperRecordTotal);
        MgrReferralOutRecordAllResVo mgrReferralOutRecordAllResVo = new MgrReferralOutRecordAllResVo();
        mgrReferralOutRecordAllResVo.setMgrReferralRecordCountResVo(mgrReferralRecordCountResVo);
        mgrReferralOutRecordAllResVo.setResMgrReferralOutRecordVo(pageResult);
        return mgrReferralOutRecordAllResVo;
    }

    public void updateReferralStatus(ReqUpdateReferralStatusVo reqUpdateReferralStatusVo) {
        log.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)reqUpdateReferralStatusVo.toString());
        this.referralOrderMapper.updateReferralStatus(reqUpdateReferralStatusVo);
    }

    public MgrReferralInRecordAllResVo getMgrReferralInRecord(ReqMgrReferralInRecordVo reqMgrReferralInRecordVo) {
        log.info("\u8f93\u5165\u67e5\u8be2\u53c2\u6570\u5185\u5bb9\uff1a{}", (Object)reqMgrReferralInRecordVo.toString());
        BaseResponse cloudUserScope = this.cloudUserScopeService.getCloudUserScope(reqMgrReferralInRecordVo.getUserId(), reqMgrReferralInRecordVo.getAppCode());
        log.info("\u901a\u8fc7\u7ba1\u7406\u5458id\u8fd4\u56de\u8be5\u7ba1\u7406\u5458\u4e0b\u6240\u6709\u533b\u9662id\uff1a{}", (Object)cloudUserScope.toString());
        String data = (String)cloudUserScope.getData();
        log.info("\u901a\u8fc7\u7ba1\u7406\u5458id\u8fd4\u56de\u8be5\u7ba1\u7406\u5458\u4e0b\u6240\u6709\u533b\u9662id\uff1a{}", (Object)data.toString());
        if (null != data && !All_ORGANCODE_HOSPITAL_ID.equals(data)) {
            log.info("===========\u6743\u9650\u4e0d\u4e3a-1==========");
            String[] idArray = data.split(",");
            ArrayList<String> idList = new ArrayList<String>(Arrays.asList(idArray));
            reqMgrReferralInRecordVo.setIds(idList);
        } else {
            log.info("===========\u6743\u9650\u4e3a-1==========");
            List organizationResVOList = this.getNodeOrganInfos(reqMgrReferralInRecordVo.getAppCode());
            log.info("\u8f6c\u51fa\u8ba2\u5355\u5217\u8868\u83b7\u53d6\u5168\u90e8\u533b\u9662\u8fd4\u56de\u4fe1\u606f\u4e3a\uff1a{}", (Object)organizationResVOList);
            List hosIdList = organizationResVOList.stream().map(OrganizationResVO::getOrganId).collect(Collectors.toList());
            reqMgrReferralInRecordVo.setIds(hosIdList);
            log.info("\u8f6c\u5165\u8ba2\u5355\u5217\u8868appCode\uff1a{},\u5168\u90e8\u533b\u9662id\u4e3a\uff1a{}", (Object)reqMgrReferralInRecordVo.getAppCode(), hosIdList);
        }
        PageHelper.startPage((int)reqMgrReferralInRecordVo.getPageNum(), (int)reqMgrReferralInRecordVo.getPageSize());
        Page mgrReferralInRecordList = this.referralOrderMapper.getMgrReferralInRecord(reqMgrReferralInRecordVo);
        ArrayList<TransferReqVo> transferReqVoList = new ArrayList<TransferReqVo>();
        TransferReqVo transferReqVo = null;
        int size = mgrReferralInRecordList.size();
        for (int i = 0; i < size; ++i) {
            transferReqVo = new TransferReqVo();
            transferReqVo.setPatientId(((ResMgrReferralInRecordVo)mgrReferralInRecordList.get(i)).getPatientId());
            transferReqVo.setAppCode(((ResMgrReferralInRecordVo)mgrReferralInRecordList.get(i)).getAppCode());
            transferReqVoList.add(transferReqVo);
        }
        log.info("\u8c03\u7528\u8fdc\u7a0b\u4f1a\u8bca\u5165\u53c2\uff1a{}", (Object)((Object)transferReqVoList).toString());
        BaseResponse remoteConsultationList = this.remoteConsultationService.getRemoteConsultationMark(transferReqVoList);
        log.info("\u8fdc\u7a0b\u4f1a\u8bca\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)remoteConsultationList.toString());
        HashMap<String, TransferResVo> transferResMap = new HashMap<String, TransferResVo>();
        List transferResDataList = (List)remoteConsultationList.getData();
        if (null == transferResDataList) {
            mgrReferralInRecordList.forEach(mgrReferralOutRecord -> mgrReferralOutRecord.setRemoteConsultationMark(RemoteConsultationEnum.NOTDONE.getValue()));
        }
        for (TransferResVo transferResVo : transferResDataList) {
            transferResMap.put(transferResVo.getAppCode() + transferResVo.getPatientId(), transferResVo);
        }
        log.info("\u505a\u8fc7\u8fdc\u7a0b\u533b\u7597\u7684\u60a3\u8005\uff1a{}", (Object)((Object)transferResMap).toString());
        for (ResMgrReferralInRecordVo resMgrReferralInRecordVo : mgrReferralInRecordList) {
            String appAndPatientId = resMgrReferralInRecordVo.getAppCode() + resMgrReferralInRecordVo.getPatientId();
            if (transferResMap.containsKey(appAndPatientId)) {
                resMgrReferralInRecordVo.setRemoteConsultationMark(RemoteConsultationEnum.TDONE.getValue());
                resMgrReferralInRecordVo.setRemoteConsultationOrderId(((TransferResVo)transferResMap.get(appAndPatientId)).getOrderId());
                resMgrReferralInRecordVo.setRemoteConsultationOrderViewId(((TransferResVo)transferResMap.get(appAndPatientId)).getOrderViewId());
                continue;
            }
            resMgrReferralInRecordVo.setRemoteConsultationMark(RemoteConsultationEnum.NOTDONE.getValue());
        }
        log.info("\u6dfb\u52a0\u4f1a\u8bca\u6807\u8bc6\u540e\u7684\u8f6c\u8bca\u96c6\u5408\uff1a{}", (Object)mgrReferralInRecordList.toString());
        PageResult pageResult = new PageResult();
        pageResult.setTotal(Long.valueOf(mgrReferralInRecordList.getTotal()).intValue());
        mgrReferralInRecordList.forEach(e -> {
            Long id = e.getReferralId();
            try {
                log.info("getMgrReferralInRecord \u52a0\u5bc6\u524dId\uff1a" + id);
                id = DigitalUtil.encrypt((String)id.toString());
                log.info("getMgrReferralInRecord \u52a0\u5bc6\u540eId\uff1a" + id);
            }
            catch (Exception exception) {
                log.error(exception.getMessage());
            }
            e.setReferralId(id);
        });
        pageResult.setContent(mgrReferralInRecordList.getResult());
        Integer recordTotal = this.referralOrderMapper.getMgrReferralInRecordTotal(reqMgrReferralInRecordVo);
        Integer upperRecordTotal = this.referralOrderMapper.getMgrReferralInUpperRecordTotal(reqMgrReferralInRecordVo);
        Integer underRecordTotal = this.referralOrderMapper.getMgrReferralInUnderRecordTotal(reqMgrReferralInRecordVo);
        MgrReferralRecordCountResVo mgrReferralRecordCountResVo = new MgrReferralRecordCountResVo();
        mgrReferralRecordCountResVo.setTotalRecord(recordTotal);
        mgrReferralRecordCountResVo.setUpperRecordTotal(upperRecordTotal);
        mgrReferralRecordCountResVo.setUnderRecordTotal(underRecordTotal);
        MgrReferralInRecordAllResVo mgrReferralInRecordAllResVo = new MgrReferralInRecordAllResVo();
        mgrReferralInRecordAllResVo.setResMgrReferralInRecordVo(pageResult);
        mgrReferralInRecordAllResVo.setMgrReferralRecordCountResVo(mgrReferralRecordCountResVo);
        return mgrReferralInRecordAllResVo;
    }

    public List<ReferralOrderEntity> getByIdList(List<Long> idList) {
        return this.referralOrderMapper.selectBatchIds(idList);
    }

    public void updatePatientSignature(UpdatePatientSignatureReqVo updatePatientSignatureReqVo) {
        this.referralOrderMapper.updatePatientSignature(updatePatientSignatureReqVo);
        ReqUpdateReferralStatusVo reqUpdateReferralStatusVo = new ReqUpdateReferralStatusVo();
        reqUpdateReferralStatusVo.setId(updatePatientSignatureReqVo.getId());
        reqUpdateReferralStatusVo.setReferralStatus(ReferralStatusEnum.TO_BE_CHECK.getValue());
        this.referralOrderMapper.updateReferralStatus(reqUpdateReferralStatusVo);
    }

    public void updateArrangement(MgrReferralArrangementReq mgrReferralArrangementReq) {
        this.referralOrderMapper.updateReferralArrangement(mgrReferralArrangementReq);
    }

    public List<ReferralOrderListForAppDoctorResVo> getReferralOrderListForAppDoctor(ReferralOrderListForAppDoctorReqVo referralOrderListForAppDoctorReqVo) {
        ReferralOrderListForAppDoctor referralOrderListForAppDoctor = this.buildReferralOrderListForAppDoctor(referralOrderListForAppDoctorReqVo);
        List referralSortList = referralOrderListForAppDoctorReqVo.getReferralSort();
        List referralOrderEntityList = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)referralSortList) || referralSortList.size() == TWO.intValue()) {
            referralOrderEntityList = this.referralOrderMapper.getReferralOrderListForAppDoctor(referralOrderListForAppDoctor);
        }
        if (null != referralSortList && referralSortList.size() == ONE.intValue()) {
            referralOrderListForAppDoctor.setInOrOut((Integer)referralSortList.get(0));
            referralOrderEntityList = this.referralOrderMapper.getReferralOrderListForAppDoctorByReferralSort(referralOrderListForAppDoctor);
        }
        String doctorId = referralOrderListForAppDoctorReqVo.getDoctorId();
        ArrayList<ReferralOrderListForAppDoctorResVo> referralOrderListForAppDoctorResVos = new ArrayList<ReferralOrderListForAppDoctorResVo>();
        referralOrderEntityList.forEach(e -> {
            ReferralOrderListForAppDoctorResVo referralOrderListForAppDoctorResVo = new ReferralOrderListForAppDoctorResVo();
            BeanUtils.copyProperties((Object)e, (Object)referralOrderListForAppDoctorResVo);
            referralOrderListForAppDoctorResVo.setReceiveDeptName(e.getReceiveDepartmentName());
            if (e.getReceiveDoctorId().equals(doctorId)) {
                referralOrderListForAppDoctorResVo.setReferralSort(CHANGE_INTO);
            }
            if (e.getLaunchDoctorId().equals(doctorId)) {
                referralOrderListForAppDoctorResVo.setReferralSort(CHANGE_OUT);
            }
            Long id = referralOrderListForAppDoctorResVo.getId();
            try {
                log.info("getReferralOrderListForAppDoctor\u52a0\u5bc6\u524dId\uff1a" + id);
                id = DigitalUtil.encrypt((String)id.toString());
                log.info("getReferralOrderListForAppDoctor\u52a0\u5bc6\u540eId\uff1a" + id);
            }
            catch (Exception exception) {
                log.error(exception.getMessage());
            }
            referralOrderListForAppDoctorResVo.setId(id);
            referralOrderListForAppDoctorResVos.add(referralOrderListForAppDoctorResVo);
        });
        return referralOrderListForAppDoctorResVos;
    }

    private ReferralOrderListForAppDoctor buildReferralOrderListForAppDoctor(ReferralOrderListForAppDoctorReqVo referralOrderListForAppDoctorReqVo) {
        ReferralOrderListForAppDoctor referralOrderListForAppDoctor = new ReferralOrderListForAppDoctor();
        BeanUtils.copyProperties((Object)referralOrderListForAppDoctorReqVo, (Object)referralOrderListForAppDoctor);
        referralOrderListForAppDoctor.setRejectStatus(RejectStatusEnum.NORMAL.getValue());
        referralOrderListForAppDoctor.setInReferralStatus(Arrays.asList(ReferralStatusEnum.TO_BE_ADMISSION.getValue(), ReferralStatusEnum.ALREADY_ADMISSION.getValue(), ReferralStatusEnum.ALREADY_REJECT.getValue()));
        referralOrderListForAppDoctor.setOutReferralStatus(Arrays.asList(ReferralStatusEnum.TO_BE_SIGNED.getValue(), ReferralStatusEnum.TO_BE_CHECK.getValue(), ReferralStatusEnum.TO_BE_ADMISSION.getValue(), ReferralStatusEnum.TO_BE_DISTRIBUTION.getValue(), ReferralStatusEnum.ALREADY_ADMISSION.getValue(), ReferralStatusEnum.ALREADY_CANCEL.getValue(), ReferralStatusEnum.CHECK_NOT_PASS.getValue()));
        return referralOrderListForAppDoctor;
    }

    public ReferralOrderDetailForAppResVo getReferralOrderDetailForApp(String id) {
        ReferralOrderDetailForAppResVo referralOrderDetailForAppResVo = new ReferralOrderDetailForAppResVo();
        ReferralOrderResVo referralOrderResVo = new ReferralOrderResVo();
        ReferralOrderEntity referralOrderEntity = (ReferralOrderEntity)this.referralOrderMapper.selectById((Serializable)((Object)id));
        log.info("ReferralOrderServiceImpl.getReferralOrderListForApp-->referralOrderMapper.selectById(id)\u67e5\u8be2\u7ed3\u679c\u4e3a:{}", (Object)referralOrderEntity);
        BeanUtils.copyProperties((Object)referralOrderEntity, (Object)referralOrderResVo);
        Long resId = referralOrderResVo.getId();
        try {
            log.info("getReferralOrderDetailForApp \u52a0\u5bc6\u524dId\uff1a" + resId);
            resId = DigitalUtil.encrypt((String)resId.toString());
            log.info("getReferralOrderDetailForApp \u52a0\u5bc6\u540eId\uff1a" + resId);
        }
        catch (Exception exception) {
            log.error(exception.getMessage());
        }
        referralOrderResVo.setId(resId);
        referralOrderDetailForAppResVo.setReferralOrderResVo(referralOrderResVo);
        String orderSeq = referralOrderEntity.getOrderSeq();
        List referralPictureInfoEntitys = this.referralPictureInfoMapper.getByOrderSeq(orderSeq);
        this.buildReferralPictureInfoEntity(referralOrderDetailForAppResVo, referralPictureInfoEntitys);
        return referralOrderDetailForAppResVo;
    }

    public Long createReferralOrder(CreateReferralOrderReqVo createReferralOrderReqVo) throws ReferralException {
        ReferralOrderEntity referralOrderEntity = new ReferralOrderEntity();
        try {
            BeanUtils.copyProperties((Object)createReferralOrderReqVo.getReferralOrderReqVo(), (Object)referralOrderEntity);
        }
        catch (Exception e) {
            throw new ReferralException("\u521b\u5efa\u8f6c\u8bca\u5355\u5931\u8d25\uff01");
        }
        String orderSeq = String.valueOf(this.snowflakeIdWorker.nextId());
        referralOrderEntity.setOrderSeq(orderSeq);
        referralOrderEntity.setReferralStatus(ReferralStatusEnum.TO_BE_SIGNED.getValue());
        Date createTime = new Date();
        List referralPictureInfoEntitieList = this.buildPictureInfoEntity(createReferralOrderReqVo, orderSeq, createTime);
        if (!CollectionUtils.isEmpty((Collection)referralPictureInfoEntitieList)) {
            log.info("ReferralOrderServiceImpl.createReferralOrder\u4e2dreferralOrderMapper.insert\u53c2\u6570\u4e3a:{}", (Object)referralOrderEntity);
            this.referralOrderMapper.insert((Object)referralOrderEntity);
            Long id = referralOrderEntity.getId();
            log.info("ReferralOrderServiceImpl.createReferralOrder\u4e2dreferralPictureInfoMapper.batchInsert\u53c2\u6570\u4e3a:{}", (Object)referralPictureInfoEntitieList);
            this.referralPictureInfoMapper.batchInsert(referralPictureInfoEntitieList);
            RabbitMqUtils.senderDelayedOrderOutTradeNo((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)id));
            return id;
        }
        log.info("ReferralOrderServiceImpl\u521b\u5efa\u8f6c\u8bca\u5355\u5931\u8d25\uff0c\u4e0a\u4f20\u4fe1\u606f\u6570\u7ec4\u4e3a\u7a7a");
        throw new ReferralException("\u521b\u5efa\u8f6c\u8bca\u5355\u5931\u8d25\uff01");
    }

    private List<ReferralPictureInfoEntity> buildPictureInfoEntity(CreateReferralOrderReqVo createReferralOrderReqVo, String orderSeq, Date date) {
        String imageUrls;
        String imageUrls2;
        String imageUrls3;
        String imageUrls4;
        String imageUrls5;
        ArrayList<ReferralPictureInfoEntity> referralPictureInfoEntities = new ArrayList<ReferralPictureInfoEntity>();
        DoctorAdviceVo doctorAdviceVo = createReferralOrderReqVo.getDoctorAdviceVo();
        if (null != createReferralOrderReqVo && null != doctorAdviceVo && doctorAdviceVo != null && StringUtils.isNotBlank((String)(imageUrls5 = this.urlListToString(doctorAdviceVo.getUrls())))) {
            ReferralPictureInfoEntity referralPictureInfoEntity = new ReferralPictureInfoEntity();
            referralPictureInfoEntity.setUrl(imageUrls5);
            referralPictureInfoEntity.setItemTypeCode(ItemTypeCodeEnum.DOCTOR_ADVICE.getValue());
            referralPictureInfoEntity.setDescription(doctorAdviceVo.getDescription());
            referralPictureInfoEntities.add(referralPictureInfoEntity);
        }
        CaseInformationVo caseInformationVo = createReferralOrderReqVo.getCaseInformationVo();
        if (null != createReferralOrderReqVo && null != caseInformationVo && null != caseInformationVo && StringUtils.isNotBlank((String)(imageUrls4 = this.urlListToString(caseInformationVo.getUrls())))) {
            ReferralPictureInfoEntity referralPictureInfoEntity = new ReferralPictureInfoEntity();
            referralPictureInfoEntity.setUrl(imageUrls4);
            referralPictureInfoEntity.setItemTypeCode(ItemTypeCodeEnum.CASE_INFORMATION.getValue());
            if (StringUtils.isNotBlank((String)createReferralOrderReqVo.getReferralOrderReqVo().getIllnessDes())) {
                referralPictureInfoEntity.setDescription(createReferralOrderReqVo.getReferralOrderReqVo().getIllnessDes());
            }
            referralPictureInfoEntities.add(referralPictureInfoEntity);
        }
        AssayDataVo assayDataVo = createReferralOrderReqVo.getAssayDataVo();
        if (null != createReferralOrderReqVo && null != assayDataVo && null != assayDataVo && StringUtils.isNotBlank((String)(imageUrls3 = this.urlListToString(assayDataVo.getUrls())))) {
            ReferralPictureInfoEntity referralPictureInfoEntity = new ReferralPictureInfoEntity();
            referralPictureInfoEntity.setUrl(imageUrls3);
            referralPictureInfoEntity.setItemTypeCode(ItemTypeCodeEnum.ASSAY_DATA.getValue());
            referralPictureInfoEntity.setDescription(assayDataVo.getDescription());
            referralPictureInfoEntities.add(referralPictureInfoEntity);
        }
        OperationRecordVo operationRecordVo = createReferralOrderReqVo.getOperationRecordVo();
        if (null != createReferralOrderReqVo && null != operationRecordVo && null != operationRecordVo && StringUtils.isNotBlank((String)(imageUrls2 = this.urlListToString(operationRecordVo.getUrls())))) {
            ReferralPictureInfoEntity referralPictureInfoEntity = new ReferralPictureInfoEntity();
            referralPictureInfoEntity.setUrl(imageUrls2);
            referralPictureInfoEntity.setItemTypeCode(ItemTypeCodeEnum.OPERATIVE_RECORD.getValue());
            referralPictureInfoEntity.setDescription(operationRecordVo.getDescription());
            referralPictureInfoEntities.add(referralPictureInfoEntity);
        }
        RecoveryPlanVo recoveryPlanVo = createReferralOrderReqVo.getRecoveryPlanVo();
        if (null != createReferralOrderReqVo && null != recoveryPlanVo && null != recoveryPlanVo && StringUtils.isNotBlank((String)(imageUrls = this.urlListToString(recoveryPlanVo.getUrls())))) {
            ReferralPictureInfoEntity referralPictureInfoEntity = new ReferralPictureInfoEntity();
            referralPictureInfoEntity.setUrl(imageUrls);
            referralPictureInfoEntity.setItemTypeCode(ItemTypeCodeEnum.RECOVERY_PLAN.getValue());
            referralPictureInfoEntity.setDescription(recoveryPlanVo.getDescription());
            referralPictureInfoEntities.add(referralPictureInfoEntity);
        }
        VideoMaterialVo videoMaterialVo = createReferralOrderReqVo.getVideoMaterialVo();
        if (null != createReferralOrderReqVo && null != videoMaterialVo && null != videoMaterialVo && !CollectionUtils.isEmpty((Collection)videoMaterialVo.getUrls())) {
            videoMaterialVo.getUrls().forEach(e -> {
                if (StringUtils.isNotBlank((String)e)) {
                    ReferralPictureInfoEntity referralPictureInfoEntity = new ReferralPictureInfoEntity();
                    referralPictureInfoEntity.setItemTypeCode(ItemTypeCodeEnum.IMAGE_DATA.getValue());
                    referralPictureInfoEntity.setUrl(e);
                    referralPictureInfoEntities.add(referralPictureInfoEntity);
                }
            });
        }
        referralPictureInfoEntities.forEach(e -> {
            e.setCreateTime(date);
            e.setOrderSeq(orderSeq);
            e.setStatus(StatusEnum.NORMAL.getValue());
            e.setUpdateTime(date);
        });
        return referralPictureInfoEntities;
    }

    private Map<String, Object> buildReferralOrderEntityForWord(ReferralOrderEntity referralOrderEntity) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("patientName", referralOrderEntity.getPatientName());
        param.put("patientIdCard", referralOrderEntity.getPatientIdCard());
        if (referralOrderEntity.getPatientGender() == PatientGenderEnum.MALE.getValue()) {
            param.put("patientSex", "\u7537");
        } else {
            param.put("patientSex", "\u5973");
        }
        param.put("patientPhone", referralOrderEntity.getPatientPhone());
        param.put("patientAge", referralOrderEntity.getPatientAge());
        param.put("hospitalName", referralOrderEntity.getLaunchHospitalName());
        param.put("launchHospitalName", referralOrderEntity.getLaunchHospitalName());
        param.put("receiveHospitalName", referralOrderEntity.getReceiveHospitalName());
        param.put("receiveDeptName", referralOrderEntity.getReceiveDepartmentName());
        param.put("nowDate", new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        if (referralOrderEntity.getReferralProject() == ReferralProjectEnum.HOSPITALIZATION.getValue()) {
            param.put("referralProject", "\u4f4f\u9662");
        } else if (referralOrderEntity.getReferralProject() == ReferralProjectEnum.OUTPATIENT.getValue()) {
            param.put("referralProject", "\u95e8\u8bca");
        } else {
            param.put("referralProject", "\u68c0\u67e5");
        }
        if (referralOrderEntity.getFeeType() == FeeTypeEnum.MEDICALINSURANCE.getValue()) {
            param.put("freeType", "\u533b\u7597\u4fdd\u9669");
        } else if (referralOrderEntity.getFeeType() == FeeTypeEnum.PUBLICMEDICAL.getValue()) {
            param.put("freeType", "\u516c\u8d39\u533b\u7597");
        } else if (referralOrderEntity.getFeeType() == FeeTypeEnum.NCMS.getValue()) {
            param.put("freeType", "\u65b0\u519c\u5408");
        } else if (referralOrderEntity.getFeeType() == FeeTypeEnum.SELFPAY.getValue()) {
            param.put("freeType", "\u81ea\u8d39");
        } else {
            param.put("freeType", "\u5176\u4ed6");
        }
        return param;
    }

    public void exportReferralApplyOrderWord(Long id, HttpServletResponse response) {
        ReferralOrderEntity referralOrderEntity = (ReferralOrderEntity)this.referralOrderMapper.selectById((Serializable)id);
        Long resId = referralOrderEntity.getId();
        try {
            log.info("getMgrReferralOutRecord \u52a0\u5bc6\u524dId\uff1a" + resId);
            resId = DigitalUtil.encrypt((String)resId.toString());
            log.info("getMgrReferralOutRecord \u52a0\u5bc6\u540eId\uff1a" + resId);
        }
        catch (Exception exception) {
            log.error(exception.getMessage());
        }
        referralOrderEntity.setId(resId);
        String path = this.getClass().getClassLoader().getResource("application.yml").getPath();
        log.info("path:   " + path);
        String wordPath = FileUtils.getPath((String)path, (String)"word/");
        Map param = this.buildReferralOrderEntityForWord(referralOrderEntity);
        String templatePath = "template/referralApplyOrder.docx";
        String fileName = null;
        try {
            fileName = new String(referralOrderEntity.getPatientName().getBytes(), "utf-8") + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd_HHmmssSSS") + ".docx";
        }
        catch (UnsupportedEncodingException e) {
            log.error("=================\u6587\u4ef6\u540d\u8f6c\u6362\u5f02\u5e38");
            e.printStackTrace();
        }
        WordUtils.exportWord((String)templatePath, (String)wordPath, fileName, (Map)param, (HttpServletResponse)response);
    }

    public void exportReferralApplyOrderZip(List<Long> idList, HttpServletResponse response) {
        List referralEntities = this.getByIdList(idList);
        log.info(referralEntities.toString());
        if (referralEntities.size() == 0) {
            return;
        }
        referralEntities.forEach(e -> {
            Long id = e.getId();
            try {
                log.info("exportReferralApplyOrderZip \u52a0\u5bc6\u524dId\uff1a" + id);
                id = DigitalUtil.encrypt((String)id.toString());
                log.info("exportReferralApplyOrderZip \u52a0\u5bc6\u540eId\uff1a" + id);
            }
            catch (Exception exception) {
                log.error(exception.getMessage());
            }
            e.setId(id);
        });
        String path = this.getClass().getClassLoader().getResource("application.yml").getPath();
        log.info("path:   " + path);
        String zipPath = FileUtils.getPath((String)path, (String)"zip/");
        String wordPath = FileUtils.getPath((String)path, (String)"word/");
        for (ReferralOrderEntity referralEntity : referralEntities) {
            Map param = this.buildReferralOrderEntityForWord(referralEntity);
            WordUtils.saveWord((String)wordPath, (Map)param, (String)referralEntity.getPatientName());
        }
        ZipUtils.saveZip((String)wordPath, (String)zipPath, (String)DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd_HHmmssSSS"), (HttpServletResponse)response);
    }

    private void buildReferralPictureInfoEntity(ReferralOrderDetailForAppResVo referralOrderDetailForAppResVo, List<ReferralPictureInfoEntity> referralPictureInfoEntitys) {
        if (referralPictureInfoEntitys != null && referralPictureInfoEntitys.size() > 0) {
            referralPictureInfoEntitys.forEach(e -> {
                List urls = this.stringToUrlList(e.getUrl());
                if (ItemTypeCodeEnum.DOCTOR_ADVICE.getValue() == e.getItemTypeCode()) {
                    DoctorAdviceVo doctorAdviceVo = new DoctorAdviceVo();
                    doctorAdviceVo.setUrls(urls);
                    doctorAdviceVo.setDescription(e.getDescription());
                    referralOrderDetailForAppResVo.setDoctorAdviceVo(doctorAdviceVo);
                }
                if (ItemTypeCodeEnum.CASE_INFORMATION.getValue() == e.getItemTypeCode()) {
                    CaseInformationVo caseInformationVo = new CaseInformationVo();
                    caseInformationVo.setUrls(urls);
                    caseInformationVo.setDescription(e.getDescription());
                    referralOrderDetailForAppResVo.setCaseInformationVo(caseInformationVo);
                }
                if (ItemTypeCodeEnum.ASSAY_DATA.getValue() == e.getItemTypeCode()) {
                    AssayDataVo assayDataVo = new AssayDataVo();
                    assayDataVo.setUrls(urls);
                    assayDataVo.setDescription(e.getDescription());
                    referralOrderDetailForAppResVo.setAssayDataVo(assayDataVo);
                }
                if (ItemTypeCodeEnum.OPERATIVE_RECORD.getValue() == e.getItemTypeCode()) {
                    OperationRecordVo operationRecordVo = new OperationRecordVo();
                    operationRecordVo.setUrls(urls);
                    operationRecordVo.setDescription(e.getDescription());
                    referralOrderDetailForAppResVo.setOperationRecordReqVo(operationRecordVo);
                }
                if (ItemTypeCodeEnum.RECOVERY_PLAN.getValue() == e.getItemTypeCode()) {
                    RecoveryPlanVo recoveryPlanVo = new RecoveryPlanVo();
                    recoveryPlanVo.setUrls(urls);
                    recoveryPlanVo.setDescription(e.getDescription());
                    referralOrderDetailForAppResVo.setRecoveryPlanVo(recoveryPlanVo);
                }
            });
            VideoMaterialVo videoMaterialVo = new VideoMaterialVo();
            ArrayList videoMateriaUrlList = new ArrayList();
            ArrayList dcomVoList = new ArrayList();
            referralPictureInfoEntitys.forEach(e -> {
                if (ItemTypeCodeEnum.IMAGE_DATA.getValue() == e.getItemTypeCode()) {
                    DcomVo dcomVo = (DcomVo)JSON.parseObject((String)e.getUrl(), DcomVo.class);
                    dcomVoList.add(dcomVo);
                    videoMateriaUrlList.add(e.getUrl());
                }
            });
            videoMaterialVo.setUrls(videoMateriaUrlList);
            videoMaterialVo.setDcomVoList(dcomVoList);
            referralOrderDetailForAppResVo.setVideoMaterialVo(videoMaterialVo);
        }
    }

    private String urlListToString(List<String> urlList) {
        if (CollectionUtils.isEmpty(urlList)) {
            return "";
        }
        return String.join((CharSequence)",", urlList);
    }

    private List<String> stringToUrlList(String urls) {
        if (StringUtils.isBlank((String)urls)) {
            return new ArrayList<String>();
        }
        return Arrays.asList(urls.split(","));
    }

    public void patientSign(PatientSignReqVo patientSignReqVo) {
        ReferralOrderEntity referralOrderEntity = new ReferralOrderEntity();
        if (PatientSignatureTypeEnum.ELECTRON_SIGN.getValue() == patientSignReqVo.getPatientSignatureType()) {
            referralOrderEntity.setPatientSignatureType(PatientSignatureTypeEnum.ELECTRON_SIGN.getValue());
            referralOrderEntity.setPatientElectronicSignature(patientSignReqVo.getPatientSignatureUrl());
        }
        if (PatientSignatureTypeEnum.IMAGE_SIGN.getValue() == patientSignReqVo.getPatientSignatureType()) {
            referralOrderEntity.setPatientSignatureType(PatientSignatureTypeEnum.IMAGE_SIGN.getValue());
            referralOrderEntity.setPatientPictureSignature(patientSignReqVo.getPatientSignatureUrl());
        }
        referralOrderEntity.setId(patientSignReqVo.getId());
        referralOrderEntity.setSignatorRelationship(patientSignReqVo.getSignatorRelationship());
        referralOrderEntity.setReferralStatus(ReferralStatusEnum.TO_BE_CHECK.getValue());
        referralOrderEntity.setUpdateTime(new Date());
        log.info("=====ReferralOrderServiceImpl.patientSign===\u533b\u751f\u7aef\u60a3\u8005\u7b7e\u540d:", (Object)referralOrderEntity);
        this.referralOrderMapper.updateById((Object)referralOrderEntity);
    }

    public Long rejectReferralOrder(Long id) {
        ReferralOrderEntity referralOrderEntityNew = new ReferralOrderEntity();
        ReferralOrderEntity referralOrderEntityOld = (ReferralOrderEntity)this.referralOrderMapper.selectById((Serializable)id);
        BeanUtils.copyProperties((Object)referralOrderEntityOld, (Object)referralOrderEntityNew);
        referralOrderEntityOld.setUpdateTime(new Date());
        referralOrderEntityOld.setReferralStatus(ReferralStatusEnum.ALREADY_REJECT.getValue());
        referralOrderEntityOld.setRejectStatus(REJECT);
        this.referralOrderMapper.updateById((Object)referralOrderEntityOld);
        referralOrderEntityNew.setReceiveDoctorId("");
        referralOrderEntityNew.setReceiveDoctorName("");
        referralOrderEntityNew.setReceiveDepartmentId("");
        referralOrderEntityNew.setReceiveDepartmentName("");
        referralOrderEntityNew.setReferralStatus(ReferralStatusEnum.TO_BE_DISTRIBUTION.getValue());
        referralOrderEntityNew.setUpdateTime(new Date());
        this.referralOrderMapper.insert((Object)referralOrderEntityNew);
        this.taskExecutor.execute(() -> {
            String deviceType = this.umAndroidPushService.getDeviceInfo(referralOrderEntityNew).getDeviceType();
            if (ChannelEnum.USER_ANDROID.getValue().equals(deviceType)) {
                log.info("\u533b\u751f\u5b89\u5353\u7aef\u62d2\u7edd\u8f6c\u8bca\u5355\u63a8\u9001\u5f00\u59cb......");
                this.umAndroidPushService.doctorRejectUMAndroidPush(referralOrderEntityNew);
                log.info("\u533b\u751f\u5b89\u5353\u7aef\u62d2\u7edd\u8f6c\u8bca\u5355\u63a8\u9001\u7ed3\u675f......");
            } else if (ChannelEnum.USER_IOS.getValue().equals(deviceType)) {
                log.info("\u533b\u751fIOS\u7aef\u62d2\u7edd\u8f6c\u8bca\u5355\u63a8\u9001\u5f00\u59cb......");
                this.umIosPushService.doctorRejectUMAndroidPush(referralOrderEntityNew);
                log.info("\u533b\u751fIOS\u7aef\u62d2\u7edd\u8f6c\u8bca\u5355\u63a8\u9001\u7ed3\u675f......");
            }
            log.info("\u533b\u751fweb\u7aef\u62d2\u7edd\u8f6c\u8bca\u5355\u63a8\u9001\u5f00\u59cb.....");
            this.goeasyService.receiveDoctorRejectPush(referralOrderEntityNew.getId(), referralOrderEntityNew.getLauchUserId());
            log.info("\u533b\u751fweb\u7aef\u62d2\u7edd\u8f6c\u8bca\u5355\u63a8\u9001\u7ed3\u675f.....");
        });
        return id;
    }

    public ReferralOrderListForWebDoctorResVo getOutReferralOrderListForWebDoctor(BaseReqVo<ReferralOrderListForOutWebDoctorReqVo> baseReqVo) {
        ReferralOrderListForWebDoctorResVo referralOrderListForWebDoctorResVo = new ReferralOrderListForWebDoctorResVo();
        ReferralOrderListForOutWebDoctorReqVo referralOrderListForOutWebDoctorReqVo = (ReferralOrderListForOutWebDoctorReqVo)baseReqVo.getQueryData();
        this.buildReferralOrderListForOutWebDoctorReqVo(referralOrderListForOutWebDoctorReqVo);
        ReferralOrderEntity referralOrderEntity = new ReferralOrderEntity();
        PageHelper.startPage((int)baseReqVo.getCurrentPage(), (int)baseReqVo.getPageSize());
        Page referralOrderEntityList = this.referralOrderMapper.getOutReferralOrderListForWebDoctor(referralOrderListForOutWebDoctorReqVo);
        PageResult pageResult = new PageResult();
        pageResult.setTotal(Long.valueOf(referralOrderEntityList.getTotal()).intValue());
        pageResult.setPageNum(referralOrderEntityList.getPageNum());
        pageResult.setPageSize(referralOrderEntityList.getPageSize());
        pageResult.setTotalPages(referralOrderEntityList.getPages());
        List result = referralOrderEntityList.getResult();
        List referralOrderResForDoctorWebVoList = result.stream().map(e -> {
            ReferralOrderResForDoctorWebVo referralOrderResForDoctorWebVo = new ReferralOrderResForDoctorWebVo();
            BeanUtils.copyProperties((Object)e, (Object)referralOrderResForDoctorWebVo);
            Long id = referralOrderResForDoctorWebVo.getId();
            try {
                log.info("getOutReferralOrderListForWebDoctor\u52a0\u5bc6\u524dId\uff1a" + id);
                id = DigitalUtil.encrypt((String)id.toString());
                log.info("getOutReferralOrderListForWebDoctor\u52a0\u5bc6\u540eId\uff1a" + id);
            }
            catch (Exception exception) {
                log.error(exception.getMessage());
            }
            referralOrderResForDoctorWebVo.setId(id);
            return referralOrderResForDoctorWebVo;
        }).collect(Collectors.toList());
        pageResult.setContent(referralOrderResForDoctorWebVoList);
        DoctorReferralRecordCountResVo doctorReferralRecordCountResVo = this.referralOrderMapper.getOutDoctorReferralRecordCountResVo(referralOrderListForOutWebDoctorReqVo);
        referralOrderListForWebDoctorResVo.setDoctorReferralRecordCountResVo(doctorReferralRecordCountResVo);
        referralOrderListForWebDoctorResVo.setPageResult(pageResult);
        return referralOrderListForWebDoctorResVo;
    }

    private void buildReferralOrderListForOutWebDoctorReqVo(ReferralOrderListForOutWebDoctorReqVo referralOrderListForOutWebDoctorReqVo) {
        referralOrderListForOutWebDoctorReqVo.setRejectStatus(RejectStatusEnum.NORMAL.getValue());
        referralOrderListForOutWebDoctorReqVo.setUpReferral(ReferralTypeEnum.UP_REFERRAL.getValue());
        referralOrderListForOutWebDoctorReqVo.setDownReferral(ReferralTypeEnum.DOWN_REFERRAL.getValue());
        referralOrderListForOutWebDoctorReqVo.setInReferralStatus(Arrays.asList(ReferralStatusEnum.TO_BE_ADMISSION.getValue(), ReferralStatusEnum.ALREADY_ADMISSION.getValue(), ReferralStatusEnum.ALREADY_REJECT.getValue()));
        referralOrderListForOutWebDoctorReqVo.setOutReferralStatus(Arrays.asList(ReferralStatusEnum.TO_BE_SIGNED.getValue(), ReferralStatusEnum.TO_BE_CHECK.getValue(), ReferralStatusEnum.TO_BE_ADMISSION.getValue(), ReferralStatusEnum.TO_BE_DISTRIBUTION.getValue(), ReferralStatusEnum.ALREADY_ADMISSION.getValue(), ReferralStatusEnum.ALREADY_CANCEL.getValue(), ReferralStatusEnum.CHECK_NOT_PASS.getValue()));
    }

    public ReferralOrderListForWebDoctorResVo getInReferralOrderListForWebDoctor(BaseReqVo<ReferralOrderListForInWebDoctorReqVo> baseReqVo) {
        ReferralOrderListForWebDoctorResVo referralOrderListForWebDoctorResVo = new ReferralOrderListForWebDoctorResVo();
        ReferralOrderListForInWebDoctorReqVo referralOrderListForInWebDoctorReqVo = (ReferralOrderListForInWebDoctorReqVo)baseReqVo.getQueryData();
        this.buildReferralOrderListForInWebDoctorReqVo(referralOrderListForInWebDoctorReqVo);
        ReferralOrderEntity referralOrderEntity = new ReferralOrderEntity();
        PageHelper.startPage((int)baseReqVo.getCurrentPage(), (int)baseReqVo.getPageSize());
        Page referralOrderEntityList = this.referralOrderMapper.getInReferralOrderListForWebDoctor(referralOrderListForInWebDoctorReqVo);
        PageResult pageResult = new PageResult();
        pageResult.setTotal(Long.valueOf(referralOrderEntityList.getTotal()).intValue());
        pageResult.setPageNum(referralOrderEntityList.getPageNum());
        pageResult.setPageSize(referralOrderEntityList.getPageSize());
        pageResult.setTotalPages(referralOrderEntityList.getPages());
        List result = referralOrderEntityList.getResult();
        List referralOrderResForDoctorWebVoList = result.stream().map(e -> {
            ReferralOrderResForDoctorWebVo referralOrderResForDoctorWebVo = new ReferralOrderResForDoctorWebVo();
            BeanUtils.copyProperties((Object)e, (Object)referralOrderResForDoctorWebVo);
            Long id = referralOrderResForDoctorWebVo.getId();
            try {
                log.info("getInReferralOrderListForWebDoctor \u52a0\u5bc6\u524dId\uff1a" + id);
                id = DigitalUtil.encrypt((String)id.toString());
                log.info("getInReferralOrderListForWebDoctor \u52a0\u5bc6\u540eId\uff1a" + id);
            }
            catch (Exception exception) {
                log.error(exception.getMessage());
            }
            referralOrderResForDoctorWebVo.setId(id);
            return referralOrderResForDoctorWebVo;
        }).collect(Collectors.toList());
        pageResult.setContent(referralOrderResForDoctorWebVoList);
        DoctorReferralRecordCountResVo doctorReferralRecordCountResVo = this.referralOrderMapper.getInDoctorReferralRecordCountResVo(referralOrderListForInWebDoctorReqVo);
        referralOrderListForWebDoctorResVo.setDoctorReferralRecordCountResVo(doctorReferralRecordCountResVo);
        referralOrderListForWebDoctorResVo.setPageResult(pageResult);
        return referralOrderListForWebDoctorResVo;
    }

    private void buildReferralOrderListForInWebDoctorReqVo(ReferralOrderListForInWebDoctorReqVo referralOrderListForInWebDoctorReqVo) {
        referralOrderListForInWebDoctorReqVo.setRejectStatus(RejectStatusEnum.NORMAL.getValue());
        referralOrderListForInWebDoctorReqVo.setUpReferral(ReferralTypeEnum.UP_REFERRAL.getValue());
        referralOrderListForInWebDoctorReqVo.setDownReferral(ReferralTypeEnum.DOWN_REFERRAL.getValue());
        referralOrderListForInWebDoctorReqVo.setInReferralStatus(Arrays.asList(ReferralStatusEnum.TO_BE_ADMISSION.getValue(), ReferralStatusEnum.ALREADY_ADMISSION.getValue(), ReferralStatusEnum.ALREADY_REJECT.getValue()));
        referralOrderListForInWebDoctorReqVo.setOutReferralStatus(Arrays.asList(ReferralStatusEnum.TO_BE_SIGNED.getValue(), ReferralStatusEnum.TO_BE_CHECK.getValue(), ReferralStatusEnum.TO_BE_ADMISSION.getValue(), ReferralStatusEnum.TO_BE_DISTRIBUTION.getValue(), ReferralStatusEnum.ALREADY_ADMISSION.getValue(), ReferralStatusEnum.ALREADY_CANCEL.getValue(), ReferralStatusEnum.CHECK_NOT_PASS.getValue()));
    }

    public MgrReferralRecordDetailResVo getReferralROrderDetail(Long id) {
        List referralPictureInfoEntityList;
        MgrReferralRecordDetailResVo mgrReferralRecordDetailResVo = new MgrReferralRecordDetailResVo();
        ArrayList mgrReferralNoteResVoList = new ArrayList();
        ArrayList<MgrReferralCaseInfoResVo> mgrReferralCaseInfoResVoList = new ArrayList<MgrReferralCaseInfoResVo>();
        MgrReferralInfoResVo mgrReferralInfoResVo = new MgrReferralInfoResVo();
        ReferralOrderEntity referralOrderEntity = (ReferralOrderEntity)this.referralOrderMapper.selectById((Serializable)id);
        log.info("ReferralOrderServiceImpl.getReferralROrderDetail->\u6839\u636eid\u67e5\u8be2\u8f6c\u8bca\u5355\u4fe1\u606f\uff0c\u67e5\u8be2\u7ed3\u679creferralOrderEntity\u4e3a\uff1a{}", (Object)referralOrderEntity);
        BeanUtils.copyProperties((Object)referralOrderEntity, (Object)mgrReferralInfoResVo);
        mgrReferralInfoResVo.setPatientIdCard(CommonUtil.idEncrypt((String)referralOrderEntity.getPatientIdCard()));
        mgrReferralInfoResVo.setPatientPhone(CommonUtil.idEncrypt((String)referralOrderEntity.getPatientPhone()));
        Long resId = mgrReferralInfoResVo.getId();
        try {
            log.info("getReferralROrderDetail \u52a0\u5bc6\u524dId\uff1a" + resId);
            resId = DigitalUtil.encrypt((String)resId.toString());
            log.info("getReferralROrderDetail \u52a0\u5bc6\u540eId\uff1a" + resId);
        }
        catch (Exception exception) {
            log.error(exception.getMessage());
        }
        mgrReferralInfoResVo.setId(resId);
        mgrReferralRecordDetailResVo.setMgrReferralInfoResVo(mgrReferralInfoResVo);
        String patientId = referralOrderEntity.getPatientId();
        String patientIdCard = referralOrderEntity.getPatientIdCard();
        Date createTime = referralOrderEntity.getCreateTime();
        ReferralOrderEntity referralOrderEntityForQuery = new ReferralOrderEntity();
        referralOrderEntityForQuery.setPatientId(patientId);
        referralOrderEntityForQuery.setPatientIdCard(patientIdCard);
        referralOrderEntityForQuery.setCreateTime(createTime);
        List mgrReferralInfoResVoList = this.referralOrderMapper.getReferralInfo(referralOrderEntityForQuery);
        log.info("ReferralOrderServiceImpl.getReferralROrderDetail->\u6839\u636eid\u67e5\u8be2\u8f6c\u8bca\u5355\u4fe1\u606flist\uff0c\u67e5\u8be2\u7ed3\u679cmgrReferralInfoResVoList\u4e3a\uff1a{}", (Object)mgrReferralInfoResVoList);
        if (mgrReferralInfoResVoList.size() == 0 && null != (referralPictureInfoEntityList = this.referralPictureInfoMapper.getByOrderSeq(referralOrderEntity.getOrderSeq()))) {
            MgrReferralCaseInfoResVo mgrReferralCaseInfoResVo = new MgrReferralCaseInfoResVo();
            mgrReferralCaseInfoResVo.setLaunchHospitalName(mgrReferralInfoResVo.getLaunchHospitalName());
            ArrayList videoMaterialUrlList = new ArrayList();
            referralPictureInfoEntityList.forEach(referralPictureInfoEntity -> this.buildMgrReferralCaseInfoResVo(referralPictureInfoEntity, mgrReferralCaseInfoResVo, videoMaterialUrlList));
            VideoMaterialResVo videoMaterialResVo = new VideoMaterialResVo();
            videoMaterialResVo.setUrl(videoMaterialUrlList);
            mgrReferralCaseInfoResVo.setVideoMaterialResVo(videoMaterialResVo);
            mgrReferralCaseInfoResVoList.add(mgrReferralCaseInfoResVo);
        }
        if (mgrReferralInfoResVoList.size() > 0) {
            int referralNumber = 0;
            mgrReferralInfoResVoList.sort((e1, e2) -> e1.getCreateTime().compareTo(e2.getCreateTime()));
            mgrReferralInfoResVoList.forEach(e -> {
                MgrReferralNoteResVo mgrReferralNoteResVo = new MgrReferralNoteResVo();
                mgrReferralNoteResVo.setLaunchHospitalName(e.getLaunchHospitalName());
                mgrReferralNoteResVo.setReceiveHospitalName(e.getReceiveHospitalName());
                mgrReferralNoteResVo.setReferralTime(e.getReferralTime());
                mgrReferralNoteResVo.setReferralNumber(Integer.valueOf(referralNumber + 1));
                mgrReferralNoteResVoList.add(mgrReferralNoteResVo);
            });
            mgrReferralInfoResVoList.add(mgrReferralInfoResVo);
            mgrReferralInfoResVoList.sort((e1, e2) -> e1.getCreateTime().compareTo(e2.getCreateTime()));
            List collect = mgrReferralInfoResVoList.stream().map(m -> m.getOrderSeq()).collect(Collectors.toList());
            log.info("init orderSeq =" + JSONArray.toJSONString(collect));
            List referralPictureInfoByOrderSeqList = this.referralPictureInfoMapper.getReferralPictureInfoByOrderSeqList(collect);
            log.info("init query orderSeq=" + JSONArray.toJSONString((Object)referralPictureInfoByOrderSeqList));
            if (referralPictureInfoByOrderSeqList != null) {
                mgrReferralInfoResVoList.forEach(e -> {
                    List<ReferralPictureInfoEntity> collect1 = referralPictureInfoByOrderSeqList.stream().filter(r -> r.getOrderSeq().equals(e.getOrderSeq())).collect(Collectors.toList());
                    if (null != collect1) {
                        MgrReferralCaseInfoResVo mgrReferralCaseInfoResVo = new MgrReferralCaseInfoResVo();
                        mgrReferralCaseInfoResVo.setLaunchHospitalName(e.getLaunchHospitalName());
                        ArrayList videoMaterialUrlList = new ArrayList();
                        collect1.forEach(referralPictureInfoEntity -> this.buildMgrReferralCaseInfoResVo(referralPictureInfoEntity, mgrReferralCaseInfoResVo, videoMaterialUrlList));
                        VideoMaterialResVo videoMaterialResVo = new VideoMaterialResVo();
                        videoMaterialResVo.setUrl(videoMaterialUrlList);
                        mgrReferralCaseInfoResVo.setVideoMaterialResVo(videoMaterialResVo);
                        mgrReferralCaseInfoResVoList.add(mgrReferralCaseInfoResVo);
                    }
                });
            }
        }
        mgrReferralRecordDetailResVo.setMgrReferralNoteResVo(mgrReferralNoteResVoList);
        mgrReferralRecordDetailResVo.setMgrReferralCaseInfoResVoList(mgrReferralCaseInfoResVoList);
        return mgrReferralRecordDetailResVo;
    }

    private void buildMgrReferralCaseInfoResVo(ReferralPictureInfoEntity referralPictureInfoEntity, MgrReferralCaseInfoResVo mgrReferralCaseInfoResVo, List<String> videoMaterialUrlList) {
        if (ItemTypeCodeEnum.DOCTOR_ADVICE.getValue() == referralPictureInfoEntity.getItemTypeCode()) {
            MedicalInformationResVo medicalInformationResVo = new MedicalInformationResVo();
            medicalInformationResVo.setDescription(referralPictureInfoEntity.getDescription());
            medicalInformationResVo.setUrl(Arrays.asList(referralPictureInfoEntity.getUrl().split(",")));
            medicalInformationResVo.setDescription(referralPictureInfoEntity.getDescription());
            mgrReferralCaseInfoResVo.setMedicalInformationResVo(medicalInformationResVo);
        }
        if (ItemTypeCodeEnum.CASE_INFORMATION.getValue() == referralPictureInfoEntity.getItemTypeCode()) {
            CaseDataResVo caseDataResVo = new CaseDataResVo();
            caseDataResVo.setDescription(referralPictureInfoEntity.getDescription());
            caseDataResVo.setUrl(Arrays.asList(referralPictureInfoEntity.getUrl().split(",")));
            caseDataResVo.setDescription(referralPictureInfoEntity.getDescription());
            mgrReferralCaseInfoResVo.setCaseDataResVo(caseDataResVo);
        }
        if (ItemTypeCodeEnum.ASSAY_DATA.getValue() == referralPictureInfoEntity.getItemTypeCode()) {
            AssayDataResVo assayDataReqVo = new AssayDataResVo();
            assayDataReqVo.setDescription(referralPictureInfoEntity.getDescription());
            assayDataReqVo.setUrl(Arrays.asList(referralPictureInfoEntity.getUrl().split(",")));
            assayDataReqVo.setDescription(referralPictureInfoEntity.getDescription());
            mgrReferralCaseInfoResVo.setAssayDataResVo(assayDataReqVo);
        }
        if (ItemTypeCodeEnum.OPERATIVE_RECORD.getValue() == referralPictureInfoEntity.getItemTypeCode()) {
            SurgicalRecordResVo surgicalRecordResVo = new SurgicalRecordResVo();
            surgicalRecordResVo.setDescription(referralPictureInfoEntity.getDescription());
            surgicalRecordResVo.setUrl(Arrays.asList(referralPictureInfoEntity.getUrl().split(",")));
            surgicalRecordResVo.setDescription(referralPictureInfoEntity.getDescription());
            mgrReferralCaseInfoResVo.setSurgicalRecordResVo(surgicalRecordResVo);
        }
        if (ItemTypeCodeEnum.RECOVERY_PLAN.getValue() == referralPictureInfoEntity.getItemTypeCode()) {
            HealthPlanResVo healthPlanResVo = new HealthPlanResVo();
            healthPlanResVo.setDescription(referralPictureInfoEntity.getDescription());
            healthPlanResVo.setUrl(Arrays.asList(referralPictureInfoEntity.getUrl().split(",")));
            healthPlanResVo.setDescription(referralPictureInfoEntity.getDescription());
            mgrReferralCaseInfoResVo.setHealthPlanResVo(healthPlanResVo);
        }
        if (ItemTypeCodeEnum.IMAGE_DATA.getValue() == referralPictureInfoEntity.getItemTypeCode()) {
            VideoMaterialResVo videoMaterialResVo = new VideoMaterialResVo();
            videoMaterialResVo.setDescription(referralPictureInfoEntity.getDescription());
            videoMaterialUrlList.add(referralPictureInfoEntity.getUrl());
        }
    }

    public Integer checkPatientHavaSign(Long id) {
        ReferralOrderEntity referralOrderEntity = (ReferralOrderEntity)this.referralOrderMapper.selectById((Serializable)id);
        if (null == referralOrderEntity || null == referralOrderEntity.getPatientSignatureType()) {
            return TO_BE_SIGN;
        }
        if (StringUtils.isBlank((String)referralOrderEntity.getPatientElectronicSignature()) && StringUtils.isBlank((String)referralOrderEntity.getPatientPictureSignature())) {
            return TO_BE_SIGN;
        }
        return AREADY_SIGNED;
    }

    public void exportReferralExcel(List<Long> idList, HttpServletResponse response) {
        ArrayList newIdList = new ArrayList();
        idList.forEach(e -> {
            Long id = e;
            try {
                log.info("exportReferralExcel \u89e3\u5bc6\u524d\u53c2\u6570\uff1a" + id);
                id = DigitalUtil.decrypt((String)id.toString());
                log.info("exportReferralExcel \u89e3\u5bc6\u540e\u53c2\u6570\uff1a" + id);
            }
            catch (Exception exception) {
                log.error(exception.getMessage());
            }
            newIdList.add(id);
        });
        List referralOrderEntyList = this.referralOrderMapper.selectBatchIds(newIdList);
        ArrayList<MgrReferralExcel> mgrReferralExcelList = new ArrayList<MgrReferralExcel>();
        for (ReferralOrderEntity referralOrderEntity : referralOrderEntyList) {
            MgrReferralExcel mgrReferralExcel = new MgrReferralExcel();
            BeanUtils.copyProperties((Object)referralOrderEntity, (Object)mgrReferralExcel);
            String patientName = referralOrderEntity.getPatientName();
            Integer patientGender = referralOrderEntity.getPatientGender();
            String patientSex = "";
            if (PatientGenderEnum.MALE.getValue() == patientGender) {
                patientSex = "\u7537";
            }
            if (PatientGenderEnum.FEMAlE.getValue() == patientGender) {
                patientSex = "\u5973";
            }
            Integer patientAge = referralOrderEntity.getPatientAge();
            mgrReferralExcel.setPatient(patientName + "/" + patientSex + "/" + patientAge);
            mgrReferralExcelList.add(mgrReferralExcel);
        }
        ExcelUtils.exportExcel(mgrReferralExcelList, (String)"\u8f6c\u8bca\u8bb0\u5f55\u8868", (String)"\u8f6c\u8bca\u8bb0\u5f55", MgrReferralExcel.class, (String)"\u8f6c\u8bca\u6570\u636e\u8868", (boolean)true, (HttpServletResponse)response);
    }

    public List<String> getRejectDoctors(Long id) {
        ReferralOrderEntity referralOrderEntity = (ReferralOrderEntity)this.referralOrderMapper.selectById((Serializable)id);
        List rejectDoctorList = this.referralOrderMapper.getRejectDoctor(referralOrderEntity.getOrderSeq());
        return rejectDoctorList;
    }

    public List<HospitalInfoResVo> getReceiveHospitalList(String appCode, String userId) {
        HospitalInfoReqVo hospitalInfoReqVo = this.buildHospitalInfoReqVo(appCode, userId);
        log.info("==========getReceiveHospitalList\u4e2dhospitalInfoReqVo=========", (Object)hospitalInfoReqVo);
        List hospitalInfoReqVoList = this.referralOrderMapper.getReceiveHospitalList(hospitalInfoReqVo);
        log.info("==========getReceiveHospitalList\u4e2dhospitalInfoReqVoList=========", (Object)hospitalInfoReqVoList.toString());
        return hospitalInfoReqVoList;
    }

    public List<HospitalInfoResVo> getLaunchHospitalList(String appCode, String userId) {
        HospitalInfoReqVo hospitalInfoReqVo = this.buildHospitalInfoReqVo(appCode, userId);
        log.info("==========getLaunchHospitalList\u4e2dhospitalInfoReqVo=========", (Object)hospitalInfoReqVo);
        List hospitalInfoReqVoList = this.referralOrderMapper.getLaunchHospitalList(hospitalInfoReqVo);
        log.info("==========getLaunchHospitalList\u4e2dhospitalInfoReqVoList=========", (Object)hospitalInfoReqVoList.toString());
        return hospitalInfoReqVoList;
    }

    private HospitalInfoReqVo buildHospitalInfoReqVo(String appCode, String userId) {
        HospitalInfoReqVo hospitalInfoReqVo = new HospitalInfoReqVo();
        hospitalInfoReqVo.setAppCode(appCode);
        ReqMgrReferralInRecordVo reqMgrReferralInRecordVo = new ReqMgrReferralInRecordVo();
        BaseResponse cloudUserScope = this.cloudUserScopeService.getCloudUserScope(userId, appCode);
        String data = (String)cloudUserScope.getData();
        if (null != data) {
            String[] idArray = data.split(",");
            ArrayList<String> idList = new ArrayList<String>(Arrays.asList(idArray));
            reqMgrReferralInRecordVo.setIds(idList);
        }
        return hospitalInfoReqVo;
    }

    public ReferralOrderEntity getOneContent() {
        return this.referralOrderMapper.getOneContent();
    }

    public Boolean judgeOneself(Long id, String doctorId, String appChannel, String channelSource, Integer type) {
        log.info("id\uff1a{}", (Object)id);
        log.info("doctorId:{}", (Object)doctorId);
        log.info("appChannel\uff1a{}", (Object)appChannel);
        log.info("channelSource\uff1a{}", (Object)channelSource);
        log.info("type\uff1a{}", (Object)type);
        ReferralOrderEntity referralOrderEntity = (ReferralOrderEntity)this.referralOrderMapper.selectById((Serializable)id);
        log.info("referralOrderEntity{}\uff1a", (Object)referralOrderEntity);
        if (referralOrderEntity == null) {
            return false;
        }
        if (StringUtils.isNotBlank((String)channelSource) && "integratedManagement".equals(channelSource)) {
            return true;
        }
        if (StringUtils.isNotBlank((String)channelSource) && "largeTerminal".equals(channelSource)) {
            return true;
        }
        if (type == 1) {
            return true;
        }
        if (type == 2 && referralOrderEntity.getReceiveDoctorId().equals(doctorId)) {
            return true;
        }
        return false;
    }

    public List<OrganizationResVO> getNodeOrganInfos(String appCode) {
        List organizationResVOList = null;
        String url = new StringBuffer(this.remoteUrls.getRootUrl()).append("cloud/doctorbasedata/organization/getAreaOrganization?cityCode=").append("&organType=1").append("&appCode=" + appCode).toString();
        log.info("\u4ece\u4e91\u7aef\u57fa\u7840\u670d\u52a1\u83b7\u53d6\u8282\u70b9\u4e0b\u7684\u533b`\u9662url\u662f:{}", (Object)url);
        try {
            String dataResp = HttpUtils.get((String)url);
            log.info("\u83b7\u53d6\u8282\u70b9\u4e0b\u7684\u533b\u9662\u8fd4\u56de\u7684\u4fe1\u606f\u662f:{}", (Object)dataResp);
            BaseResponse baseResponse = (BaseResponse)JSONArray.parseObject((String)dataResp, BaseResponse.class);
            organizationResVOList = JSONArray.parseArray((String)JSONObject.toJSONString((Object)baseResponse.getData()), OrganizationResVO.class);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return organizationResVOList;
    }
}

