/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.referral.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.service.referral.common.model.ReferralOrderEntity;
import com.ebaiyihui.service.referral.server.config.RemoteUrls;
import com.ebaiyihui.service.referral.server.service.UmAndroidPushService;
import com.ebaiyihui.service.referral.server.service.remotecall.UserCenterService;
import com.ebaiyihui.service.referral.server.util.ClientCodeUtil;
import com.ebaiyihui.service.referral.server.util.HttpKit;
import com.ebaiyihui.service.referral.server.vo.DeviceInfoReqVo;
import com.ebaiyihui.service.referral.server.vo.DeviceInfoResVo;
import com.ebaiyihui.service.referral.server.vo.UmPushMsgWithUserIdReqVO;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UmAndroidPushServiceImpl
implements UmAndroidPushService {
    private static final Logger log = LoggerFactory.getLogger(UmAndroidPushServiceImpl.class);
    @Autowired
    private RemoteUrls remoteUrls;
    @Autowired
    private UserCenterService useCenterService;
    @Autowired
    private ClientCodeUtil clientCodeUtil;

    public BaseResponse<?> pushandroidunicast(UmPushMsgWithUserIdReqVO umPushMsgWithUserIdReqVO) {
        try {
            String body = HttpKit.jsonPost((String)this.remoteUrls.getUMAndroidPushCalls(), (String)JSON.toJSONString((Object)umPushMsgWithUserIdReqVO));
            log.info("\u53cb\u76df\u63a8\u9001\u5b89\u5353url\uff1a{}", (Object)this.remoteUrls.getUMAndroidPushCalls());
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("\u53cb\u76df\u63a8\u9001\u5b89\u5353baseResponse: " + baseResponse);
            return baseResponse;
        }
        catch (Exception e) {
            log.error("\u53cb\u76df\u63a8\u9001\u5b89\u5353\u5931\u8d25\uff0c\u539f\u56e0\u662f" + e.getMessage());
            return null;
        }
    }

    public void doctorAgreeUMAndroidPush(ReferralOrderEntity referralOrderEntity) {
        UmPushMsgWithUserIdReqVO umPushMsgWithUserIdReqVO = new UmPushMsgWithUserIdReqVO();
        umPushMsgWithUserIdReqVO.setBusiCode("doctor_referral_application_success");
        umPushMsgWithUserIdReqVO.setClientCode(this.clientCodeUtil.getClientCodeByAppCodeAndChannel(referralOrderEntity.getAppCode(), this.getDeviceInfo(referralOrderEntity).getDeviceType()));
        umPushMsgWithUserIdReqVO.setDeviceTokens(this.getDeviceInfo(referralOrderEntity).getDeviceNumber());
        umPushMsgWithUserIdReqVO.setText("\u60a8\u7684\u8f6c\u8bca\u7533\u8bf7\u5df2\u6210\u529f,\u70b9\u51fb\u67e5\u770b\u8be6\u60c5");
        umPushMsgWithUserIdReqVO.setUserId(referralOrderEntity.getLauchUserId());
        umPushMsgWithUserIdReqVO.setTitle("\u8f6c\u8bca\u5355\u63a5\u8bca\u6210\u529f");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", referralOrderEntity.getId().toString());
        map.put("actionCode", "RDAA");
        map.put("businessCode", "sxzz");
        umPushMsgWithUserIdReqVO.setExtra(map);
        log.info("\u63a5\u8bca\u533b\u751f\u5df2\u63a5\u8bca\u5b89\u5353APP\u63a8\u9001:" + JSON.toJSONString((Object)umPushMsgWithUserIdReqVO));
        BaseResponse pushPatientApp = this.pushandroidunicast(umPushMsgWithUserIdReqVO);
        log.info("\u63a5\u8bca\u533b\u751f\u5df2\u63a5\u8bca\u5b89\u5353APP\u63a8\u9001pushPatientApp:" + pushPatientApp.toString());
        if (!pushPatientApp.isSuccess()) {
            log.info("\u63a5\u8bca\u533b\u751f\u5df2\u63a5\u8bca\u5b89\u5353APP\u63a8\u9001\u5931\u8d25:" + pushPatientApp.toString());
        }
    }

    public void doctorRejectUMAndroidPush(ReferralOrderEntity referralOrderEntity) {
        UmPushMsgWithUserIdReqVO umPushMsgWithUserIdReqVO = new UmPushMsgWithUserIdReqVO();
        umPushMsgWithUserIdReqVO.setBusiCode("doctor_referral_application");
        umPushMsgWithUserIdReqVO.setClientCode(this.clientCodeUtil.getClientCodeByAppCodeAndChannel(referralOrderEntity.getAppCode(), this.getDeviceInfo(referralOrderEntity).getDeviceType()));
        umPushMsgWithUserIdReqVO.setDeviceTokens(this.getDeviceInfo(referralOrderEntity).getDeviceNumber());
        umPushMsgWithUserIdReqVO.setText("\u60a8\u7684\u8f6c\u8bca\u7533\u8bf7\u5df2\u4ea4\u7531\u7ba1\u7406\u5458\u8fdb\u884c\u5206\u914d\uff0c\u8bf7\u7b49\u5f85\u5206\u914d\u7ed3\u679c\u3002\u70b9\u51fb\u67e5\u770b\u8be6\u60c5");
        umPushMsgWithUserIdReqVO.setUserId(referralOrderEntity.getLauchUserId());
        umPushMsgWithUserIdReqVO.setTitle("\u8f6c\u8bca\u5355\u91cd\u65b0\u5206\u914d");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", referralOrderEntity.getId().toString());
        map.put("actionCode", "RDRA");
        map.put("businessCode", "sxzz");
        umPushMsgWithUserIdReqVO.setExtra(map);
        log.info("\u63a5\u8bca\u533b\u751f\u5df2\u63a5\u8bca\u5b89\u5353APP\u63a8\u9001:" + JSON.toJSONString((Object)umPushMsgWithUserIdReqVO));
        BaseResponse pushPatientApp = this.pushandroidunicast(umPushMsgWithUserIdReqVO);
        log.info("\u63a5\u8bca\u533b\u751f\u5df2\u63a5\u8bca\u5b89\u5353APP\u63a8\u9001pushPatientApp:" + pushPatientApp.toString());
        if (!pushPatientApp.isSuccess()) {
            log.info("\u63a5\u8bca\u533b\u751f\u5df2\u63a5\u8bca\u5b89\u5353APP\u63a8\u9001\u5931\u8d25:" + pushPatientApp.toString());
        }
    }

    public DeviceInfoResVo getDeviceInfo(ReferralOrderEntity referralOrderEntity) {
        DeviceInfoReqVo deviceInfoReqVo = new DeviceInfoReqVo();
        deviceInfoReqVo.setUserId(referralOrderEntity.getLauchUserId());
        deviceInfoReqVo.setUserType(Integer.valueOf(1));
        deviceInfoReqVo.setAccountId("");
        log.info("\u8c03\u7528\u8bbe\u5907\u4fe1\u606f\u8bf7\u6c42\u53c2\u6570\u4e3a{}", (Object)JSON.toJSONString((Object)deviceInfoReqVo));
        BaseResponse baseResponse = this.useCenterService.getdeviceInfo(deviceInfoReqVo);
        log.info("\u8c03\u7528\u8bbe\u5907\u4fe1\u606f\u8fd4\u56de\u7ed3\u679c\u4e3a", (Object)JSON.toJSONString((Object)baseResponse));
        DeviceInfoResVo deviceInfoResVo = (DeviceInfoResVo)baseResponse.getData();
        if (null == baseResponse.getData()) {
            log.info("\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f\u8fd4\u56de\u4f53\uff1a{}", (Object)baseResponse);
            return null;
        }
        log.info("deviceInfoReqVo:" + deviceInfoReqVo.toString());
        return deviceInfoResVo;
    }
}

