/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.referral.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.service.referral.common.model.ReferralOrderEntity;
import com.ebaiyihui.service.referral.server.config.RemoteUrls;
import com.ebaiyihui.service.referral.server.service.UmIosPushService;
import com.ebaiyihui.service.referral.server.service.remotecall.UserCenterService;
import com.ebaiyihui.service.referral.server.util.ClientCodeUtil;
import com.ebaiyihui.service.referral.server.util.HttpKit;
import com.ebaiyihui.service.referral.server.vo.DeviceInfoReqVo;
import com.ebaiyihui.service.referral.server.vo.DeviceInfoResVo;
import com.ebaiyihui.service.referral.server.vo.UmPushMsgIOSReqVo;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UmIosPushServiceImpl
implements UmIosPushService {
    private static final Logger log = LoggerFactory.getLogger(UmIosPushServiceImpl.class);
    @Autowired
    private RemoteUrls remoteUrls;
    @Autowired
    private ClientCodeUtil clientCodeUtil;
    @Autowired
    private UserCenterService userCenterService;

    public BaseResponse<?> pushiosunicast(UmPushMsgIOSReqVo umPushMsgIOSReqVo) {
        try {
            log.info("\u53cb\u76dfios\u63a8\u9001\u8bf7\u6c42\u53c2\u6570\u4e3a{}: " + JSON.toJSONString((Object)umPushMsgIOSReqVo));
            String body = HttpKit.jsonPost((String)this.remoteUrls.getUMIOSPullCalls(), (String)JSON.toJSONString((Object)umPushMsgIOSReqVo));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("\u53cb\u76dfios\u63a8\u9001baseResponse: " + baseResponse);
            return baseResponse;
        }
        catch (Exception e) {
            log.error("\u53cb\u76dfios\u63a8\u9001\u5931\u8d25\uff0c\u539f\u56e0\u662f" + e.getMessage());
            return BaseResponse.error((String)"\u53cb\u76dfios\u63a8\u9001\u5931\u8d25");
        }
    }

    public void doctorAgreeUMAndroidPush(ReferralOrderEntity referralOrderEntity) {
        UmPushMsgIOSReqVo umPushMsgIOSReqVo = new UmPushMsgIOSReqVo();
        umPushMsgIOSReqVo.setBusiCode("doctor_referral_application_success");
        umPushMsgIOSReqVo.setTitle("\u8f6c\u8bca\u5355\u63a5\u8bca\u6210\u529f");
        umPushMsgIOSReqVo.setUserId(referralOrderEntity.getLauchUserId());
        umPushMsgIOSReqVo.setDeviceTokens(this.getDeviceInfo(referralOrderEntity).getDeviceNumber());
        umPushMsgIOSReqVo.setClientCode(this.clientCodeUtil.getClientCodeByAppCodeAndChannel(referralOrderEntity.getAppCode(), this.getDeviceInfo(referralOrderEntity).getDeviceType()));
        umPushMsgIOSReqVo.setBody("\u60a8\u7684\u8f6c\u8bca\u7533\u8bf7\u5df2\u6210\u529f,\u70b9\u51fb\u67e5\u770b\u8be6\u60c5");
        umPushMsgIOSReqVo.setSubTitle("\u8f6c\u8bca\u5355\u63a5\u8bca\u6210\u529f");
        umPushMsgIOSReqVo.setDescription("\u60a8\u7684\u8f6c\u8bca\u7533\u8bf7\u5df2\u6210\u529f,\u70b9\u51fb\u67e5\u770b\u8be6\u60c5");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", referralOrderEntity.getId().toString());
        map.put("actionCode", "RDAA");
        map.put("businessCode", "sxzz");
        umPushMsgIOSReqVo.setExtra(map);
        log.info("\u5df2\u63a5\u8bca\uff0cIOS\u63a8\u9001\u5f00\u59cb\uff0cumPushMsgIOSReqVo\u63a8\u9001\u5165\u53c2:" + JSON.toJSONString((Object)umPushMsgIOSReqVo));
        BaseResponse pushPatientApp = this.pushiosunicast(umPushMsgIOSReqVo);
        log.info("\u5df2\u63a5\u8bca\uff0cios\u63a8\u9001\u6210\u529f\uff0c\u63a8\u9001pushPatientApp\u8fd4\u56de\u503c:" + pushPatientApp.toString());
        if (!pushPatientApp.isSuccess()) {
            log.info("\u5df2\u63a5\u8bca\uff0cios\u63a8\u9001\u63a8\u9001\u5931\u8d25:" + pushPatientApp.toString());
        }
    }

    public void doctorRejectUMAndroidPush(ReferralOrderEntity referralOrderEntity) {
        UmPushMsgIOSReqVo umPushMsgIOSReqVo = new UmPushMsgIOSReqVo();
        umPushMsgIOSReqVo.setBusiCode("doctor_referral_application");
        umPushMsgIOSReqVo.setTitle("\u8f6c\u8bca\u5355\u91cd\u65b0\u5206\u914d");
        umPushMsgIOSReqVo.setUserId(referralOrderEntity.getLauchUserId());
        umPushMsgIOSReqVo.setDeviceTokens(this.getDeviceInfo(referralOrderEntity).getDeviceNumber());
        umPushMsgIOSReqVo.setClientCode(this.clientCodeUtil.getClientCodeByAppCodeAndChannel(referralOrderEntity.getAppCode(), this.getDeviceInfo(referralOrderEntity).getDeviceType()));
        umPushMsgIOSReqVo.setBody("\u60a8\u7684\u8f6c\u8bca\u7533\u8bf7\u5df2\u4ea4\u7531\u7ba1\u7406\u5458\u8fdb\u884c\u5206\u914d\uff0c\u8bf7\u7b49\u5f85\u5206\u914d\u7ed3\u679c\u3002\u70b9\u51fb\u67e5\u770b\u8be6\u60c5");
        umPushMsgIOSReqVo.setSubTitle("\u8f6c\u8bca\u5355\u91cd\u65b0\u5206\u914d");
        umPushMsgIOSReqVo.setDescription("\u60a8\u7684\u8f6c\u8bca\u7533\u8bf7\u5df2\u4ea4\u7531\u7ba1\u7406\u5458\u8fdb\u884c\u5206\u914d\uff0c\u8bf7\u7b49\u5f85\u5206\u914d\u7ed3\u679c\u3002\u70b9\u51fb\u67e5\u770b\u8be6\u60c5");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", referralOrderEntity.getId().toString());
        map.put("actionCode", "RDRA");
        map.put("businessCode", "sxzz");
        umPushMsgIOSReqVo.setExtra(map);
        log.info("\u62d2\u7edd\u63a5\u8bca\uff0ciOS\u63a8\u9001\u5f00\u59cb\uff0cumPushMsgIOSReqVo\u63a8\u9001\u5165\u53c2:" + JSON.toJSONString((Object)umPushMsgIOSReqVo));
        BaseResponse pushPatientApp = this.pushiosunicast(umPushMsgIOSReqVo);
        log.info("\u62d2\u7edd\u63a5\u8bca\uff0ciso\u63a8\u9001\u6210\u529f\uff0cpushPatientApp\u8fd4\u56de\u503c:" + pushPatientApp.toString());
        if (!pushPatientApp.isSuccess()) {
            log.info("\u62d2\u7edd\u63a5\u8bcaios\u63a8\u9001\u5931\u8d25:" + pushPatientApp.toString());
        }
    }

    public DeviceInfoResVo getDeviceInfo(ReferralOrderEntity referralOrderEntity) {
        DeviceInfoReqVo deviceInfoReqVo = new DeviceInfoReqVo();
        deviceInfoReqVo.setUserId(referralOrderEntity.getLauchUserId());
        deviceInfoReqVo.setUserType(Integer.valueOf(1));
        deviceInfoReqVo.setAccountId("");
        BaseResponse baseResponse = this.userCenterService.getdeviceInfo(deviceInfoReqVo);
        DeviceInfoResVo deviceInfoResVo = (DeviceInfoResVo)baseResponse.getData();
        if (null == baseResponse.getData()) {
            log.error("\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f\u8fd4\u56de\u4f53\uff1a{}", (Object)baseResponse);
            return null;
        }
        log.info("deviceInfoReqVo:" + deviceInfoReqVo.toString());
        return deviceInfoResVo;
    }
}

