/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.referral.server.util;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.service.referral.server.config.RemoteUrls;
import com.ebaiyihui.service.referral.server.util.HttpKit;
import com.ebaiyihui.service.referral.server.vo.ClientCodeVo;
import com.ebaiyihui.service.referral.server.vo.UcConfigurationDTO;
import com.ebaiyihui.service.referral.server.vo.UcConfigurationVO;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ClientCodeUtil {
    private static final Logger log = LoggerFactory.getLogger(ClientCodeUtil.class);
    public static final String SMS = "sms";
    public static final String YOUMENG_PUSH = "youmengPush";
    public static final String WE_CHAT_APPLETS = "weChatApplets";
    public static final String USER_TYPE_DOCTOR = "doctor";
    @Autowired
    private RemoteUrls remoteUrls;

    public String getClientCodeByAppCodeAndChannel(String appCode, String deviceType) {
        ClientCodeVo clientCodeVo = new ClientCodeVo();
        clientCodeVo.setAppCode(appCode);
        clientCodeVo.setType(YOUMENG_PUSH);
        BaseResponse baseResponse = null;
        try {
            String body = HttpKit.jsonPost((String)this.remoteUrls.getConfigurationDetailUrl(), (String)JSON.toJSONString((Object)clientCodeVo));
            baseResponse = (BaseResponse)JSON.parseObject((String)body, BaseResponse.class);
            UcConfigurationDTO ucConfigurationDTO = (UcConfigurationDTO)JSON.parseObject((String)JSON.toJSONString((Object)baseResponse.getData()), UcConfigurationDTO.class);
            String clientCode = ucConfigurationDTO.getClientCode();
            List ucConfigurationVOS = JSON.parseArray((String)clientCode, UcConfigurationVO.class);
            if (!CollectionUtils.isEmpty((Collection)ucConfigurationVOS)) {
                for (UcConfigurationVO ucConfigurationVO : ucConfigurationVOS) {
                    if (!deviceType.equals(ucConfigurationVO.getDeviceType().toUpperCase()) || !USER_TYPE_DOCTOR.equals(ucConfigurationVO.getUserType())) continue;
                    return ucConfigurationVO.getClientCode();
                }
            }
            return "";
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5931\u8d25\uff0c\u539f\u56e0\u662f" + e.getMessage());
            return "";
        }
    }
}

