/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.referral.server.util;

import cn.afterturn.easypoi.word.WordExportUtil;
import com.ebaiyihui.service.referral.server.util.FileUtils;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordUtils {
    private static final Logger log = LoggerFactory.getLogger(WordUtils.class);

    public static void saveWord(String wordPath, Map<String, Object> param, String name) {
        try {
            ZipSecureFile.setMinInflateRatio((double)-1.0);
            String templatePath = "template/referralApplyOrder.docx";
            XWPFDocument doc = WordExportUtil.exportWord07((String)templatePath, param);
            FileOutputStream out = new FileOutputStream(wordPath + name + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd_HHmmssSSS") + ".docx");
            doc.write((OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            log.error("word\u6a21\u677f\u5199\u5165\u5931\u8d25");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportWord(String templatePath, String temDir, String fileName, Map<String, Object> params, HttpServletResponse response) {
        try {
            ZipSecureFile.setMinInflateRatio((double)-1.0);
            XWPFDocument doc = WordExportUtil.exportWord07((String)templatePath, params);
            String tmpPath = temDir + fileName;
            FileOutputStream fos = new FileOutputStream(tmpPath);
            doc.write((OutputStream)fos);
            response.setContentType("application/force-download");
            response.setCharacterEncoding("utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            ServletOutputStream out = response.getOutputStream();
            doc.write((OutputStream)out);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            FileUtils.deleteDir((String)temDir);
        }
    }
}

