/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.sysinfo.server.api;

import com.ebaiyihui.framework.api.BaseController;
import com.ebaiyihui.framework.common.PageResult;
import com.ebaiyihui.framework.common.ResultInfo;
import com.ebaiyihui.framework.enums.ReturnCodeEnum;
import com.ebaiyihui.sysinfo.common.SuperAdminUserEntity;
import com.ebaiyihui.sysinfo.common.vo.ResetPwdVo;
import com.ebaiyihui.sysinfo.server.exception.SuperAdminUserException;
import com.ebaiyihui.sysinfo.server.service.AdminService;
import com.ebaiyihui.sysinfo.server.vo.SearchParamVo;
import com.ebaiyihui.sysinfo.server.vo.SuperAdminUserDetailsVo;
import com.ebaiyihui.sysinfo.server.vo.SuperAdminUserVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8d85\u7ea7\u7ba1\u7406\u5458"})
@RestController
@RequestMapping(value={"/api/v1/superadmin"})
public class AdminController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(AdminController.class);
    @Autowired
    private AdminService adminService;

    @ApiOperation(value="\u767b\u5f55\u540d\u624b\u673a\u53f7\u9a8c\u8bc1")
    @GetMapping(value={"/verifyLoginName"})
    public ResultInfo<SuperAdminUserEntity> verifyLoginName(@RequestParam(value="loginName") String loginName, @RequestParam(value="telephone") String telephone) {
        SuperAdminUserEntity adminUserEntity = this.adminService.getByLoginName(loginName.trim());
        if (adminUserEntity != null && telephone.trim().equals(adminUserEntity.getMobileNumber())) {
            return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
        }
        return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
    }

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u8d85\u7ba1")
    @GetMapping(value={"/select_super_admin_detail_info"})
    public ResultInfo<SuperAdminUserDetailsVo> selectSuperAdminDetailInfoById(@RequestParam(value="id") Long id) {
        SuperAdminUserDetailsVo superAdminUserRolePermissionVo = this.adminService.selectSuperAdminDetailInfoById(id);
        return this.returnSucceed((Object)superAdminUserRolePermissionVo, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u6839\u636eid\u4fee\u6539\u8d85\u7ba1")
    @PostMapping(value={"/update_super_admin_info_by_id"})
    public ResultInfo<String> updateSuperAdminInfoById(@RequestBody SuperAdminUserVo superAdminUserVo) {
        this.adminService.updateSuperAdminInfoById(superAdminUserVo);
        return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u91cd\u7f6e\u5bc6\u7801")
    @PostMapping(value={"/resetPwd"})
    public ResultInfo<SuperAdminUserEntity> resetPwd(@RequestBody ResetPwdVo vo) {
        Integer resetFlag = this.adminService.resetPwd(vo);
        if (resetFlag > 0) {
            return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
        }
        return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
    }

    @ApiOperation(value="\u901a\u8fc7\u767b\u5f55\u540d\u67e5\u8be2")
    @GetMapping(value={"/getbyloginname"})
    public ResultInfo<SuperAdminUserEntity> getByloginName(@RequestParam(value="loginName") String loginName) {
        return this.returnSucceed((Object)this.adminService.getByLoginName(loginName), ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u4fdd\u5b58token")
    @PostMapping(value={"/savetoken"})
    public ResultInfo saveToken(@RequestParam(value="loginName") String loginName, @RequestParam(value="token") String token) {
        int flagSave = this.adminService.saveAdminToken(loginName, token);
        if (flagSave > 0) {
            return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
        }
        return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
    }

    @ApiOperation(value="\u521b\u5efa\u8d85\u7ea7\u7ba1\u7406\u5458")
    @PostMapping(value={"/save_super_admin_user"})
    public ResultInfo<String> saveSuperAdminUser(@RequestBody SuperAdminUserVo superAdminUserVo) {
        try {
            this.adminService.saveSuperAdminUser(superAdminUserVo);
            return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
        }
        catch (SuperAdminUserException e) {
            log.error(e.getMessage());
            return this.returnFailure(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.returnFailure("\u7f51\u7edc\u8d85\u65f6, \u8bf7\u91cd\u8bd5");
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u8d85\u7ea7\u7ba1\u7406\u5458")
    @GetMapping(value={"/get_super_admin_user_page_by_search_param"})
    public ResultInfo<String> getSuperAdminUserPageBySearchParam(SearchParamVo searchParamVo, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        PageResult pageResult = this.adminService.getSuperAdminUserPageBySearchParam(searchParamVo, pageNum, pageSize);
        return this.returnSucceed((Object)pageResult, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u7981\u7528\u8d85\u7ea7\u7ba1\u7406\u5458")
    @PostMapping(value={"/delete_super_admin"})
    public ResultInfo<String> deleteSuperAdminById(@RequestParam(value="id") Long id) {
        this.adminService.deleteSuperAdminById(id);
        return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u542f\u7528\u8d85\u7ea7\u7ba1\u7406\u5458")
    @PostMapping(value={"/enable_super_admin"})
    public ResultInfo<String> enableSuperAdminById(@RequestParam(value="id") Long id) {
        this.adminService.enableSuperAdminById(id);
        return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
    }
}

