/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.sysinfo.server.api;

import com.ebaiyihui.framework.api.BaseController;
import com.ebaiyihui.framework.common.ResultInfo;
import com.ebaiyihui.sysinfo.common.AppVersionEntity;
import com.ebaiyihui.sysinfo.server.service.AppVersionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7248\u672c\u63a7\u5236"})
@RestController
@RequestMapping(value={"/api/v1/app_version"})
public class AppVersionController
extends BaseController {
    @Autowired
    AppVersionService appVersionService;

    @ApiOperation(value="\u6839\u636e\u5e73\u53f0\u67e5\u8be2\u6700\u65b0\u4e00\u6761\u7248\u672c\u4fe1\u606f")
    @GetMapping(value={"/get/latestbyplatform"})
    public ResultInfo<AppVersionEntity> getAppVersionById(@RequestParam(value="platform") String platform) {
        AppVersionEntity appVersionEntity = this.appVersionService.getLatestByPlatform(platform);
        return this.returnSucceed((Object)appVersionEntity, "\u67e5\u8be2\u6210\u529f");
    }

    @ApiOperation(value="\u6839\u636ename\u67e5\u8be2\u7248\u672c\u63a7\u5236")
    @GetMapping(value={"/get/byname"})
    public ResultInfo<AppVersionEntity> getAppVersionByName(@RequestParam(value="versionName") String versionName) {
        AppVersionEntity appVersionEntity = this.appVersionService.getAppVersionByName(versionName);
        return this.returnSucceed((Object)appVersionEntity, "\u67e5\u8be2\u6210\u529f");
    }

    @ApiOperation(value="\u6dfb\u52a0\u7248\u672c\u63a7\u5236")
    @PostMapping(value={"/insert"})
    public ResultInfo insertAppVersion(@RequestBody AppVersionEntity appVersionEntity) {
        int insertAppVersion = this.appVersionService.insertAppVersion(appVersionEntity);
        if (insertAppVersion == 0) {
            return this.returnFailure("\u6dfb\u52a0\u5931\u8d25");
        }
        return this.returnSucceed("\u6dfb\u52a0\u6210\u529f");
    }

    @ApiOperation(value="\u66f4\u65b0\u7248\u672c\u63a7\u5236")
    @PostMapping(value={"/update"})
    public ResultInfo updateAppVersion(@RequestBody AppVersionEntity appVersionEntity) {
        int updateAppVersion = this.appVersionService.updateAppVersion(appVersionEntity);
        if (updateAppVersion == 0) {
            return this.returnFailure("\u66f4\u65b0\u5931\u8d25");
        }
        return this.returnSucceed("\u66f4\u65b0\u6210\u529f");
    }

    @ApiOperation(value="\u6839\u636e\u4e3b\u5065\u5220\u9664\u7248\u672c\u63a7\u5236")
    @GetMapping(value={"/delete/byid"})
    public ResultInfo deleteAppVersionById(@RequestParam(value="id") Long id) {
        int deleteAppVersionById = this.appVersionService.deleteAppVersionById(id);
        if (deleteAppVersionById == 0) {
            return this.returnFailure("\u5220\u9664\u5931\u8d25");
        }
        return this.returnSucceed("\u5220\u9664\u6210\u529f");
    }
}

