/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.sysinfo.server.api;

import com.ebaiyihui.framework.api.BaseController;
import com.ebaiyihui.framework.common.ResultInfo;
import com.ebaiyihui.framework.enums.ReturnCodeEnum;
import com.ebaiyihui.sysinfo.common.BankCardEntity;
import com.ebaiyihui.sysinfo.server.service.BankCardService;
import com.ebaiyihui.sysinfo.server.utils.BankCardUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/bankcard"})
@Api(tags={"\u94f6\u884c\u5361\u56db\u8981\u7d20\u6821\u9a8c"})
public class BankCardController
extends BaseController {
    @Autowired
    private BankCardService bankCardService;

    @PostMapping(value={"/verify"})
    @ApiOperation(value="\u94f6\u884c\u5361\u56db\u8981\u7d20\u6821\u9a8c")
    public ResultInfo<BankCardEntity> verify(@RequestBody BankCardEntity bankCardEntity) {
        return this.returnSucceed((Object)this.bankCardService.auditId(this.bankCardService.auditId(bankCardEntity)), ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @GetMapping(value={"/getBankName"})
    @ApiOperation(value="\u83b7\u53d6\u94f6\u884c\u540d\u79f0\u53ca\u5361\u7c7b\u578b")
    public ResultInfo<Map<String, String>> getBankName(@RequestParam(value="bankCardNo") String bankCardNo) {
        HashMap<String, String> result = new HashMap<String, String>();
        String bankName = BankCardUtils.getDetailNameOfBank((String)bankCardNo.trim());
        if ("".equals(bankName)) {
            return this.returnFailure("\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u94f6\u884c\u5361\u4fe1\u606f");
        }
        String[] mapInfo = bankName.split("\u00b7");
        result.put("BankName", mapInfo[0]);
        result.put("CardType", mapInfo[1]);
        return this.returnSucceed(result, ReturnCodeEnum.SUCCEED.getDisplay());
    }
}

